/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.git;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.gui.DPoint;
import org.apache.hop.core.gui.IGc;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.svg.SvgFile;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePainter;
import org.apache.hop.ui.core.PropsUi;

@ExtensionPoint(id="DrawDiffOnTransExtensionPoint", description="Draws a marker on top of a transform if it has some change", extensionPointId="PipelinePainterEnd")
public class DrawDiffOnTransformExtensionPoint
implements IExtensionPoint {
    public void callExtensionPoint(ILogChannel log, IVariables variables, Object object) throws HopException {
        if (!(object instanceof PipelinePainter)) {
            return;
        }
        PipelinePainter painter = (PipelinePainter)object;
        DPoint offset = painter.getOffset();
        IGc gc = painter.getGc();
        PipelineMeta pipelineMeta = painter.getPipelineMeta();
        try {
            pipelineMeta.getTransforms().stream().filter(transform -> transform.getAttribute("Git", "Status") != null).forEach(transform -> {
                if (pipelineMeta.getPipelineVersion() != null && pipelineMeta.getPipelineVersion().startsWith("git")) {
                    String location;
                    String status = transform.getAttribute("Git", "Status");
                    Point n = transform.getLocation();
                    switch (status) {
                        case "REMOVED": {
                            location = "removed.svg";
                            break;
                        }
                        case "CHANGED": {
                            location = "changed.svg";
                            break;
                        }
                        case "ADDED": {
                            location = "added.svg";
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    int iconSize = 32;
                    try {
                        iconSize = PropsUi.getInstance().getIconSize();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    double x = (double)(n.x + iconSize) + offset.x - (double)(iconSize / 4);
                    double y = (double)n.y + offset.y - (double)(iconSize / 4);
                    try {
                        gc.drawImage(new SvgFile(location, this.getClass().getClassLoader()), (int)x, (int)y, iconSize / 2, iconSize / 2, gc.getMagnification(), 0.0);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                transform.getAttributesMap().remove("Git");
            });
        }
        catch (Exception e) {
            throw new HopException("Error drawing status on transform", (Throwable)e);
        }
    }
}

