/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.importer;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.neo4j.transforms.importer.ImporterMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ImporterDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = ImporterMeta.class;
    private Text wTransformName;
    private CCombo wFilenameField;
    private CCombo wFileTypeField;
    private TextVar wDatabaseFilename;
    private TextVar wAdminCommand;
    private TextVar wBaseFolder;
    private Button wHighIo;
    private Button wCacheOnHeap;
    private Button wIgnoreEmptyStrings;
    private Button wIgnoreExtraColumns;
    private Button wLegacyStyleQuoting;
    private Button wMultiLine;
    private Button wNormalizeTypes;
    private Button wSkipBadEntriesLogging;
    private Button wSkipBadRelationships;
    private Button wSkipDuplicateNodes;
    private Button wTrimStrings;
    private Button wOverwriteDestination;
    private TextVar wBadTolerance;
    private TextVar wMaxMemory;
    private TextVar wReadBufferSize;
    private TextVar wProcessors;
    private CCombo wNeo4jVersion;
    private ImporterMeta input;

    public ImporterDialog(Shell parent, IVariables variables, ImporterMeta inputMetadata, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)inputMetadata, pipelineMeta);
        this.input = inputMetadata;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout shellLayout = new FormLayout();
        this.shell.setLayout((Layout)shellLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ImporterMeta.name", (String[])new String[0]));
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        ScrolledComposite wScrolledComposite = new ScrolledComposite((Composite)this.shell, 768);
        FormLayout scFormLayout = new FormLayout();
        wScrolledComposite.setLayout((Layout)scFormLayout);
        FormData fdSComposite = new FormData();
        fdSComposite.left = new FormAttachment(0, 0);
        fdSComposite.right = new FormAttachment(100, 0);
        fdSComposite.top = new FormAttachment(0, 0);
        fdSComposite.bottom = new FormAttachment(100, 0);
        wScrolledComposite.setLayoutData((Object)fdSComposite);
        Composite wComposite = new Composite((Composite)wScrolledComposite, 0);
        PropsUi.setLook((Widget)wComposite);
        FormData fdComposite = new FormData();
        fdComposite.left = new FormAttachment(0, 0);
        fdComposite.right = new FormAttachment(100, 0);
        fdComposite.top = new FormAttachment(0, 0);
        fdComposite.bottom = new FormAttachment(100, 0);
        wComposite.setLayoutData((Object)fdComposite);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        wComposite.setLayout((Layout)formLayout);
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Label wlTransformName = new Label(wComposite, 131072);
        wlTransformName.setText("Transform name");
        PropsUi.setLook((Widget)wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text(wComposite, 18436);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        String[] fieldnames = new String[]{};
        try {
            fieldnames = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta).getFieldNames();
        }
        catch (HopTransformException e2) {
            this.log.logError("error getting input field names: ", (Throwable)e2);
        }
        Label wlFilenameField = new Label(wComposite, 131072);
        wlFilenameField.setText("Filename field ");
        PropsUi.setLook((Widget)wlFilenameField);
        FormData fdlFilenameField = new FormData();
        fdlFilenameField.left = new FormAttachment(0, 0);
        fdlFilenameField.right = new FormAttachment(middle, -margin);
        fdlFilenameField.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlFilenameField.setLayoutData((Object)fdlFilenameField);
        this.wFilenameField = new CCombo(wComposite, 2080);
        this.wFilenameField.setItems(fieldnames);
        PropsUi.setLook((Widget)this.wFilenameField);
        FormData fdFilenameField = new FormData();
        fdFilenameField.left = new FormAttachment(middle, 0);
        fdFilenameField.right = new FormAttachment(100, 0);
        fdFilenameField.top = new FormAttachment((Control)wlFilenameField, 0, 0x1000000);
        this.wFilenameField.setLayoutData((Object)fdFilenameField);
        lastControl = wlFilenameField;
        Label wlFileTypeField = new Label(wComposite, 131072);
        wlFileTypeField.setText("File type field ");
        PropsUi.setLook((Widget)wlFileTypeField);
        FormData fdlFileTypeField = new FormData();
        fdlFileTypeField.left = new FormAttachment(0, 0);
        fdlFileTypeField.right = new FormAttachment(middle, -margin);
        fdlFileTypeField.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlFileTypeField.setLayoutData((Object)fdlFileTypeField);
        this.wFileTypeField = new CCombo(wComposite, 2080);
        this.wFileTypeField.setItems(fieldnames);
        PropsUi.setLook((Widget)this.wFileTypeField);
        FormData fdFileTypeField = new FormData();
        fdFileTypeField.left = new FormAttachment(middle, 0);
        fdFileTypeField.right = new FormAttachment(100, 0);
        fdFileTypeField.top = new FormAttachment((Control)wlFileTypeField, 0, 0x1000000);
        this.wFileTypeField.setLayoutData((Object)fdFileTypeField);
        lastControl = wlFileTypeField;
        Label wlDatabaseFilename = new Label(wComposite, 131072);
        wlDatabaseFilename.setText("Database filename ");
        PropsUi.setLook((Widget)wlDatabaseFilename);
        FormData fdlDatabaseFilename = new FormData();
        fdlDatabaseFilename.left = new FormAttachment(0, 0);
        fdlDatabaseFilename.right = new FormAttachment(middle, -margin);
        fdlDatabaseFilename.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlDatabaseFilename.setLayoutData((Object)fdlDatabaseFilename);
        this.wDatabaseFilename = new TextVar(this.variables, wComposite, 18436);
        PropsUi.setLook((Widget)this.wDatabaseFilename);
        this.wDatabaseFilename.addModifyListener(lsMod);
        FormData fdDatabaseFilename = new FormData();
        fdDatabaseFilename.left = new FormAttachment(middle, 0);
        fdDatabaseFilename.right = new FormAttachment(100, 0);
        fdDatabaseFilename.top = new FormAttachment((Control)wlDatabaseFilename, 0, 0x1000000);
        this.wDatabaseFilename.setLayoutData((Object)fdDatabaseFilename);
        lastControl = this.wDatabaseFilename;
        Label wlAdminCommand = new Label(wComposite, 131072);
        wlAdminCommand.setText("neo4j-admin command path ");
        PropsUi.setLook((Widget)wlAdminCommand);
        FormData fdlAdminCommand = new FormData();
        fdlAdminCommand.left = new FormAttachment(0, 0);
        fdlAdminCommand.right = new FormAttachment(middle, -margin);
        fdlAdminCommand.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlAdminCommand.setLayoutData((Object)fdlAdminCommand);
        this.wAdminCommand = new TextVar(this.variables, wComposite, 18436);
        PropsUi.setLook((Widget)this.wAdminCommand);
        this.wAdminCommand.addModifyListener(lsMod);
        FormData fdAdminCommand = new FormData();
        fdAdminCommand.left = new FormAttachment(middle, 0);
        fdAdminCommand.right = new FormAttachment(100, 0);
        fdAdminCommand.top = new FormAttachment((Control)wlAdminCommand, 0, 0x1000000);
        this.wAdminCommand.setLayoutData((Object)fdAdminCommand);
        lastControl = this.wAdminCommand;
        Label wlNeo4jVersion = new Label(wComposite, 131072);
        wlNeo4jVersion.setText("Neo4j version ");
        PropsUi.setLook((Widget)wlNeo4jVersion);
        FormData fdlNeo4jVersion = new FormData();
        fdlNeo4jVersion.left = new FormAttachment(0, 0);
        fdlNeo4jVersion.right = new FormAttachment(middle, -margin);
        fdlNeo4jVersion.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlNeo4jVersion.setLayoutData((Object)fdlNeo4jVersion);
        this.wNeo4jVersion = new CCombo(wComposite, 2056);
        this.wNeo4jVersion.setItems(new String[]{"4.x", "5.x"});
        PropsUi.setLook((Widget)this.wNeo4jVersion);
        this.wNeo4jVersion.addModifyListener(lsMod);
        FormData fdNeo4jVersion = new FormData();
        fdNeo4jVersion.left = new FormAttachment(middle, 0);
        fdNeo4jVersion.right = new FormAttachment(100, 0);
        fdNeo4jVersion.top = new FormAttachment((Control)wlNeo4jVersion, 0, 0x1000000);
        this.wNeo4jVersion.setLayoutData((Object)fdNeo4jVersion);
        lastControl = wlNeo4jVersion;
        Label wlOverwriteDestination = new Label(wComposite, 131072);
        wlOverwriteDestination.setText("Overwrite existing database (5.x only) ");
        PropsUi.setLook((Widget)wlOverwriteDestination);
        FormData fdlOverwriteDestination = new FormData();
        fdlOverwriteDestination.left = new FormAttachment(0, 0);
        fdlOverwriteDestination.right = new FormAttachment(middle, -margin);
        fdlOverwriteDestination.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlOverwriteDestination.setLayoutData((Object)fdlOverwriteDestination);
        this.wOverwriteDestination = new Button(wComposite, 16416);
        PropsUi.setLook((Widget)this.wOverwriteDestination);
        FormData fdOverwriteDestination = new FormData();
        fdOverwriteDestination.left = new FormAttachment(middle, 0);
        fdOverwriteDestination.right = new FormAttachment(100, 0);
        fdOverwriteDestination.top = new FormAttachment((Control)wlOverwriteDestination, 0, 0x1000000);
        this.wOverwriteDestination.setLayoutData((Object)fdOverwriteDestination);
        this.wOverwriteDestination.addListener(13, e -> this.input.setChanged());
        lastControl = wlOverwriteDestination;
        Label wlNote = new Label(wComposite, 64);
        wlNote.setText("Note: Neo4j database must be stopped before import. For Community Edition, use 'neo4j stop' to stop Neo4j entirely. For Enterprise Edition, use Cypher 'STOP DATABASE <name>' to stop the specific database.");
        PropsUi.setLook((Widget)wlNote);
        FormData fdlNote = new FormData();
        fdlNote.left = new FormAttachment(0, 0);
        fdlNote.right = new FormAttachment(100, 0);
        fdlNote.top = new FormAttachment((Control)lastControl, margin);
        wlNote.setLayoutData((Object)fdlNote);
        lastControl = wlNote;
        Label wlBaseFolder = new Label(wComposite, 131072);
        wlBaseFolder.setText("Base folder (below import/ folder) ");
        PropsUi.setLook((Widget)wlBaseFolder);
        FormData fdlBaseFolder = new FormData();
        fdlBaseFolder.left = new FormAttachment(0, 0);
        fdlBaseFolder.right = new FormAttachment(middle, -margin);
        fdlBaseFolder.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlBaseFolder.setLayoutData((Object)fdlBaseFolder);
        this.wBaseFolder = new TextVar(this.variables, wComposite, 18436);
        PropsUi.setLook((Widget)this.wBaseFolder);
        this.wBaseFolder.addModifyListener(lsMod);
        FormData fdBaseFolder = new FormData();
        fdBaseFolder.left = new FormAttachment(middle, 0);
        fdBaseFolder.right = new FormAttachment(100, 0);
        fdBaseFolder.top = new FormAttachment((Control)wlBaseFolder, 0, 0x1000000);
        this.wBaseFolder.setLayoutData((Object)fdBaseFolder);
        lastControl = this.wBaseFolder;
        Label wlVerbose = new Label(wComposite, 131072);
        wlVerbose.setText("Verbose output? ");
        PropsUi.setLook((Widget)wlVerbose);
        FormData fdlVerbose = new FormData();
        fdlVerbose.left = new FormAttachment(0, 0);
        fdlVerbose.right = new FormAttachment(middle, -margin);
        fdlVerbose.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlVerbose.setLayoutData((Object)fdlVerbose);
        Button wVerbose = new Button(wComposite, 16416);
        PropsUi.setLook((Widget)wVerbose);
        FormData fdVerbose = new FormData();
        fdVerbose.left = new FormAttachment(middle, 0);
        fdVerbose.right = new FormAttachment(100, 0);
        fdVerbose.top = new FormAttachment((Control)wlVerbose, 0, 0x1000000);
        wVerbose.setLayoutData((Object)fdVerbose);
        lastControl = wlVerbose;
        Label wlHighIo = new Label(wComposite, 131072);
        wlHighIo.setText("High IO? ");
        PropsUi.setLook((Widget)wlHighIo);
        FormData fdlHighIo = new FormData();
        fdlHighIo.left = new FormAttachment(0, 0);
        fdlHighIo.right = new FormAttachment(middle, -margin);
        fdlHighIo.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlHighIo.setLayoutData((Object)fdlHighIo);
        this.wHighIo = new Button(wComposite, 16416);
        PropsUi.setLook((Widget)this.wHighIo);
        FormData fdHighIo = new FormData();
        fdHighIo.left = new FormAttachment(middle, 0);
        fdHighIo.right = new FormAttachment(100, 0);
        fdHighIo.top = new FormAttachment((Control)wlHighIo, 0, 0x1000000);
        this.wHighIo.setLayoutData((Object)fdHighIo);
        lastControl = wlHighIo;
        Label wlCacheOnHeap = new Label(wComposite, 131072);
        wlCacheOnHeap.setText("Cache on heap? ");
        PropsUi.setLook((Widget)wlCacheOnHeap);
        FormData fdlCacheOnHeap = new FormData();
        fdlCacheOnHeap.left = new FormAttachment(0, 0);
        fdlCacheOnHeap.right = new FormAttachment(middle, -margin);
        fdlCacheOnHeap.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlCacheOnHeap.setLayoutData((Object)fdlCacheOnHeap);
        this.wCacheOnHeap = new Button(wComposite, 16416);
        PropsUi.setLook((Widget)this.wCacheOnHeap);
        FormData fdCacheOnHeap = new FormData();
        fdCacheOnHeap.left = new FormAttachment(middle, 0);
        fdCacheOnHeap.right = new FormAttachment(100, 0);
        fdCacheOnHeap.top = new FormAttachment((Control)wlCacheOnHeap, 0, 0x1000000);
        this.wCacheOnHeap.setLayoutData((Object)fdCacheOnHeap);
        lastControl = wlCacheOnHeap;
        Label wlIgnoreEmptyStrings = new Label(wComposite, 131072);
        wlIgnoreEmptyStrings.setText("Ignore empty strings? ");
        PropsUi.setLook((Widget)wlIgnoreEmptyStrings);
        FormData fdlIgnoreEmptyStrings = new FormData();
        fdlIgnoreEmptyStrings.left = new FormAttachment(0, 0);
        fdlIgnoreEmptyStrings.right = new FormAttachment(middle, -margin);
        fdlIgnoreEmptyStrings.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlIgnoreEmptyStrings.setLayoutData((Object)fdlIgnoreEmptyStrings);
        this.wIgnoreEmptyStrings = new Button(wComposite, 16416);
        PropsUi.setLook((Widget)this.wIgnoreEmptyStrings);
        FormData fdIgnoreEmptyStrings = new FormData();
        fdIgnoreEmptyStrings.left = new FormAttachment(middle, 0);
        fdIgnoreEmptyStrings.right = new FormAttachment(100, 0);
        fdIgnoreEmptyStrings.top = new FormAttachment((Control)wlIgnoreEmptyStrings, 0, 0x1000000);
        this.wIgnoreEmptyStrings.setLayoutData((Object)fdIgnoreEmptyStrings);
        lastControl = this.wIgnoreEmptyStrings;
        Label wlIgnoreExtraColumns = new Label(wComposite, 131072);
        wlIgnoreExtraColumns.setText("Ignore extra columns? ");
        PropsUi.setLook((Widget)wlIgnoreExtraColumns);
        FormData fdlIgnoreExtraColumns = new FormData();
        fdlIgnoreExtraColumns.left = new FormAttachment(0, 0);
        fdlIgnoreExtraColumns.right = new FormAttachment(middle, -margin);
        fdlIgnoreExtraColumns.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlIgnoreExtraColumns.setLayoutData((Object)fdlIgnoreExtraColumns);
        this.wIgnoreExtraColumns = new Button(wComposite, 16416);
        PropsUi.setLook((Widget)this.wIgnoreExtraColumns);
        FormData fdIgnoreExtraColumns = new FormData();
        fdIgnoreExtraColumns.left = new FormAttachment(middle, 0);
        fdIgnoreExtraColumns.right = new FormAttachment(100, 0);
        fdIgnoreExtraColumns.top = new FormAttachment((Control)wlIgnoreExtraColumns, 0, 0x1000000);
        this.wIgnoreExtraColumns.setLayoutData((Object)fdIgnoreExtraColumns);
        lastControl = this.wIgnoreExtraColumns;
        Label wlLegacyStyleQuoting = new Label(wComposite, 131072);
        wlLegacyStyleQuoting.setText("Legacy style quoting? ");
        PropsUi.setLook((Widget)wlLegacyStyleQuoting);
        FormData fdlLegacyStyleQuoting = new FormData();
        fdlLegacyStyleQuoting.left = new FormAttachment(0, 0);
        fdlLegacyStyleQuoting.right = new FormAttachment(middle, -margin);
        fdlLegacyStyleQuoting.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlLegacyStyleQuoting.setLayoutData((Object)fdlLegacyStyleQuoting);
        this.wLegacyStyleQuoting = new Button(wComposite, 16416);
        PropsUi.setLook((Widget)this.wLegacyStyleQuoting);
        FormData fdLegacyStyleQuoting = new FormData();
        fdLegacyStyleQuoting.left = new FormAttachment(middle, 0);
        fdLegacyStyleQuoting.right = new FormAttachment(100, 0);
        fdLegacyStyleQuoting.top = new FormAttachment((Control)wlLegacyStyleQuoting, 0, 0x1000000);
        this.wLegacyStyleQuoting.setLayoutData((Object)fdLegacyStyleQuoting);
        lastControl = wlLegacyStyleQuoting;
        Label wlMultiLine = new Label(wComposite, 131072);
        wlMultiLine.setText("Fields can have multi-line data? ");
        PropsUi.setLook((Widget)wlMultiLine);
        FormData fdlMultiLine = new FormData();
        fdlMultiLine.left = new FormAttachment(0, 0);
        fdlMultiLine.right = new FormAttachment(middle, -margin);
        fdlMultiLine.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlMultiLine.setLayoutData((Object)fdlMultiLine);
        this.wMultiLine = new Button(wComposite, 16416);
        PropsUi.setLook((Widget)this.wMultiLine);
        FormData fdMultiLine = new FormData();
        fdMultiLine.left = new FormAttachment(middle, 0);
        fdMultiLine.right = new FormAttachment(100, 0);
        fdMultiLine.top = new FormAttachment((Control)wlMultiLine, 0, 0x1000000);
        this.wMultiLine.setLayoutData((Object)fdMultiLine);
        lastControl = wlMultiLine;
        Label wlNormalizeTypes = new Label(wComposite, 131072);
        wlNormalizeTypes.setText("Normalize types? ");
        PropsUi.setLook((Widget)wlNormalizeTypes);
        FormData fdlNormalizeTypes = new FormData();
        fdlNormalizeTypes.left = new FormAttachment(0, 0);
        fdlNormalizeTypes.right = new FormAttachment(middle, -margin);
        fdlNormalizeTypes.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlNormalizeTypes.setLayoutData((Object)fdlNormalizeTypes);
        this.wNormalizeTypes = new Button(wComposite, 16416);
        PropsUi.setLook((Widget)this.wNormalizeTypes);
        FormData fdNormalizeTypes = new FormData();
        fdNormalizeTypes.left = new FormAttachment(middle, 0);
        fdNormalizeTypes.right = new FormAttachment(100, 0);
        fdNormalizeTypes.top = new FormAttachment((Control)wlNormalizeTypes, 0, 0x1000000);
        this.wNormalizeTypes.setLayoutData((Object)fdNormalizeTypes);
        lastControl = wlNormalizeTypes;
        Label wlSkipBadEntriesLogging = new Label(wComposite, 131072);
        wlSkipBadEntriesLogging.setText("Skip logging bad entries during import? ");
        PropsUi.setLook((Widget)wlSkipBadEntriesLogging);
        FormData fdlSkipBadEntriesLogging = new FormData();
        fdlSkipBadEntriesLogging.left = new FormAttachment(0, 0);
        fdlSkipBadEntriesLogging.right = new FormAttachment(middle, -margin);
        fdlSkipBadEntriesLogging.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlSkipBadEntriesLogging.setLayoutData((Object)fdlSkipBadEntriesLogging);
        this.wSkipBadEntriesLogging = new Button(wComposite, 16416);
        PropsUi.setLook((Widget)this.wSkipBadEntriesLogging);
        FormData fdSkipBadEntriesLogging = new FormData();
        fdSkipBadEntriesLogging.left = new FormAttachment(middle, 0);
        fdSkipBadEntriesLogging.right = new FormAttachment(100, 0);
        fdSkipBadEntriesLogging.top = new FormAttachment((Control)wlSkipBadEntriesLogging, 0, 0x1000000);
        this.wSkipBadEntriesLogging.setLayoutData((Object)fdSkipBadEntriesLogging);
        lastControl = wlSkipBadEntriesLogging;
        Label wlSkipBadRelationships = new Label(wComposite, 131072);
        wlSkipBadRelationships.setText("Skip bad relationships? ");
        PropsUi.setLook((Widget)wlSkipBadRelationships);
        FormData fdlSkipBadRelationships = new FormData();
        fdlSkipBadRelationships.left = new FormAttachment(0, 0);
        fdlSkipBadRelationships.right = new FormAttachment(middle, -margin);
        fdlSkipBadRelationships.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlSkipBadRelationships.setLayoutData((Object)fdlSkipBadRelationships);
        this.wSkipBadRelationships = new Button(wComposite, 16416);
        PropsUi.setLook((Widget)this.wSkipBadRelationships);
        FormData fdSkipBadRelationships = new FormData();
        fdSkipBadRelationships.left = new FormAttachment(middle, 0);
        fdSkipBadRelationships.right = new FormAttachment(100, 0);
        fdSkipBadRelationships.top = new FormAttachment((Control)wlSkipBadRelationships, 0, 0x1000000);
        this.wSkipBadRelationships.setLayoutData((Object)fdSkipBadRelationships);
        lastControl = wlSkipBadRelationships;
        Label wlSkipDuplicateNodes = new Label(wComposite, 131072);
        wlSkipDuplicateNodes.setText("Skip duplicate nodes? ");
        String ttSkipDuplicateNodes = "If enabled, skip duplicate node IDs in CSV files. Required when the same node appears multiple times (e.g., as both source and target in relationships).";
        wlSkipDuplicateNodes.setToolTipText(ttSkipDuplicateNodes);
        PropsUi.setLook((Widget)wlSkipDuplicateNodes);
        FormData fdlSkipDuplicateNodes = new FormData();
        fdlSkipDuplicateNodes.left = new FormAttachment(0, 0);
        fdlSkipDuplicateNodes.right = new FormAttachment(middle, -margin);
        fdlSkipDuplicateNodes.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlSkipDuplicateNodes.setLayoutData((Object)fdlSkipDuplicateNodes);
        this.wSkipDuplicateNodes = new Button(wComposite, 16416);
        this.wSkipDuplicateNodes.setToolTipText(ttSkipDuplicateNodes);
        PropsUi.setLook((Widget)this.wSkipDuplicateNodes);
        FormData fdSkipDuplicateNodes = new FormData();
        fdSkipDuplicateNodes.left = new FormAttachment(middle, 0);
        fdSkipDuplicateNodes.right = new FormAttachment(100, 0);
        fdSkipDuplicateNodes.top = new FormAttachment((Control)wlSkipDuplicateNodes, 0, 0x1000000);
        this.wSkipDuplicateNodes.setLayoutData((Object)fdSkipDuplicateNodes);
        lastControl = wlSkipDuplicateNodes;
        Label wlTrimStrings = new Label(wComposite, 131072);
        wlTrimStrings.setText("Trim strings? ");
        PropsUi.setLook((Widget)wlTrimStrings);
        FormData fdlTrimStrings = new FormData();
        fdlTrimStrings.left = new FormAttachment(0, 0);
        fdlTrimStrings.right = new FormAttachment(middle, -margin);
        fdlTrimStrings.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlTrimStrings.setLayoutData((Object)fdlTrimStrings);
        this.wTrimStrings = new Button(wComposite, 16416);
        PropsUi.setLook((Widget)this.wTrimStrings);
        FormData fdTrimStrings = new FormData();
        fdTrimStrings.left = new FormAttachment(middle, 0);
        fdTrimStrings.right = new FormAttachment(100, 0);
        fdTrimStrings.top = new FormAttachment((Control)wlTrimStrings, 0, 0x1000000);
        this.wTrimStrings.setLayoutData((Object)fdTrimStrings);
        lastControl = wlTrimStrings;
        Label wlBadTolerance = new Label(wComposite, 131072);
        wlBadTolerance.setText("Bad tolerance");
        String ttBadTolerance = "Number of bad entries before the import is considered failed";
        wlBadTolerance.setToolTipText(ttBadTolerance);
        PropsUi.setLook((Widget)wlBadTolerance);
        FormData fdlBadTolerance = new FormData();
        fdlBadTolerance.left = new FormAttachment(0, 0);
        fdlBadTolerance.right = new FormAttachment(middle, -margin);
        fdlBadTolerance.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlBadTolerance.setLayoutData((Object)fdlBadTolerance);
        this.wBadTolerance = new TextVar(this.variables, wComposite, 18436);
        this.wBadTolerance.setToolTipText(ttBadTolerance);
        PropsUi.setLook((Widget)this.wBadTolerance);
        this.wBadTolerance.addModifyListener(lsMod);
        FormData fdBadTolerance = new FormData();
        fdBadTolerance.left = new FormAttachment(middle, 0);
        fdBadTolerance.right = new FormAttachment(100, 0);
        fdBadTolerance.top = new FormAttachment((Control)wlBadTolerance, 0, 0x1000000);
        this.wBadTolerance.setLayoutData((Object)fdBadTolerance);
        lastControl = this.wBadTolerance;
        Label wlMaxMemory = new Label(wComposite, 131072);
        wlMaxMemory.setText("Max memory ");
        PropsUi.setLook((Widget)wlMaxMemory);
        FormData fdlMaxMemory = new FormData();
        fdlMaxMemory.left = new FormAttachment(0, 0);
        fdlMaxMemory.right = new FormAttachment(middle, -margin);
        fdlMaxMemory.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlMaxMemory.setLayoutData((Object)fdlMaxMemory);
        this.wMaxMemory = new TextVar(this.variables, wComposite, 18436);
        PropsUi.setLook((Widget)this.wMaxMemory);
        this.wMaxMemory.addModifyListener(lsMod);
        FormData fdMaxMemory = new FormData();
        fdMaxMemory.left = new FormAttachment(middle, 0);
        fdMaxMemory.right = new FormAttachment(100, 0);
        fdMaxMemory.top = new FormAttachment((Control)wlMaxMemory, 0, 0x1000000);
        this.wMaxMemory.setLayoutData((Object)fdMaxMemory);
        lastControl = this.wMaxMemory;
        Label wlReadBufferSize = new Label(wComposite, 131072);
        wlReadBufferSize.setText("Read buffer size ");
        PropsUi.setLook((Widget)wlReadBufferSize);
        FormData fdlReadBufferSize = new FormData();
        fdlReadBufferSize.left = new FormAttachment(0, 0);
        fdlReadBufferSize.right = new FormAttachment(middle, -margin);
        fdlReadBufferSize.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlReadBufferSize.setLayoutData((Object)fdlReadBufferSize);
        this.wReadBufferSize = new TextVar(this.variables, wComposite, 18436);
        PropsUi.setLook((Widget)this.wReadBufferSize);
        this.wReadBufferSize.addModifyListener(lsMod);
        FormData fdReadBufferSize = new FormData();
        fdReadBufferSize.left = new FormAttachment(middle, 0);
        fdReadBufferSize.right = new FormAttachment(100, 0);
        fdReadBufferSize.top = new FormAttachment((Control)wlReadBufferSize, 0, 0x1000000);
        this.wReadBufferSize.setLayoutData((Object)fdReadBufferSize);
        lastControl = this.wReadBufferSize;
        Label wlProcessors = new Label(wComposite, 131072);
        wlProcessors.setText("Processors ");
        PropsUi.setLook((Widget)wlProcessors);
        FormData fdlProcessors = new FormData();
        fdlProcessors.left = new FormAttachment(0, 0);
        fdlProcessors.right = new FormAttachment(middle, -margin);
        fdlProcessors.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlProcessors.setLayoutData((Object)fdlProcessors);
        this.wProcessors = new TextVar(this.variables, wComposite, 18436);
        PropsUi.setLook((Widget)this.wProcessors);
        this.wProcessors.addModifyListener(lsMod);
        FormData fdProcessors = new FormData();
        fdProcessors.left = new FormAttachment(middle, 0);
        fdProcessors.right = new FormAttachment(100, 0);
        fdProcessors.top = new FormAttachment((Control)wlProcessors, 0, 0x1000000);
        this.wProcessors.setLayoutData((Object)fdProcessors);
        lastControl = this.wProcessors;
        this.wOk = new Button(wComposite, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button(wComposite, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)lastControl);
        wComposite.pack();
        Rectangle bounds = wComposite.getBounds();
        wScrolledComposite.setContent((Control)wComposite);
        wScrolledComposite.setExpandHorizontal(true);
        wScrolledComposite.setExpandVertical(true);
        wScrolledComposite.setMinWidth(bounds.width);
        wScrolledComposite.setMinHeight(bounds.height);
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    public void getData() {
        this.wTransformName.setText(Const.NVL((String)this.transformName, (String)""));
        this.wFilenameField.setText(Const.NVL((String)this.input.getFilenameField(), (String)""));
        this.wFileTypeField.setText(Const.NVL((String)this.input.getFileTypeField(), (String)""));
        this.wDatabaseFilename.setText(Const.NVL((String)this.input.getDatabaseName(), (String)""));
        this.wAdminCommand.setText(Const.NVL((String)this.input.getAdminCommand(), (String)""));
        this.wBaseFolder.setText(Const.NVL((String)this.input.getBaseFolder(), (String)""));
        String neo4jVersion = Const.NVL((String)this.input.getNeo4jVersion(), (String)"4.x");
        if (neo4jVersion.equals("5.x") || neo4jVersion.startsWith("5.")) {
            this.wNeo4jVersion.setText("5.x");
        } else {
            this.wNeo4jVersion.setText("4.x");
        }
        this.wOverwriteDestination.setSelection(this.input.isOverwriteDestination());
        this.wHighIo.setSelection(this.input.isHighIo());
        this.wCacheOnHeap.setSelection(this.input.isCacheOnHeap());
        this.wIgnoreEmptyStrings.setSelection(this.input.isIgnoringEmptyStrings());
        this.wIgnoreExtraColumns.setSelection(this.input.isIgnoringExtraColumns());
        this.wLegacyStyleQuoting.setSelection(this.input.isQuotingLegacyStyle());
        this.wMultiLine.setSelection(this.input.isMultiLine());
        this.wNormalizeTypes.setSelection(this.input.isNormalizingTypes());
        this.wSkipBadEntriesLogging.setSelection(this.input.isSkippingBadEntriesLogging());
        this.wSkipBadRelationships.setSelection(this.input.isSkippingBadRelationships());
        this.wSkipDuplicateNodes.setSelection(this.input.isSkippingDuplicateNodes());
        this.wTrimStrings.setSelection(this.input.isTrimmingStrings());
        this.wBadTolerance.setText(Const.NVL((String)this.input.getBadTolerance(), (String)""));
        this.wMaxMemory.setText(Const.NVL((String)this.input.getMaxMemory(), (String)""));
        this.wReadBufferSize.setText(Const.NVL((String)this.input.getReadBufferSize(), (String)""));
        this.wProcessors.setText(Const.NVL((String)this.input.getProcessors(), (String)""));
    }

    private void ok() {
        if (StringUtils.isEmpty((String)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        this.dispose();
    }

    private void getInfo(ImporterMeta meta) {
        meta.setFilenameField(this.wFilenameField.getText());
        meta.setFileTypeField(this.wFileTypeField.getText());
        meta.setAdminCommand(this.wAdminCommand.getText());
        meta.setDatabaseName(this.wDatabaseFilename.getText());
        meta.setBaseFolder(this.wBaseFolder.getText());
        meta.setNeo4jVersion(this.wNeo4jVersion.getText());
        meta.setOverwriteDestination(this.wOverwriteDestination.getSelection());
        meta.setHighIo(this.wHighIo.getSelection());
        meta.setCacheOnHeap(this.wCacheOnHeap.getSelection());
        meta.setIgnoringEmptyStrings(this.wIgnoreEmptyStrings.getSelection());
        meta.setIgnoringExtraColumns(this.wIgnoreExtraColumns.getSelection());
        meta.setQuotingLegacyStyle(this.wLegacyStyleQuoting.getSelection());
        meta.setMultiLine(this.wMultiLine.getSelection());
        meta.setNormalizingTypes(this.wNormalizeTypes.getSelection());
        meta.setSkippingBadEntriesLogging(this.wSkipBadEntriesLogging.getSelection());
        meta.setSkippingBadRelationships(this.wSkipBadRelationships.getSelection());
        meta.setSkippingDuplicateNodes(this.wSkipDuplicateNodes.getSelection());
        meta.setBadTolerance(this.wBadTolerance.getText());
        meta.setMaxMemory(this.wMaxMemory.getText());
        meta.setReadBufferSize(this.wReadBufferSize.getText());
        meta.setProcessors(this.wProcessors.getText());
    }
}

