/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.graph;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.neo4j.model.GraphModel;
import org.apache.hop.neo4j.model.GraphNode;
import org.apache.hop.neo4j.model.GraphProperty;
import org.apache.hop.neo4j.model.GraphRelationship;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.apache.hop.neo4j.transforms.graph.FieldModelMapping;
import org.apache.hop.neo4j.transforms.graph.GraphOutput;
import org.apache.hop.neo4j.transforms.graph.GraphOutputMeta;
import org.apache.hop.neo4j.transforms.graph.ModelTargetHint;
import org.apache.hop.neo4j.transforms.graph.ModelTargetType;
import org.apache.hop.neo4j.transforms.graph.NodeMapping;
import org.apache.hop.neo4j.transforms.graph.NodeMappingType;
import org.apache.hop.neo4j.transforms.graph.RelationshipMapping;
import org.apache.hop.neo4j.transforms.graph.RelationshipMappingType;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterMappingDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GraphOutputDialog
extends BaseTransformDialog {
    public static final String CONST_ERROR = "Error";
    private static final Class<?> PKG = GraphOutputMeta.class;
    private Text wTransformName;
    private MetaSelectionLine<NeoConnection> wConnection;
    private MetaSelectionLine<GraphModel> wModel;
    private Label wlBatchSize;
    private TextVar wBatchSize;
    private Label wlCreateIndexes;
    private Button wCreateIndexes;
    private Button wReturnGraph;
    private Label wlReturnGraphField;
    private TextVar wReturnGraphField;
    private Button wValidateAgainstModel;
    private Button wOutOfOrderAllowed;
    private CTabFolder wTabFolder;
    private TableView wFieldMappings;
    private TableView wRelMappings;
    private TableView wNodeMappings;
    private GraphOutputMeta input;
    private GraphModel activeModel;

    public GraphOutputDialog(Shell parent, IVariables variables, GraphOutputMeta inputMetadata, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)inputMetadata, pipelineMeta);
        this.input = inputMetadata;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"GraphOutput.Name", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Label wlTransformName = new Label((Composite)this.shell, 131072);
        wlTransformName.setText("Transform name");
        PropsUi.setLook((Widget)wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        TextVar lastControl = this.wTransformName;
        this.wConnection = new MetaSelectionLine(this.variables, this.metadataProvider, NeoConnection.class, (Composite)this.shell, 18436, "Neo4j Connection", "The name of the Neo4j connection to use");
        PropsUi.setLook(this.wConnection);
        FormData fdConnection = new FormData();
        fdConnection.left = new FormAttachment(0, 0);
        fdConnection.right = new FormAttachment(100, 0);
        fdConnection.top = new FormAttachment((Control)lastControl, margin);
        this.wConnection.setLayoutData((Object)fdConnection);
        try {
            this.wConnection.fillItems();
        }
        catch (Exception e2) {
            new ErrorDialog(this.shell, CONST_ERROR, "Error getting list of connections", e2);
        }
        lastControl = this.wConnection;
        this.wModel = new MetaSelectionLine(this.variables, this.metadataProvider, GraphModel.class, (Composite)this.shell, 18436, "Graph model", "The name of the Neo4j logical Graph Model to use");
        PropsUi.setLook(this.wModel);
        FormData fdModel = new FormData();
        fdModel.left = new FormAttachment(0, 0);
        fdModel.right = new FormAttachment(100, 0);
        fdModel.top = new FormAttachment(lastControl, margin);
        this.wModel.setLayoutData((Object)fdModel);
        try {
            this.wModel.fillItems();
        }
        catch (Exception e3) {
            new ErrorDialog(this.shell, CONST_ERROR, "Error getting list of models", e3);
        }
        lastControl = this.wModel;
        this.wlBatchSize = new Label((Composite)this.shell, 131072);
        this.wlBatchSize.setText("Batch size (rows)");
        PropsUi.setLook((Widget)this.wlBatchSize);
        FormData fdlBatchSize = new FormData();
        fdlBatchSize.left = new FormAttachment(0, 0);
        fdlBatchSize.right = new FormAttachment(middle, -margin);
        fdlBatchSize.top = new FormAttachment(lastControl, 2 * margin);
        this.wlBatchSize.setLayoutData((Object)fdlBatchSize);
        this.wBatchSize = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wBatchSize);
        FormData fdBatchSize = new FormData();
        fdBatchSize.left = new FormAttachment(middle, 0);
        fdBatchSize.right = new FormAttachment(100, 0);
        fdBatchSize.top = new FormAttachment((Control)this.wlBatchSize, 0, 0x1000000);
        this.wBatchSize.setLayoutData((Object)fdBatchSize);
        lastControl = this.wBatchSize;
        this.wlCreateIndexes = new Label((Composite)this.shell, 131072);
        this.wlCreateIndexes.setText("Create indexes? ");
        this.wlCreateIndexes.setToolTipText("Create index on first row using label field and primary key properties.");
        PropsUi.setLook((Widget)this.wlCreateIndexes);
        FormData fdlCreateIndexes = new FormData();
        fdlCreateIndexes.left = new FormAttachment(0, 0);
        fdlCreateIndexes.right = new FormAttachment(middle, -margin);
        fdlCreateIndexes.top = new FormAttachment((Control)lastControl, 2 * margin);
        this.wlCreateIndexes.setLayoutData((Object)fdlCreateIndexes);
        this.wCreateIndexes = new Button((Composite)this.shell, 2080);
        this.wCreateIndexes.setToolTipText("Create index on first row using label field and primary key properties.");
        PropsUi.setLook((Widget)this.wCreateIndexes);
        FormData fdCreateIndexes = new FormData();
        fdCreateIndexes.left = new FormAttachment(middle, 0);
        fdCreateIndexes.right = new FormAttachment(100, 0);
        fdCreateIndexes.top = new FormAttachment((Control)this.wlCreateIndexes, 0, 0x1000000);
        this.wCreateIndexes.setLayoutData((Object)fdCreateIndexes);
        lastControl = this.wCreateIndexes;
        Label wlReturnGraph = new Label((Composite)this.shell, 131072);
        wlReturnGraph.setText("Return graph data?");
        String returnGraphTooltipText = "The update data to be updated in the form of Graph a value in the output of this transform";
        wlReturnGraph.setToolTipText(returnGraphTooltipText);
        PropsUi.setLook((Widget)wlReturnGraph);
        FormData fdlReturnGraph = new FormData();
        fdlReturnGraph.left = new FormAttachment(0, 0);
        fdlReturnGraph.right = new FormAttachment(middle, -margin);
        fdlReturnGraph.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlReturnGraph.setLayoutData((Object)fdlReturnGraph);
        this.wReturnGraph = new Button((Composite)this.shell, 2080);
        this.wReturnGraph.setToolTipText(returnGraphTooltipText);
        PropsUi.setLook((Widget)this.wReturnGraph);
        FormData fdReturnGraph = new FormData();
        fdReturnGraph.left = new FormAttachment(middle, 0);
        fdReturnGraph.right = new FormAttachment(100, 0);
        fdReturnGraph.top = new FormAttachment((Control)wlReturnGraph, 0, 0x1000000);
        this.wReturnGraph.setLayoutData((Object)fdReturnGraph);
        this.wReturnGraph.addListener(13, e -> this.enableFields());
        lastControl = this.wReturnGraph;
        this.wlReturnGraphField = new Label((Composite)this.shell, 131072);
        this.wlReturnGraphField.setText("Graph output field name");
        PropsUi.setLook((Widget)this.wlReturnGraphField);
        FormData fdlReturnGraphField = new FormData();
        fdlReturnGraphField.left = new FormAttachment(0, 0);
        fdlReturnGraphField.right = new FormAttachment(middle, -margin);
        fdlReturnGraphField.top = new FormAttachment((Control)lastControl, 2 * margin);
        this.wlReturnGraphField.setLayoutData((Object)fdlReturnGraphField);
        this.wReturnGraphField = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wReturnGraphField);
        FormData fdReturnGraphField = new FormData();
        fdReturnGraphField.left = new FormAttachment(middle, 0);
        fdReturnGraphField.right = new FormAttachment(100, 0);
        fdReturnGraphField.top = new FormAttachment((Control)this.wlReturnGraphField, 0, 0x1000000);
        this.wReturnGraphField.setLayoutData((Object)fdReturnGraphField);
        lastControl = this.wReturnGraphField;
        Label wlValidateAgainstModel = new Label((Composite)this.shell, 131072);
        wlValidateAgainstModel.setText("Validate against model?");
        wlValidateAgainstModel.setToolTipText("This validates indexes, constraints and properties as specified in the model");
        PropsUi.setLook((Widget)wlValidateAgainstModel);
        FormData fdlValidateAgainstModel = new FormData();
        fdlValidateAgainstModel.left = new FormAttachment(0, 0);
        fdlValidateAgainstModel.right = new FormAttachment(middle, -margin);
        fdlValidateAgainstModel.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlValidateAgainstModel.setLayoutData((Object)fdlValidateAgainstModel);
        this.wValidateAgainstModel = new Button((Composite)this.shell, 2080);
        this.wValidateAgainstModel.setToolTipText(returnGraphTooltipText);
        PropsUi.setLook((Widget)this.wValidateAgainstModel);
        FormData fdValidateAgainstModel = new FormData();
        fdValidateAgainstModel.left = new FormAttachment(middle, 0);
        fdValidateAgainstModel.right = new FormAttachment(100, 0);
        fdValidateAgainstModel.top = new FormAttachment((Control)wlValidateAgainstModel, 0, 0x1000000);
        this.wValidateAgainstModel.setLayoutData((Object)fdValidateAgainstModel);
        this.wValidateAgainstModel.addListener(13, e -> this.enableFields());
        lastControl = wlValidateAgainstModel;
        Label wlOutOfOrderAllowed = new Label((Composite)this.shell, 131072);
        wlOutOfOrderAllowed.setText("Allow out of order updates?");
        wlOutOfOrderAllowed.setToolTipText("The transform can group similar cypher statements to increase performance.");
        PropsUi.setLook((Widget)wlOutOfOrderAllowed);
        FormData fdlOutOfOrderAllowed = new FormData();
        fdlOutOfOrderAllowed.left = new FormAttachment(0, 0);
        fdlOutOfOrderAllowed.right = new FormAttachment(middle, -margin);
        fdlOutOfOrderAllowed.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlOutOfOrderAllowed.setLayoutData((Object)fdlOutOfOrderAllowed);
        this.wOutOfOrderAllowed = new Button((Composite)this.shell, 2080);
        this.wOutOfOrderAllowed.setToolTipText(returnGraphTooltipText);
        PropsUi.setLook((Widget)this.wOutOfOrderAllowed);
        FormData fdOutOfOrderAllowed = new FormData();
        fdOutOfOrderAllowed.left = new FormAttachment(middle, 0);
        fdOutOfOrderAllowed.right = new FormAttachment(100, 0);
        fdOutOfOrderAllowed.top = new FormAttachment((Control)wlOutOfOrderAllowed, 0, 0x1000000);
        this.wOutOfOrderAllowed.setLayoutData((Object)fdOutOfOrderAllowed);
        lastControl = wlOutOfOrderAllowed;
        Button wShowCypher = new Button((Composite)this.shell, 8);
        wShowCypher.setText(BaseMessages.getString(PKG, (String)"GraphOutputDialog.Button.ShowCypher", (String[])new String[0]));
        wShowCypher.addListener(13, e -> this.showCypherPreview());
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{wShowCypher, this.wOk, this.wCancel}, margin, null);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)this.wTabFolder, (int)4);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)lastControl, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -margin);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        String[] fieldNames = this.getInputRowMeta().getFieldNames();
        this.addFieldMappingsTab(margin, fieldNames);
        this.addRelMappingsTab(margin, fieldNames);
        this.addNodeMappingsTab(fieldNames);
        this.wTabFolder.setSelection(0);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void addFieldMappingsTab(int margin, String[] fieldNames) {
        CTabItem wPropertiesTab = new CTabItem(this.wTabFolder, 0);
        wPropertiesTab.setFont(GuiResource.getInstance().getFontDefault());
        wPropertiesTab.setText("Field to properties mappings  ");
        Composite wPropertiesComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wPropertiesComp);
        wPropertiesComp.setLayout((Layout)new FormLayout());
        Button wMapping = new Button(wPropertiesComp, 8);
        wMapping.setText("Map fields");
        wMapping.addListener(13, e -> this.enterMapping());
        GraphOutputDialog.positionBottomButtons((Composite)wPropertiesComp, (Button[])new Button[]{wMapping}, (int)margin, null);
        ColumnInfo[] parameterColumns = new ColumnInfo[]{new ColumnInfo("Field", 2, fieldNames, false), new ColumnInfo("Target type", 2, ModelTargetType.getNames(), false), new ColumnInfo("Target", 2, new String[0], false), new ColumnInfo("Property", 2, new String[0], false), new ColumnInfo("Target hint", 2, ModelTargetHint.getDescriptions(), false)};
        this.wFieldMappings = new TableView(this.variables, wPropertiesComp, 65538, parameterColumns, this.input.getFieldModelMappings().size(), null, this.props);
        PropsUi.setLook((Widget)this.wFieldMappings);
        FormData fdFieldMappings = new FormData();
        fdFieldMappings.left = new FormAttachment(0, 0);
        fdFieldMappings.right = new FormAttachment(100, 0);
        fdFieldMappings.top = new FormAttachment(0, 0);
        fdFieldMappings.bottom = new FormAttachment((Control)wMapping, -margin, 128);
        this.wFieldMappings.setLayoutData((Object)fdFieldMappings);
        FormData fdPropertiesComp = new FormData();
        fdPropertiesComp.left = new FormAttachment(0, 0);
        fdPropertiesComp.top = new FormAttachment(0, 0);
        fdPropertiesComp.right = new FormAttachment(100, 0);
        fdPropertiesComp.bottom = new FormAttachment(100, 0);
        wPropertiesComp.setLayoutData((Object)fdPropertiesComp);
        wPropertiesComp.layout();
        wPropertiesTab.setControl((Control)wPropertiesComp);
    }

    private void addRelMappingsTab(int margin, String[] fieldNames) {
        CTabItem wRelationshipsTab = new CTabItem(this.wTabFolder, 0);
        wRelationshipsTab.setFont(GuiResource.getInstance().getFontDefault());
        wRelationshipsTab.setText("Field to relationship mappings  ");
        Composite wRelationshipsComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wRelationshipsComp);
        wRelationshipsComp.setLayout((Layout)new FormLayout());
        Button wGetFields = new Button(wRelationshipsComp, 8);
        wGetFields.setText("Get fields");
        wGetFields.addListener(13, e -> this.enterRelationshipsMapping());
        GraphOutputDialog.positionBottomButtons((Composite)wRelationshipsComp, (Button[])new Button[]{wGetFields}, (int)margin, null);
        ColumnInfo[] mappingColumns = new ColumnInfo[]{new ColumnInfo("Mapping type", 2, RelationshipMappingType.getDescriptions(), false), new ColumnInfo("Field name", 2, fieldNames, false), new ColumnInfo("Field value", 1, false, false), new ColumnInfo("Target relationship", 2, new String[0], false), new ColumnInfo("Source node", 2, new String[0], false), new ColumnInfo("Target node", 2, new String[0], false)};
        this.wRelMappings = new TableView(this.variables, wRelationshipsComp, 65538, mappingColumns, this.input.getRelationshipMappings().size(), null, this.props);
        PropsUi.setLook((Widget)this.wFieldMappings);
        this.wRelMappings.addModifyListener(null);
        FormData fdRelMappings = new FormData();
        fdRelMappings.left = new FormAttachment(0, 0);
        fdRelMappings.right = new FormAttachment(100, 0);
        fdRelMappings.top = new FormAttachment(0, 0);
        fdRelMappings.bottom = new FormAttachment((Control)wGetFields, -margin, 128);
        this.wRelMappings.setLayoutData((Object)fdRelMappings);
        FormData fdRelationshipsComp = new FormData();
        fdRelationshipsComp.left = new FormAttachment(0, 0);
        fdRelationshipsComp.top = new FormAttachment(0, 0);
        fdRelationshipsComp.right = new FormAttachment(100, 0);
        fdRelationshipsComp.bottom = new FormAttachment(100, 0);
        wRelationshipsComp.setLayoutData((Object)fdRelationshipsComp);
        wRelationshipsComp.layout();
        wRelationshipsTab.setControl((Control)wRelationshipsComp);
    }

    private void addNodeMappingsTab(String[] fieldNames) {
        CTabItem wNodesTab = new CTabItem(this.wTabFolder, 0);
        wNodesTab.setFont(GuiResource.getInstance().getFontDefault());
        wNodesTab.setText("Node label mappings  ");
        Composite wNodesComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wNodesComp);
        wNodesComp.setLayout((Layout)new FormLayout());
        ColumnInfo[] mappingColumns = new ColumnInfo[]{new ColumnInfo("Mapping type", 2, NodeMappingType.getDescriptions(), false), new ColumnInfo("Target node name", 2, new String[0], false), new ColumnInfo("Field name", 2, fieldNames, false), new ColumnInfo("Field value", 1, false, false), new ColumnInfo("Target label", 2, new String[0], false)};
        this.wNodeMappings = new TableView(this.variables, wNodesComp, 65538, mappingColumns, this.input.getNodeMappings().size(), null, this.props);
        PropsUi.setLook((Widget)this.wNodeMappings);
        this.wNodeMappings.addModifyListener(null);
        FormData fdNodeMappings = new FormData();
        fdNodeMappings.left = new FormAttachment(0, 0);
        fdNodeMappings.right = new FormAttachment(100, 0);
        fdNodeMappings.top = new FormAttachment(0, 0);
        fdNodeMappings.bottom = new FormAttachment(100, 0);
        this.wNodeMappings.setLayoutData((Object)fdNodeMappings);
        FormData fdNodesComp = new FormData();
        fdNodesComp.left = new FormAttachment(0, 0);
        fdNodesComp.top = new FormAttachment(0, 0);
        fdNodesComp.right = new FormAttachment(100, 0);
        fdNodesComp.bottom = new FormAttachment(100, 0);
        wNodesComp.setLayoutData((Object)fdNodesComp);
        wNodesComp.layout();
        wNodesTab.setControl((Control)wNodesComp);
    }

    private void enableFields() {
        boolean toNeo = !this.wReturnGraph.getSelection();
        this.wConnection.setEnabled(toNeo);
        this.wlBatchSize.setEnabled(toNeo);
        this.wBatchSize.setEnabled(toNeo);
        this.wlCreateIndexes.setEnabled(toNeo);
        this.wCreateIndexes.setEnabled(toNeo);
        this.wlReturnGraphField.setEnabled(!toNeo);
        this.wReturnGraphField.setEnabled(!toNeo);
    }

    private void enterMapping() {
        try {
            String combo;
            if (this.activeModel == null && !this.loadActiveModel()) {
                return;
            }
            IRowMeta inputRowMeta = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
            String[] inputFields = inputRowMeta.getFieldNames();
            String separator = " . ";
            ArrayList<CallSite> targetPropertiesList = new ArrayList<CallSite>();
            for (GraphNode node : this.activeModel.getNodes()) {
                for (GraphProperty property : node.getProperties()) {
                    combo = node.getName() + " . " + property.getName();
                    targetPropertiesList.add((CallSite)((Object)combo));
                }
            }
            for (GraphRelationship relationship : this.activeModel.getRelationships()) {
                for (GraphProperty property : relationship.getProperties()) {
                    combo = relationship.getName() + " . " + property.getName();
                    targetPropertiesList.add((CallSite)((Object)combo));
                }
            }
            String[] targetProperties = targetPropertiesList.toArray(new String[0]);
            List<SourceToTargetMapping> mappings = new ArrayList();
            for (int i = 0; i < this.wFieldMappings.nrNonEmpty(); ++i) {
                TableItem item = this.wFieldMappings.getNonEmpty(i);
                int sourceIndex = Const.indexOfString((String)item.getText(1), (String[])inputFields);
                int targetIndex = Const.indexOfString((String)(item.getText(3) + separator + item.getText(4)), (String[])targetProperties);
                if (sourceIndex < 0 || targetIndex < 0) continue;
                mappings.add(new SourceToTargetMapping(sourceIndex, targetIndex));
            }
            EnterMappingDialog dialog = new EnterMappingDialog(this.shell, inputFields, targetProperties, mappings);
            if ((mappings = dialog.open()) != null) {
                this.wFieldMappings.clearAll();
                for (SourceToTargetMapping mapping : mappings) {
                    String field = mapping.getSourceString(inputFields);
                    String target = mapping.getTargetString(targetProperties);
                    int index = target.indexOf(separator);
                    String targetName = target.substring(0, index);
                    String property = target.substring(index + separator.length());
                    String targetType = null;
                    if (this.activeModel.findNode(targetName) != null) {
                        targetType = "Node";
                    } else if (this.activeModel.findRelationship(targetName) != null) {
                        targetType = "Relationship";
                    } else {
                        throw new HopException("Neither node nor pipeline found for target '" + targetName + ": internal error");
                    }
                    this.wFieldMappings.add(new String[]{field, targetType, targetName, property});
                }
                this.wFieldMappings.removeEmptyRows();
                this.wFieldMappings.setRowNums();
                this.wFieldMappings.optWidth(true);
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, CONST_ERROR, "Error mapping input fields to node properties", e);
        }
    }

    private boolean loadActiveModel() throws HopException {
        try {
            if (StringUtils.isEmpty((String)this.wModel.getText())) {
                return false;
            }
            IHopMetadataSerializer modelSerializer = this.metadataProvider.getSerializer(GraphModel.class);
            this.activeModel = (GraphModel)modelSerializer.load(this.wModel.getText());
            ArrayList<String> nodeNamesList = new ArrayList<String>(Arrays.asList(this.activeModel.getNodeNames()));
            String[] nodeNames = nodeNamesList.toArray(new String[0]);
            ArrayList<String> relNamesList = new ArrayList<String>(Arrays.asList(this.activeModel.getRelationshipNames()));
            String[] relNames = relNamesList.toArray(new String[0]);
            ArrayList<String> allNamesList = new ArrayList<String>(nodeNamesList);
            allNamesList.addAll(relNamesList);
            String[] allNames = allNamesList.toArray(new String[0]);
            HashSet<String> allLabelsSet = new HashSet<String>();
            for (GraphNode node : this.activeModel.getNodes()) {
                allLabelsSet.addAll(node.getLabels());
            }
            ArrayList allLabelsList = new ArrayList(allLabelsSet);
            Collections.sort(allLabelsList);
            String[] allLabels = allLabelsList.toArray(new String[0]);
            this.wFieldMappings.getColumns()[2].setComboValues(allNames);
            this.wRelMappings.getColumns()[3].setComboValues(relNames);
            this.wRelMappings.getColumns()[4].setComboValues(nodeNames);
            this.wRelMappings.getColumns()[5].setComboValues(nodeNames);
            this.wNodeMappings.getColumns()[1].setComboValues(nodeNames);
            this.wNodeMappings.getColumns()[4].setComboValues(allLabels);
            return true;
        }
        catch (Exception e) {
            throw new HopException("Error loading graph model", (Throwable)e);
        }
    }

    private void enterRelationshipsMapping() {
        try {
            if (!this.loadActiveModel()) {
                return;
            }
            String[] relationshipNames = this.activeModel.getRelationshipNames();
            this.wRelMappings.getColumns()[2].setComboValues(relationshipNames);
            IRowMeta inputRowMeta = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
            for (IValueMeta valueMeta : inputRowMeta.getValueMetaList()) {
                this.wRelMappings.add(new String[]{valueMeta.getName()});
            }
            this.wRelMappings.optimizeTableView();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, CONST_ERROR, "Error listing fields or loading graph model", e);
        }
    }

    private void showCypherPreview() {
        try {
            String cypherPreview = GraphOutput.generatePreviewCypher(this.input, this.variables);
            EnterTextDialog dialog = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"GraphOutputDialog.ShowCypher.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GraphOutputDialog.ShowCypher.Message", (String[])new String[0]), cypherPreview, true);
            dialog.setReadOnly();
            dialog.open();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GraphOutputDialog.ShowCypher.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GraphOutputDialog.ShowCypher.Error.Message", (String[])new String[0]), e);
        }
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    public void getData() {
        int idx;
        TableItem item;
        Object mapping;
        int i;
        this.wTransformName.setText(Const.NVL((String)this.transformName, (String)""));
        this.wConnection.setText(Const.NVL((String)this.input.getConnectionName(), (String)""));
        try {
            this.wConnection.fillItems();
        }
        catch (HopException e) {
            this.log.logError("Error getting list of Neo4j Connection names", (Throwable)e);
        }
        this.wModel.setText(Const.NVL((String)this.input.getModel(), (String)""));
        try {
            this.wModel.fillItems();
        }
        catch (HopException e) {
            this.log.logError("Error getting list of Neo4j Graph Model names", (Throwable)e);
        }
        this.wBatchSize.setText(Const.NVL((String)this.input.getBatchSize(), (String)""));
        this.wCreateIndexes.setSelection(this.input.isCreatingIndexes());
        for (i = 0; i < this.input.getFieldModelMappings().size(); ++i) {
            mapping = this.input.getFieldModelMappings().get(i);
            item = this.wFieldMappings.table.getItem(i);
            idx = 1;
            item.setText(idx++, Const.NVL((String)((FieldModelMapping)mapping).getField(), (String)""));
            item.setText(idx++, ModelTargetType.getCode(((FieldModelMapping)mapping).getTargetType()));
            item.setText(idx++, Const.NVL((String)((FieldModelMapping)mapping).getTargetName(), (String)""));
            item.setText(idx++, Const.NVL((String)((FieldModelMapping)mapping).getTargetProperty(), (String)""));
            item.setText(idx++, ((FieldModelMapping)mapping).getTargetHint() == null ? "" : ((FieldModelMapping)mapping).getTargetHint().getDescription());
        }
        this.wFieldMappings.optimizeTableView();
        for (i = 0; i < this.input.getRelationshipMappings().size(); ++i) {
            mapping = this.input.getRelationshipMappings().get(i);
            item = this.wRelMappings.table.getItem(i);
            idx = 1;
            item.setText(idx++, ((RelationshipMapping)mapping).getType() == null ? "" : ((RelationshipMapping)mapping).getType().getDescription());
            item.setText(idx++, Const.NVL((String)((RelationshipMapping)mapping).getFieldName(), (String)""));
            item.setText(idx++, Const.NVL((String)((RelationshipMapping)mapping).getFieldValue(), (String)""));
            item.setText(idx++, Const.NVL((String)((RelationshipMapping)mapping).getTargetRelationship(), (String)""));
            item.setText(idx++, Const.NVL((String)((RelationshipMapping)mapping).getSourceNode(), (String)""));
            item.setText(idx++, Const.NVL((String)((RelationshipMapping)mapping).getTargetNode(), (String)""));
        }
        this.wRelMappings.optimizeTableView();
        for (i = 0; i < this.input.getNodeMappings().size(); ++i) {
            mapping = this.input.getNodeMappings().get(i);
            item = this.wNodeMappings.table.getItem(i);
            idx = 1;
            item.setText(idx++, ((NodeMapping)mapping).getType() == null ? "" : ((NodeMapping)mapping).getType().getDescription());
            item.setText(idx++, Const.NVL((String)((NodeMapping)mapping).getTargetNode(), (String)""));
            item.setText(idx++, Const.NVL((String)((NodeMapping)mapping).getFieldName(), (String)""));
            item.setText(idx++, Const.NVL((String)((NodeMapping)mapping).getFieldValue(), (String)""));
            item.setText(idx++, Const.NVL((String)((NodeMapping)mapping).getTargetLabel(), (String)""));
        }
        this.wNodeMappings.optimizeTableView();
        this.wReturnGraph.setSelection(this.input.isReturningGraph());
        this.wReturnGraphField.setText(Const.NVL((String)this.input.getReturnGraphField(), (String)""));
        this.wValidateAgainstModel.setSelection(this.input.isValidatingAgainstModel());
        this.wOutOfOrderAllowed.setSelection(this.input.isOutOfOrderAllowed());
        try {
            this.loadActiveModel();
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, CONST_ERROR, "Error loading specified graph model", (Exception)((Object)e));
        }
        this.enableFields();
    }

    private void ok() {
        Enum mappingType;
        if (StringUtils.isEmpty((String)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setConnectionName(this.wConnection.getText());
        this.input.setBatchSize(this.wBatchSize.getText());
        this.input.setCreatingIndexes(this.wCreateIndexes.getSelection());
        this.input.setModel(this.wModel.getText());
        this.input.setReturningGraph(this.wReturnGraph.getSelection());
        this.input.setReturnGraphField(this.wReturnGraphField.getText());
        this.input.setValidatingAgainstModel(this.wValidateAgainstModel.getSelection());
        this.input.setOutOfOrderAllowed(this.wOutOfOrderAllowed.getSelection());
        ArrayList<FieldModelMapping> mappings = new ArrayList<FieldModelMapping>();
        for (TableItem item : this.wFieldMappings.getNonEmptyItems()) {
            int idx = 1;
            String sourceField = item.getText(idx++);
            ModelTargetType targetType = ModelTargetType.parseCode(item.getText(idx++));
            String targetName = item.getText(idx++);
            String targetProperty = item.getText(idx++);
            ModelTargetHint targetHint = ModelTargetHint.getTypeFromDescription(item.getText(idx++));
            mappings.add(new FieldModelMapping(sourceField, targetType, targetName, targetProperty, targetHint));
        }
        this.input.setFieldModelMappings(mappings);
        ArrayList<RelationshipMapping> relMappings = new ArrayList<RelationshipMapping>();
        for (TableItem item : this.wRelMappings.getNonEmptyItems()) {
            int idx = 1;
            mappingType = RelationshipMappingType.getTypeFromDescription(item.getText(idx++));
            String sourceFieldName = item.getText(idx++);
            String sourceFieldValue = item.getText(idx++);
            String targetRelationship = item.getText(idx++);
            String sourceNode = item.getText(idx++);
            String targetNode = item.getText(idx++);
            relMappings.add(new RelationshipMapping((RelationshipMappingType)mappingType, sourceFieldName, sourceFieldValue, targetRelationship, sourceNode, targetNode));
        }
        this.input.setRelationshipMappings(relMappings);
        ArrayList<NodeMapping> nodeMappings = new ArrayList<NodeMapping>();
        for (TableItem item : this.wNodeMappings.getNonEmptyItems()) {
            int idx = 1;
            mappingType = NodeMappingType.getTypeFromDescription(item.getText(idx++));
            String targetNodeName = item.getText(idx++);
            String sourceFieldName = item.getText(idx++);
            String sourceFieldValue = item.getText(idx++);
            String targetLabel = item.getText(idx++);
            nodeMappings.add(new NodeMapping((NodeMappingType)mappingType, targetNodeName, sourceFieldName, sourceFieldValue, targetLabel));
        }
        this.input.setNodeMappings(nodeMappings);
        this.input.setChanged();
        this.dispose();
    }

    private IRowMeta getInputRowMeta() {
        IRowMeta inputRowMeta;
        try {
            inputRowMeta = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
        }
        catch (HopTransformException e) {
            LogChannel.GENERAL.logError("Unable to find transform input field", (Throwable)e);
            inputRowMeta = new RowMeta();
        }
        return inputRowMeta;
    }
}

