/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.cypherbuilder.operation;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.metadata.api.IHopMetadataObjectFactory;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.CreateOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.DeleteOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.EdgeCreateOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.EdgeMatchOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.EdgeMergeOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.IOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.MatchOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.MergeOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.OperationType;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.OrderByOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.ReturnOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.SetOperation;

public class OperationFactory
implements IHopMetadataObjectFactory {
    public static IOperation createOperation(OperationType operationType) {
        assert (operationType != null) : "Please specify an operation type";
        return switch (operationType) {
            case OperationType.MATCH -> new MatchOperation();
            case OperationType.MERGE -> new MergeOperation();
            case OperationType.CREATE -> new CreateOperation();
            case OperationType.RETURN -> new ReturnOperation();
            case OperationType.DELETE -> new DeleteOperation();
            case OperationType.SET -> new SetOperation();
            case OperationType.ORDER_BY -> new OrderByOperation();
            case OperationType.EDGE_MATCH -> new EdgeMatchOperation();
            case OperationType.EDGE_CREATE -> new EdgeCreateOperation();
            case OperationType.EDGE_MERGE -> new EdgeMergeOperation();
            default -> throw new RuntimeException("Operation type " + String.valueOf((Object)operationType) + " is not supported");
        };
    }

    public Object createObject(String id, Object parentObject) throws HopException {
        try {
            OperationType operationType = OperationType.valueOf(id);
            return OperationFactory.createOperation(operationType);
        }
        catch (Exception e) {
            throw new HopException("Error creating operation object ", (Throwable)e);
        }
    }

    public String getObjectId(Object object) throws HopException {
        if (object instanceof IOperation) {
            IOperation iOperation = (IOperation)object;
            return iOperation.getOperationType().name();
        }
        throw new HopException("Unexpected object class received: " + object.getClass().getName());
    }
}

