/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.logging.util;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LoggingHierarchy;
import org.apache.hop.core.logging.LoggingRegistry;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.neo4j.logging.util.WorkLambda;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.eclipse.swt.graphics.Rectangle;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.TransactionContext;
import org.neo4j.driver.Value;
import org.neo4j.driver.types.Node;

public class LoggingCore {
    public static final boolean isEnabled(IVariables space) {
        String connectionName = space.getVariable("NEO4J_LOGGING_CONNECTION");
        return StringUtils.isNotEmpty((String)connectionName) && !"-".equals(connectionName);
    }

    public static final NeoConnection getConnection(IHopMetadataProvider metadataProvider, IVariables space) throws HopException {
        String connectionName = space.getVariable("NEO4J_LOGGING_CONNECTION");
        if (StringUtils.isEmpty((String)connectionName)) {
            return null;
        }
        IHopMetadataSerializer serializer = metadataProvider.getSerializer(NeoConnection.class);
        return (NeoConnection)serializer.load(connectionName);
    }

    public static final void writeHierarchies(ILogChannel log, NeoConnection connection, TransactionContext transaction, List<LoggingHierarchy> hierarchies, String rootLogChannelId) {
        try {
            StringBuilder execCypher;
            HashMap<String, Object> execPars;
            ILoggingObject loggingObject;
            for (LoggingHierarchy hierarchy : hierarchies) {
                loggingObject = hierarchy.getLoggingObject();
                LogLevel logLevel = loggingObject.getLogLevel();
                execPars = new HashMap<String, Object>();
                execPars.put("name", loggingObject.getObjectName());
                execPars.put("type", loggingObject.getObjectType().name());
                execPars.put("copy", loggingObject.getObjectCopy());
                execPars.put("id", loggingObject.getLogChannelId());
                execPars.put("containerId", loggingObject.getContainerId());
                execPars.put("logLevel", logLevel != null ? logLevel.getCode() : null);
                execPars.put("root", loggingObject.getLogChannelId().equals(rootLogChannelId));
                execPars.put("registrationDate", new SimpleDateFormat("yyyy/MM/dd'T'HH:mm:ss").format(loggingObject.getRegistrationDate()));
                execCypher = new StringBuilder();
                execCypher.append("MERGE (e:Execution { name : $name, type : $type, id : $id } ) ");
                execCypher.append("SET ");
                execCypher.append("  e.containerId = $containerId ");
                execCypher.append(", e.logLevel = $logLevel ");
                execCypher.append(", e.copy = $copy ");
                execCypher.append(", e.registrationDate = $registrationDate ");
                execCypher.append(", e.root = $root ");
                Result run = transaction.run(execCypher.toString(), execPars);
                run.consume();
            }
            for (LoggingHierarchy hierarchy : hierarchies) {
                loggingObject = hierarchy.getLoggingObject();
                ILoggingObject parentObject = loggingObject.getParent();
                if (parentObject == null) continue;
                execPars = new HashMap();
                execPars.put("name", loggingObject.getObjectName());
                execPars.put("type", loggingObject.getObjectType().name());
                execPars.put("id", loggingObject.getLogChannelId());
                execPars.put("parentName", parentObject.getObjectName());
                execPars.put("parentType", parentObject.getObjectType().name());
                execPars.put("parentId", parentObject.getLogChannelId());
                execCypher = new StringBuilder();
                execCypher.append("MATCH (child:Execution { name : $name, type : $type, id : $id } ) ");
                execCypher.append("MATCH (parent:Execution { name : $parentName, type : $parentType, id : $parentId } ) ");
                execCypher.append("MERGE (parent)-[rel:EXECUTES]->(child) ");
                transaction.run(execCypher.toString(), execPars);
            }
        }
        catch (Exception e) {
            log.logError("Error logging hierarchies", (Throwable)e);
        }
    }

    public static <T> T executeCypher(ILogChannel log, IVariables variables, NeoConnection connection, String cypher, Map<String, Object> parameters, WorkLambda<T> lambda) throws Exception {
        try (Driver driver = connection.getDriver(log, variables);){
            Object object;
            block12: {
                Session session = connection.getSession(log, driver, variables);
                try {
                    object = session.executeRead(tx -> {
                        Result result = tx.run(cypher, parameters);
                        return lambda.getResultValue(result);
                    });
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return (T)object;
        }
    }

    public static String getStringValue(Record record, int i) {
        if (i >= record.size()) {
            return null;
        }
        Value value = record.get(i);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.asString();
    }

    public static Long getLongValue(Record record, int i) {
        if (i >= record.size()) {
            return null;
        }
        Value value = record.get(i);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.asLong();
    }

    public static Date getDateValue(Record record, int i) {
        if (i >= record.size()) {
            return null;
        }
        Value value = record.get(i);
        if (value == null || value.isNull()) {
            return null;
        }
        LocalDateTime localDateTime = value.asLocalDateTime();
        if (localDateTime == null) {
            return null;
        }
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    @Nullable
    public static Boolean getBooleanValue(Record record, int i) {
        if (i >= record.size()) {
            return null;
        }
        Value value = record.get(i);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.asBoolean();
    }

    public static String getStringValue(Node node, String name) {
        Value value = node.get(name);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.asString();
    }

    public static Long getLongValue(Node node, String name) {
        Value value = node.get(name);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.asLong();
    }

    public static Integer getIntegerValue(Node node, String name) {
        Value value = node.get(name);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.asInt();
    }

    @Nullable
    public static Boolean getBooleanValue(Node node, String name) {
        Value value = node.get(name);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.asBoolean();
    }

    public static Date getDateValue(Node node, String name) {
        Value value = node.get(name);
        if (value == null || value.isNull()) {
            return null;
        }
        LocalDateTime localDateTime = value.asLocalDateTime();
        if (localDateTime == null) {
            return null;
        }
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static double calculateRadius(Rectangle bounds) {
        return (double)Math.min(bounds.width, bounds.height) * 0.8 / 2.0;
    }

    public static double calculateOptDistance(Rectangle bounds, int nrNodes) {
        if (nrNodes == 0) {
            return -1.0;
        }
        double radius = LoggingCore.calculateRadius(bounds);
        double circleLength = Math.PI * 2 * radius;
        return 0.75 * circleLength / (double)(nrNodes * 2);
    }

    public static final List<LoggingHierarchy> getLoggingHierarchy(String logChannelId) {
        ArrayList<LoggingHierarchy> hierarchy = new ArrayList<LoggingHierarchy>();
        List childIds = LoggingRegistry.getInstance().getLogChannelChildren(logChannelId);
        for (String childId : childIds) {
            ILoggingObject loggingObject = LoggingRegistry.getInstance().getLoggingObject(childId);
            if (loggingObject == null) continue;
            hierarchy.add(new LoggingHierarchy(logChannelId, loggingObject));
        }
        return hierarchy;
    }

    public static final String getFancyDurationFromMs(Long durationMs) {
        if (durationMs == null) {
            return "";
        }
        double seconds = (double)durationMs.longValue() / 1000.0;
        return LoggingCore.getFancyDurationFromSeconds(seconds);
    }

    public static final String getFancyDurationFromSeconds(double seconds) {
        int day = (int)TimeUnit.SECONDS.toDays((long)seconds);
        long hours = TimeUnit.SECONDS.toHours((long)seconds) - (long)(day * 24);
        long minute = TimeUnit.SECONDS.toMinutes((long)seconds) - TimeUnit.SECONDS.toHours((long)seconds) * 60L;
        long second = TimeUnit.SECONDS.toSeconds((long)seconds) - TimeUnit.SECONDS.toMinutes((long)seconds) * 60L;
        long ms = (long)((seconds - (double)((long)seconds)) * 1000.0);
        StringBuilder hms = new StringBuilder();
        if (day > 0) {
            hms.append(day + "d ");
        }
        if (day > 0 || hours > 0L) {
            hms.append(hours + "h ");
        }
        if (day > 0 || hours > 0L || minute > 0L) {
            hms.append(String.format("%02d", minute) + "' ");
        }
        hms.append(String.format("%02d", second) + ".");
        hms.append(String.format("%03d", ms) + "\"");
        return hms.toString();
    }
}

