/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.repeatfields;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IEnumHasCodeAndDescription;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.repeatfields.Repeat;
import org.apache.hop.pipeline.transforms.repeatfields.RepeatFields;
import org.apache.hop.pipeline.transforms.repeatfields.RepeatFieldsData;

@Transform(id="RepeatFields", image="repeatfields.svg", name="i18n::RepeatFields.Name", description="i18n::RepeatFields.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Utility", keywords={"i18n::RepeatFields.keyword"}, documentationUrl="/pipeline/transforms/repeatfields.html")
public class RepeatFieldsMeta
extends BaseTransformMeta<RepeatFields, RepeatFieldsData> {
    private static final Class<?> PKG = RepeatFields.class;
    @HopMetadataProperty(key="group_field", groupKey="group_fields", injectionGroupKey="GROUP_FIELDS", injectionGroupDescription="RepeatFields.Injection.GroupFields", injectionKey="GROUP_FIELD", injectionKeyDescription="RepeatFields.Injection.GroupField")
    private List<String> groupFields = new ArrayList<String>();
    @HopMetadataProperty(key="field", groupKey="repeats", injectionGroupKey="REPEATS", injectionGroupDescription="RepeatFields.Injection.Repeats", injectionKey="REPEAT", injectionKeyDescription="RepeatFields.Injection.Repeat")
    private List<Repeat> repeats = new ArrayList<Repeat>();

    public RepeatFieldsMeta() {
    }

    public RepeatFieldsMeta(RepeatFieldsMeta m) {
        this();
        this.groupFields.addAll(m.groupFields);
        for (Repeat repeat : m.repeats) {
            this.repeats.add(new Repeat(repeat));
        }
    }

    public Object clone() {
        return new RepeatFieldsMeta(this);
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (Repeat repeat : this.repeats) {
            String targetFieldName = variables.resolve(repeat.getTargetField());
            if (!StringUtils.isNotEmpty((String)targetFieldName)) continue;
            String sourceFieldName = variables.resolve(repeat.getSourceField());
            IValueMeta sourceFieldValueMeta = inputRowMeta.searchValueMeta(sourceFieldName);
            if (sourceFieldValueMeta == null) {
                throw new HopTransformException("Unable to find source field " + sourceFieldName + " in the input of transform " + name);
            }
            IValueMeta targetFieldValueMeta = sourceFieldValueMeta.clone();
            targetFieldValueMeta.setName(targetFieldName);
            targetFieldValueMeta.setOrigin(name);
            inputRowMeta.addValueMeta(targetFieldValueMeta);
        }
    }

    @Generated
    public List<String> getGroupFields() {
        return this.groupFields;
    }

    @Generated
    public List<Repeat> getRepeats() {
        return this.repeats;
    }

    @Generated
    public void setGroupFields(List<String> groupFields) {
        this.groupFields = groupFields;
    }

    @Generated
    public void setRepeats(List<Repeat> repeats) {
        this.repeats = repeats;
    }

    public static enum RepeatType implements IEnumHasCodeAndDescription
    {
        Previous("previous", BaseMessages.getString(PKG, (String)"RepeatFields.Previous.Description", (String[])new String[0])),
        PreviousWhenNull("previous_when_null", BaseMessages.getString(PKG, (String)"RepeatFields.PreviousWhenNull.Description", (String[])new String[0])),
        CurrentWhenIndicated("current_when_indicated", BaseMessages.getString(PKG, (String)"RepeatFields.CurrentWhenIndicated.Description", (String[])new String[0]));

        private final String code;
        private final String description;

        private RepeatType(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public static RepeatType lookupDescription(String description) {
            return (RepeatType)IEnumHasCodeAndDescription.lookupDescription(RepeatType.class, (String)description, null);
        }

        public static String[] getDescriptions() {
            return IEnumHasCodeAndDescription.getDescriptions(RepeatType.class);
        }

        @Generated
        public String getCode() {
            return this.code;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }
    }
}

