/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.workflowexecutor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.ActionTransformType;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaNone;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.CurrentDirectoryResolver;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transform.stream.Stream;
import org.apache.hop.pipeline.transform.stream.StreamIcon;
import org.apache.hop.pipeline.transforms.workflowexecutor.WorkflowExecutor;
import org.apache.hop.pipeline.transforms.workflowexecutor.WorkflowExecutorData;
import org.apache.hop.pipeline.transforms.workflowexecutor.WorkflowExecutorParameters;
import org.apache.hop.pipeline.transforms.workflowexecutor.WorkflowExecutorResultRows;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.w3c.dom.Node;

@Transform(id="WorkflowExecutor", image="workflowexecutor.svg", name="i18n::WorkflowExecutor.Name", description="i18n::WorkflowExecutor.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Flow", documentationUrl="/pipeline/transforms/workflow-executor.html", keywords={"i18n::WorkflowExecutorMeta.keyword"}, actionTransformTypes={ActionTransformType.HOP_FILE, ActionTransformType.HOP_WORKFLOW})
public class WorkflowExecutorMeta
extends BaseTransformMeta<WorkflowExecutor, WorkflowExecutorData> {
    private static final Class<?> PKG = WorkflowExecutorMeta.class;
    @HopMetadataProperty(key="run_configuration")
    private String runConfigurationName;
    @HopMetadataProperty(key="filename", hopMetadataPropertyType=HopMetadataPropertyType.WORKFLOW_FILE)
    private String filename;
    @HopMetadataProperty(key="group_size")
    private String groupSize;
    @HopMetadataProperty(key="group_field")
    private String groupField;
    @HopMetadataProperty(key="group_time")
    private String groupTime;
    @HopMetadataProperty(key="variablemapping", groupKey="parameters")
    private List<WorkflowExecutorParameters> parameters;
    @HopMetadataProperty(key="execution_result_target_transform")
    private String executionResultTargetTransform;
    private TransformMeta executionResultTargetTransformMeta;
    @HopMetadataProperty(key="execution_time_field")
    private String executionTimeField;
    @HopMetadataProperty(key="execution_result_field")
    private String executionResultField;
    @HopMetadataProperty(key="execution_errors_field")
    private String executionNrErrorsField;
    @HopMetadataProperty(key="execution_lines_read_field")
    private String executionLinesReadField;
    @HopMetadataProperty(key="execution_lines_written_field")
    private String executionLinesWrittenField;
    @HopMetadataProperty(key="execution_lines_input_field")
    private String executionLinesInputField;
    @HopMetadataProperty(key="execution_lines_output_field")
    private String executionLinesOutputField;
    @HopMetadataProperty(key="execution_lines_rejected_field")
    private String executionLinesRejectedField;
    @HopMetadataProperty(key="execution_lines_updated_field")
    private String executionLinesUpdatedField;
    @HopMetadataProperty(key="execution_lines_deleted_field")
    private String executionLinesDeletedField;
    @HopMetadataProperty(key="execution_files_retrieved_field")
    private String executionFilesRetrievedField;
    @HopMetadataProperty(key="execution_exit_status_field")
    private String executionExitStatusField;
    @HopMetadataProperty(key="execution_log_text_field")
    private String executionLogTextField;
    @HopMetadataProperty(key="execution_log_channelid_field")
    private String executionLogChannelIdField;
    @HopMetadataProperty(key="result_rows_target_transform")
    private String resultRowsTargetTransform;
    private TransformMeta resultRowsTargetTransformMeta;
    @HopMetadataProperty(key="result_rows_field", inlineListTags={"name", "type", "length", "precision"})
    private List<WorkflowExecutorResultRows> resultRowsField;
    @HopMetadataProperty(key="result_files_target_transform")
    private String resultFilesTargetTransform;
    private TransformMeta resultFilesTargetTransformMeta;
    @HopMetadataProperty(key="result_files_file_name_field")
    private String resultFilesFileNameField;
    @HopMetadataProperty(key="inherit_all_vars")
    private boolean inheritingAllVariables;
    private IHopMetadataProvider metadataProvider;

    @Deprecated(since="2.13")
    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            super.loadXml(transformNode, metadataProvider);
            String value = XmlHandler.getTagValue((Node)XmlHandler.getSubNode((Node)transformNode, (String)"parameters"), (String)"inherit_all_vars");
            if (value != null) {
                this.setInheritingAllVariables("Y".equalsIgnoreCase(value));
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"WorkflowExecutorMeta.Exception.ErrorLoadingJobExecutorDetailsFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.parameters = new ArrayList<WorkflowExecutorParameters>();
        this.resultRowsField = new ArrayList<WorkflowExecutorResultRows>();
        this.inheritingAllVariables = true;
        this.groupSize = "1";
        this.groupField = "";
        this.groupTime = "";
        this.executionTimeField = "ExecutionTime";
        this.executionResultField = "ExecutionResult";
        this.executionNrErrorsField = "ExecutionNrErrors";
        this.executionLinesReadField = "ExecutionLinesRead";
        this.executionLinesWrittenField = "ExecutionLinesWritten";
        this.executionLinesInputField = "ExecutionLinesInput";
        this.executionLinesOutputField = "ExecutionLinesOutput";
        this.executionLinesRejectedField = "ExecutionLinesRejected";
        this.executionLinesUpdatedField = "ExecutionLinesUpdated";
        this.executionLinesDeletedField = "ExecutionLinesDeleted";
        this.executionFilesRetrievedField = "ExecutionFilesRetrieved";
        this.executionExitStatusField = "ExecutionExitStatus";
        this.executionLogTextField = "ExecutionLogText";
        this.executionLogChannelIdField = "ExecutionLogChannelId";
        this.resultFilesFileNameField = "FileName";
    }

    public void getFields(IRowMeta row, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        row.clear();
        if (nextTransform != null && nextTransform.equals((Object)this.resultRowsTargetTransformMeta)) {
            for (WorkflowExecutorResultRows workflowExecutorResultRows : this.resultRowsField) {
                ValueMetaNone value;
                try {
                    value = ValueMetaFactory.createValueMeta((String)workflowExecutorResultRows.getName(), (int)ValueMetaFactory.getIdForValueMeta((String)workflowExecutorResultRows.getType()), (int)workflowExecutorResultRows.getLength(), (int)workflowExecutorResultRows.getPrecision());
                }
                catch (HopPluginException e) {
                    value = new ValueMetaNone(workflowExecutorResultRows.getName());
                    value.setLength(workflowExecutorResultRows.getLength(), workflowExecutorResultRows.getPrecision());
                }
                row.addValueMeta((IValueMeta)value);
            }
        } else if (nextTransform != null && nextTransform.equals((Object)this.resultFilesTargetTransformMeta)) {
            if (!Utils.isEmpty((CharSequence)this.resultFilesFileNameField)) {
                ValueMetaString value = new ValueMetaString("filename", 255, 0);
                row.addValueMeta((IValueMeta)value);
            }
        } else if (nextTransform != null && nextTransform.equals((Object)this.executionResultTargetTransformMeta)) {
            ValueMetaInteger value;
            if (!Utils.isEmpty((CharSequence)this.executionTimeField)) {
                value = new ValueMetaInteger(this.executionTimeField, 15, 0);
                row.addValueMeta((IValueMeta)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionResultField)) {
                value = new ValueMetaBoolean(this.executionResultField);
                row.addValueMeta((IValueMeta)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionNrErrorsField)) {
                value = new ValueMetaInteger(this.executionNrErrorsField, 9, 0);
                row.addValueMeta((IValueMeta)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLinesReadField)) {
                value = new ValueMetaInteger(this.executionLinesReadField, 9, 0);
                row.addValueMeta((IValueMeta)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLinesWrittenField)) {
                value = new ValueMetaInteger(this.executionLinesWrittenField, 9, 0);
                row.addValueMeta((IValueMeta)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLinesInputField)) {
                value = new ValueMetaInteger(this.executionLinesInputField, 9, 0);
                row.addValueMeta((IValueMeta)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLinesOutputField)) {
                value = new ValueMetaInteger(this.executionLinesOutputField, 9, 0);
                row.addValueMeta((IValueMeta)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLinesRejectedField)) {
                value = new ValueMetaInteger(this.executionLinesRejectedField, 9, 0);
                row.addValueMeta((IValueMeta)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLinesUpdatedField)) {
                value = new ValueMetaInteger(this.executionLinesUpdatedField, 9, 0);
                row.addValueMeta((IValueMeta)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLinesDeletedField)) {
                value = new ValueMetaInteger(this.executionLinesDeletedField, 9, 0);
                row.addValueMeta((IValueMeta)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionFilesRetrievedField)) {
                value = new ValueMetaInteger(this.executionFilesRetrievedField, 9, 0);
                row.addValueMeta((IValueMeta)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionExitStatusField)) {
                value = new ValueMetaInteger(this.executionExitStatusField, 3, 0);
                row.addValueMeta((IValueMeta)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLogTextField)) {
                value = new ValueMetaString(this.executionLogTextField);
                value.setLargeTextField(true);
                row.addValueMeta((IValueMeta)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLogChannelIdField)) {
                value = new ValueMetaString(this.executionLogChannelIdField, 50, 0);
                row.addValueMeta((IValueMeta)value);
            }
        }
    }

    public String[] getInfoTransforms() {
        String[] infoTransforms = this.getTransformIOMeta().getInfoTransformNames();
        return infoTransforms.length == 0 ? null : infoTransforms;
    }

    public String[] getTargetTransforms() {
        ArrayList<String> targetTransforms = new ArrayList<String>();
        if (!Utils.isEmpty((CharSequence)this.resultFilesTargetTransform)) {
            targetTransforms.add(this.resultFilesTargetTransform);
        }
        if (!Utils.isEmpty((CharSequence)this.resultRowsTargetTransform)) {
            targetTransforms.add(this.resultRowsTargetTransform);
        }
        if (targetTransforms.isEmpty()) {
            return null;
        }
        return targetTransforms.toArray(new String[targetTransforms.size()]);
    }

    public static final synchronized WorkflowMeta loadWorkflowMeta(WorkflowExecutorMeta executorMeta, IVariables variables, IHopMetadataProvider metadataProvider) throws HopException {
        return WorkflowExecutorMeta.loadWorkflowMeta(executorMeta, metadataProvider, variables);
    }

    public static final synchronized WorkflowMeta loadWorkflowMeta(WorkflowExecutorMeta executorMeta, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        WorkflowMeta mappingWorkflowMeta = null;
        CurrentDirectoryResolver r = new CurrentDirectoryResolver();
        IVariables tmpSpace = r.resolveCurrentDirectory(variables, executorMeta.getParentTransformMeta(), executorMeta.getFilename());
        String realFilename = tmpSpace.resolve(executorMeta.getFilename());
        mappingWorkflowMeta = new WorkflowMeta(variables, realFilename, metadataProvider);
        LogChannel.GENERAL.logDetailed("Loaded workflow", new Object[]{"Workflow was loaded from XML file [" + realFilename + "]"});
        mappingWorkflowMeta.setMetadataProvider(metadataProvider);
        mappingWorkflowMeta.setFilename(mappingWorkflowMeta.getFilename());
        return mappingWorkflowMeta;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.isEmpty()) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"WorkflowExecutorMeta.CheckResult.NotReceivingAnyFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"WorkflowExecutorMeta.CheckResult.TransformReceivingFields", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"WorkflowExecutorMeta.CheckResult.TransformReceivingFieldsFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"WorkflowExecutorMeta.CheckResult.NoInputReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, TransformMeta transformMeta) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        String realFilename = variables.resolve(this.filename);
        ResourceReference reference = new ResourceReference((IResourceHolder)transformMeta);
        references.add(reference);
        if (StringUtils.isNotEmpty((String)realFilename)) {
            reference.getEntries().add(new ResourceEntry(realFilename, ResourceEntry.ResourceType.ACTIONFILE));
        }
        return references;
    }

    WorkflowMeta loadWorkflowMetaProxy(WorkflowExecutorMeta executorMeta, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        return WorkflowExecutorMeta.loadWorkflowMeta(executorMeta, metadataProvider, variables);
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            WorkflowMeta executorWorkflowMeta = this.loadWorkflowMetaProxy(this, metadataProvider, variables);
            String proposedNewFilename = executorWorkflowMeta.exportResources(variables, definitions, iResourceNaming, metadataProvider);
            String newFilename = "${Internal.Entry.Current.Folder}/" + proposedNewFilename;
            executorWorkflowMeta.setFilename(newFilename);
            this.filename = newFilename;
            return proposedNewFilename;
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"WorkflowExecutorMeta.Exception.UnableToLoadWorkflow", (String[])new String[]{this.filename}));
        }
    }

    public ITransformIOMeta getTransformIOMeta() {
        ITransformIOMeta ioMeta = super.getTransformIOMeta(false);
        if (ioMeta == null) {
            ioMeta = new TransformIOMeta(true, true, true, false, true, false);
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.TARGET, this.executionResultTargetTransformMeta, BaseMessages.getString(PKG, (String)"WorkflowExecutorMeta.ResultStream.Description", (String[])new String[0]), StreamIcon.TARGET, null));
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.TARGET, this.resultRowsTargetTransformMeta, BaseMessages.getString(PKG, (String)"WorkflowExecutorMeta.ResultRowsStream.Description", (String[])new String[0]), StreamIcon.TARGET, null));
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.TARGET, this.resultFilesTargetTransformMeta, BaseMessages.getString(PKG, (String)"WorkflowExecutorMeta.ResultFilesStream.Description", (String[])new String[0]), StreamIcon.TARGET, null));
            this.setTransformIOMeta(ioMeta);
        }
        return ioMeta;
    }

    public void handleStreamSelection(IStream stream) {
        List targets = this.getTransformIOMeta().getTargetStreams();
        int index = targets.indexOf(stream);
        TransformMeta transform = ((IStream)targets.get(index)).getTransformMeta();
        switch (index) {
            case 0: {
                this.setExecutionResultTargetTransformMeta(transform);
                this.setExecutionResultTargetTransform(transform.getName());
                break;
            }
            case 1: {
                this.setResultRowsTargetTransformMeta(transform);
                this.setResultRowsTargetTransform(transform.getName());
                break;
            }
            case 2: {
                this.setResultFilesTargetTransformMeta(transform);
                this.setResultFilesTargetTransform(transform.getName());
                break;
            }
        }
    }

    public void resetTransformIoMeta() {
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        this.executionResultTargetTransformMeta = TransformMeta.findTransform(transforms, (String)this.executionResultTargetTransform);
        this.resultRowsTargetTransformMeta = TransformMeta.findTransform(transforms, (String)this.resultRowsTargetTransform);
        this.resultFilesTargetTransformMeta = TransformMeta.findTransform(transforms, (String)this.resultFilesTargetTransform);
    }

    public PipelineMeta.PipelineType[] getSupportedPipelineTypes() {
        return new PipelineMeta.PipelineType[]{PipelineMeta.PipelineType.Normal};
    }

    public boolean excludeFromCopyDistributeVerification() {
        return true;
    }

    public String[] getReferencedObjectDescriptions() {
        return new String[]{BaseMessages.getString(PKG, (String)"WorkflowExecutorMeta.ReferencedObject.Description", (String[])new String[0])};
    }

    private boolean isJobDefined() {
        return StringUtils.isNotEmpty((String)this.filename);
    }

    public boolean[] isReferencedObjectEnabled() {
        return new boolean[]{this.isJobDefined()};
    }

    public IHasFilename loadReferencedObject(int index, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        return WorkflowExecutorMeta.loadWorkflowMeta(this, metadataProvider, variables);
    }

    public boolean cleanAfterHopFromRemove() {
        this.setExecutionResultTargetTransformMeta(null);
        this.setExecutionResultTargetTransform(null);
        this.setResultRowsTargetTransformMeta(null);
        this.setResultRowsTargetTransform(null);
        this.setResultFilesTargetTransformMeta(null);
        this.setResultFilesTargetTransform(null);
        return true;
    }

    public boolean cleanAfterHopFromRemove(TransformMeta toTransform) {
        if (null == toTransform || null == toTransform.getName()) {
            return false;
        }
        boolean hasChanged = false;
        String toTransformName = toTransform.getName();
        if (this.getExecutionResultTargetTransformMeta() != null && toTransformName.equals(this.getExecutionResultTargetTransformMeta().getName())) {
            this.setExecutionResultTargetTransformMeta(null);
            this.setExecutionResultTargetTransform(null);
            hasChanged = true;
        } else if (this.getResultRowsTargetTransformMeta() != null && toTransformName.equals(this.getResultRowsTargetTransformMeta().getName())) {
            this.setResultRowsTargetTransformMeta(null);
            this.setResultRowsTargetTransform(null);
            hasChanged = true;
        } else if (this.getResultFilesTargetTransformMeta() != null && toTransformName.equals(this.getResultFilesTargetTransformMeta().getName())) {
            this.setResultFilesTargetTransformMeta(null);
            this.setResultFilesTargetTransform(null);
            hasChanged = true;
        }
        return hasChanged;
    }

    @Generated
    public String getRunConfigurationName() {
        return this.runConfigurationName;
    }

    @Generated
    public String getFilename() {
        return this.filename;
    }

    @Generated
    public String getGroupSize() {
        return this.groupSize;
    }

    @Generated
    public String getGroupField() {
        return this.groupField;
    }

    @Generated
    public String getGroupTime() {
        return this.groupTime;
    }

    @Generated
    public List<WorkflowExecutorParameters> getParameters() {
        return this.parameters;
    }

    @Generated
    public String getExecutionResultTargetTransform() {
        return this.executionResultTargetTransform;
    }

    @Generated
    public TransformMeta getExecutionResultTargetTransformMeta() {
        return this.executionResultTargetTransformMeta;
    }

    @Generated
    public String getExecutionTimeField() {
        return this.executionTimeField;
    }

    @Generated
    public String getExecutionResultField() {
        return this.executionResultField;
    }

    @Generated
    public String getExecutionNrErrorsField() {
        return this.executionNrErrorsField;
    }

    @Generated
    public String getExecutionLinesReadField() {
        return this.executionLinesReadField;
    }

    @Generated
    public String getExecutionLinesWrittenField() {
        return this.executionLinesWrittenField;
    }

    @Generated
    public String getExecutionLinesInputField() {
        return this.executionLinesInputField;
    }

    @Generated
    public String getExecutionLinesOutputField() {
        return this.executionLinesOutputField;
    }

    @Generated
    public String getExecutionLinesRejectedField() {
        return this.executionLinesRejectedField;
    }

    @Generated
    public String getExecutionLinesUpdatedField() {
        return this.executionLinesUpdatedField;
    }

    @Generated
    public String getExecutionLinesDeletedField() {
        return this.executionLinesDeletedField;
    }

    @Generated
    public String getExecutionFilesRetrievedField() {
        return this.executionFilesRetrievedField;
    }

    @Generated
    public String getExecutionExitStatusField() {
        return this.executionExitStatusField;
    }

    @Generated
    public String getExecutionLogTextField() {
        return this.executionLogTextField;
    }

    @Generated
    public String getExecutionLogChannelIdField() {
        return this.executionLogChannelIdField;
    }

    @Generated
    public String getResultRowsTargetTransform() {
        return this.resultRowsTargetTransform;
    }

    @Generated
    public TransformMeta getResultRowsTargetTransformMeta() {
        return this.resultRowsTargetTransformMeta;
    }

    @Generated
    public List<WorkflowExecutorResultRows> getResultRowsField() {
        return this.resultRowsField;
    }

    @Generated
    public String getResultFilesTargetTransform() {
        return this.resultFilesTargetTransform;
    }

    @Generated
    public TransformMeta getResultFilesTargetTransformMeta() {
        return this.resultFilesTargetTransformMeta;
    }

    @Generated
    public String getResultFilesFileNameField() {
        return this.resultFilesFileNameField;
    }

    @Generated
    public boolean isInheritingAllVariables() {
        return this.inheritingAllVariables;
    }

    @Generated
    public IHopMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    @Generated
    public void setRunConfigurationName(String runConfigurationName) {
        this.runConfigurationName = runConfigurationName;
    }

    @Generated
    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Generated
    public void setGroupSize(String groupSize) {
        this.groupSize = groupSize;
    }

    @Generated
    public void setGroupField(String groupField) {
        this.groupField = groupField;
    }

    @Generated
    public void setGroupTime(String groupTime) {
        this.groupTime = groupTime;
    }

    @Generated
    public void setParameters(List<WorkflowExecutorParameters> parameters) {
        this.parameters = parameters;
    }

    @Generated
    public void setExecutionResultTargetTransform(String executionResultTargetTransform) {
        this.executionResultTargetTransform = executionResultTargetTransform;
    }

    @Generated
    public void setExecutionResultTargetTransformMeta(TransformMeta executionResultTargetTransformMeta) {
        this.executionResultTargetTransformMeta = executionResultTargetTransformMeta;
    }

    @Generated
    public void setExecutionTimeField(String executionTimeField) {
        this.executionTimeField = executionTimeField;
    }

    @Generated
    public void setExecutionResultField(String executionResultField) {
        this.executionResultField = executionResultField;
    }

    @Generated
    public void setExecutionNrErrorsField(String executionNrErrorsField) {
        this.executionNrErrorsField = executionNrErrorsField;
    }

    @Generated
    public void setExecutionLinesReadField(String executionLinesReadField) {
        this.executionLinesReadField = executionLinesReadField;
    }

    @Generated
    public void setExecutionLinesWrittenField(String executionLinesWrittenField) {
        this.executionLinesWrittenField = executionLinesWrittenField;
    }

    @Generated
    public void setExecutionLinesInputField(String executionLinesInputField) {
        this.executionLinesInputField = executionLinesInputField;
    }

    @Generated
    public void setExecutionLinesOutputField(String executionLinesOutputField) {
        this.executionLinesOutputField = executionLinesOutputField;
    }

    @Generated
    public void setExecutionLinesRejectedField(String executionLinesRejectedField) {
        this.executionLinesRejectedField = executionLinesRejectedField;
    }

    @Generated
    public void setExecutionLinesUpdatedField(String executionLinesUpdatedField) {
        this.executionLinesUpdatedField = executionLinesUpdatedField;
    }

    @Generated
    public void setExecutionLinesDeletedField(String executionLinesDeletedField) {
        this.executionLinesDeletedField = executionLinesDeletedField;
    }

    @Generated
    public void setExecutionFilesRetrievedField(String executionFilesRetrievedField) {
        this.executionFilesRetrievedField = executionFilesRetrievedField;
    }

    @Generated
    public void setExecutionExitStatusField(String executionExitStatusField) {
        this.executionExitStatusField = executionExitStatusField;
    }

    @Generated
    public void setExecutionLogTextField(String executionLogTextField) {
        this.executionLogTextField = executionLogTextField;
    }

    @Generated
    public void setExecutionLogChannelIdField(String executionLogChannelIdField) {
        this.executionLogChannelIdField = executionLogChannelIdField;
    }

    @Generated
    public void setResultRowsTargetTransform(String resultRowsTargetTransform) {
        this.resultRowsTargetTransform = resultRowsTargetTransform;
    }

    @Generated
    public void setResultRowsTargetTransformMeta(TransformMeta resultRowsTargetTransformMeta) {
        this.resultRowsTargetTransformMeta = resultRowsTargetTransformMeta;
    }

    @Generated
    public void setResultRowsField(List<WorkflowExecutorResultRows> resultRowsField) {
        this.resultRowsField = resultRowsField;
    }

    @Generated
    public void setResultFilesTargetTransform(String resultFilesTargetTransform) {
        this.resultFilesTargetTransform = resultFilesTargetTransform;
    }

    @Generated
    public void setResultFilesTargetTransformMeta(TransformMeta resultFilesTargetTransformMeta) {
        this.resultFilesTargetTransformMeta = resultFilesTargetTransformMeta;
    }

    @Generated
    public void setResultFilesFileNameField(String resultFilesFileNameField) {
        this.resultFilesFileNameField = resultFilesFileNameField;
    }

    @Generated
    public void setInheritingAllVariables(boolean inheritingAllVariables) {
        this.inheritingAllVariables = inheritingAllVariables;
    }

    @Generated
    public void setMetadataProvider(IHopMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }
}

