/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mongo.wrapper.field;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.mongo.wrapper.field.MongoField;
import org.apache.hop.pipeline.transforms.mongodbinput.MongoDbInputData;
import org.bson.Document;

public class MongoArrayExpansion {
    protected static final Class<?> PKG = MongoArrayExpansion.class;
    public String expansionPath;
    protected List<MongoField> subFields;
    private List<String> pathParts;
    private List<String> tempParts;
    public IRowMeta outputRowMeta;

    public MongoArrayExpansion(List<MongoField> subFields) {
        this.subFields = subFields;
    }

    public void init() throws HopException {
        if (StringUtils.isEmpty((String)this.expansionPath)) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorMessage.NoPathSet", (String[])new String[0]));
        }
        if (this.pathParts != null) {
            return;
        }
        String expansionPath = MongoDbInputData.cleansePath(this.expansionPath);
        String[] temp = expansionPath.split("\\.");
        this.pathParts = new ArrayList<String>();
        Collections.addAll(this.pathParts, temp);
        if (this.pathParts.get(0).equals("$")) {
            this.pathParts.remove(0);
        } else if (this.pathParts.get(0).startsWith("$[")) {
            String r = this.pathParts.get(0).substring(1);
            this.pathParts.set(0, r);
        }
        this.tempParts = new ArrayList<String>();
        if (this.subFields != null) {
            for (MongoField f : this.subFields) {
                int outputIndex = this.outputRowMeta.indexOfValue(f.fieldName);
                f.init(outputIndex);
            }
        }
    }

    public void reset(IVariables variables) {
        this.tempParts.clear();
        for (String part : this.pathParts) {
            this.tempParts.add(variables.resolve(part));
        }
        for (MongoField f : this.subFields) {
            f.reset(variables);
        }
    }

    protected Object[][] nullResult() {
        return new Object[1][this.outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
    }

    public Object[][] convertToHopValue(Document mongoObject, IVariables variables) throws HopException {
        Object fieldValue;
        if (mongoObject == null) {
            return this.nullResult();
        }
        if (this.tempParts.isEmpty()) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorMessage.MalformedPathRecord", (String[])new String[0]));
        }
        String part = this.tempParts.remove(0);
        if (part.charAt(0) == '[') {
            return this.nullResult();
        }
        if (part.contains("[")) {
            String arrayPart = part.substring(part.indexOf(91));
            part = part.substring(0, part.indexOf(91));
            this.tempParts.add(0, arrayPart);
        }
        if ((fieldValue = mongoObject.get((Object)part)) == null) {
            return this.nullResult();
        }
        if (fieldValue instanceof Document) {
            Document doc = (Document)fieldValue;
            return this.convertToHopValue(doc, variables);
        }
        if (fieldValue instanceof List) {
            List list = (List)fieldValue;
            return this.convertToHopValue(list, variables);
        }
        return this.nullResult();
    }

    public Object[][] convertToHopValue(List<?> mongoList, IVariables variables) throws HopException {
        if (mongoList == null) {
            return this.nullResult();
        }
        if (this.tempParts.isEmpty()) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorMessage.MalformedPathArray", (String[])new String[0]));
        }
        String part = this.tempParts.remove(0);
        if (part.charAt(0) != '[') {
            return this.nullResult();
        }
        String index = part.substring(1, part.indexOf(93));
        if (part.indexOf(93) < part.length() - 1) {
            part = part.substring(part.indexOf(93) + 1);
            this.tempParts.add(0, part);
        }
        if (index.equals("*")) {
            Object[][] result = new Object[mongoList.size()][this.outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
            for (int i = 0; i < mongoList.size(); ++i) {
                Object element = mongoList.get(i);
                for (MongoField sf : this.subFields) {
                    sf.reset(variables);
                    if (element instanceof Document) {
                        Document doc = (Document)element;
                        result[i][sf.outputIndex] = sf.convertToHopValue(doc);
                        continue;
                    }
                    if (element instanceof List) {
                        List list = (List)element;
                        result[i][sf.outputIndex] = sf.convertToHopValue(list);
                        continue;
                    }
                    result[i][sf.outputIndex] = sf.getHopValue(element);
                }
            }
            return result;
        }
        int arrayI = 0;
        try {
            arrayI = Integer.parseInt(index.trim());
        }
        catch (NumberFormatException e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorMessage.UnableToParseArrayIndex", (String[])new String[]{index}));
        }
        if (arrayI >= mongoList.size() || arrayI < 0) {
            return this.nullResult();
        }
        Object element = mongoList.get(arrayI);
        if (element == null) {
            return this.nullResult();
        }
        if (element instanceof Document) {
            Document doc = (Document)element;
            return this.convertToHopValue(doc, variables);
        }
        if (element instanceof List) {
            List list = (List)element;
            return this.convertToHopValue(list, variables);
        }
        return this.nullResult();
    }
}

