/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mongo.wrapper.cursor;

import com.mongodb.ServerAddress;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCursor;
import org.apache.hop.mongo.MongoDbException;
import org.apache.hop.mongo.wrapper.cursor.MongoCursorWrapper;
import org.bson.Document;

public class DefaultCursorWrapper
implements MongoCursorWrapper {
    private final FindIterable<Document> findIterable;
    private MongoCursor<Document> cursor;
    private ServerAddress serverAddress;

    public DefaultCursorWrapper(FindIterable<Document> findIterable) {
        this.findIterable = findIterable;
        this.cursor = null;
    }

    private MongoCursor<Document> getCursor() {
        if (this.cursor == null) {
            this.cursor = this.findIterable.iterator();
        }
        return this.cursor;
    }

    @Override
    public boolean hasNext() throws MongoDbException {
        return this.getCursor().hasNext();
    }

    @Override
    public Document next() throws MongoDbException {
        Document doc = (Document)this.getCursor().next();
        if (this.serverAddress == null) {
            this.serverAddress = this.getCursor().getServerAddress();
        }
        return doc;
    }

    @Override
    public ServerAddress getServerAddress() throws MongoDbException {
        if (this.serverAddress != null) {
            return this.serverAddress;
        }
        return this.getCursor().getServerAddress();
    }

    @Override
    public void close() throws MongoDbException {
        if (this.cursor != null) {
            this.cursor.close();
        }
    }

    @Override
    public MongoCursorWrapper limit(int i) throws MongoDbException {
        if (this.cursor != null) {
            this.cursor.close();
            this.cursor = null;
        }
        return new DefaultCursorWrapper((FindIterable<Document>)this.findIterable.limit(i));
    }
}

