/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mongo.wrapper;

import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.connection.ClusterType;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.mongo.MongoDbException;
import org.apache.hop.mongo.MongoProp;
import org.apache.hop.mongo.MongoProperties;
import org.apache.hop.mongo.MongoUtilLogger;
import org.apache.hop.mongo.Util;
import org.apache.hop.mongo.wrapper.DefaultMongoClientFactory;
import org.apache.hop.mongo.wrapper.MongoClientFactory;
import org.apache.hop.mongo.wrapper.MongoClientWrapper;
import org.apache.hop.mongo.wrapper.MongoDBAction;
import org.apache.hop.mongo.wrapper.collection.DefaultMongoCollectionWrapper;
import org.apache.hop.mongo.wrapper.collection.MongoCollectionWrapper;
import org.bson.Document;
import org.bson.conversions.Bson;

class MongoClientWrapperImpl
implements MongoClientWrapper {
    private static final Class<?> PKG = MongoClientWrapperImpl.class;
    public static final int MONGO_DEFAULT_PORT = 27017;
    public static final String LOCAL_DB = "local";
    public static final String REPL_SET_COLLECTION = "system.replset";
    public static final String REPL_SET_SETTINGS = "settings";
    public static final String REPL_SET_LAST_ERROR_MODES = "getLastErrorModes";
    public static final String REPL_SET_MEMBERS = "members";
    public static final String CONST_MONGO_NO_AUTH_WRAPPER_MESSAGE_WARNING_NO_REPLICA_SET_MEMBERS_DEFINED = "MongoNoAuthWrapper.Message.Warning.NoReplicaSetMembersDefined";
    static MongoClientFactory clientFactory = new DefaultMongoClientFactory();
    private final MongoClient mongo;
    private final MongoUtilLogger log;
    protected MongoProperties props;

    MongoClientWrapperImpl(MongoProperties props, MongoUtilLogger log) throws MongoDbException {
        this.log = log;
        this.props = props;
        this.mongo = this.getClient(props.buildMongoClientSettings(log));
    }

    MongoClientWrapperImpl(MongoClient mongo, MongoProperties props, MongoUtilLogger log) {
        this.mongo = mongo;
        this.log = log;
        this.props = props;
    }

    MongoClient getMongo() {
        return this.mongo;
    }

    @Override
    public void test() throws MongoDbException {
        String databaseName = this.props.get(MongoProp.DBNAME);
        try {
            this.mongo.getDatabase(databaseName).runCommand((Bson)new Document("ping", (Object)1));
        }
        catch (Exception e) {
            throw new MongoDbException("Error pinging database " + databaseName, e);
        }
    }

    private List<ServerAddress> getServerAddressList() throws MongoDbException {
        String[] parts;
        String hostsPorts = this.props.get(MongoProp.HOST);
        String singlePort = this.props.get(MongoProp.PORT);
        int singlePortI = -1;
        try {
            singlePortI = Integer.parseInt(singlePort);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (Util.isEmpty(hostsPorts)) {
            throw new MongoDbException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.Message.Error.EmptyHostsString", (String[])new String[0]));
        }
        ArrayList<ServerAddress> serverList = new ArrayList<ServerAddress>();
        for (String part : parts = hostsPorts.trim().split(",")) {
            int port = singlePortI != -1 ? singlePortI : 27017;
            String[] hp = part.split(":");
            if (hp.length > 2) {
                throw new MongoDbException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.Message.Error.MalformedHost", (String[])new String[]{part}));
            }
            String host = hp[0];
            if (hp.length == 2) {
                try {
                    port = Integer.parseInt(hp[1].trim());
                }
                catch (NumberFormatException n) {
                    throw new MongoDbException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.Message.Error.UnableToParsePortNumber", (String[])new String[]{hp[1]}));
                }
            }
            try {
                ServerAddress s = new ServerAddress(host, port);
                serverList.add(s);
            }
            catch (Throwable u) {
                throw new MongoDbException(u);
            }
        }
        return serverList;
    }

    protected MongoClient getClient(MongoClientSettings.Builder settingsBuilder) throws MongoDbException {
        String connectionString = this.props.get(MongoProp.CONNECTION_STRING);
        if (!Util.isEmpty(connectionString)) {
            List<MongoCredential> credList = this.getCredentialList();
            return this.getClientFactory(this.props).getMongoClient(connectionString, settingsBuilder, credList);
        }
        List<MongoCredential> credList = this.getCredentialList();
        List<ServerAddress> serverAddressList = this.getServerAddressList();
        if (serverAddressList.isEmpty()) {
            throw new MongoDbException(BaseMessages.getString(MongoClientWrapper.class, (String)"MongoNoAuthWrapper.Message.Error.NoHostSet", (String[])new String[0]));
        }
        return this.getClientFactory(this.props).getMongoClient(serverAddressList, credList, settingsBuilder, this.props.useAllReplicaSetMembers());
    }

    @Override
    public List<String> getDatabaseNames() throws MongoDbException {
        try {
            ArrayList<String> names = new ArrayList<String>();
            this.getMongo().listDatabaseNames().into(names);
            return names;
        }
        catch (Exception e) {
            throw new MongoDbException(e);
        }
    }

    protected MongoDatabase getDb(String dbName) throws MongoDbException {
        try {
            return this.getMongo().getDatabase(dbName);
        }
        catch (Exception e) {
            throw new MongoDbException(e);
        }
    }

    @Override
    public Set<String> getCollectionsNames(String dB) throws MongoDbException {
        try {
            HashSet<String> names = new HashSet<String>();
            this.getDb(dB).listCollectionNames().into(names);
            return names;
        }
        catch (Exception e) {
            if (e instanceof MongoDbException) {
                MongoDbException mongoDbException = (MongoDbException)e;
                throw mongoDbException;
            }
            throw new MongoDbException(e);
        }
    }

    @Override
    public List<String> getLastErrorModes() throws MongoDbException {
        ArrayList<String> customLastErrorModes = new ArrayList<String>();
        MongoDatabase local = this.getDb(LOCAL_DB);
        if (local != null) {
            try {
                MongoCollection replset = local.getCollection(REPL_SET_COLLECTION);
                if (replset != null) {
                    Document config = (Document)replset.find().first();
                    this.extractLastErrorModes(config, customLastErrorModes);
                }
            }
            catch (Exception e) {
                throw new MongoDbException(e);
            }
        }
        return customLastErrorModes;
    }

    protected void extractLastErrorModes(Document config, List<String> customLastErrorModes) {
        Object getLastErrModes;
        Object settings;
        if (config != null && (settings = config.get((Object)REPL_SET_SETTINGS)) != null && (getLastErrModes = ((Document)settings).get((Object)REPL_SET_LAST_ERROR_MODES)) != null) {
            for (String m : ((Document)getLastErrModes).keySet()) {
                customLastErrorModes.add(m);
            }
        }
    }

    @Override
    public List<String> getIndexInfo(String dbName, String collection) throws MongoDbException {
        try {
            MongoCollection coll;
            MongoDatabase db = this.getDb(dbName);
            if (db == null) {
                throw new MongoDbException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.ErrorMessage.NonExistentDB", (String[])new String[]{dbName}));
            }
            if (Util.isEmpty(collection)) {
                throw new MongoDbException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.ErrorMessage.NoCollectionSpecified", (String[])new String[0]));
            }
            boolean exists = false;
            for (String name : db.listCollectionNames()) {
                if (!name.equals(collection)) continue;
                exists = true;
                break;
            }
            if (!exists) {
                db.createCollection(collection);
            }
            if ((coll = db.getCollection(collection)) == null) {
                throw new MongoDbException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.ErrorMessage.UnableToGetInfoForCollection", (String[])new String[]{collection}));
            }
            ArrayList<String> result = new ArrayList<String>();
            try (MongoCursor cursor = coll.listIndexes().iterator();){
                while (cursor.hasNext()) {
                    Document index = (Document)cursor.next();
                    result.add(index.toJson());
                }
            }
            if (Utils.isEmpty(result)) {
                throw new MongoDbException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.ErrorMessage.UnableToGetInfoForCollection", (String[])new String[]{collection}));
            }
            return result;
        }
        catch (Exception e) {
            this.log.error(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.ErrorMessage.GeneralError.Message", (String[])new String[0]) + ":\n\n" + e.getMessage(), e);
            if (e instanceof MongoDbException) {
                MongoDbException mongoDbException = (MongoDbException)e;
                throw mongoDbException;
            }
            throw new MongoDbException(e);
        }
    }

    @Override
    public List<String> getAllTags() throws MongoDbException {
        return this.setupAllTags(this.getRepSetMemberRecords());
    }

    private List<Document> getRepSetMemberRecords() throws MongoDbException {
        List setMembers = null;
        try {
            MongoDatabase local = this.getDb(LOCAL_DB);
            if (local != null) {
                MongoCollection replset = local.getCollection(REPL_SET_COLLECTION);
                if (replset != null) {
                    Document config = (Document)replset.find().first();
                    if (config != null) {
                        Object members = config.get((Object)REPL_SET_MEMBERS);
                        if (members instanceof List) {
                            List membersList = (List)members;
                            if (membersList.isEmpty()) {
                                this.logInfo(BaseMessages.getString(PKG, (String)CONST_MONGO_NO_AUTH_WRAPPER_MESSAGE_WARNING_NO_REPLICA_SET_MEMBERS_DEFINED, (String[])new String[0]));
                            } else {
                                setMembers = membersList;
                            }
                        } else {
                            this.logInfo(BaseMessages.getString(PKG, (String)CONST_MONGO_NO_AUTH_WRAPPER_MESSAGE_WARNING_NO_REPLICA_SET_MEMBERS_DEFINED, (String[])new String[0]));
                        }
                    } else {
                        this.logInfo(BaseMessages.getString(PKG, (String)CONST_MONGO_NO_AUTH_WRAPPER_MESSAGE_WARNING_NO_REPLICA_SET_MEMBERS_DEFINED, (String[])new String[0]));
                    }
                } else {
                    this.logInfo(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.Message.Warning.ReplicaSetCollectionUnavailable", (String[])new String[0]));
                }
            } else {
                this.logInfo(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.Message.Warning.LocalDBNotAvailable", (String[])new String[0]));
            }
        }
        catch (Exception ex) {
            throw new MongoDbException(ex);
        }
        finally {
            if (this.getMongo() != null) {
                this.getMongo().close();
            }
        }
        return setMembers;
    }

    private void logInfo(String message) {
        if (this.log != null) {
            this.log.info(message);
        }
    }

    protected List<String> setupAllTags(List<Document> members) {
        HashSet<CallSite> tempTags = new HashSet<CallSite>();
        if (!Utils.isEmpty(members)) {
            for (Document member : members) {
                Document tags;
                if (member == null || (tags = (Document)member.get((Object)"tags")) == null) continue;
                for (String tagName : tags.keySet()) {
                    String tagVal = tags.get((Object)tagName).toString();
                    String combined = MongoClientWrapperImpl.quote(tagName) + " : " + MongoClientWrapperImpl.quote(tagVal);
                    tempTags.add((CallSite)((Object)combined));
                }
            }
        }
        return new ArrayList<String>(tempTags);
    }

    protected static String quote(String string) {
        if (((String)string).indexOf(34) >= 0) {
            string = ((String)string).replace("\"", "\\\"");
        }
        string = "\"" + (String)string + "\"";
        return string;
    }

    @Override
    public List<String> getReplicaSetMembersThatSatisfyTagSets(List<Document> tagSets) throws MongoDbException {
        try {
            ArrayList<String> result = new ArrayList<String>();
            for (Document object : this.checkForReplicaSetMembersThatSatisfyTagSets(tagSets, this.getRepSetMemberRecords())) {
                result.add(object.toJson());
            }
            return result;
        }
        catch (Exception ex) {
            if (ex instanceof MongoDbException) {
                MongoDbException mongoDbException = (MongoDbException)ex;
                throw mongoDbException;
            }
            throw new MongoDbException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.ErrorMessage.UnableToGetReplicaSetMembers", (String[])new String[0]), ex);
        }
    }

    protected List<Document> checkForReplicaSetMembersThatSatisfyTagSets(List<Document> tagSets, List<Document> members) {
        ArrayList<Document> satisfy = new ArrayList<Document>();
        if (!Utils.isEmpty(members)) {
            for (Document m : members) {
                Document tags;
                if (m == null || (tags = (Document)m.get((Object)"tags")) == null) continue;
                for (Document toMatch : tagSets) {
                    boolean match = true;
                    for (String tagName : toMatch.keySet()) {
                        String tagValue = toMatch.get((Object)tagName).toString();
                        Object matchVal = tags.get((Object)tagName);
                        if (matchVal == null) {
                            match = false;
                            break;
                        }
                        if (matchVal.toString().equals(tagValue)) continue;
                        match = false;
                        break;
                    }
                    if (!match || satisfy.contains(m)) continue;
                    satisfy.add(m);
                }
            }
        }
        return satisfy;
    }

    @Override
    public MongoCollectionWrapper getCollection(String db, String name) throws MongoDbException {
        return this.wrap((MongoCollection<Document>)this.getDb(db).getCollection(name));
    }

    @Override
    public MongoCollectionWrapper createCollection(String db, String name) throws MongoDbException {
        this.getDb(db).createCollection(name);
        return this.wrap((MongoCollection<Document>)this.getDb(db).getCollection(name));
    }

    @Override
    public List<MongoCredential> getCredentialList() {
        char[] passwordChars;
        ArrayList<MongoCredential> credList = new ArrayList<MongoCredential>();
        String username = this.props.get(MongoProp.USERNAME);
        String password = this.props.get(MongoProp.PASSWORD);
        if (username == null || username.trim().isEmpty() || password == null) {
            return credList;
        }
        String authDatabase = this.props.get(MongoProp.AUTH_DATABASE);
        String dbName = this.props.get(MongoProp.DBNAME);
        String authMecha = this.props.get(MongoProp.AUTH_MECHA);
        if (authMecha == null) {
            authMecha = "";
        }
        String string = authDatabase = authDatabase == null || authDatabase.trim().isEmpty() ? dbName : authDatabase;
        if (authDatabase == null || authDatabase.trim().isEmpty()) {
            authDatabase = "admin";
        }
        char[] cArray = passwordChars = password != null && !password.isEmpty() ? password.toCharArray() : new char[]{};
        if (authMecha.equalsIgnoreCase("SCRAM-SHA-1") || authMecha.equalsIgnoreCase("SCRAM_SHA_1")) {
            credList.add(MongoCredential.createScramSha1Credential((String)username, (String)authDatabase, (char[])passwordChars));
        } else if (authMecha.equalsIgnoreCase("SCRAM-SHA-256") || authMecha.equalsIgnoreCase("SCRAM_SHA_256")) {
            credList.add(MongoCredential.createScramSha256Credential((String)username, (String)authDatabase, (char[])passwordChars));
        } else if (authMecha.equalsIgnoreCase("PLAIN")) {
            credList.add(MongoCredential.createPlainCredential((String)username, (String)authDatabase, (char[])passwordChars));
        } else {
            credList.add(MongoCredential.createCredential((String)username, (String)authDatabase, (char[])passwordChars));
        }
        return credList;
    }

    protected MongoCollectionWrapper wrap(MongoCollection<Document> collection) {
        return new DefaultMongoCollectionWrapper(collection);
    }

    @Override
    public void dispose() {
        if (this.getMongo() != null) {
            this.getMongo().close();
        }
    }

    @Override
    public boolean isReplicaSet() {
        try {
            return this.getMongo().getClusterDescription().getType().equals((Object)ClusterType.REPLICA_SET);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public <ReturnType> ReturnType perform(String db, MongoDBAction<ReturnType> action) throws MongoDbException {
        return action.perform(this.getDb(db));
    }

    public MongoClientFactory getClientFactory(MongoProperties opts) {
        return clientFactory;
    }
}

