/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mongo.wrapper;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.connection.ClusterConnectionMode;
import java.util.Collections;
import java.util.List;
import org.apache.hop.mongo.wrapper.MongoClientFactory;

public class DefaultMongoClientFactory
implements MongoClientFactory {
    @Override
    public MongoClient getMongoClient(List<ServerAddress> serverAddressList, List<MongoCredential> credList, MongoClientSettings.Builder settingsBuilder, boolean useReplicaSet) {
        List<ServerAddress> hosts = useReplicaSet || serverAddressList.size() > 1 ? serverAddressList : Collections.singletonList(serverAddressList.get(0));
        settingsBuilder.applyToClusterSettings(builder -> builder.hosts(hosts).mode(this.getClusterMode(hosts, useReplicaSet)));
        if (credList != null && !credList.isEmpty()) {
            settingsBuilder.credential(credList.get(0));
        }
        return MongoClients.create((MongoClientSettings)settingsBuilder.build());
    }

    private ClusterConnectionMode getClusterMode(List<ServerAddress> hosts, boolean useReplicaSet) {
        if (useReplicaSet || hosts.size() > 1) {
            return ClusterConnectionMode.MULTIPLE;
        }
        return ClusterConnectionMode.SINGLE;
    }

    @Override
    public MongoClient getMongoClient(String connectionString, MongoClientSettings.Builder settingsBuilder, List<MongoCredential> credList) {
        ConnectionString connString = new ConnectionString(connectionString);
        if (settingsBuilder != null) {
            if (credList != null && !credList.isEmpty()) {
                settingsBuilder.credential(credList.get(0));
            }
            settingsBuilder.applyConnectionString(connString);
            if (credList != null && !credList.isEmpty()) {
                settingsBuilder.credential(credList.get(0));
            }
            return MongoClients.create((MongoClientSettings)settingsBuilder.build());
        }
        if (credList != null && !credList.isEmpty()) {
            MongoClientSettings.Builder builder = MongoClientSettings.builder();
            builder.applyConnectionString(connString);
            builder.credential(credList.get(0));
            return MongoClients.create((MongoClientSettings)builder.build());
        }
        return MongoClients.create((ConnectionString)connString);
    }
}

