/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mongo.metadata;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.mongo.MongoDbException;
import org.apache.hop.mongo.MongoProp;
import org.apache.hop.mongo.MongoProperties;
import org.apache.hop.mongo.NamedReadPreference;
import org.apache.hop.mongo.metadata.MongoDbAuthenticationMechanism;
import org.apache.hop.mongo.metadata.MongoDbConnectionType;
import org.apache.hop.mongo.wrapper.HopMongoUtilLogger;
import org.apache.hop.mongo.wrapper.MongoClientWrapper;
import org.apache.hop.mongo.wrapper.MongoClientWrapperFactory;

@GuiPlugin
@HopMetadata(key="mongodb-connection", name="i18n::MongoDbConnection.name", description="i18n::MongoDbConnection.description", image="MongoDB_Leaf_FullColor_RGB.svg", documentationUrl="/metadata-types/mongodb-connection.html", hopMetadataPropertyType=HopMetadataPropertyType.MONGODB_CONNECTION)
public class MongoDbConnection
extends HopMetadataBase
implements IHopMetadata {
    public static final String WIDGET_ID_CONNECTION_TYPE = "09900-connection-type";
    public static final String WIDGET_ID_HOSTNAME = "10000-hostname";
    public static final String WIDGET_ID_PORT = "10100-port";
    public static final String WIDGET_ID_APPNAME = "10150-appname";
    public static final String WIDGET_ID_DB_NAME = "10200-database-name";
    public static final String WIDGET_ID_COLLECTION = "10300-collection";
    public static final String WIDGET_ID_AUTH_DB_NAME = "10400-auth-database-name";
    public static final String WIDGET_ID_AUTH_USER = "10500-auth-user";
    public static final String WIDGET_ID_AUTH_PASSWORD = "10600-auth-password";
    public static final String WIDGET_ID_AUTH_MECHANISM = "10700-auth-mechanism";
    public static final String WIDGET_ID_CONNECTION_TIMEOUT_MS = "10900-connection-timeout-ms";
    public static final String WIDGET_ID_SOCKET_TIMEOUT_MS = "11000-socket-timeout-ms";
    public static final String WIDGET_ID_READ_PREFERENCE = "11100-read-preference";
    public static final String WIDGET_ID_USE_ALL_REPLICA_SET_MEMBERS = "11200-use-all-replica-set-members";
    public static final String WIDGET_ID_READ_PREF_TAG_SETS = "11300-read-pref-tag-sets";
    public static final String WIDGET_ID_USE_SSL_SOCKET_FACTORY = "11400-use-ssl-socket-factory";
    public static final String WIDGET_ID_WRITE_CONCERN = "11500-write-concern";
    public static final String WIDGET_ID_TIMEOUT_MS = "11600-timeout-ms";
    public static final String WIDGET_ID_JOURNALED = "11700-journaled";
    @HopMetadataProperty
    @GuiWidgetElement(id="09900-connection-type", type=GuiElementType.COMBO, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="i18n::MongoMetadata.ConnectionType.Label", toolTip="i18n::MongoMetadata.ConnectionType.ToolTip", variables=false)
    private MongoDbConnectionType connectionType = MongoDbConnectionType.STANDARD;
    @HopMetadataProperty
    @GuiWidgetElement(id="10000-hostname", type=GuiElementType.TEXT, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="i18n::MongoMetadata.Hostname.Label", toolTip="i18n::MongoMetadata.Hostname.ToolTip")
    private String hostname = "localhost";
    @HopMetadataProperty
    @GuiWidgetElement(id="10100-port", type=GuiElementType.TEXT, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="i18n::MongoMetadata.Port.Label", toolTip="i18n::MongoMetadata.Port.ToolTip")
    private String port;
    @HopMetadataProperty
    @GuiWidgetElement(id="10150-appname", type=GuiElementType.TEXT, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="i18n::MongoMetadata.AppName.Label", toolTip="i18n::MongoMetadata.AppName.ToolTip")
    private String appName;
    @HopMetadataProperty
    @GuiWidgetElement(id="10200-database-name", type=GuiElementType.COMBO, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="i18n::MongoMetadata.DbName.Label", toolTip="i18n::MongoMetadata.DbName.ToolTip")
    private String dbName;
    @HopMetadataProperty
    @GuiWidgetElement(id="10400-auth-database-name", type=GuiElementType.COMBO, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="i18n::MongoMetadata.AuthDatabaseName.Label", toolTip="i18n::MongoMetadata.AuthDatabaseName.ToolTip")
    private String authenticationDatabaseName;
    @HopMetadataProperty
    @GuiWidgetElement(id="10500-auth-user", type=GuiElementType.TEXT, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="i18n::MongoMetadata.Username.Label", toolTip="i18n::MongoMetadata.Username.ToolTip")
    private String authenticationUser;
    @HopMetadataProperty(password=true)
    @GuiWidgetElement(id="10600-auth-password", type=GuiElementType.TEXT, password=true, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="i18n::MongoMetadata.Password.Label", toolTip="i18n::MongoMetadata.Password.ToolTip")
    private String authenticationPassword;
    @HopMetadataProperty
    @GuiWidgetElement(id="10700-auth-mechanism", type=GuiElementType.COMBO, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="i18n::MongoMetadata.AuthenticationMechanism.Label", toolTip="i18n::MongoMetadata.AuthenticationMechanism.ToolTip", variables=false)
    private MongoDbAuthenticationMechanism authenticationMechanism = MongoDbAuthenticationMechanism.PLAIN;
    @HopMetadataProperty
    @GuiWidgetElement(id="10900-connection-timeout-ms", type=GuiElementType.TEXT, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="i18n::MongoMetadata.ConnectionTimeoutMs.Label", toolTip="i18n::MongoMetadata.ConnectionTimeoutMs.ToolTip")
    private String connectTimeoutMs = "";
    @HopMetadataProperty
    @GuiWidgetElement(id="11000-socket-timeout-ms", type=GuiElementType.TEXT, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="i18n::MongoMetadata.SocketTimeoutMs.Label", toolTip="i18n::MongoMetadata.SocketTimeoutMs.ToolTip")
    private String socketTimeoutMs = "";
    @HopMetadataProperty
    @GuiWidgetElement(id="11100-read-preference", type=GuiElementType.COMBO, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="i18n::MongoMetadata.ReadPreference.Label", toolTip="i18n::MongoMetadata.ReadPreference.ToolTip", variables=false)
    private NamedReadPreference readPreference = NamedReadPreference.PRIMARY;
    @HopMetadataProperty
    @GuiWidgetElement(id="11200-use-all-replica-set-members", type=GuiElementType.CHECKBOX, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="i18n::MongoMetadata.UseAllReplicaSetMembers.Label", toolTip="i18n::MongoMetadata.UseAllReplicaSetMembers.ToolTip")
    private boolean usingAllReplicaSetMembers;
    @HopMetadataProperty
    @GuiWidgetElement(id="11300-read-pref-tag-sets", type=GuiElementType.COMBO, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="i18n::MongoMetadata.ReadPrefTagSets.Label", toolTip="i18n::MongoMetadata.ReadPrefTagSets.ToolTip")
    private String readPrefTagSets;
    @HopMetadataProperty
    @GuiWidgetElement(id="11400-use-ssl-socket-factory", type=GuiElementType.CHECKBOX, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="i18n::MongoMetadata.UseSslSocketFactory.Label", toolTip="i18n::MongoMetadata.UseSslSocketFactory.ToolTip")
    private boolean usingSslSocketFactory;
    @HopMetadataProperty
    @GuiWidgetElement(id="11500-write-concern", type=GuiElementType.TEXT, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="i18n::MongoMetadata.WriteConcern.Label", toolTip="i18n::MongoMetadata.WriteConcern.ToolTip")
    private String writeConcern = "";
    @HopMetadataProperty
    @GuiWidgetElement(id="11600-timeout-ms", type=GuiElementType.TEXT, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="i18n::MongoMetadata.ReplicaTimeoutMs.Label", toolTip="i18n::MongoMetadata.ReplicaTimeoutMs.ToolTip")
    private String replicationTimeoutMs = "";
    @HopMetadataProperty
    @GuiWidgetElement(id="11700-journaled", type=GuiElementType.CHECKBOX, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="i18n::MongoMetadata.Journaled.Label", toolTip="i18n::MongoMetadata.Journaled.ToolTip")
    private boolean journaled = true;

    public MongoDbConnection() {
    }

    public MongoDbConnection(MongoDbConnection m) {
        super(m.name);
        this.connectionType = m.connectionType;
        this.hostname = m.hostname;
        this.port = m.port;
        this.appName = m.appName;
        this.dbName = m.dbName;
        this.authenticationDatabaseName = m.authenticationDatabaseName;
        this.authenticationUser = m.authenticationUser;
        this.authenticationPassword = m.authenticationPassword;
        this.authenticationMechanism = m.authenticationMechanism;
        this.connectTimeoutMs = m.connectTimeoutMs;
        this.socketTimeoutMs = m.socketTimeoutMs;
        this.readPreference = m.readPreference;
        this.usingAllReplicaSetMembers = m.usingAllReplicaSetMembers;
        this.readPrefTagSets = m.readPrefTagSets;
        this.usingSslSocketFactory = m.usingSslSocketFactory;
        this.writeConcern = m.writeConcern;
        this.replicationTimeoutMs = m.replicationTimeoutMs;
        this.journaled = m.journaled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test(IVariables variables, ILogChannel log) throws MongoDbException {
        String testDbName = variables.resolve(this.dbName);
        if (StringUtils.isEmpty((String)testDbName)) {
            throw new MongoDbException("Database name cannot be null or empty. Please specify a database name in the connection settings.");
        }
        MongoClientWrapper wrapper = this.createWrapper(variables, log);
        try {
            wrapper.test();
        }
        finally {
            wrapper.dispose();
        }
    }

    public MongoClientWrapper createWrapper(IVariables variables, ILogChannel log) throws MongoDbException {
        return MongoClientWrapperFactory.createMongoClientWrapper(this.createPropertiesBuilder(variables).build(), new HopMongoUtilLogger(log));
    }

    public MongoProperties.Builder createPropertiesBuilder(IVariables variables) {
        MongoProperties.Builder propertiesBuilder = new MongoProperties.Builder();
        String connectionString = this.buildCleanConnectionString(variables);
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.CONNECTION_STRING, connectionString);
        if (this.connectionType != MongoDbConnectionType.SRV) {
            MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.HOST, this.hostname);
            MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.PORT, this.port);
        }
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.DBNAME, this.dbName);
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.connectTimeout, this.connectTimeoutMs);
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.socketTimeout, this.socketTimeoutMs);
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.readPreference, this.readPreference.getName());
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.writeConcern, this.writeConcern);
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.wTimeout, this.replicationTimeoutMs);
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.JOURNALED, Boolean.toString(this.journaled));
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.USE_ALL_REPLICA_SET_MEMBERS, Boolean.toString(this.usingAllReplicaSetMembers));
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.AUTH_DATABASE, this.authenticationDatabaseName);
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.USERNAME, this.authenticationUser);
        MongoDbConnection.setIfNotNullOrEmptyPassword(variables, propertiesBuilder, MongoProp.PASSWORD, this.authenticationPassword);
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.AUTH_MECHA, this.authenticationMechanism.name());
        boolean sslRequired = this.connectionType == MongoDbConnectionType.SRV || this.usingSslSocketFactory;
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.useSSL, Boolean.toString(sslRequired));
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.tagSet, this.readPrefTagSets);
        return propertiesBuilder;
    }

    private static void setIfNotNullOrEmpty(IVariables variables, MongoProperties.Builder builder, MongoProp prop, String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            builder.set(prop, variables.resolve(value));
        }
    }

    private static void setIfNotNullOrEmptyPassword(IVariables variables, MongoProperties.Builder builder, MongoProp prop, String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            builder.set(prop, Utils.resolvePassword((IVariables)variables, (String)variables.resolve(value)));
        }
    }

    private String buildCleanConnectionString(IVariables variables) {
        String resolvedPort;
        StringBuilder connStr = new StringBuilder();
        if (this.connectionType == MongoDbConnectionType.SRV) {
            connStr.append("mongodb+srv://");
        } else {
            connStr.append("mongodb://");
        }
        String resolvedHostname = variables.resolve(this.hostname);
        if (StringUtils.isNotEmpty((String)resolvedHostname)) {
            connStr.append(resolvedHostname);
        } else {
            connStr.append("localhost");
        }
        if (this.connectionType == MongoDbConnectionType.STANDARD && StringUtils.isNotEmpty((String)(resolvedPort = variables.resolve(this.port)))) {
            connStr.append(":").append(resolvedPort);
        }
        String resolvedDbName = variables.resolve(this.dbName);
        connStr.append("/");
        if (StringUtils.isNotEmpty((String)resolvedDbName)) {
            connStr.append(resolvedDbName);
        }
        StringBuilder queryParams = new StringBuilder();
        String resolvedAppName = variables.resolve(this.appName);
        if (StringUtils.isNotEmpty((String)resolvedAppName)) {
            try {
                queryParams.append("appName=").append(URLEncoder.encode(resolvedAppName, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                queryParams.append("appName=").append(resolvedAppName);
            }
        }
        if (this.connectionType == MongoDbConnectionType.SRV || this.usingSslSocketFactory) {
            if (!queryParams.isEmpty()) {
                queryParams.append("&");
            }
            queryParams.append("ssl=true");
        }
        if (!queryParams.isEmpty()) {
            connStr.append("?").append((CharSequence)queryParams);
        }
        return connStr.toString();
    }

    @Generated
    public MongoDbConnectionType getConnectionType() {
        return this.connectionType;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public String getPort() {
        return this.port;
    }

    @Generated
    public String getAppName() {
        return this.appName;
    }

    @Generated
    public String getDbName() {
        return this.dbName;
    }

    @Generated
    public String getAuthenticationDatabaseName() {
        return this.authenticationDatabaseName;
    }

    @Generated
    public String getAuthenticationUser() {
        return this.authenticationUser;
    }

    @Generated
    public String getAuthenticationPassword() {
        return this.authenticationPassword;
    }

    @Generated
    public MongoDbAuthenticationMechanism getAuthenticationMechanism() {
        return this.authenticationMechanism;
    }

    @Generated
    public String getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    @Generated
    public String getSocketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    @Generated
    public NamedReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Generated
    public boolean isUsingAllReplicaSetMembers() {
        return this.usingAllReplicaSetMembers;
    }

    @Generated
    public String getReadPrefTagSets() {
        return this.readPrefTagSets;
    }

    @Generated
    public boolean isUsingSslSocketFactory() {
        return this.usingSslSocketFactory;
    }

    @Generated
    public String getWriteConcern() {
        return this.writeConcern;
    }

    @Generated
    public String getReplicationTimeoutMs() {
        return this.replicationTimeoutMs;
    }

    @Generated
    public boolean isJournaled() {
        return this.journaled;
    }

    @Generated
    public void setConnectionType(MongoDbConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Generated
    public void setPort(String port) {
        this.port = port;
    }

    @Generated
    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Generated
    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    @Generated
    public void setAuthenticationDatabaseName(String authenticationDatabaseName) {
        this.authenticationDatabaseName = authenticationDatabaseName;
    }

    @Generated
    public void setAuthenticationUser(String authenticationUser) {
        this.authenticationUser = authenticationUser;
    }

    @Generated
    public void setAuthenticationPassword(String authenticationPassword) {
        this.authenticationPassword = authenticationPassword;
    }

    @Generated
    public void setAuthenticationMechanism(MongoDbAuthenticationMechanism authenticationMechanism) {
        this.authenticationMechanism = authenticationMechanism;
    }

    @Generated
    public void setConnectTimeoutMs(String connectTimeoutMs) {
        this.connectTimeoutMs = connectTimeoutMs;
    }

    @Generated
    public void setSocketTimeoutMs(String socketTimeoutMs) {
        this.socketTimeoutMs = socketTimeoutMs;
    }

    @Generated
    public void setReadPreference(NamedReadPreference readPreference) {
        this.readPreference = readPreference;
    }

    @Generated
    public void setUsingAllReplicaSetMembers(boolean usingAllReplicaSetMembers) {
        this.usingAllReplicaSetMembers = usingAllReplicaSetMembers;
    }

    @Generated
    public void setReadPrefTagSets(String readPrefTagSets) {
        this.readPrefTagSets = readPrefTagSets;
    }

    @Generated
    public void setUsingSslSocketFactory(boolean usingSslSocketFactory) {
        this.usingSslSocketFactory = usingSslSocketFactory;
    }

    @Generated
    public void setWriteConcern(String writeConcern) {
        this.writeConcern = writeConcern;
    }

    @Generated
    public void setReplicationTimeoutMs(String replicationTimeoutMs) {
        this.replicationTimeoutMs = replicationTimeoutMs;
    }

    @Generated
    public void setJournaled(boolean journaled) {
        this.journaled = journaled;
    }
}

