/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mongo;

import com.mongodb.MongoClientSettings;
import com.mongodb.ReadPreference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.hop.mongo.MongoDbException;
import org.apache.hop.mongo.MongoProp;
import org.apache.hop.mongo.MongoPropToOption;
import org.apache.hop.mongo.MongoUtilLogger;

public class MongoProperties {
    private final Map<MongoProp, String> props;

    private MongoProperties(Map<MongoProp, String> props) {
        this.props = props;
    }

    public String get(MongoProp prop) {
        return this.props.get((Object)prop);
    }

    public MongoClientSettings.Builder buildMongoClientSettings(MongoUtilLogger log) throws MongoDbException {
        MongoClientSettings.Builder builder = MongoClientSettings.builder();
        MongoPropToOption propToOption = new MongoPropToOption(log);
        for (MongoProp prop : MongoProp.values()) {
            prop.setOption(builder, this, propToOption);
        }
        return builder;
    }

    public boolean useAllReplicaSetMembers() {
        return Boolean.parseBoolean(this.props.get((Object)MongoProp.USE_ALL_REPLICA_SET_MEMBERS));
    }

    public ReadPreference getReadPreference() {
        return ReadPreference.valueOf((String)this.props.get((Object)MongoProp.readPreference));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MongoProperties:\n");
        ArrayList<MongoProp> propList = new ArrayList<MongoProp>(this.props.keySet());
        Collections.sort(propList, (p1, p2) -> Objects.compare(p1 == null ? null : p1.name(), p2 == null ? null : p2.name(), String.CASE_INSENSITIVE_ORDER));
        for (MongoProp prop : propList) {
            builder.append(String.format("%s=%s\n", prop.name(), this.props.get((Object)prop)));
        }
        return builder.toString();
    }

    public static class Builder {
        private static final String DEFAULT_HOST = "localhost";
        private static final String DEFAULT_READ_PREFERENCE = "primary";
        private final Map<MongoProp, String> props = new HashMap<MongoProp, String>();

        public Builder() {
            this.props.put(MongoProp.PASSWORD, "");
            this.props.put(MongoProp.HOST, DEFAULT_HOST);
            this.props.put(MongoProp.readPreference, DEFAULT_READ_PREFERENCE);
        }

        public Builder set(MongoProp prop, String value) {
            this.props.put(prop, value);
            return this;
        }

        public MongoProperties build() {
            return new MongoProperties(new HashMap<MongoProp, String>(this.props));
        }
    }
}

