/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mongo;

import com.mongodb.MongoClientSettings;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import java.util.concurrent.TimeUnit;
import org.apache.hop.mongo.MongoDbException;
import org.apache.hop.mongo.MongoPropToOption;
import org.apache.hop.mongo.MongoProperties;
import org.bson.UuidRepresentation;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MongoProp {
    CONNECTION_STRING,
    AUTH_DATABASE,
    USERNAME,
    PASSWORD,
    USE_KERBEROS,
    HOP_JAAS_AUTH_MODE,
    HOP_JAAS_KEYTAB_FILE,
    DBNAME,
    HOST,
    PORT,
    JOURNALED,
    USE_ALL_REPLICA_SET_MEMBERS,
    connectionsPerHost{

        @Override
        public void setOption(MongoClientSettings.Builder builder, MongoProperties props, MongoPropToOption propToOption) {
            int maxPoolSize = propToOption.intValue(props.get(connectionsPerHost), 100);
            builder.applyToConnectionPoolSettings(poolBuilder -> poolBuilder.maxSize(maxPoolSize).minSize(0));
        }
    }
    ,
    connectTimeout{

        @Override
        public void setOption(MongoClientSettings.Builder builder, MongoProperties props, MongoPropToOption propToOption) {
            int timeout = propToOption.intValue(props.get(connectTimeout), 10000);
            builder.applyToSocketSettings(socketBuilder -> socketBuilder.connectTimeout((long)timeout, TimeUnit.MILLISECONDS));
        }
    }
    ,
    maxWaitTime{

        @Override
        public void setOption(MongoClientSettings.Builder builder, MongoProperties props, MongoPropToOption propToOption) {
            long wait = propToOption.longValue(props.get(maxWaitTime), 120000L);
            builder.applyToConnectionPoolSettings(poolBuilder -> poolBuilder.maxWaitTime(wait, TimeUnit.MILLISECONDS));
        }
    }
    ,
    cursorFinalizerEnabled{

        @Override
        public void setOption(MongoClientSettings.Builder builder, MongoProperties props, MongoPropToOption propToOption) {
        }
    }
    ,
    socketKeepAlive{

        @Override
        public void setOption(MongoClientSettings.Builder builder, MongoProperties props, MongoPropToOption propToOption) {
        }
    }
    ,
    socketTimeout{

        @Override
        public void setOption(MongoClientSettings.Builder builder, MongoProperties props, MongoPropToOption propToOption) {
            int timeout = propToOption.intValue(props.get(socketTimeout), 0);
            builder.applyToSocketSettings(socketBuilder -> socketBuilder.readTimeout((long)timeout, TimeUnit.MILLISECONDS));
        }
    }
    ,
    useSSL{

        @Override
        public void setOption(MongoClientSettings.Builder builder, MongoProperties props, MongoPropToOption propToOption) {
            if ("true".equalsIgnoreCase(props.get(useSSL))) {
                builder.applyToSslSettings(sslBuilder -> sslBuilder.enabled(true));
            }
        }
    }
    ,
    readPreference{

        @Override
        public void setOption(MongoClientSettings.Builder builder, MongoProperties props, MongoPropToOption propToOption) throws MongoDbException {
            ReadPreference readPref = propToOption.readPrefValue(props);
            if (readPref != null) {
                builder.readPreference(readPref);
            }
        }
    }
    ,
    tagSet,
    writeConcern{

        @Override
        public void setOption(MongoClientSettings.Builder builder, MongoProperties props, MongoPropToOption propToOption) throws MongoDbException {
            WriteConcern wc = propToOption.writeConcernValue(props);
            if (wc != null) {
                builder.writeConcern(wc);
            }
        }
    }
    ,
    wTimeout,
    AUTH_MECHA,
    uuidRepresentation{

        @Override
        public void setOption(MongoClientSettings.Builder builder, MongoProperties props, MongoPropToOption propToOption) {
            builder.uuidRepresentation(UuidRepresentation.STANDARD);
        }
    };


    public void setOption(MongoClientSettings.Builder builder, MongoProperties props, MongoPropToOption propToOption) throws MongoDbException {
    }
}

