/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.welcome;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.SwtUniversalImageSvg;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.gui.plugin.GuiElements;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiRegistry;
import org.apache.hop.core.gui.plugin.menu.GuiMenuElement;
import org.apache.hop.core.gui.plugin.menu.GuiMenuElementType;
import org.apache.hop.core.svg.SvgCache;
import org.apache.hop.core.svg.SvgCacheEntry;
import org.apache.hop.core.svg.SvgFile;
import org.apache.hop.core.svg.SvgImage;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Document;

@GuiPlugin
public class WelcomeDialog {
    public static final String PARENT_ID_WELCOME_WIDGETS = "WelcomeDialog.Parent.ID";
    public static final String HOP_CONFIG_NO_SHOW_OPTION = "doNotShowWelcomeDialog";
    public static final String VARIABLE_HOP_NO_WELCOME_DIALOG = "HOP_NO_WELCOME_DIALOG";
    private Shell shell;
    private Image logoImage;
    private Font titleFont;
    private Button doNotShow;
    private org.eclipse.swt.widgets.List wTopics;
    private Composite wPluginsComp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        Shell parent = HopGui.getInstance().getShell();
        try {
            this.shell = new Shell(parent, 3184);
            this.shell.setLayout((Layout)new FormLayout());
            this.shell.setText("Apache Hop");
            PropsUi.setLook((Widget)this.shell);
            PropsUi props = PropsUi.getInstance();
            int margin = PropsUi.getMargin();
            Label logoLabel = new Label((Composite)this.shell, 0);
            SvgCacheEntry cacheEntry = SvgCache.loadSvg((SvgFile)new SvgFile("ui/images/logo_hop.svg", this.getClass().getClassLoader()));
            SwtUniversalImageSvg imageSvg = new SwtUniversalImageSvg(new SvgImage((Document)cacheEntry.getSvgDocument()));
            int logoSize = (int)(75.0 * props.getZoomFactor());
            this.logoImage = imageSvg.getAsBitmapForSize((Device)this.shell.getDisplay(), logoSize, logoSize);
            logoLabel.setImage(this.logoImage);
            FormData fdLogoLabel = new FormData();
            fdLogoLabel.left = new FormAttachment(0, 0);
            fdLogoLabel.top = new FormAttachment(0, 0);
            logoLabel.setLayoutData((Object)fdLogoLabel);
            Label welcome = new Label((Composite)this.shell, 0x1000000);
            PropsUi.setLook((Widget)welcome);
            welcome.setText("Apache Hop");
            this.titleFont = new Font((Device)this.shell.getDisplay(), "Open Sans", (int)(18.0 * props.getZoomFactor()), 0);
            welcome.setFont(this.titleFont);
            FormData fdWelcome = new FormData();
            fdWelcome.left = new FormAttachment((Control)logoLabel, PropsUi.getMargin(), 131072);
            fdWelcome.right = new FormAttachment(100, 0);
            fdWelcome.top = new FormAttachment((Control)logoLabel, 0, 0x1000000);
            welcome.setLayoutData((Object)fdWelcome);
            this.doNotShow = new Button((Composite)this.shell, 32);
            this.doNotShow.setText("Don't show this at startup (find me in the Help menu)");
            this.doNotShow.addListener(13, this::dontShowAgain);
            this.doNotShow.setSelection(HopConfig.readOptionBoolean((String)HOP_CONFIG_NO_SHOW_OPTION, (boolean)false));
            PropsUi.setLook((Widget)this.doNotShow);
            FormData fdDoNotShow = new FormData();
            fdDoNotShow.bottom = new FormAttachment(100, 0);
            fdDoNotShow.left = new FormAttachment(0, margin);
            fdDoNotShow.right = new FormAttachment(100, 0);
            this.doNotShow.setLayoutData((Object)fdDoNotShow);
            this.wTopics = new org.eclipse.swt.widgets.List((Composite)this.shell, 18948);
            PropsUi.setLook((Widget)this.wTopics);
            FormData fdTopics = new FormData();
            fdTopics.left = new FormAttachment(0, 0);
            fdTopics.right = new FormAttachment((Control)logoLabel, 0, 131072);
            fdTopics.top = new FormAttachment((Control)logoLabel, 2 * margin);
            fdTopics.bottom = new FormAttachment((Control)this.doNotShow, -2 * margin);
            this.wTopics.setLayoutData((Object)fdTopics);
            this.wPluginsComp = new Composite((Composite)this.shell, 0);
            PropsUi.setLook((Widget)this.wPluginsComp);
            this.wPluginsComp.setLayout((Layout)new FormLayout());
            FormData fdPluginsComp = new FormData();
            fdPluginsComp.left = new FormAttachment((Control)logoLabel, 2 * margin, 131072);
            fdPluginsComp.right = new FormAttachment(100, 0);
            fdPluginsComp.top = new FormAttachment((Control)logoLabel, 2 * margin, 1024);
            fdPluginsComp.bottom = new FormAttachment((Control)this.doNotShow, -2 * margin);
            this.wPluginsComp.setLayoutData((Object)fdPluginsComp);
            GuiRegistry guiRegistry = GuiRegistry.getInstance();
            List elementsList = (List)guiRegistry.getCompositeGuiElements().get(PARENT_ID_WELCOME_WIDGETS);
            elementsList.sort(Comparator.comparing(GuiElements::getId));
            for (GuiElements elements : elementsList) {
                this.wTopics.add(elements.getLabel());
                this.wTopics.setData(elements.getLabel(), (Object)elements);
            }
            if (this.wTopics.getItemCount() > 0) {
                this.wTopics.setSelection(0);
                this.topicSelected();
            }
            this.wTopics.addListener(13, e -> this.topicSelected());
            BaseDialog.defaultShellHandling(this.shell, e -> this.close(), e -> this.close());
        }
        catch (Exception e2) {
            new ErrorDialog(parent, "Error", "Error showing welcome dialog!", e2);
        }
        finally {
            this.logoImage.dispose();
            this.titleFont.dispose();
        }
    }

    private void topicSelected() {
        String selectedLabel = this.wTopics.getSelection()[0];
        GuiElements elements = (GuiElements)this.wTopics.getData(selectedLabel);
        if (elements == null) {
            return;
        }
        try {
            Arrays.stream(this.wPluginsComp.getChildren()).forEach(Widget::dispose);
            this.wPluginsComp.setBackground(GuiResource.getInstance().getColorLightGray());
            this.wPluginsComp.setForeground(GuiResource.getInstance().getColorDarkGray());
            Object object = elements.getButtonMethod().getDeclaringClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            elements.getButtonMethod().invoke(object, this.wPluginsComp);
            this.wPluginsComp.layout(true, true);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to invoke welcome method with the parent Composite as the argument", ex);
        }
    }

    private void dontShowAgain(Event event) {
        boolean doNotShow = ((Button)event.widget).getSelection();
        HopConfig.getInstance().saveOption(HOP_CONFIG_NO_SHOW_OPTION, (Object)doNotShow);
    }

    public void close() {
        HopConfig.saveOptions(Map.of(HOP_CONFIG_NO_SHOW_OPTION, this.doNotShow.getSelection()));
        this.shell.dispose();
    }

    @GuiMenuElement(root="HopGui-Menu", parentId="90000-menu-help", type=GuiMenuElementType.MENU_ITEM, id="help.welcome", label="Welcome", image="ui/images/logo_hop.svg")
    public void menuHelpWelcome() {
        this.open();
    }
}

