/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.search;

import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.search.ISearchableCallback;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.workflow.HopGuiWorkflowGraph;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerPerspective;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;

public class HopGuiWorkflowSearchable
implements ISearchable<WorkflowMeta> {
    private String location;
    private WorkflowMeta workflowMeta;

    public HopGuiWorkflowSearchable(String location, WorkflowMeta workflowMeta) {
        this.location = location;
        this.workflowMeta = workflowMeta;
    }

    public String getLocation() {
        return this.location;
    }

    public String getName() {
        return this.workflowMeta.getName();
    }

    public String getType() {
        return "Workflow";
    }

    public String getFilename() {
        return this.workflowMeta.getFilename();
    }

    public WorkflowMeta getSearchableObject() {
        return this.workflowMeta;
    }

    public ISearchableCallback getSearchCallback() {
        return (searchable, searchResult) -> {
            ActionMeta action;
            HopGuiWorkflowGraph workflowGraph;
            ExplorerPerspective perspective = HopGui.getExplorerPerspective();
            IHopFileTypeHandler fileTypeHandler = perspective.findFileTypeHandlerByFilename(this.workflowMeta.getFilename());
            if (fileTypeHandler != null) {
                perspective.setActiveFileTypeHandler(fileTypeHandler);
                workflowGraph = (HopGuiWorkflowGraph)fileTypeHandler;
            } else {
                workflowGraph = (HopGuiWorkflowGraph)perspective.addWorkflow(this.workflowMeta);
            }
            if (searchResult.getComponent() != null && (action = this.workflowMeta.findAction(searchResult.getComponent())) != null) {
                action.setSelected(true);
                workflowGraph.editAction(action);
            }
            perspective.activate();
        };
    }
}

