/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.explorer.file.types.text;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerFile;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerPerspective;
import org.apache.hop.ui.hopgui.perspective.explorer.file.types.base.BaseExplorerFileTypeHandler;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BaseTextExplorerFileTypeHandler
extends BaseExplorerFileTypeHandler {
    private Text wText;
    boolean reloadListener = false;

    public BaseTextExplorerFileTypeHandler(HopGui hopGui, ExplorerPerspective perspective, ExplorerFile explorerFile) {
        super(hopGui, perspective, explorerFile);
    }

    @Override
    public void renderFile(Composite composite) {
        this.wText = new Text(composite, 770);
        PropsUi.setLook((Widget)this.wText, 1);
        FormData fdText = new FormData();
        fdText.left = new FormAttachment(0, 0);
        fdText.right = new FormAttachment(100, 0);
        fdText.top = new FormAttachment(0, 0);
        fdText.bottom = new FormAttachment(100, 0);
        this.wText.setLayoutData((Object)fdText);
        this.reload();
        this.wText.addModifyListener(e -> {
            if (this.reloadListener) {
                this.setChanged();
                this.perspective.updateGui();
            }
        });
    }

    @Override
    public void save() throws HopException {
        try {
            String filename = this.explorerFile.getFilename();
            boolean fileExist = HopVfs.fileExists((String)filename);
            try (OutputStream outputStream = HopVfs.getOutputStream((String)filename, (boolean)false);){
                outputStream.write(this.wText.getText().getBytes(StandardCharsets.UTF_8));
                outputStream.flush();
            }
            this.clearChanged();
            this.updateGui();
            if (!fileExist) {
                this.perspective.refresh();
            }
        }
        catch (Exception e) {
            throw new HopException("Unable to save file '" + this.explorerFile.getFilename() + "'", (Throwable)e);
        }
    }

    @Override
    public void saveAs(String filename) throws HopException {
        try {
            FileObject fileObject;
            if (!((String)filename).toLowerCase().endsWith(this.getFileType().getDefaultFileExtension())) {
                filename = (String)filename + this.getFileType().getDefaultFileExtension();
            }
            if ((fileObject = HopVfs.getFileObject((String)(filename = HopVfs.normalize((String)filename)))).exists()) {
                MessageBox box = new MessageBox(this.hopGui.getActiveShell(), 196);
                box.setText("Overwrite?");
                box.setMessage("Are you sure you want to overwrite file '" + (String)filename + "'?");
                int answer = box.open();
                if ((answer & 0x40) == 0) {
                    return;
                }
            }
            this.setFilename((String)filename);
            this.save();
            this.hopGui.fileRefreshDelegate.register((String)filename, this);
        }
        catch (Exception e) {
            throw new HopException("Error validating file existence for '" + (String)filename + "'", (Throwable)e);
        }
    }

    @Override
    public void reload() {
        try {
            this.reloadListener = false;
            String contents = this.readTextFileContent("UTF-8");
            this.wText.setText(Const.NVL((String)contents, (String)""));
            this.reloadListener = true;
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error reading contents of file '" + this.explorerFile.getFilename() + "'", (Throwable)e);
        }
    }

    @Override
    public void selectAll() {
        this.wText.selectAll();
    }

    @Override
    public void unselectAll() {
        this.wText.setSelection(0, 0);
    }

    @Override
    public void copySelectedToClipboard() {
        this.wText.copy();
    }
}

