/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.pipeline.delegates;

import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.core.widget.OsHelper;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.core.widget.StyledTextVar;
import org.apache.hop.ui.core.widget.TextComposite;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiLogBrowser;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;
import org.apache.hop.ui.hopgui.file.shared.TextZoom;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin(description="Pipeline Graph Log Delegate")
public class HopGuiPipelineLogDelegate {
    private static final Class<?> PKG = HopGui.class;
    private static final String GUI_PLUGIN_TOOLBAR_PARENT_ID = "HopGuiPipelineLogDelegate-ToolBar";
    public static final String TOOLBAR_ICON_CLEAR_LOG_VIEW = "ToolbarIcon-10000-ClearLog";
    public static final String TOOLBAR_ICON_SHOW_ERROR_LINES = "ToolbarIcon-10010-ShowErrorLines";
    public static final String TOOLBAR_ICON_LOG_COPY_TO_CLIPBOARD = "ToolbarIcon-10020-LogCopyToClipboard";
    public static final String TOOLBAR_ICON_LOG_PAUSE_RESUME = "ToolbarIcon-10030-LogPauseResume";
    public static final String TOOLBAR_ICON_LOG_INCREASE_FONT = "ToolbarIcon-10040-LogIncreaseFont";
    public static final String TOOLBAR_ICON_LOG_DECREASE_FONT = "ToolbarIcon-10050-LogDecreaseFont";
    public static final String TOOLBAR_ICON_LOG_RESET_FONT = "ToolbarIcon-10060-LogResetFont";
    private final HopGuiPipelineGraph pipelineGraph;
    private HopGui hopGui;
    private CTabItem pipelineLogTab;
    private TextComposite pipelineLogText;
    private TextZoom textZoom;
    private ToolBar toolbar;
    private GuiToolbarWidgets toolBarWidgets;
    private Composite pipelineLogComposite;
    private HopGuiLogBrowser logBrowser;

    public HopGuiPipelineLogDelegate(HopGui hopGui, HopGuiPipelineGraph pipelineGraph) {
        this.hopGui = hopGui;
        this.pipelineGraph = pipelineGraph;
    }

    public void addPipelineLog() {
        if (this.pipelineGraph.extraViewTabFolder == null || this.pipelineGraph.extraViewTabFolder.isDisposed()) {
            this.pipelineGraph.addExtraView();
        } else if (this.pipelineLogTab != null && !this.pipelineLogTab.isDisposed()) {
            return;
        }
        this.pipelineLogTab = new CTabItem(this.pipelineGraph.extraViewTabFolder, 0);
        this.pipelineLogTab.setFont(GuiResource.getInstance().getFontDefault());
        this.pipelineLogTab.setImage(GuiResource.getInstance().getImageShowLog());
        this.pipelineLogTab.setText(BaseMessages.getString(PKG, (String)"HopGui.PipelineGraph.LogTab.Name", (String[])new String[0]));
        this.pipelineLogComposite = new Composite((Composite)this.pipelineGraph.extraViewTabFolder, 0);
        this.pipelineLogComposite.setLayout((Layout)new FormLayout());
        this.addToolBar();
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.toolbar.setLayoutData((Object)fd);
        this.pipelineLogText = EnvironmentUtils.getInstance().isWeb() ? new StyledTextComp(this.pipelineGraph.getVariables(), this.pipelineLogComposite, 2826) : new StyledTextVar(this.pipelineGraph.getVariables(), this.pipelineLogComposite, 2826, false, false);
        PropsUi.setLook((Widget)this.pipelineLogText);
        FormData fdText = new FormData();
        fdText.left = new FormAttachment(0, 0);
        fdText.right = new FormAttachment(100, 0);
        fdText.top = new FormAttachment((Control)this.toolbar, 0);
        fdText.bottom = new FormAttachment(100, 0);
        this.pipelineLogText.setLayoutData(fdText);
        this.textZoom = new TextZoom(this.pipelineLogText, GuiResource.getInstance().getFontFixed());
        this.textZoom.resetFont();
        if (OsHelper.isMac()) {
            this.pipelineLogText.setText(Const.CR);
        }
        this.logBrowser = new HopGuiLogBrowser(this.pipelineLogText, this.pipelineGraph);
        this.logBrowser.installLogSniffer();
        this.pipelineGraph.addDisposeListener(event -> {
            if (this.pipelineGraph.pipeline != null) {
                HopLogStore.discardLines((String)this.pipelineGraph.pipeline.getLogChannelId(), (boolean)true);
            }
        });
        this.pipelineLogTab.setControl((Control)this.pipelineLogComposite);
    }

    public static HopGuiPipelineLogDelegate getInstance() {
        IHopFileTypeHandler fileTypeHandler = HopGui.getInstance().getActiveFileTypeHandler();
        if (fileTypeHandler instanceof HopGuiPipelineGraph) {
            HopGuiPipelineGraph hopGuiPipelineGraph = (HopGuiPipelineGraph)fileTypeHandler;
            return hopGuiPipelineGraph.pipelineLogDelegate;
        }
        return null;
    }

    private void addToolBar() {
        this.toolbar = new ToolBar(this.pipelineLogComposite, 16704);
        FormData fdToolBar = new FormData();
        fdToolBar.left = new FormAttachment(0, 0);
        fdToolBar.top = new FormAttachment(0, 0);
        fdToolBar.right = new FormAttachment(100, 0);
        this.toolbar.setLayoutData((Object)fdToolBar);
        PropsUi.setLook((Widget)this.toolbar, 5);
        this.toolBarWidgets = new GuiToolbarWidgets();
        this.toolBarWidgets.registerGuiPluginObject(this);
        this.toolBarWidgets.createToolbarWidgets((Composite)this.toolbar, GUI_PLUGIN_TOOLBAR_PARENT_ID);
        this.toolbar.pack();
    }

    public void showLogView() {
        if (this.pipelineLogTab == null || this.pipelineLogTab.isDisposed()) {
            this.addPipelineLog();
        } else {
            this.pipelineLogTab.dispose();
            this.pipelineGraph.checkEmptyExtraView();
        }
    }

    @GuiToolbarElement(root="HopGuiPipelineLogDelegate-ToolBar", id="ToolbarIcon-10000-ClearLog", toolTip="i18n:org.apache.hop.ui.hopgui:PipelineLog.Button.ClearLog", image="ui/images/delete.svg")
    public void clearLog() {
        Map<String, String> transformLogMap;
        if (this.pipelineLogText != null && !this.pipelineLogText.isDisposed()) {
            String textToSet = OsHelper.isMac() ? Const.CR : "";
            this.pipelineLogText.setText(textToSet);
        }
        if ((transformLogMap = this.pipelineGraph.getTransformLogMap()) != null) {
            transformLogMap.clear();
            this.pipelineGraph.getDisplay().asyncExec(this.pipelineGraph::redraw);
        }
    }

    @GuiToolbarElement(root="HopGuiPipelineLogDelegate-ToolBar", id="ToolbarIcon-10020-LogCopyToClipboard", toolTip="i18n:org.apache.hop.ui.hopgui:PipelineLog.Button.LogCopyToClipboard", image="ui/images/copy.svg")
    public void copyToClipboard() {
        GuiResource.getInstance().toClipboard(this.pipelineLogText.getText());
    }

    @GuiToolbarElement(root="HopGuiPipelineLogDelegate-ToolBar", id="ToolbarIcon-10010-ShowErrorLines", toolTip="i18n:org.apache.hop.ui.hopgui:PipelineLog.Button.ShowErrorLines", image="ui/images/filter.svg")
    public void showErrors() {
        String uLine;
        String line;
        int i;
        String all = this.pipelineLogText.getText();
        ArrayList<String> err = new ArrayList<String>();
        int startpos = 0;
        int crlen = Const.CR.length();
        for (i = 0; i < all.length() - crlen; ++i) {
            if (!all.substring(i, i + crlen).equalsIgnoreCase(Const.CR)) continue;
            line = all.substring(startpos, i);
            uLine = line.toUpperCase();
            if (uLine.contains(BaseMessages.getString(PKG, (String)"PipelineLog.System.ERROR", (String[])new String[0])) || uLine.contains(BaseMessages.getString(PKG, (String)"PipelineLog.System.EXCEPTION", (String[])new String[0])) || uLine.contains("ERROR") || uLine.contains("EXCEPTION")) {
                err.add(line);
            }
            startpos = i + crlen;
        }
        line = all.substring(startpos);
        uLine = line.toUpperCase();
        if (uLine.contains(BaseMessages.getString(PKG, (String)"PipelineLog.System.ERROR2", (String[])new String[0])) || uLine.contains(BaseMessages.getString(PKG, (String)"PipelineLog.System.EXCEPTION2", (String[])new String[0])) || uLine.contains("ERROR") || uLine.contains("EXCEPTION")) {
            err.add(line);
        }
        if (!err.isEmpty()) {
            String[] errLines = new String[err.size()];
            for (i = 0; i < errLines.length; ++i) {
                errLines[i] = (String)err.get(i);
            }
            EnterSelectionDialog esd = new EnterSelectionDialog(this.pipelineGraph.getShell(), errLines, BaseMessages.getString(PKG, (String)"PipelineLog.Dialog.ErrorLines.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineLog.Dialog.ErrorLines.Message", (String[])new String[0]));
            line = esd.open();
            if (line != null) {
                PipelineMeta pipelineMeta = this.pipelineGraph.getManagedObject();
                for (i = 0; i < pipelineMeta.nrTransforms(); ++i) {
                    TransformMeta transformMeta = pipelineMeta.getTransform(i);
                    if (!line.contains(transformMeta.getName())) continue;
                    this.pipelineGraph.editTransform(pipelineMeta, transformMeta);
                }
            }
        }
    }

    public String getLoggingText() {
        if (this.pipelineLogText != null && !this.pipelineLogText.isDisposed()) {
            return this.pipelineLogText.getText();
        }
        return null;
    }

    @GuiToolbarElement(root="HopGuiPipelineLogDelegate-ToolBar", id="ToolbarIcon-10030-LogPauseResume", toolTip="i18n:org.apache.hop.ui.hopgui:WorkflowLog.Button.Pause", image="ui/images/pause.svg", separator=true)
    public void pauseLog() {
        ToolItem item = this.toolBarWidgets.findToolItem(TOOLBAR_ICON_LOG_PAUSE_RESUME);
        if (this.logBrowser.isPaused()) {
            this.logBrowser.setPaused(false);
            item.setImage(GuiResource.getInstance().getImagePause());
            item.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineLog.Dialog.Pause.Tooltip", (String[])new String[0]));
        } else {
            this.logBrowser.setPaused(true);
            item.setImage(GuiResource.getInstance().getImageRun());
            item.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineLog.Dialog.Resume.Tooltip", (String[])new String[0]));
        }
    }

    @GuiToolbarElement(root="HopGuiPipelineLogDelegate-ToolBar", id="ToolbarIcon-10040-LogIncreaseFont", toolTip="i18n:org.apache.hop.ui.hopgui:WorkflowLog.Button.IncreaseFont", image="ui/images/zoom-in.svg", separator=true)
    public void increaseFont() {
        this.textZoom.increaseFont();
    }

    @GuiToolbarElement(root="HopGuiPipelineLogDelegate-ToolBar", id="ToolbarIcon-10050-LogDecreaseFont", toolTip="i18n:org.apache.hop.ui.hopgui:WorkflowLog.Button.DecreaseFont", image="ui/images/zoom-out.svg", separator=false)
    public void decreaseFont() {
        this.textZoom.decreaseFont();
    }

    @GuiToolbarElement(root="HopGuiPipelineLogDelegate-ToolBar", id="ToolbarIcon-10060-LogResetFont", toolTip="i18n:org.apache.hop.ui.hopgui:WorkflowLog.Button.ResetFont", image="ui/images/zoom-100.svg", separator=false)
    public void resetFont() {
        this.textZoom.resetFont();
    }

    public boolean hasSelectedText() {
        if (this.pipelineLogText == null || this.pipelineLogText.isDisposed()) {
            return false;
        }
        return StringUtils.isNotEmpty((String)this.pipelineLogText.getSelectionText());
    }

    public void copySelected() {
        if (this.hasSelectedText()) {
            this.pipelineGraph.pipelineClipboardDelegate.toClipboard(this.pipelineLogText.getSelectionText());
        }
    }

    @Generated
    public CTabItem getPipelineLogTab() {
        return this.pipelineLogTab;
    }

    @Generated
    public HopGuiLogBrowser getLogBrowser() {
        return this.logBrowser;
    }
}

