/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core;

import java.util.Arrays;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.ui.core.PropsUi;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;

public class ConstUi {
    public static final int ICON_SIZE = 32;
    public static final int LARGE_ICON_SIZE = 48;
    public static final int SMALL_ICON_SIZE = 16;
    public static final int MEDIUM_ICON_SIZE = 24;
    public static final int DOCUMENTATION_ICON_SIZE = 14;
    public static final int CHECKBOX_WIDTH = 20;
    public static final int LINE_WIDTH = 1;
    public static final int GRID_SIZE = 16;
    public static final int NOTE_MIN_SIZE = 20;
    public static final int TOOLTIP_OFFSET = 5;
    public static final int COLOR_BACKGROUND_RED = 255;
    public static final int COLOR_BACKGROUND_GREEN = 255;
    public static final int COLOR_BACKGROUND_BLUE = 255;
    public static final int COLOR_GRAPH_RED = 255;
    public static final int COLOR_GRAPH_GREEN = 255;
    public static final int COLOR_GRAPH_BLUE = 255;
    public static final int COLOR_TAB_RED = 240;
    public static final int COLOR_TAB_GREEN = 240;
    public static final int COLOR_TAB_BLUE = 240;
    public static final int INTERVAL_MS_PIPELINE_CANVAS_REFRESH = 1000;
    public static final int SMALL_MARGIN = 5;
    public static final int MEDIUM_MARGIN = 10;
    public static final String HOP_GUI_ZOOM_FACTOR = "HOP_GUI_ZOOM_FACTOR";
    public static final String HOP_GUI_HIDE_MENU = "HOP_GUI_HIDE_MENU";

    public static final int getTreeLevel(TreeItem ti) {
        int level = 0;
        for (TreeItem parent = ti.getParentItem(); parent != null; parent = parent.getParentItem()) {
            ++level;
        }
        return level;
    }

    public static final String[] getTreeStrings(TreeItem ti) {
        int nrlevels = ConstUi.getTreeLevel(ti) + 1;
        String[] retval = new String[nrlevels];
        int level = 0;
        retval[nrlevels - 1] = ti.getText();
        for (TreeItem parent = ti.getParentItem(); parent != null; parent = parent.getParentItem()) {
            retval[nrlevels - ++level - 1] = parent.getText();
        }
        return retval;
    }

    public static final String getTreePath(TreeItem ti, int from) {
        String[] path = ConstUi.getTreeStrings(ti);
        if (path == null) {
            return null;
        }
        Object retval = "";
        for (int i = from; i < path.length; ++i) {
            if (path[i].equalsIgnoreCase(Const.FILE_SEPARATOR)) continue;
            retval = (String)retval + Const.FILE_SEPARATOR + path[i];
        }
        return retval;
    }

    public static final void flipExpanded(TreeItem ti) {
        ti.setExpanded(!ti.getExpanded());
    }

    public static final TreeItem findTreeItem(TreeItem parent, String name) {
        return ConstUi.findTreeItem(parent, null, name);
    }

    public static final TreeItem findTreeItem(TreeItem parent, String parentName, String name) {
        return ConstUi.findTreeItem(null, parent, parentName, name);
    }

    private static final TreeItem findTreeItem(TreeItem grandParent, TreeItem parent, String parentName, String name) {
        TreeItem[] ti;
        if (Utils.isEmpty((CharSequence)parentName) ? parent.getText().equalsIgnoreCase(name) : grandParent != null && grandParent.getText().equalsIgnoreCase(parentName) && parent.getText().equalsIgnoreCase(name)) {
            return parent;
        }
        for (TreeItem treeItem : ti = parent.getItems()) {
            TreeItem child = ConstUi.findTreeItem(parent, treeItem, parentName, name);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    public static void displayMenu(Menu menu, Control control) {
        Menu oldMenu = control.getMenu();
        if (oldMenu != null && oldMenu != menu) {
            oldMenu.setVisible(false);
        }
        menu.setVisible(true);
    }

    public static String[] sortFieldNames(List<String> names) {
        Object[] result = names.toArray(new String[0]);
        if (PropsUi.getInstance().isSortFieldByName()) {
            Arrays.sort(result);
        }
        return result;
    }

    public static String[] sortFieldNames(String[] names) {
        if (PropsUi.getInstance().isSortFieldByName()) {
            Arrays.sort(names);
        }
        return names;
    }
}

