/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ListSelectionEventSupport;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceCellRenderer;
import com.ibm.as400.vaccess.ResourceHeaderRenderer;
import com.ibm.as400.vaccess.ResourceListDetailsModel;
import com.ibm.as400.vaccess.ResourceListPopupMenuAdapter;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.ResourceProperties;
import com.ibm.as400.vaccess.SerializationListener;
import com.ibm.as400.vaccess.VTableColumn;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.Point;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ResourceListDetailsPane
extends JComponent
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String ACTION_PROPERTIES_ = ResourceLoader.getText("ACTION_PROPERTIES");
    private static final String ACTION_LIST_PROPERTIES_ = ResourceLoader.getText("ACTION_LIST_PROPERTIES");
    private boolean allowActions_ = true;
    private ResourceListDetailsModel model_ = null;
    private ResourceProperties resourceProperties_ = null;
    private transient JScrollPane scrollPane_ = null;
    private transient JTable table_ = null;
    private transient ErrorEventSupport errorEventSupport_;
    private transient ListSelectionEventSupport listSelectionEventSupport_;
    private transient ResourceListPopupMenuAdapter popupMenuAdapter_;
    private transient PropertyChangeSupport propertyChangeSupport_;

    public ResourceListDetailsPane() {
        this.initializeCommon();
        this.resourceProperties_ = new ResourceProperties();
    }

    public ResourceListDetailsPane(ResourceList resourceList, Object[] columnAttributeIDs, ResourceProperties resourceProperties) {
        if (resourceList == null) {
            throw new NullPointerException("resourceList");
        }
        if (columnAttributeIDs == null) {
            throw new NullPointerException("columnAttributeIDs");
        }
        if (resourceProperties == null) {
            throw new NullPointerException("resourceProperties");
        }
        this.initializeCommon();
        this.resourceProperties_ = resourceProperties;
        this.model_.setResourceList(resourceList);
        this.model_.setColumnAttributeIDs(columnAttributeIDs);
        this.refreshColumns();
        this.popupMenuAdapter_.setResourceList(resourceList);
        this.popupMenuAdapter_.setResourceProperties(resourceProperties);
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.listSelectionEventSupport_.addListSelectionListener(listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    public boolean getAllowActions() {
        return this.allowActions_;
    }

    public Object[] getColumnAttributeIDs() {
        return this.model_.getColumnAttributeIDs();
    }

    public TableColumnModel getColumnModel() {
        return this.table_.getColumnModel();
    }

    public TableModel getModel() {
        return this.model_;
    }

    public Resource getResourceAtPoint(Point point) {
        Resource resource = null;
        int row = this.table_.rowAtPoint(point);
        if (row != -1) {
            resource = this.model_.getResourceAt(row);
        }
        return resource;
    }

    public ResourceList getResourceList() {
        return this.model_.getResourceList();
    }

    public ResourceProperties getResourceProperties() {
        return this.resourceProperties_;
    }

    public Resource getSelectedResource() {
        Resource selectedResource = null;
        int[] selectedRows = this.table_.getSelectedRows();
        if (selectedRows.length > 0) {
            selectedResource = this.model_.getResourceAt(selectedRows[0]);
        }
        return selectedResource;
    }

    public Resource[] getSelectedResources() {
        int[] selectedRows = this.table_.getSelectedRows();
        Resource[] selectedResource = new Resource[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            selectedResource[i] = this.model_.getResourceAt(selectedRows[i]);
        }
        return selectedResource;
    }

    public ListSelectionModel getSelectionModel() {
        return this.table_.getSelectionModel();
    }

    private void initializeCommon() {
        this.model_ = new ResourceListDetailsModel();
        this.initializeTransient();
        this.setAllowActions(true);
    }

    private void initializeTransient() {
        this.addFocusListener(new SerializationListener(this));
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.listSelectionEventSupport_ = new ListSelectionEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.table_ = new JTable(this.model_);
        this.table_.setAutoCreateColumnsFromModel(false);
        this.table_.setAutoResizeMode(0);
        this.table_.setColumnSelectionAllowed(false);
        this.table_.setRowSelectionAllowed(true);
        this.table_.setShowGrid(false);
        this.model_.addErrorListener(this.errorEventSupport_);
        this.model_.addPropertyChangeListener(this.propertyChangeSupport_);
        this.table_.getSelectionModel().addListSelectionListener(this.listSelectionEventSupport_);
        this.setLayout(new BorderLayout());
        this.scrollPane_ = new JScrollPane(this.table_);
        this.add("Center", this.scrollPane_);
        this.table_.setDoubleBuffered(true);
        this.scrollPane_.getViewport().setBackingStoreEnabled(true);
        this.scrollPane_.setDoubleBuffered(true);
        this.scrollPane_.getViewport().setDoubleBuffered(true);
        this.scrollPane_.getViewport().putClientProperty("EnableWindowBlit", Boolean.TRUE);
        this.popupMenuAdapter_ = new ResourceListPopupMenuAdapter(this, this.model_.getResourceList(), this.resourceProperties_, this.errorEventSupport_);
        this.model_.addWorkingListener(new WorkingCursorAdapter(this.table_));
        this.setAllowActions(this.allowActions_);
    }

    public boolean isSelected(Resource resource) {
        if (resource == null) {
            throw new NullPointerException("resource");
        }
        int[] selectedRows = this.table_.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            Resource selectedResource = this.model_.getResourceAt(selectedRows[i]);
            if (selectedResource == null || !selectedResource.equals(resource)) continue;
            return true;
        }
        return false;
    }

    public void load() {
        this.table_.clearSelection();
        this.model_.load();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    private void refreshColumns() {
        TableColumnModel tableColumnModel = this.table_.getColumnModel();
        Vector<TableColumn> oldColumns = new Vector<TableColumn>();
        Enumeration<TableColumn> e = tableColumnModel.getColumns();
        while (e.hasMoreElements()) {
            oldColumns.addElement(e.nextElement());
        }
        e = oldColumns.elements();
        while (e.hasMoreElements()) {
            TableColumn column = e.nextElement();
            tableColumnModel.removeColumn(column);
        }
        Object[] columnAttributeIDs = this.getColumnAttributeIDs();
        if (columnAttributeIDs != null) {
            for (int i = 0; i < columnAttributeIDs.length; ++i) {
                ResourceMetaData metaData;
                block10: {
                    metaData = null;
                    if (columnAttributeIDs[i] != null) {
                        try {
                            metaData = this.getResourceList().getAttributeMetaData(columnAttributeIDs[i]);
                        }
                        catch (Exception e2) {
                            if (!Trace.isTraceErrorOn()) break block10;
                            Trace.log(2, "Column attribute ID not valid:" + columnAttributeIDs[i], (Throwable)e2);
                        }
                    }
                }
                VTableColumn tableColumn = new VTableColumn(i, columnAttributeIDs[i]);
                tableColumn.setCellRenderer(new ResourceCellRenderer(metaData));
                tableColumn.setHeaderValue(this.model_.getColumnName(i));
                tableColumn.setHeaderRenderer(new ResourceHeaderRenderer(metaData));
                tableColumn.setPreferredCharWidth(15);
                tableColumnModel.addColumn(tableColumn);
            }
        }
        int fontSize = 0;
        Font font = this.table_.getFont();
        if (font != null) {
            fontSize = this.table_.getFontMetrics(font).charWidth('M');
        }
        if (fontSize > 0) {
            TableColumnModel columnModel = this.table_.getColumnModel();
            int columnCount = columnModel.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                TableColumn column = columnModel.getColumn(i);
                column.setPreferredWidth(this.model_.getColumnWidth(i) * fontSize + 10);
            }
        }
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.listSelectionEventSupport_.removeListSelectionListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    public void setAllowActions(boolean allowActions) {
        Boolean oldValue = this.allowActions_;
        this.allowActions_ = allowActions;
        if (this.allowActions_) {
            this.scrollPane_.getViewport().addMouseListener(this.popupMenuAdapter_);
            this.table_.addMouseListener(this.popupMenuAdapter_);
        } else {
            this.scrollPane_.getViewport().removeMouseListener(this.popupMenuAdapter_);
            this.table_.removeMouseListener(this.popupMenuAdapter_);
        }
        this.propertyChangeSupport_.firePropertyChange("allowActions", oldValue, (Object)allowActions);
    }

    public void setColumnAttributeIDs(Object[] columnAttributeIDs) {
        if (columnAttributeIDs == null) {
            throw new NullPointerException("columnAttributeIDs");
        }
        this.table_.clearSelection();
        this.model_.setColumnAttributeIDs(columnAttributeIDs);
        this.refreshColumns();
    }

    public void setResourceList(ResourceList resourceList) {
        if (resourceList == null) {
            throw new NullPointerException("resourceList");
        }
        this.table_.clearSelection();
        this.model_.setResourceList(resourceList);
        this.refreshColumns();
        this.popupMenuAdapter_.setResourceList(resourceList);
    }

    public void setResourceProperties(ResourceProperties resourceProperties) {
        if (resourceProperties == null) {
            throw new NullPointerException("resourceProperties");
        }
        ResourceProperties oldValue = this.resourceProperties_;
        this.resourceProperties_ = resourceProperties;
        this.popupMenuAdapter_.setResourceProperties(resourceProperties);
        this.propertyChangeSupport_.firePropertyChange("resourceProperties", oldValue, resourceProperties);
    }

    public void setSelectionModel(ListSelectionModel selectionModel) {
        if (selectionModel == null) {
            throw new NullPointerException("selectionModel");
        }
        ListSelectionModel oldSelectionModel = this.table_.getSelectionModel();
        if (oldSelectionModel != null) {
            oldSelectionModel.removeListSelectionListener(this.listSelectionEventSupport_);
        }
        this.table_.setSelectionModel(selectionModel);
        if (selectionModel != null) {
            selectionModel.addListSelectionListener(this.listSelectionEventSupport_);
        }
    }
}

