/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400Message;
import com.ibm.as400.vaccess.ChangeEventSupport;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.MessageUtilities;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VMessage;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;

class MessagePropertiesPane
implements VPropertiesPane {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String dateText_ = ResourceLoader.getText("MESSAGE_DATE") + ": ";
    private static final String generalTabText_ = ResourceLoader.getText("TAB_GENERAL");
    private static final String messageFileText_ = ResourceLoader.getText("MESSAGE_FILE") + ": ";
    private static final String severityText_ = ResourceLoader.getText("MESSAGE_SEVERITY") + ": ";
    private static final String typeText_ = ResourceLoader.getText("MESSAGE_TYPE") + ": ";
    private static DateFormat dateFormat_ = DateFormat.getDateTimeInstance();
    private AS400Message message_;
    private VMessage object_;
    private ChangeEventSupport changeEventSupport_ = new ChangeEventSupport(this);
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);
    private VObjectEventSupport objectEventSupport_ = new VObjectEventSupport(this);
    private WorkingEventSupport workingEventSupport_ = new WorkingEventSupport(this);

    public MessagePropertiesPane(VMessage object, AS400Message message) {
        this.object_ = object;
        this.message_ = message;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeEventSupport_.addChangeListener(listener);
    }

    @Override
    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    @Override
    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    @Override
    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    @Override
    public void applyChanges() throws Exception {
    }

    @Override
    public Component getComponent() {
        JPanel generalTab = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        generalTab.setLayout(layout);
        generalTab.setBorder(new EmptyBorder(10, 10, 10, 10));
        int row = 0;
        VUtilities.constrain(new JLabel(this.object_.getText(), this.object_.getIcon(32, false), 2), generalTab, layout, 0, row++, 2, 1);
        JTextArea text = new JTextArea(this.message_.getText());
        text.setEditable(false);
        text.setBackground(generalTab.getBackground());
        text.setColumns(40);
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        VUtilities.constrain(text, generalTab, layout, 0, row++, 2, 1);
        String help = this.message_.getHelp();
        if (help != null && help.length() > 0) {
            JTextArea helpText = new JTextArea(help);
            helpText.setEditable(false);
            helpText.setBackground(generalTab.getBackground());
            helpText.setColumns(40);
            helpText.setLineWrap(true);
            helpText.setWrapStyleWord(true);
            VUtilities.constrain(helpText, generalTab, layout, 0, row++, 2, 1);
        }
        VUtilities.constrain(new JSeparator(), generalTab, layout, 0, row++, 2, 1);
        VUtilities.constrain(new JLabel(severityText_), generalTab, layout, 0, row, 1, 1);
        VUtilities.constrain(new JLabel(Integer.toString(this.message_.getSeverity())), generalTab, layout, 1, row, 1, 1);
        VUtilities.constrain(new JLabel(typeText_), generalTab, layout, 0, ++row, 1, 1);
        VUtilities.constrain(new JLabel(MessageUtilities.getTypeText(this.message_.getType())), generalTab, layout, 1, row, 1, 1);
        VUtilities.constrain(new JLabel(dateText_), generalTab, layout, 0, ++row, 1, 1);
        Calendar date = this.message_.getDate();
        if (date != null) {
            VUtilities.constrain(new JLabel(dateFormat_.format(date.getTime())), generalTab, layout, 1, row, 1, 1);
        }
        int n = ++row;
        VUtilities.constrain(new JSeparator(), generalTab, layout, 0, n, 2, 1);
        VUtilities.constrain(new JLabel(messageFileText_), generalTab, layout, 0, ++row, 1, 1);
        VUtilities.constrain(new JLabel(this.message_.getPath()), generalTab, layout, 1, row, 1, 1);
        ++row;
        JTabbedPane pane = new JTabbedPane();
        pane.addTab(generalTabText_, null, generalTab);
        pane.setSelectedIndex(0);
        return pane;
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeEventSupport_.removeChangeListener(listener);
    }

    @Override
    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    @Override
    public void removeVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    @Override
    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    static {
        dateFormat_.setTimeZone(TimeZone.getDefault());
    }
}

