/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.security.auth;

import com.ibm.as400.access.AS400;
import com.ibm.as400.security.auth.AS400AuthenticationException;
import java.io.Serializable;

public final class ProfileTokenEnhancedInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean isEnhancedProfileToken_ = false;
    private String verificationID_ = "QIBM_OS400_JT400              ";
    private String remoteIPAddress_ = null;
    private int remotePort_ = 0;
    private String localIPAddress_ = null;
    private int localPort_ = 0;

    public ProfileTokenEnhancedInfo() {
    }

    public ProfileTokenEnhancedInfo(String verificationID, String remoteIPAddress, int remotePort, String localIPAddress, int localPort) {
        this.initialize(verificationID, remoteIPAddress, remotePort, localIPAddress, localPort);
    }

    public ProfileTokenEnhancedInfo(ProfileTokenEnhancedInfo enhancedInfo) {
        this.initialize(enhancedInfo.verificationID_, enhancedInfo.remoteIPAddress_, enhancedInfo.remotePort_, enhancedInfo.localIPAddress_, enhancedInfo.localPort_);
    }

    public String getVerificationID() {
        return this.verificationID_;
    }

    public String getRemoteIPAddress() {
        return this.remoteIPAddress_;
    }

    public int getRemotePort() {
        return this.remotePort_;
    }

    public String getLocalIPAddress() {
        return this.localIPAddress_;
    }

    public int getLocalPort() {
        return this.localPort_;
    }

    public void setVerificationID(String verificationID) {
        this.verificationID_ = verificationID == null ? "QIBM_OS400_JT400              " : verificationID;
    }

    public void setRemoteIPAddress(String remoteIPAddress) {
        this.remoteIPAddress_ = remoteIPAddress;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort_ = remotePort;
    }

    public void setLocalIPAddress(String localIPAddress) {
        this.localIPAddress_ = localIPAddress;
    }

    public void setLocalPort(int localPort) {
        this.localPort_ = localPort;
    }

    public boolean isEnhancedProfileToken() {
        return this.isEnhancedProfileToken_;
    }

    public void setEnhancedTokenCreated(boolean enhancedTokenCreated) throws AS400AuthenticationException {
        if (enhancedTokenCreated) {
            this.checkEnhancedTokenForValidity(true);
        }
        this.isEnhancedProfileToken_ = enhancedTokenCreated;
    }

    public void reset() {
        this.isEnhancedProfileToken_ = false;
        this.verificationID_ = "QIBM_OS400_JT400              ";
        this.localIPAddress_ = null;
        this.remoteIPAddress_ = null;
        this.localPort_ = 0;
        this.remotePort_ = 0;
    }

    void checkEnhancedTokenForValidity(boolean assertOnInvalid) throws AS400AuthenticationException {
        if (this.verificationID_ == null) {
            if (assertOnInvalid) {
                throw new AS400AuthenticationException(37);
            }
            this.verificationID_ = "";
        }
        if (this.remoteIPAddress_ == null) {
            if (assertOnInvalid) {
                throw new AS400AuthenticationException(37);
            }
            this.remoteIPAddress_ = "";
        }
    }

    public void initialize(boolean isEnhancedToken, String verificationID, String remoteIPAddress, int remotePort, String localIPAddress, int localPort) throws AS400AuthenticationException {
        this.verificationID_ = verificationID;
        this.remoteIPAddress_ = remoteIPAddress;
        if (isEnhancedToken) {
            this.checkEnhancedTokenForValidity(true);
        }
        this.isEnhancedProfileToken_ = isEnhancedToken;
        this.remotePort_ = remotePort;
        this.localIPAddress_ = localIPAddress;
        this.localPort_ = localPort;
    }

    public void initialize(String verificationID, String remoteIPAddress, int remotePort, String localIPAddress, int localPort) {
        this.verificationID_ = verificationID;
        this.remoteIPAddress_ = remoteIPAddress;
        this.remotePort_ = remotePort;
        this.localIPAddress_ = localIPAddress;
        this.localPort_ = localPort;
    }

    public void ensureRequiredFieldsSet(String remoteIPAddress) {
        if (this.verificationID_ == null || this.verificationID_.isEmpty()) {
            this.verificationID_ = "QIBM_OS400_JT400              ";
        }
        if (this.verificationID_.length() < 30) {
            this.verificationID_ = (this.verificationID_ + "                              ").substring(0, 30);
        }
        if (this.remoteIPAddress_ == null || this.remoteIPAddress_.isEmpty()) {
            if (remoteIPAddress == null || remoteIPAddress.isEmpty()) {
                remoteIPAddress = AS400.getDefaultLocalIPAddress();
            }
            this.remoteIPAddress_ = remoteIPAddress;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ProfileTokenEnhancedInfo {");
        sb.append("enhancedTokenCreated: ").append(this.isEnhancedProfileToken_);
        sb.append(",").append("verificationID=").append(this.verificationID_);
        if (this.remoteIPAddress_ != null) {
            sb.append(",").append("remoteIPAddress=").append(this.remoteIPAddress_);
        }
        sb.append("}");
        return sb.toString();
    }
}

