/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.ResourceMetaData;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ResourceMetaDataTable
implements Serializable {
    static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private Hashtable metaDataByID_ = new Hashtable();
    private ResourceMetaData[] metaData_ = null;
    private transient PresentationLoader presentationLoader_ = null;
    private transient String presentationKey_ = null;

    public ResourceMetaDataTable() {
    }

    public ResourceMetaDataTable(PresentationLoader presentationLoader, String presentationKey) {
        this.presentationLoader_ = presentationLoader;
        this.presentationKey_ = presentationKey;
    }

    public ResourceMetaDataTable(ResourceMetaData[] metaData) {
        this.metaData_ = metaData == null ? new ResourceMetaData[0] : metaData;
        for (int i = 0; i < this.metaData_.length; ++i) {
            this.metaDataByID_.put(this.metaData_[i].getID(), this.metaData_[i]);
        }
    }

    public ResourceMetaData add(Object id, Class type) {
        return this.add(id, type, false, null, null, false, false);
    }

    public ResourceMetaData add(Object id, Class type, boolean readOnly) {
        return this.add(id, type, readOnly, null, null, false, false);
    }

    public ResourceMetaData add(Object id, Class type, Object defaultValue) {
        return this.add(id, type, false, null, defaultValue, false, false);
    }

    public ResourceMetaData add(Object id, Class type, boolean readOnly, Object[] possibleValues, Object defaultValue, boolean valueLimited) {
        return this.add(id, type, readOnly, possibleValues, defaultValue, valueLimited, false);
    }

    public ResourceMetaData add(Object id, Class type, boolean readOnly, Object[] possibleValues, Object defaultValue, boolean valueLimited, boolean multipleAllowed) {
        return this.add(id, type, readOnly, possibleValues, defaultValue, valueLimited, multipleAllowed, null);
    }

    public ResourceMetaData add(Object id, Class type, boolean readOnly, Object[] possibleValues, Object defaultValue, boolean valueLimited, boolean multipleAllowed, String[] possibleValuePresentationKeys) {
        if (this.presentationLoader_ == null) {
            throw new NullPointerException("presentationLoader_");
        }
        Presentation presentation = null;
        if (this.presentationLoader_ != null) {
            presentation = this.presentationLoader_.getPresentation(this.presentationKey_, id.toString());
        }
        Presentation[] possibleValuePresentations = null;
        if (possibleValues != null && this.presentationLoader_ != null) {
            possibleValuePresentations = new Presentation[possibleValues.length];
            for (int i = 0; i < possibleValues.length; ++i) {
                StringBuilder buffer = new StringBuilder();
                buffer.append(id);
                buffer.append('_');
                String asString = null;
                asString = possibleValuePresentationKeys == null ? (possibleValues[i] instanceof byte[] ? Byte.toString(((byte[])possibleValues[i])[0]) : possibleValues[i].toString()) : possibleValuePresentationKeys[i];
                int length = asString.length();
                for (int j = 0; j < length; ++j) {
                    char ch = asString.charAt(j);
                    if (ch == ' ') {
                        buffer.append('_');
                        continue;
                    }
                    if (ch == '*') continue;
                    buffer.append(ch);
                }
                String keySuffix = buffer.toString();
                if (length == 1 && asString.charAt(0) == '*') {
                    keySuffix = "__";
                }
                possibleValuePresentations[i] = this.presentationLoader_.getPresentation(this.presentationKey_, buffer.toString());
            }
        }
        this.metaData_ = null;
        ResourceMetaData rmd = new ResourceMetaData(id, type, readOnly, possibleValues, defaultValue, valueLimited, multipleAllowed, presentation, possibleValuePresentations);
        this.metaDataByID_.put(id, rmd);
        return rmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceMetaData[] getMetaData() {
        ResourceMetaDataTable resourceMetaDataTable = this;
        synchronized (resourceMetaDataTable) {
            Vector<ResourceMetaData> asVector = new Vector<ResourceMetaData>(this.metaDataByID_.size());
            boolean i = false;
            Enumeration list = this.metaDataByID_.elements();
            while (list.hasMoreElements()) {
                ResourceMetaData rmd = (ResourceMetaData)list.nextElement();
                asVector.addElement(rmd);
            }
            Object[] metaData = new ResourceMetaData[asVector.size()];
            asVector.copyInto(metaData);
            return metaData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceMetaData[] getMetaData(String level) {
        if (level == null) {
            throw new NullPointerException("level");
        }
        ResourceMetaDataTable resourceMetaDataTable = this;
        synchronized (resourceMetaDataTable) {
            Vector<ResourceMetaData> asVector = new Vector<ResourceMetaData>(this.metaDataByID_.size());
            Enumeration list = this.metaDataByID_.elements();
            while (list.hasMoreElements()) {
                ResourceMetaData rmd = (ResourceMetaData)list.nextElement();
                if (!rmd.getLevel().checkLevel(level)) continue;
                asVector.addElement(rmd);
            }
            Object[] metaData = new ResourceMetaData[asVector.size()];
            asVector.copyInto(metaData);
            return metaData;
        }
    }

    public ResourceMetaData getMetaData(Object id) {
        return this.validateID(id);
    }

    ResourceMetaData validateID(Object id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (!this.metaDataByID_.containsKey(id)) {
            throw new ExtendedIllegalArgumentException("id(" + id.toString() + ")", 2);
        }
        return (ResourceMetaData)this.metaDataByID_.get(id);
    }

    void validateIDs(Object[] id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        for (int i = 0; i < id.length; ++i) {
            if (this.metaDataByID_.containsKey(id[i])) continue;
            throw new ExtendedIllegalArgumentException("id[" + i + "](" + id[i].toString() + ")", 2);
        }
    }
}

