/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.AS400Array;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400PackedDecimal;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400ZonedDecimal;
import com.ibm.as400.access.ArrayFieldDescription;
import com.ibm.as400.access.DateFieldDescription;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.TimeFieldDescription;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.Descriptor;
import com.ibm.as400.data.ParseException;
import com.ibm.as400.data.PcmlAttribute;
import com.ibm.as400.data.PcmlAttributeList;
import com.ibm.as400.data.PcmlDimensions;
import com.ibm.as400.data.PcmlSpecificationException;
import com.ibm.as400.data.RfmlData;
import com.ibm.as400.data.RfmlDescriptor;
import com.ibm.as400.data.RfmlDocument;
import com.ibm.as400.data.RfmlRecordFormat;
import com.ibm.as400.data.RfmlSAXParser;
import com.ibm.as400.data.SystemResourceFinder;
import com.ibm.as400.data.XmlException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.MissingResourceException;
import java.util.Vector;

public class RecordFormatDocument
implements Serializable,
Cloneable {
    static final long serialVersionUID = 5L;
    static final String RFML_VERSION = "4.0";
    private RfmlDocument m_rfmlDoc_;

    public RecordFormatDocument() {
    }

    public RecordFormatDocument(String documentName) throws XmlException {
        if (documentName == null) {
            throw new NullPointerException("documentName");
        }
        this.m_rfmlDoc_ = RecordFormatDocument.loadRfmlDocument(documentName, null);
    }

    public RecordFormatDocument(String documentName, ClassLoader loader) throws XmlException {
        if (documentName == null) {
            throw new NullPointerException("documentName");
        }
        if (loader == null) {
            throw new NullPointerException("loader");
        }
        this.m_rfmlDoc_ = RecordFormatDocument.loadRfmlDocument(documentName, loader);
    }

    public RecordFormatDocument(Record record) throws XmlException {
        if (record == null) {
            throw new NullPointerException("record");
        }
        RecordFormat recordFormat = record.getRecordFormat();
        if (recordFormat == null) {
            throw new XmlException("RECORD_NOT_INITIALIZED");
        }
        this.setRecordFormat(recordFormat);
        this.setValues(recordFormat.getName(), record);
    }

    public RecordFormatDocument(RecordFormat recordFormat) throws XmlException {
        if (recordFormat == null) {
            throw new NullPointerException("recordFormat");
        }
        this.setRecordFormat(recordFormat);
    }

    private static void addAttribute(PcmlAttributeList attrList, String attrName, String attrValue) {
        PcmlAttribute attr = new PcmlAttribute(attrName, attrValue, true);
        attrList.addAttribute(attr);
    }

    public Object clone() {
        RecordFormatDocument newRfml = null;
        try {
            newRfml = (RecordFormatDocument)super.clone();
            if (this.m_rfmlDoc_ != null) {
                newRfml.m_rfmlDoc_ = (RfmlDocument)this.m_rfmlDoc_.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            Trace.log(1, e);
        }
        return newRfml;
    }

    private static PcmlAttributeList generateAttributeList(FieldDescription fieldDesc, boolean isKeyField, Vector priorFieldNames, String recordFormatName) throws XmlException {
        Object defaultValue;
        AS400DataType dataType = fieldDesc.getDataType();
        PcmlAttributeList attrList = new PcmlAttributeList(1);
        int count = 1;
        int dtType = dataType.getInstanceType();
        if (dtType == 0) {
            count = ((AS400Array)dataType).getNumberOfElements();
            if (count < 0) {
                Trace.log(1, "AS400Array count is not set (" + count + ")");
                count = 1;
            }
            RecordFormatDocument.addAttribute(attrList, "count", Integer.toString(count));
            dataType = ((AS400Array)dataType).getType();
            dtType = dataType.getInstanceType();
            if (dataType.getInstanceType() == 0) {
                throw new XmlException("MULTI_ARRAY_NOT_SUPPORTED");
            }
        }
        if (dtType == 8) {
            throw new XmlException("DATATYPE_NOT_SUPPORTED", new String[]{"AS400Structure"});
        }
        String fieldName = fieldDesc.getFieldName();
        if (priorFieldNames.contains(fieldName)) {
            throw new XmlException("DUPLICATE_FIELD_NAME", new String[]{recordFormatName, fieldName});
        }
        if (fieldName != null && fieldName.length() != 0) {
            RecordFormatDocument.addAttribute(attrList, "name", fieldName);
            priorFieldNames.add(fieldName);
        }
        if (dtType != 1 && dtType != 10 && dtType != 2 && dtType != 11 && dtType != 3 && dtType != 16 && dtType != 5 && dtType != 6 && dtType != 7) {
            int fieldLength = count == 0 ? fieldDesc.getLength() : fieldDesc.getLength() / count;
            RecordFormatDocument.addAttribute(attrList, "length", Integer.toString(fieldLength));
        }
        if ((defaultValue = fieldDesc.getDFT()) == null) {
            defaultValue = fieldDesc.getDFTCurrentValue();
        }
        if (defaultValue != null) {
            if (defaultValue instanceof byte[] && ((byte[])defaultValue).length != 0) {
                byte[] dftBytes = (byte[])defaultValue;
                if (RecordFormatDocument.isSameByteRepeated(dftBytes)) {
                    String byte0 = Byte.toString(dftBytes[0]);
                    RecordFormatDocument.addAttribute(attrList, "init", byte0);
                } else {
                    StringBuilder valList = new StringBuilder();
                    for (int i = 0; i < dftBytes.length; ++i) {
                        valList.append(Byte.toString(dftBytes[i])).append(" ");
                    }
                    valList.deleteCharAt(valList.length() - 1);
                    RecordFormatDocument.addAttribute(attrList, "init", valList.toString());
                }
            } else {
                RecordFormatDocument.addAttribute(attrList, "init", defaultValue.toString());
            }
        }
        switch (dtType) {
            case 1: {
                RecordFormatDocument.addAttribute(attrList, "type", "int");
                RecordFormatDocument.addAttribute(attrList, "length", "2");
                break;
            }
            case 2: {
                RecordFormatDocument.addAttribute(attrList, "type", "int");
                RecordFormatDocument.addAttribute(attrList, "length", "4");
                break;
            }
            case 3: {
                RecordFormatDocument.addAttribute(attrList, "type", "int");
                RecordFormatDocument.addAttribute(attrList, "length", "8");
                break;
            }
            case 10: {
                RecordFormatDocument.addAttribute(attrList, "type", "int");
                RecordFormatDocument.addAttribute(attrList, "length", "2");
                RecordFormatDocument.addAttribute(attrList, "precision", "16");
                break;
            }
            case 11: {
                RecordFormatDocument.addAttribute(attrList, "type", "int");
                RecordFormatDocument.addAttribute(attrList, "length", "4");
                RecordFormatDocument.addAttribute(attrList, "precision", "32");
                break;
            }
            case 16: {
                RecordFormatDocument.addAttribute(attrList, "type", "int");
                RecordFormatDocument.addAttribute(attrList, "length", "8");
                RecordFormatDocument.addAttribute(attrList, "precision", "64");
                break;
            }
            case 4: {
                RecordFormatDocument.addAttribute(attrList, "type", "byte");
                break;
            }
            case 5: {
                RecordFormatDocument.addAttribute(attrList, "type", "float");
                RecordFormatDocument.addAttribute(attrList, "length", "4");
                break;
            }
            case 6: {
                RecordFormatDocument.addAttribute(attrList, "type", "float");
                RecordFormatDocument.addAttribute(attrList, "length", "8");
                break;
            }
            case 7: {
                RecordFormatDocument.addAttribute(attrList, "type", "packed");
                int numDigits = ((AS400PackedDecimal)dataType).getNumberOfDigits();
                RecordFormatDocument.addAttribute(attrList, "length", Integer.toString(numDigits));
                int precision = ((AS400PackedDecimal)dataType).getNumberOfDecimalPositions();
                RecordFormatDocument.addAttribute(attrList, "precision", Integer.toString(precision));
                break;
            }
            case 9: {
                RecordFormatDocument.addAttribute(attrList, "type", "char");
                try {
                    if (fieldDesc instanceof ArrayFieldDescription) {
                        int ccsid = ((AS400Text)dataType).getCcsid();
                        if (ccsid <= 0) break;
                        RecordFormatDocument.addAttribute(attrList, "ccsid", Integer.toString(ccsid));
                        break;
                    }
                    Method method = fieldDesc.getClass().getMethod("getCCSID", null);
                    String ccsids = (String)method.invoke((Object)fieldDesc, (Object[])null);
                    if (ccsids == null || ccsids.length() == 0) break;
                    RecordFormatDocument.addAttribute(attrList, "ccsid", ccsids);
                }
                catch (Exception e) {
                    Trace.log(1, e);
                }
                break;
            }
            case 12: {
                RecordFormatDocument.addAttribute(attrList, "type", "zoned");
                int precisionZ = ((AS400ZonedDecimal)dataType).getNumberOfDecimalPositions();
                RecordFormatDocument.addAttribute(attrList, "precision", Integer.toString(precisionZ));
                break;
            }
            case 17: {
                RecordFormatDocument.addAttribute(attrList, "type", "date");
                RecordFormatDocument.addAttribute(attrList, "length", Integer.toString(fieldDesc.getLength()));
                String dateFormat = ((DateFieldDescription)((Object)dataType)).getDATFMT();
                RecordFormatDocument.addAttribute(attrList, "dateformat", dateFormat);
                String dateSeparator = ((DateFieldDescription)((Object)dataType)).getDATSEP();
                RecordFormatDocument.addAttribute(attrList, "dateseparator", dateSeparator);
                break;
            }
            case 18: {
                RecordFormatDocument.addAttribute(attrList, "type", "time");
                RecordFormatDocument.addAttribute(attrList, "length", Integer.toString(fieldDesc.getLength()));
                String timeFormat = ((TimeFieldDescription)((Object)dataType)).getTIMFMT();
                RecordFormatDocument.addAttribute(attrList, "timeformat", timeFormat);
                String timeSeparator = ((TimeFieldDescription)((Object)dataType)).getTIMSEP();
                RecordFormatDocument.addAttribute(attrList, "timeseparator", timeSeparator);
                break;
            }
            case 19: {
                RecordFormatDocument.addAttribute(attrList, "type", "timestamp");
                RecordFormatDocument.addAttribute(attrList, "length", Integer.toString(fieldDesc.getLength()));
                break;
            }
            default: {
                Trace.log(2, "Unrecognized data type: dtType==" + dtType);
                throw new InternalErrorException(6);
            }
        }
        if (isKeyField) {
            RecordFormatDocument.addAttribute(attrList, "keyfield", "true");
        }
        return attrList;
    }

    public static Descriptor getDescriptor(String documentName) throws XmlException {
        if (documentName == null) {
            throw new NullPointerException("documentName");
        }
        RfmlDocument pd = null;
        pd = RecordFormatDocument.loadRfmlDocument(documentName, null);
        return new RfmlDescriptor(pd);
    }

    public static Descriptor getDescriptor(String documentName, ClassLoader loader) throws XmlException {
        if (documentName == null) {
            throw new NullPointerException("documentName");
        }
        if (loader == null) {
            throw new NullPointerException("loader");
        }
        RfmlDocument pd = null;
        pd = RecordFormatDocument.loadRfmlDocument(documentName, loader);
        return new RfmlDescriptor(pd);
    }

    public Descriptor getDescriptor() {
        if (this.m_rfmlDoc_ != null) {
            return new RfmlDescriptor(this.m_rfmlDoc_);
        }
        return null;
    }

    String getDocName() {
        if (this.m_rfmlDoc_ == null) {
            return null;
        }
        return this.m_rfmlDoc_.getDocName();
    }

    public double getDoubleValue(String name) throws XmlException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        return this.m_rfmlDoc_.getDoubleValue(name);
    }

    public double getDoubleValue(String name, int[] indices) throws XmlException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (indices == null) {
            throw new NullPointerException("indices");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        return this.m_rfmlDoc_.getDoubleValue(name, new PcmlDimensions(indices));
    }

    public int getIntValue(String name) throws XmlException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        return this.m_rfmlDoc_.getIntValue(name);
    }

    public int getIntValue(String name, int[] indices) throws XmlException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (indices == null) {
            throw new NullPointerException("indices");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        return this.m_rfmlDoc_.getIntValue(name, new PcmlDimensions(indices));
    }

    public String getStringValue(String name) throws XmlException {
        return this.getStringValue(name, 0);
    }

    public String getStringValue(String name, int type) throws XmlException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        return this.m_rfmlDoc_.getStringValue(name, type);
    }

    public String getStringValue(String name, int[] indices, int type) throws XmlException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (indices == null) {
            throw new NullPointerException("indices");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        return this.m_rfmlDoc_.getStringValue(name, new PcmlDimensions(indices), type);
    }

    public Object getValue(String name) throws XmlException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        return this.m_rfmlDoc_.getValue(name);
    }

    public Object getValue(String name, int[] indices) throws XmlException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (indices == null) {
            throw new NullPointerException("indices");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        return this.m_rfmlDoc_.getValue(name, new PcmlDimensions(indices));
    }

    private static boolean isSameByteRepeated(byte[] bytes) {
        for (int i = 1; i < bytes.length; ++i) {
            if (bytes[i] == bytes[0]) continue;
            return false;
        }
        return true;
    }

    private static RfmlDocument loadRfmlDocument(String docName, ClassLoader loader) throws XmlException {
        RfmlDocument pd = null;
        pd = RecordFormatDocument.loadSerializedRfmlDocument(docName, loader);
        if (pd != null) {
            return pd;
        }
        pd = RecordFormatDocument.loadSourceRfmlDocument(docName, loader);
        return pd;
    }

    private static RfmlDocument loadSerializedRfmlDocument(String docName, ClassLoader loader) throws XmlException {
        RfmlDocument pd = null;
        InputStream is = null;
        ObjectInputStream in = null;
        try {
            is = SystemResourceFinder.getSerializedRFMLDocument(docName, loader);
            in = new ObjectInputStream(is);
            pd = (RfmlDocument)in.readObject();
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (StreamCorruptedException streamCorruptedException) {
        }
        catch (IOException e) {
            if (Trace.isTraceErrorOn()) {
                e.printStackTrace(Trace.getPrintWriter());
            }
            throw new XmlException(e);
        }
        catch (ClassNotFoundException e) {
            if (Trace.isTraceErrorOn()) {
                e.printStackTrace(Trace.getPrintWriter());
            }
            throw new XmlException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return pd;
    }

    private static RfmlDocument loadSourceRfmlDocument(String docName, ClassLoader loader) throws XmlException {
        RfmlDocument pd = null;
        try {
            RfmlSAXParser psp = new RfmlSAXParser();
            psp.parse(docName, loader);
            pd = psp.getRfmlDocument();
        }
        catch (ParseException pe) {
            pe.reportErrors();
            throw new XmlException(pe);
        }
        catch (PcmlSpecificationException pse) {
            pse.reportErrors();
            throw new XmlException(pse);
        }
        catch (IOException ioe) {
            if (Trace.isTraceErrorOn()) {
                ioe.printStackTrace(Trace.getPrintWriter());
            }
            throw new XmlException(ioe);
        }
        catch (Exception e) {
            if (Trace.isTraceErrorOn()) {
                e.printStackTrace(Trace.getPrintWriter());
            }
            throw new XmlException(e);
        }
        return pd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String errMsg = SystemResourceFinder.format("PCD_ARGUMENTS");
        if (args.length == 2) {
            if (!args[0].equalsIgnoreCase("-SERIALIZE")) {
                System.out.println(errMsg);
                if (System.getProperty("com.ibm.as400.data.DisableExit") == null && System.getenv("com.ibm.as400.data.DisableExit") == null) {
                    System.exit(-1);
                } else {
                    return;
                }
            }
            FileOutputStream fos = null;
            try {
                RecordFormatDocument doc = new RecordFormatDocument(args[1]);
                String outFileName = doc.getDocName() + ".rfml.ser";
                fos = new FileOutputStream(outFileName);
                doc.serialize(fos);
                Trace.log(7, SystemResourceFinder.format("XML_SERIALIZED", new Object[]{"RFML", outFileName}));
            }
            catch (Exception e) {
                System.out.println(e.getLocalizedMessage());
                if (System.getProperty("com.ibm.as400.data.DisableExit") == null && System.getenv("com.ibm.as400.data.DisableExit") == null) {
                    System.exit(-1);
                }
                return;
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            System.out.println(errMsg);
            if (System.getProperty("com.ibm.as400.data.DisableExit") == null && System.getenv("com.ibm.as400.data.DisableExit") == null) {
                System.exit(-1);
            } else {
                return;
            }
        }
    }

    private static void saveRfmlDocument(RfmlDocument pd, OutputStream outStream) throws XmlException {
        ObjectOutputStream out = null;
        pd.setSerializingWithData(false);
        try {
            out = new ObjectOutputStream(outStream);
            out.writeObject(pd);
        }
        catch (IOException e) {
            if (Trace.isTraceErrorOn()) {
                e.printStackTrace(Trace.getPrintWriter());
            }
            throw new XmlException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void serialize(OutputStream outputStream) throws IOException, XmlException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        RecordFormatDocument.saveRfmlDocument(this.m_rfmlDoc_, outputStream);
    }

    public void serialize(File file) throws IOException, XmlException {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(file);
            this.serialize(fos);
        }
    }

    public void serialize(String fileName) throws IOException, XmlException {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(fileName);
            this.serialize(fos);
        }
    }

    public void setIntValue(String name, int value) throws XmlException {
        this.setValue(name, value);
    }

    public void setIntValue(String name, int[] indices, int value) throws XmlException {
        this.setValue(name, indices, value);
    }

    private void setRecordFormat(RecordFormat recordFormat) throws XmlException {
        String fmtName = recordFormat.getName();
        if (fmtName == null || fmtName.length() == 0) {
            Trace.log(2, "RecordFormat name is null or zero-length.");
            throw new XmlException("RECORDFORMAT_NOT_INITIALIZED");
        }
        this.setRecordFormat(fmtName, recordFormat);
    }

    private void setRecordFormat(String formatName, RecordFormat recordFormat) throws XmlException {
        PcmlAttributeList attrList = new PcmlAttributeList(1);
        RecordFormatDocument.addAttribute(attrList, "version", RFML_VERSION);
        this.m_rfmlDoc_ = new RfmlDocument(attrList, recordFormat.getName());
        attrList = new PcmlAttributeList(1);
        RecordFormatDocument.addAttribute(attrList, "name", formatName);
        RfmlRecordFormat recFormatNode = new RfmlRecordFormat(attrList);
        this.m_rfmlDoc_.addChild(recFormatNode);
        FieldDescription[] descriptions = recordFormat.getFieldDescriptions();
        Object[] keyFieldDescriptions = recordFormat.getKeyFieldDescriptions();
        Vector priorFieldNames = new Vector();
        for (int i = 0; i < descriptions.length; ++i) {
            FieldDescription fieldDesc = descriptions[i];
            boolean isKeyField = RecordFormatDocument.contains(keyFieldDescriptions, fieldDesc);
            attrList = RecordFormatDocument.generateAttributeList(fieldDesc, isKeyField, priorFieldNames, recordFormat.getName());
            if (attrList == null) continue;
            RfmlData dataNode = new RfmlData(attrList);
            recFormatNode.addChild(dataNode);
        }
    }

    private static final boolean contains(Object[] array, Object element) {
        boolean contains = false;
        for (int i = 0; i < array.length && !contains; ++i) {
            if (!array[i].equals(element)) continue;
            contains = true;
        }
        return contains;
    }

    public void setStringValue(String name, String value) throws XmlException {
        this.setStringValue(name, value, 0);
    }

    public void setStringValue(String name, String value, int type) throws XmlException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        this.m_rfmlDoc_.setStringValue(name, value, type);
    }

    public void setStringValue(String name, int[] indices, String value, int type) throws XmlException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (indices == null) {
            throw new NullPointerException("indices");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        this.m_rfmlDoc_.setStringValue(name, value, new PcmlDimensions(indices), type);
    }

    public void setDocument(String documentName) throws XmlException {
        if (documentName == null) {
            throw new NullPointerException("documentName");
        }
        if (this.m_rfmlDoc_ != null) {
            throw new XmlException("DOCUMENT_ALREADY_SET");
        }
        this.m_rfmlDoc_ = RecordFormatDocument.loadRfmlDocument(documentName, null);
    }

    public void setDocument(String documentName, ClassLoader loader) throws XmlException {
        if (documentName == null) {
            throw new NullPointerException("documentName");
        }
        if (loader == null) {
            throw new NullPointerException("loader");
        }
        if (this.m_rfmlDoc_ != null) {
            throw new XmlException("DOCUMENT_ALREADY_SET");
        }
        this.m_rfmlDoc_ = RecordFormatDocument.loadRfmlDocument(documentName, loader);
    }

    public void setValue(String name, Object value) throws XmlException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        this.m_rfmlDoc_.setValue(name, value);
    }

    public void setValue(String name, int[] indices, Object value) throws XmlException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (indices == null) {
            throw new NullPointerException("indices");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        this.m_rfmlDoc_.setValue(name, value, new PcmlDimensions(indices));
    }

    public void setValues(String formatName, Record record) throws XmlException {
        if (formatName == null) {
            throw new NullPointerException("formatName");
        }
        if (record == null) {
            throw new NullPointerException("record");
        }
        if (this.m_rfmlDoc_ == null) {
            RecordFormat recFmt = record.getRecordFormat();
            if (recFmt != null) {
                this.setRecordFormat(formatName, recFmt);
            } else {
                Trace.log(2, "The Record has a null RecordFormat.");
                throw new XmlException("RECORD_NOT_INITIALIZED");
            }
        }
        RfmlRecordFormat recFormatNode = this.m_rfmlDoc_.getRecordFormatNode(formatName);
        try {
            recFormatNode.setValues(record);
        }
        catch (UnsupportedEncodingException e) {
            throw new XmlException(e);
        }
    }

    public void setValues(String formatName, byte[] values) throws XmlException {
        if (formatName == null) {
            throw new NullPointerException("formatName");
        }
        if (values == null) {
            throw new NullPointerException("values");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        RfmlRecordFormat recFormatNode = this.m_rfmlDoc_.getRecordFormatNode(formatName);
        int bytesConsumed = recFormatNode.parseBytes(values);
        if (bytesConsumed < values.length) {
            throw new XmlException("EXCESS_INPUT_DATA", new Object[]{Integer.toString(bytesConsumed), Integer.toString(values.length), "<recordformat>", this.m_rfmlDoc_.getNameForException()});
        }
    }

    public byte[] toByteArray(String formatName) throws XmlException {
        if (formatName == null) {
            throw new NullPointerException("formatName");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        RfmlRecordFormat recFormatNode = this.m_rfmlDoc_.getRecordFormatNode(formatName);
        return recFormatNode.toBytes();
    }

    public Record toRecord(String formatName) throws XmlException {
        try {
            return new Record(this.toRecordFormat(formatName), this.toByteArray(formatName));
        }
        catch (UnsupportedEncodingException e) {
            throw new XmlException(e);
        }
    }

    public RecordFormat toRecordFormat(String formatName) throws XmlException {
        if (formatName == null) {
            throw new NullPointerException("formatName");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        RfmlRecordFormat recFormatNode = this.m_rfmlDoc_.getRecordFormatNode(formatName);
        return recFormatNode.toRecordFormat();
    }

    public void toXml(OutputStream outputStream) throws IOException, XmlException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        this.m_rfmlDoc_.toXml(outputStream);
    }

    public void toXml(File file) throws IOException, XmlException {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(file);
            this.toXml(fos);
        }
    }

    public void toXml(String fileName) throws IOException, XmlException {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(fileName);
            this.toXml(fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        RecordFormatDocument recordFormatDocument = this;
        synchronized (recordFormatDocument) {
            if (this.m_rfmlDoc_ != null) {
                this.m_rfmlDoc_.setSerializingWithData(true);
            }
            out.defaultWriteObject();
        }
    }
}

