/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Timestamp;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.SystemPool;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.TimeZone;

public class SystemStatus
implements Serializable {
    static final long serialVersionUID = 4L;
    private static final ProgramParameter ERROR_CODE = new ProgramParameter(new byte[8]);
    private AS400 system_;
    byte[][] receiverVariables_ = new byte[4][];
    private List<SystemPool> poolsList_;
    private transient boolean connected_ = false;
    private transient boolean caching_ = false;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;
    private transient AS400Timestamp timestampConverter_;
    private static final int FORMAT_DTS = 1;

    public SystemStatus() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SystemStatus object.");
        }
    }

    public SystemStatus(AS400 system) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SystemStatus object, system: " + system);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.system_ = system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        SystemStatus systemStatus = this;
        synchronized (systemStatus) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        SystemStatus systemStatus = this;
        synchronized (systemStatus) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(listener);
        }
    }

    public int getActiveJobsInSystem() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 100);
    }

    public int getActiveThreadsInSystem() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 104);
    }

    public int getBatchJobsEndedWithPrinterOutputWaitingToPrint() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 76);
    }

    public int getBatchJobsEnding() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 56);
    }

    public int getBatchJobsHeldOnJobQueue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 64);
    }

    public int getBatchJobsHeldWhileRunning() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 52);
    }

    public int getBatchJobsOnAHeldJobQueue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 68);
    }

    public int getBatchJobsOnUnassignedJobQueue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 72);
    }

    public int getBatchJobsRunning() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 48);
    }

    public int getBatchJobsWaitingForMessage() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 44);
    }

    public int getBatchJobsWaitingToRunOrAlreadyScheduled() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 60);
    }

    public float getCurrentProcessingCapacity() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return (float)BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 88) / 100.0f;
    }

    public int getCurrentUnprotectedStorageUsed() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 60);
    }

    public Date getDateAndTimeStatusGathered() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(0);
        byte[] currentDateAndTime = new byte[8];
        System.arraycopy(this.receiverVariables_[0], 8, currentDateAndTime, 0, 8);
        AS400Timestamp conv = this.getTimestampConverter(1);
        return conv.toDate(conv.toTimestamp(currentDateAndTime), TimeZone.getDefault());
    }

    public int getElapsedTime() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int format;
        if (!this.caching_) {
            this.refreshCache();
        }
        if (this.receiverVariables_[2] == null) {
            if (this.receiverVariables_[3] == null) {
                this.loadInformation(2);
                format = 2;
            } else {
                format = 3;
            }
        } else {
            format = 2;
        }
        int hours = (this.receiverVariables_[format][24] & 0xF) * 10 + (this.receiverVariables_[format][25] & 0xF);
        int minutes = (this.receiverVariables_[format][26] & 0xF) * 10 + (this.receiverVariables_[format][27] & 0xF);
        int seconds = (this.receiverVariables_[format][28] & 0xF) * 10 + (this.receiverVariables_[format][29] & 0xF);
        return hours * 3600 + minutes * 60 + seconds;
    }

    public int getJobsInSystem() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 36);
    }

    public long getMainStorageSize() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        if (this.system_.getVRM() < 328704) {
            return BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 72);
        }
        return BinaryConverter.byteArrayToLong(this.receiverVariables_[2], 140);
    }

    public long getMaximumJobsInSystem() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 108);
    }

    public int getMaximumUnprotectedStorageUsed() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 64);
    }

    public int getNumberOfPartitions() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 76);
    }

    public int getNumberOfProcessors() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 96);
    }

    public int getPartitionIdentifier() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 80);
    }

    public float getPercentCurrentInteractivePerformance() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 128);
    }

    public float getPercentDBCapability() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        int intValue = BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 68);
        return intValue == -1 ? -1.0f : (float)intValue / 10.0f;
    }

    public float getPercentPermanentAddresses() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return (float)BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 40) / 1000.0f;
    }

    public float getPercentPermanent256MBSegmentsUsed() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return (float)BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 120) / 1000.0f;
    }

    public float getPercentPermanent4GBSegmentsUsed() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return (float)BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 124) / 1000.0f;
    }

    public float getPercentProcessingUnitUsed() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return (float)BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 32) / 10.0f;
    }

    public float getPercentSharedProcessorPoolUsed() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        int intValue = BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 136);
        return this.system_.getVRM() < 328448 || intValue == -1 ? -1.0f : (float)intValue / 10.0f;
    }

    public float getPercentSystemASPUsed() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return (float)BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 52) / 10000.0f;
    }

    public float getPercentTemporaryAddresses() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return (float)BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 44) / 1000.0f;
    }

    public float getPercentTemporary256MBSegmentsUsed() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return (float)BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 112) / 1000.0f;
    }

    public float getPercentTemporary4GBSegmentsUsed() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return (float)BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 116) / 1000.0f;
    }

    public float getPercentUncappedCPUCapacityUsed() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        int intValue = BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 132);
        return this.system_.getVRM() < 328448 || intValue == -1 ? -1.0f : (float)intValue / 10.0f;
    }

    public int getPoolsNumber() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(3);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[3], 32);
    }

    public int getProcessorSharingAttribute() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return this.receiverVariables_[2][92] & 0xF;
    }

    public boolean getRestrictedStateFlag() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return this.receiverVariables_[2][30] == -15;
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    public int getSystemASP() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 48);
    }

    public String getSystemName() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(0);
        Converter conv = new Converter(this.system_.getJobCcsid(), this.system_);
        return conv.byteArrayToString(this.receiverVariables_[0], 16, 8).trim();
    }

    public Enumeration<SystemPool> getSystemPools() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return Collections.enumeration(this.getSystemPoolsList());
    }

    public List<SystemPool> getSystemPoolsList() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(3);
        if (this.poolsList_ != null) {
            return this.poolsList_;
        }
        this.poolsList_ = new ArrayList<SystemPool>();
        int number = BinaryConverter.byteArrayToInt(this.receiverVariables_[3], 32);
        int offset = BinaryConverter.byteArrayToInt(this.receiverVariables_[3], 36);
        int length = BinaryConverter.byteArrayToInt(this.receiverVariables_[3], 40);
        for (int i = 0; i < number; ++i) {
            byte[] poolInformation = new byte[length];
            System.arraycopy(this.receiverVariables_[3], offset, poolInformation, 0, length);
            SystemPool systemPool = null;
            int poolIdentifier = BinaryConverter.byteArrayToInt(poolInformation, 0);
            if (poolIdentifier != 0) {
                systemPool = new SystemPool(this.system_, poolIdentifier);
            } else {
                String poolName = new CharConverter(this.system_.getJobCcsid(), this.system_).byteArrayToString(poolInformation, 44, 10);
                systemPool = new SystemPool(this.system_, poolName);
            }
            this.poolsList_.add(systemPool);
            offset += length;
        }
        return this.poolsList_;
    }

    private synchronized AS400Timestamp getTimestampConverter(int format) {
        if (this.timestampConverter_ == null) {
            this.timestampConverter_ = new AS400Timestamp(AS400.getDefaultTimeZone(this.system_));
            this.timestampConverter_.setFormat(format);
        } else if (format != this.timestampConverter_.getFormat()) {
            this.timestampConverter_.setFormat(format);
        }
        return this.timestampConverter_;
    }

    public int getTotalAuxiliaryStorage() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[2], 56);
    }

    public int getUsersCurrentSignedOn() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 24);
    }

    public int getUsersSignedOffWithPrinterOutputWaitingToPrint() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 40);
    }

    public int getUsersSuspendedByGroupJobs() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 36);
    }

    public int getUsersSuspendedBySystemRequest() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 32);
    }

    public int getUsersTemporarilySignedOff() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(1);
        return BinaryConverter.byteArrayToInt(this.receiverVariables_[1], 28);
    }

    public boolean isCaching() {
        return this.caching_;
    }

    public void reset() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(2, true);
    }

    private void loadInformation(int format) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadInformation(format, false);
    }

    private void loadInformation(int format, boolean reset) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        boolean repeatRun;
        byte[] byArray;
        int receiverVariableLength;
        if (!this.caching_ || reset) {
            this.refreshCache();
        }
        if (this.receiverVariables_[format] != null) {
            return;
        }
        if (format == 0) {
            format = 1;
        }
        if (!this.connected_) {
            if (this.system_ == null) {
                Trace.log(2, "Cannot connect before setting system.");
                throw new ExtendedIllegalStateException("system", 4);
            }
            this.connected_ = true;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving system status.");
        }
        int n = format == 1 ? 80 : (receiverVariableLength = format == 2 ? 148 : 2048);
        if (reset) {
            byte[] byArray2 = new byte[10];
            byArray2[0] = 92;
            byArray2[1] = -24;
            byArray2[2] = -59;
            byArray2[3] = -30;
            byArray2[4] = 64;
            byArray2[5] = 64;
            byArray2[6] = 64;
            byArray2[7] = 64;
            byArray2[8] = 64;
            byArray = byArray2;
            byArray2[9] = 64;
        } else {
            byte[] byArray3 = new byte[10];
            byArray3[0] = 92;
            byArray3[1] = -43;
            byArray3[2] = -42;
            byArray3[3] = 64;
            byArray3[4] = 64;
            byArray3[5] = 64;
            byArray3[6] = 64;
            byArray3[7] = 64;
            byArray3[8] = 64;
            byArray = byArray3;
            byArray3[9] = 64;
        }
        byte[] resetStatusStatistics = byArray;
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(receiverVariableLength), new ProgramParameter(BinaryConverter.intToByteArray(receiverVariableLength)), new ProgramParameter(new byte[]{-30, -30, -29, -30, -16, (byte)(0xF0 | format), -16, -16}), new ProgramParameter(resetStatusStatistics), ERROR_CODE};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QWCRSSTS.PGM", parameters);
        do {
            repeatRun = false;
            if (!pc.run()) {
                throw new AS400Exception(pc.getMessageList());
            }
            this.receiverVariables_[format] = parameters[0].getOutputData();
            int bytesAvailable = BinaryConverter.byteArrayToInt(this.receiverVariables_[format], 0);
            int bytesReturned = BinaryConverter.byteArrayToInt(this.receiverVariables_[format], 4);
            if (bytesReturned >= bytesAvailable) continue;
            repeatRun = true;
            if (Trace.traceOn_) {
                Trace.log(1, "Retrieve system status receiver variable too small, bytes returned: " + bytesReturned + ", bytes available: " + bytesAvailable);
            }
            parameters[0] = new ProgramParameter(bytesAvailable);
            parameters[1] = new ProgramParameter(BinaryConverter.intToByteArray(bytesAvailable));
        } while (repeatRun);
        this.receiverVariables_[0] = this.receiverVariables_[format];
    }

    public void refreshCache() {
        this.receiverVariables_ = new byte[4][];
        this.poolsList_ = null;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(listener);
        }
    }

    public void setCaching(boolean caching) {
        this.caching_ = caching;
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + system);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.connected_) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.system_ = system;
        } else {
            AS400 oldValue = this.system_;
            AS400 newValue = system;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("system", oldValue, newValue);
            }
            this.system_ = system;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("system", oldValue, newValue);
            }
        }
    }
}

