/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.HexFieldDescription;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.PoolInformationFormat;
import com.ibm.as400.access.PoolInformationFormat0400;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.SSTS0300Format;
import com.ibm.as400.access.SSTS0400Format;
import com.ibm.as400.access.Subsystem;
import com.ibm.as400.access.SystemStatusFormat;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public class SystemPool {
    private static final boolean DEBUG = false;
    public static final float CALCULATE = -2.0f;
    private static final Float CALCULATE_FLOAT = Float.valueOf(-2.0f);
    public static final int CALCULATE_INT = -2;
    private static final Integer CALCULATE_INTEGER = -2;
    private static final Integer NO_CHANGE = -1;
    private static final String DEFAULT = "*DFT";
    private AS400 system_;
    private String poolName_;
    private Integer poolIdentifier_;
    private boolean indicatedSharedPool_;
    private String subsystemLibrary_;
    private String subsystemName_;
    private int poolSequenceNumber_;
    private transient boolean connected_;
    private boolean cacheChanges_ = false;
    private transient PropertyChangeSupport changes_;
    private transient VetoableChangeSupport vetos_;
    private SystemStatusFormat systemStatusFormat_;
    private PoolInformationFormat poolFormat_;
    private Record poolRecord_;
    private transient Hashtable changesTable_;
    private static final String TEN_BLANKS = "          ";

    public SystemPool() {
    }

    public SystemPool(AS400 system, String poolName) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (poolName == null) {
            throw new NullPointerException("poolName");
        }
        if (Trace.isTraceOn() && !SystemPool.isValidNameForSharedPool(poolName)) {
            Trace.log(4, "Invalid name for shared pool: " + poolName);
        }
        this.system_ = system;
        this.poolName_ = poolName.trim();
        this.indicatedSharedPool_ = true;
    }

    public SystemPool(Subsystem subsystem, int sequenceNumber) {
        if (subsystem == null) {
            throw new NullPointerException("subsystem");
        }
        if (sequenceNumber < 1 || sequenceNumber > 10) {
            throw new ExtendedIllegalArgumentException("sequenceNumber (" + sequenceNumber + ")", 4);
        }
        this.system_ = subsystem.getSystem();
        this.poolName_ = Integer.toString(sequenceNumber);
        this.subsystemLibrary_ = subsystem.getLibrary();
        this.subsystemName_ = subsystem.getName();
        this.poolSequenceNumber_ = sequenceNumber;
        this.indicatedSharedPool_ = false;
    }

    public SystemPool(Subsystem subsystem, int sequenceNumber, int size, int activityLevel) {
        this(subsystem, sequenceNumber);
        this.cacheChanges_ = true;
        try {
            this.set("poolSize", size);
            this.set("activityLevel", activityLevel);
        }
        catch (Exception e) {
            Trace.log(2, e);
            throw new InternalErrorException(10);
        }
        this.cacheChanges_ = false;
    }

    public SystemPool(Subsystem subsystem, int sequenceNumber, long size, int activityLevel) {
        this(subsystem, sequenceNumber);
        this.cacheChanges_ = true;
        try {
            this.set("poolSizeLong", size);
            this.set("activityLevel", activityLevel);
        }
        catch (Exception e) {
            Trace.log(2, e);
            throw new InternalErrorException(10);
        }
        this.cacheChanges_ = false;
    }

    public SystemPool(AS400 system, String poolName, int poolIdentifier) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (poolName == null) {
            throw new NullPointerException("poolName");
        }
        if (poolIdentifier < 1 || poolIdentifier > 64) {
            throw new ExtendedIllegalArgumentException("poolIdentifier (" + poolIdentifier + ")", 4);
        }
        this.system_ = system;
        this.poolName_ = poolName.trim();
        this.poolIdentifier_ = poolIdentifier;
        this.indicatedSharedPool_ = true;
        if (Trace.isTraceOn() && !SystemPool.isValidNameForSharedPool(poolName)) {
            Trace.log(4, "Invalid name for shared pool: " + poolName);
        }
    }

    public SystemPool(AS400 system, int poolIdentifier) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (poolIdentifier < 1 || poolIdentifier > 64) {
            throw new ExtendedIllegalArgumentException("poolIdentifier (" + poolIdentifier + ")", 4);
        }
        this.system_ = system;
        this.poolIdentifier_ = poolIdentifier;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    private static final Integer convertToHundredths(Object obj) {
        float floatVal = ((Float)obj).floatValue();
        Integer obj1 = floatVal <= 0.0f ? Integer.valueOf((int)floatVal) : Integer.valueOf((int)(floatVal * 100.0f));
        return obj1;
    }

    public synchronized void commitCache() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        int poolIdentifier;
        block44: {
            if (this.changesTable_ == null || this.changesTable_.isEmpty()) {
                return;
            }
            if (!this.connected_) {
                this.connect();
            }
            poolIdentifier = 0;
            try {
                poolIdentifier = this.getIdentifier();
            }
            catch (ObjectDoesNotExistException e) {
                poolIdentifier = 0;
                if (!Trace.isTraceOn()) break block44;
                Trace.log(1, "No pool identifier is assigned to pool.", (Throwable)e);
            }
        }
        String messageLogging_pending = null;
        if (poolIdentifier == 0 || this.changesTable_.get("poolSizeLong") != null) {
            StringBuilder cmdBuf = new StringBuilder("QSYS/CHGSHRPOOL POOL(" + this.getName() + ")");
            Object obj = this.changesTable_.get("poolSizeLong");
            if (obj != null) {
                cmdBuf.append(" SIZE(").append(obj.toString()).append(")");
            } else {
                obj = this.changesTable_.get("poolSize");
                if (obj != null) {
                    cmdBuf.append(" SIZE(").append(obj.toString()).append(")");
                }
            }
            obj = this.changesTable_.get("activityLevel");
            if (obj != null) {
                if (obj.equals(CALCULATE_INTEGER)) {
                    obj = "*SAME";
                    if (Trace.isTraceOn()) {
                        Trace.log(4, "Setting activityLevel to SAME.");
                    }
                }
                cmdBuf.append(" ACTLVL(").append(obj.toString()).append(")");
            }
            if ((obj = this.changesTable_.get("pagingOption")) != null) {
                cmdBuf.append(" PAGING(").append(obj.toString()).append(")");
            }
            if ((obj = this.changesTable_.get("priority")) != null) {
                if (obj.equals(CALCULATE_INTEGER)) {
                    obj = DEFAULT;
                    if (Trace.isTraceOn()) {
                        Trace.log(4, "Setting priority to DEFAULT.");
                    }
                }
                cmdBuf.append(" PTY(").append(obj.toString()).append(")");
            }
            if ((obj = this.changesTable_.get("minimumPoolSize")) != null) {
                if (obj.equals(CALCULATE_FLOAT)) {
                    obj = DEFAULT;
                    if (Trace.isTraceOn()) {
                        Trace.log(4, "Setting minimumPoolSize to DEFAULT.");
                    }
                }
                cmdBuf.append(" MINPCT(").append(obj.toString()).append(")");
            }
            if ((obj = this.changesTable_.get("maximumPoolSize")) != null) {
                if (obj.equals(CALCULATE_FLOAT)) {
                    obj = DEFAULT;
                    if (Trace.isTraceOn()) {
                        Trace.log(4, "Setting maximumPoolSize to DEFAULT.");
                    }
                }
                cmdBuf.append(" MAXPCT(").append(obj.toString()).append(")");
            }
            if ((obj = this.changesTable_.get("minimumFaults")) != null) {
                if (obj.equals(CALCULATE_FLOAT)) {
                    obj = DEFAULT;
                    if (Trace.isTraceOn()) {
                        Trace.log(4, "Setting minimumFaults to DEFAULT.");
                    }
                }
                cmdBuf.append(" MINFAULT(").append(obj.toString()).append(")");
            }
            if ((obj = this.changesTable_.get("perThreadFaults")) != null) {
                if (obj.equals(CALCULATE_FLOAT)) {
                    obj = DEFAULT;
                    if (Trace.isTraceOn()) {
                        Trace.log(4, "Setting perThreadFaults to DEFAULT.");
                    }
                }
                cmdBuf.append(" JOBFAULT(").append(obj.toString()).append(")");
            }
            if ((obj = this.changesTable_.get("maximumFaults")) != null) {
                if (obj.equals(CALCULATE_FLOAT)) {
                    obj = DEFAULT;
                    if (Trace.isTraceOn()) {
                        Trace.log(4, "Setting maximumFaults to DEFAULT.");
                    }
                }
                cmdBuf.append(" MAXFAULT(").append(obj.toString()).append(")");
            }
            CommandCall cmd = new CommandCall(this.system_, cmdBuf.toString());
            cmd.suggestThreadsafe(false);
            if (!cmd.run()) {
                throw new AS400Exception(cmd.getMessageList());
            }
            messageLogging_pending = (String)this.changesTable_.get("messageLogging");
        } else {
            QSYSObjectPathName prgName = new QSYSObjectPathName("QSYS", "QUSCHGPA", "PGM");
            AS400Bin4 bin4 = new AS400Bin4();
            ProgramParameter[] parmList = new ProgramParameter[12];
            parmList[0] = new ProgramParameter(bin4.toBytes(this.getIdentifier()));
            Object obj = this.changesTable_.get("poolSize");
            if (obj == null) {
                obj = NO_CHANGE;
            }
            parmList[1] = new ProgramParameter(bin4.toBytes(obj));
            obj = this.changesTable_.get("activityLevel");
            if (obj == null) {
                obj = NO_CHANGE;
            }
            parmList[2] = new ProgramParameter(bin4.toBytes(obj));
            obj = this.changesTable_.get("messageLogging");
            if (obj == null) {
                obj = "Y";
            }
            AS400Text text1 = new AS400Text(1, this.system_.getCcsid(), this.system_);
            parmList[3] = new ProgramParameter(text1.toBytes(obj));
            byte[] errorInfo = new byte[32];
            parmList[4] = new ProgramParameter(errorInfo, 0);
            obj = this.changesTable_.get("pagingOption");
            if (obj == null) {
                obj = "*SAME";
            }
            AS400Text text10 = new AS400Text(10, this.system_.getCcsid(), this.system_);
            parmList[5] = new ProgramParameter(text10.toBytes(obj));
            obj = this.changesTable_.get("priority");
            if (obj == null) {
                obj = NO_CHANGE;
            }
            parmList[6] = new ProgramParameter(bin4.toBytes(obj));
            obj = this.changesTable_.get("minimumPoolSize");
            obj = obj == null ? NO_CHANGE : (obj.equals(CALCULATE_FLOAT) ? CALCULATE_INTEGER : SystemPool.convertToHundredths(obj));
            parmList[7] = new ProgramParameter(bin4.toBytes(obj));
            obj = this.changesTable_.get("maximumPoolSize");
            obj = obj == null ? NO_CHANGE : (obj.equals(CALCULATE_FLOAT) ? CALCULATE_INTEGER : SystemPool.convertToHundredths(obj));
            parmList[8] = new ProgramParameter(bin4.toBytes(obj));
            obj = this.changesTable_.get("minimumFaults");
            obj = obj == null ? NO_CHANGE : (obj.equals(CALCULATE_FLOAT) ? CALCULATE_INTEGER : SystemPool.convertToHundredths(obj));
            parmList[9] = new ProgramParameter(bin4.toBytes(obj));
            obj = this.changesTable_.get("perThreadFaults");
            obj = obj == null ? NO_CHANGE : (obj.equals(CALCULATE_FLOAT) ? CALCULATE_INTEGER : SystemPool.convertToHundredths(obj));
            parmList[10] = new ProgramParameter(bin4.toBytes(obj));
            obj = this.changesTable_.get("maximumFaults");
            obj = obj == null ? NO_CHANGE : (obj.equals(CALCULATE_FLOAT) ? CALCULATE_INTEGER : SystemPool.convertToHundredths(obj));
            parmList[11] = new ProgramParameter(bin4.toBytes(obj));
            ProgramCall pgm = new ProgramCall(this.system_);
            try {
                pgm.setProgram(prgName.getPath(), parmList);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (Trace.isTraceOn()) {
                Trace.log(1, "Setting system pool information.");
            }
            if (!pgm.run()) {
                AS400Message[] msgList = pgm.getMessageList();
                if (Trace.isTraceOn()) {
                    Trace.log(2, "Error setting system pool information:");
                    for (int i = 0; i < msgList.length; ++i) {
                        Trace.log(2, msgList[i].toString());
                    }
                }
                throw new AS400Exception(msgList);
            }
        }
        this.changesTable_.clear();
        if (messageLogging_pending != null) {
            this.changesTable_.put("messageLogging", messageLogging_pending);
            Trace.log(2, "Unable to update 'message logging' attribute, since shared pool " + this.poolName_ + " is not in use.  The change remains pending.");
        }
    }

    private void connect() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        if (this.system_ == null) {
            Trace.log(2, "Attempt to connect before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.connected_ = true;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            SystemPool other = (SystemPool)obj;
            if (this.system_ == null ? other.getSystem() != null : !this.system_.equals(other.getSystem())) {
                return false;
            }
            if (this.poolName_ == null ? other.getName() != null : !this.poolName_.equals(other.getName())) {
                return false;
            }
            if (this.subsystemLibrary_ == null ? other.getSubsystemLibrary() != null : !this.subsystemLibrary_.equals(other.getSubsystemLibrary())) {
                return false;
            }
            if (this.subsystemName_ == null ? other.getSubsystemName() != null : !this.subsystemName_.equals(other.getSubsystemName())) {
                return false;
            }
            return this.poolIdentifier_ == null || this.poolIdentifier_ == 0 || other.getIdentifier() == 0 || this.poolIdentifier_.intValue() == other.getIdentifier();
        }
        catch (Throwable e) {
            return false;
        }
    }

    public int hashCode() {
        int hash = 0;
        if (this.system_ != null) {
            hash += this.system_.hashCode();
        }
        if (this.poolName_ != null) {
            hash += this.poolName_.hashCode();
        }
        if (this.subsystemLibrary_ != null) {
            hash += this.subsystemLibrary_.hashCode();
        }
        if (this.subsystemName_ != null) {
            hash += this.subsystemName_.hashCode();
        }
        if (this.poolIdentifier_ != null) {
            hash += this.poolIdentifier_.hashCode();
        }
        return hash;
    }

    private Object get(String field) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        Object obj = null;
        if (!this.cacheChanges_) {
            this.refreshCache();
        } else if (this.changesTable_ != null) {
            obj = this.changesTable_.get(field);
        }
        if (obj == null) {
            this.retrieveInformation();
            obj = this.poolRecord_.getField(field);
        }
        return obj;
    }

    public float getActiveToIneligible() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return ((Integer)this.get("activeToIneligible")).floatValue() / 10.0f;
    }

    public float getActiveToWait() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return ((Integer)this.get("activeToWait")).floatValue() / 10.0f;
    }

    public float getDatabaseFaults() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return ((Integer)this.get("databaseFaults")).floatValue() / 10.0f;
    }

    public float getDatabasePages() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return ((Integer)this.get("databasePages")).floatValue() / 10.0f;
    }

    public String getDescription() {
        if (this.poolName_ == null) {
            return "";
        }
        if (this.poolName_.equals("*MACHINE")) {
            return ResourceBundleLoader.getText("SYSTEM_POOL_MACHINE");
        }
        if (this.poolName_.equals("*BASE")) {
            return ResourceBundleLoader.getText("SYSTEM_POOL_BASE");
        }
        if (this.poolName_.equals("*INTERACT")) {
            return ResourceBundleLoader.getText("SYSTEM_POOL_INTERACT");
        }
        if (this.poolName_.equals("*SPOOL")) {
            return ResourceBundleLoader.getText("SYSTEM_POOL_SPOOL");
        }
        return ResourceBundleLoader.getText("SYSTEM_POOL_OTHER");
    }

    public int getMaximumActiveThreads() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return this.getActivityLevel();
    }

    public int getActivityLevel() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (Integer)this.get("activityLevel");
    }

    public float getNonDatabaseFaults() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return ((Integer)this.get("nonDatabaseFaults")).floatValue() / 10.0f;
    }

    public float getNonDatabasePages() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return ((Integer)this.get("nonDatabasePages")).floatValue() / 10.0f;
    }

    public String getPagingOption() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return ((String)this.get("pagingOption")).trim();
    }

    public int getPoolIdentifier() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return this.getIdentifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdentifier() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        if (this.poolIdentifier_ == null) {
            SystemPool systemPool = this;
            synchronized (systemPool) {
                if (this.poolIdentifier_ == null) {
                    boolean oldVal = this.cacheChanges_;
                    this.cacheChanges_ = true;
                    this.poolIdentifier_ = (Integer)this.get("poolIdentifier");
                    this.cacheChanges_ = oldVal;
                }
            }
        }
        return this.poolIdentifier_ == null ? 0 : this.poolIdentifier_;
    }

    public String getPoolName() {
        return this.getName();
    }

    public String getName() {
        if (this.poolName_ != null) {
            return this.poolName_;
        }
        try {
            this.poolName_ = ((String)this.get("poolName")).trim();
            return this.poolName_;
        }
        catch (Exception e) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Unable to get pool name.", (Throwable)e);
            }
            return null;
        }
    }

    public int getPoolSize() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return this.getSize();
    }

    public int getSize() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (Integer)this.get("poolSize");
    }

    public long getSizeLong() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        if (this.system_.getVRM() >= 459264) {
            return (Long)this.get("poolSizeLong");
        }
        return ((Integer)this.get("poolSize")).longValue();
    }

    public int getReservedSize() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (Integer)this.get("reservedSize");
    }

    public String getSubsystemLibrary() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return ((String)this.get("subsystemLibraryName")).trim();
    }

    public String getSubsystemName() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return ((String)this.get("subsystemName")).trim();
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public float getWaitToIneligible() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return ((Integer)this.get("waitToIneligible")).floatValue() / 10.0f;
    }

    public boolean isCaching() {
        return this.cacheChanges_;
    }

    public boolean isShared() {
        return (this.indicatedSharedPool_ || SystemPool.isValidNameForSharedPool(this.poolName_)) && this.subsystemLibrary_ == null && this.subsystemName_ == null && this.poolSequenceNumber_ == 0;
    }

    public void loadInformation() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        this.refreshCache();
    }

    public synchronized void refreshCache() {
        this.poolRecord_ = null;
        if (this.changesTable_ != null) {
            this.changesTable_.clear();
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(listener);
        }
    }

    private ProgramParameter[] buildParameterList() {
        int numParms;
        AS400Bin4 bin4 = new AS400Bin4();
        if (this.indicatedSharedPool_ || this.poolIdentifier_ != null) {
            numParms = 7;
            if (this.systemStatusFormat_ == null || this.systemStatusFormat_.getClass() != SSTS0400Format.class) {
                this.systemStatusFormat_ = new SSTS0400Format(this.system_);
                this.poolFormat_ = new PoolInformationFormat0400(this.system_);
            }
        } else {
            numParms = 5;
            if (this.systemStatusFormat_ == null || this.systemStatusFormat_.getClass() != SSTS0300Format.class) {
                this.systemStatusFormat_ = new SSTS0300Format(this.system_);
                this.poolFormat_ = new PoolInformationFormat(this.system_);
            }
        }
        ProgramParameter[] parmList = new ProgramParameter[numParms];
        int receiverLength = this.systemStatusFormat_.getNewRecord().getRecordLength();
        parmList[0] = new ProgramParameter(receiverLength);
        parmList[1] = new ProgramParameter(bin4.toBytes(receiverLength));
        AS400Text text = new AS400Text(8, this.system_.getCcsid(), this.system_);
        parmList[2] = new ProgramParameter(text.toBytes(this.systemStatusFormat_.getName()));
        text = new AS400Text(10, this.system_.getCcsid(), this.system_);
        parmList[3] = new ProgramParameter(text.toBytes("*NO"));
        byte[] errorInfo = new byte[32];
        parmList[4] = new ProgramParameter(errorInfo, 0);
        if (numParms > 5) {
            String typeOfPool = this.indicatedSharedPool_ ? "*SHARED   " : "*SYSTEM   ";
            StringBuilder sharedPoolName = new StringBuilder(this.indicatedSharedPool_ ? this.poolName_ : "");
            if (sharedPoolName.length() < 10) {
                int numPadBytes = 10 - sharedPoolName.length();
                sharedPoolName.append(TEN_BLANKS.substring(10 - numPadBytes));
            }
            int systemPoolIdentifier = this.indicatedSharedPool_ ? 0 : this.poolIdentifier_;
            byte[] poolType = text.toBytes(typeOfPool);
            byte[] poolNam = text.toBytes(sharedPoolName.toString());
            byte[] poolId = BinaryConverter.intToByteArray(systemPoolIdentifier);
            byte[] poolSelectionInformation = new byte[24];
            System.arraycopy(poolType, 0, poolSelectionInformation, 0, 10);
            System.arraycopy(poolNam, 0, poolSelectionInformation, 10, 10);
            System.arraycopy(poolId, 0, poolSelectionInformation, 20, 4);
            parmList[5] = new ProgramParameter(poolSelectionInformation);
            if (Trace.isTraceOn()) {
                Trace.log(1, "QWCRSSTS parameter 6: poolType==|" + typeOfPool + "| , poolName==|" + sharedPoolName.toString() + "| , poolID==|" + systemPoolIdentifier + "|");
            }
            parmList[6] = new ProgramParameter(bin4.toBytes(24));
        }
        return parmList;
    }

    public static final boolean isValidNameForSharedPool(String name) {
        if (name == null) {
            return false;
        }
        return name.equals("*ALL") || name.equals("*MACHINE") || name.equals("*BASE") || name.equals("*INTERACT") || name.equals("*SPOOL") || name.startsWith("*SHRPOOL");
    }

    private void retrieveInformation() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        if (this.poolRecord_ != null) {
            return;
        }
        if (!this.connected_) {
            this.connect();
        }
        QSYSObjectPathName prgName = new QSYSObjectPathName("QSYS", "QWCRSSTS", "PGM");
        ProgramParameter[] parmList = this.buildParameterList();
        ProgramCall pgm = new ProgramCall(this.system_);
        try {
            pgm.setProgram(prgName.getPath(), parmList);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "Retrieving system pool information.");
        }
        if (!pgm.run()) {
            AS400Message[] msgList = pgm.getMessageList();
            if (Trace.isTraceOn()) {
                Trace.log(2, "Error retrieving system pool information:");
                for (int i = 0; i < msgList.length; ++i) {
                    Trace.log(2, msgList[i].toString());
                }
            }
            if (this.poolIdentifier_ == null && !SystemPool.isValidNameForSharedPool(this.poolName_)) {
                Trace.log(2, "Invalid name for shared pool: " + this.poolName_);
                throw new ObjectDoesNotExistException(this.poolName_, 2);
            }
            throw new AS400Exception(msgList);
        }
        byte[] retrievedData = parmList[0].getOutputData();
        Record rec = this.systemStatusFormat_.getNewRecord(retrievedData);
        if (this.resizeFormat(rec)) {
            this.retrieveInformation();
            return;
        }
        int offsetToInfo = (Integer)rec.getField("offsetToPoolInformation");
        int numPools = (Integer)rec.getField("numberOfPools");
        int entryLength = (Integer)rec.getField("lengthOfPoolInformationEntry");
        byte[] data = rec.getContents();
        if (Trace.isTraceOn()) {
            Trace.log(1, "Parsing out " + numPools + " system pools with " + entryLength + " bytes each starting at offset " + offsetToInfo + " for a maximum length of " + data.length + ".");
        }
        for (int i = 0; i < numPools; ++i) {
            int offset = offsetToInfo + i * entryLength;
            Record pool = this.poolFormat_.getNewRecord(data, offset);
            if (Trace.isTraceOn()) {
                Trace.log(1, "Parsed pool at offset " + offset + ": " + pool.toString());
            }
            String returnedName = ((String)pool.getField("poolName")).trim();
            Integer poolIdentifier = (Integer)pool.getField("poolIdentifier");
            if (this.poolIdentifier_ != null) {
                if (!this.poolIdentifier_.equals(poolIdentifier)) continue;
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Found matching system pool '" + this.poolName_ + "'");
                }
                this.poolRecord_ = pool;
                return;
            }
            if (this.indicatedSharedPool_) {
                if (!returnedName.equals(this.poolName_)) continue;
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Found matching system pool '" + this.poolName_ + "'");
                }
                this.poolRecord_ = pool;
                if (this.poolIdentifier_ == null) {
                    this.poolIdentifier_ = poolIdentifier;
                }
                return;
            }
            String subsysName = ((String)pool.getField("subsystemName")).trim();
            String subsysLib = ((String)pool.getField("subsystemLibraryName")).trim();
            if (!subsysName.equalsIgnoreCase(this.subsystemName_) || !subsysLib.equalsIgnoreCase(this.subsystemLibrary_) || !returnedName.equals(this.poolName_)) continue;
            this.poolRecord_ = pool;
            if (this.poolIdentifier_ == null) {
                this.poolIdentifier_ = poolIdentifier;
            }
            return;
        }
        Trace.log(2, "System pool '" + this.poolName_ + "' not found.");
        throw new ObjectDoesNotExistException(this.poolName_, 2);
    }

    private boolean resizeFormat(Record rec) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        int entryLength;
        int offset;
        int numPools;
        int available = (Integer)rec.getField("numberOfBytesAvailable");
        int returned = (Integer)rec.getField("numberOfBytesReturned");
        if (Trace.isTraceOn()) {
            Trace.log(1, "Size check of System Status format: " + available + ", " + returned);
            numPools = (Integer)rec.getField("numberOfPools");
            offset = (Integer)rec.getField("offsetToPoolInformation");
            entryLength = (Integer)rec.getField("lengthOfPoolInformationEntry");
            Trace.log(1, "  Old pool information: " + numPools + ", " + offset + ", " + entryLength + ", " + rec.getRecordLength());
        }
        if (available > returned) {
            numPools = (Integer)rec.getField("numberOfPools");
            offset = (Integer)rec.getField("offsetToPoolInformation");
            entryLength = (Integer)rec.getField("lengthOfPoolInformationEntry");
            int baseLength = this.systemStatusFormat_.getNewRecord().getRecordLength();
            int newLength = numPools * entryLength + (offset - baseLength);
            this.systemStatusFormat_.addFieldDescription(new HexFieldDescription(new AS400ByteArray(newLength), "poolInformation"));
            if (Trace.isTraceOn()) {
                Trace.log(1, "Resizing System Status format to hold more system pool information.");
                Trace.log(1, "  New pool information: " + baseLength + ", " + newLength + ", " + this.systemStatusFormat_.getNewRecord().getRecordLength());
            }
            return true;
        }
        return false;
    }

    private void set(String field, Object value) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        Object oldValue = null;
        if ((this.vetos_ != null || this.changes_ != null) && this.changesTable_ != null) {
            oldValue = this.changesTable_.get(field);
        }
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange(field, oldValue, value);
        }
        if (this.changesTable_ == null) {
            this.changesTable_ = new Hashtable(11);
        }
        this.changesTable_.put(field, value);
        if (this.changes_ != null) {
            this.changes_.firePropertyChange(field, oldValue, value);
        }
        if (!this.cacheChanges_) {
            this.commitCache();
        }
    }

    public synchronized void setCaching(boolean cache) {
        this.cacheChanges_ = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFaults(float minValue, float perValue, float maxValue) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        if (!this.indicatedSharedPool_) {
            SystemPool.throwUnsupported();
        }
        if (!this.cacheChanges_) {
            SystemPool systemPool = this;
            synchronized (systemPool) {
                this.cacheChanges_ = true;
                this.setMinimumFaults(minValue);
                this.setPerThreadFaults(perValue);
                this.setMaximumFaults(maxValue);
                this.commitCache();
                this.cacheChanges_ = false;
            }
        } else {
            this.setMinimumFaults(minValue);
            this.setPerThreadFaults(perValue);
            this.setMaximumFaults(maxValue);
        }
    }

    public void setMaximumFaults(float value) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        if (!this.indicatedSharedPool_) {
            SystemPool.throwUnsupported();
        }
        this.set("maximumFaults", Float.valueOf(value));
    }

    public void setMaximumPoolSize(float value) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        if (!this.indicatedSharedPool_) {
            SystemPool.throwUnsupported();
        }
        this.set("maximumPoolSize", Float.valueOf(value));
    }

    public void setMessageLogging(boolean log) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        this.set("messageLogging", log ? "Y" : "N");
    }

    public void setMinimumFaults(float value) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        if (!this.indicatedSharedPool_) {
            SystemPool.throwUnsupported();
        }
        this.set("minimumFaults", Float.valueOf(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinAndMaxPoolSize(float minValue, float maxValue) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        if (!this.indicatedSharedPool_) {
            SystemPool.throwUnsupported();
        }
        if (!this.cacheChanges_) {
            SystemPool systemPool = this;
            synchronized (systemPool) {
                this.cacheChanges_ = true;
                this.setMinimumPoolSize(minValue);
                this.setMaximumPoolSize(maxValue);
                this.commitCache();
                this.cacheChanges_ = false;
            }
        } else {
            this.setMinimumPoolSize(minValue);
            this.setMaximumPoolSize(maxValue);
        }
    }

    public void setMinimumPoolSize(float value) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        if (!this.indicatedSharedPool_) {
            SystemPool.throwUnsupported();
        }
        this.set("minimumPoolSize", Float.valueOf(value));
    }

    public void setPagingOption(String value) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        this.set("pagingOption", value);
    }

    public void setPerThreadFaults(float value) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        if (!this.indicatedSharedPool_) {
            SystemPool.throwUnsupported();
        }
        this.set("perThreadFaults", Float.valueOf(value));
    }

    public void setPoolActivityLevel(int value) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        this.setActivityLevel(value);
    }

    public void setActivityLevel(int value) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        this.set("activityLevel", value);
    }

    public void setPoolName(String poolName) throws PropertyVetoException {
        this.setName(poolName);
    }

    public void setName(String poolName) throws PropertyVetoException {
        if (poolName == null) {
            throw new NullPointerException("poolName");
        }
        if (this.connected_) {
            throw new ExtendedIllegalStateException("poolName", 5);
        }
        String oldValue = this.poolName_;
        String newValue = poolName.trim();
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("poolName", oldValue, newValue);
        }
        this.poolName_ = poolName;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("poolName", oldValue, newValue);
        }
    }

    public void setPoolSize(int value) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        this.setSize(value);
    }

    public void setSize(int value) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        this.set("poolSize", value);
    }

    public void setSizeLong(long value) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        this.set("poolSizeLong", value);
    }

    public void setPriority(int value) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        if (!this.indicatedSharedPool_) {
            SystemPool.throwUnsupported();
        }
        this.set("priority", value);
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (this.connected_) {
            throw new ExtendedIllegalStateException("system", 5);
        }
        AS400 oldValue = this.system_;
        AS400 newValue = system;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("system", oldValue, newValue);
        }
        this.system_ = system;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("system", oldValue, newValue);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        if (this.poolName_ != null || this.subsystemName_ != null || this.poolIdentifier_ != null) {
            if (this.subsystemName_ != null) {
                buf.append("[").append(this.subsystemLibrary_).append("/").append(this.subsystemName_).append("/").append(this.poolSequenceNumber_).append("]");
            } else if (this.poolName_ != null) {
                buf.append("[").append(this.poolName_).append("]");
            } else if (this.poolIdentifier_ != null) {
                buf.append("[poolID=").append(this.poolIdentifier_.toString()).append("]");
            }
        }
        return buf.toString();
    }

    private static final void throwUnsupported() {
        Trace.log(2, "Method not supported for subsystem (non-shared) pools.");
        throw new UnsupportedOperationException();
    }
}

