/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.IllegalPathNameException;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import java.util.EventListener;

public class QSYSObjectPathName
implements Serializable {
    static final long serialVersionUID = 4L;
    private String path_ = "";
    private String libraryName_ = "";
    private String objectName_ = "";
    private String memberName_ = "";
    private String objectType_ = "";
    private String aspName_ = "";
    private static QSYSObjectPathName verified_ = null;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;

    public QSYSObjectPathName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing QSYSObjectPathName object.");
        }
    }

    public QSYSObjectPathName(String path) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing QSYSObjectPathName object, path: " + path);
        }
        if (path == null) {
            Trace.log(2, "Parameter 'path' is null.");
            throw new NullPointerException("path");
        }
        this.parse(path);
    }

    QSYSObjectPathName(String path, String objectType) {
        this(path);
        if (!this.objectType_.equals(objectType.toUpperCase())) {
            Trace.log(2, "Object type is not valid, path: '" + path + "'");
            throw new IllegalPathNameException(path, 1);
        }
    }

    public QSYSObjectPathName(String libraryName, String objectName, String objectType) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing QSYSObjectPathName object, libraryName: " + libraryName + " objectName: " + objectName + " objectType: " + objectType);
        }
        QSYSObjectPathName.checkLibraryName(libraryName);
        QSYSObjectPathName.checkObjectName(objectName);
        QSYSObjectPathName.checkObjectType(objectType);
        this.libraryName_ = QSYSObjectPathName.toQSYSName(libraryName);
        this.objectName_ = QSYSObjectPathName.toQSYSName(objectName);
        this.objectType_ = objectType.toUpperCase();
        this.path_ = QSYSObjectPathName.buildPathName(this.libraryName_, this.objectName_, "", this.objectType_);
    }

    public QSYSObjectPathName(String libraryName, String objectName, String memberName, String objectType) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing QSYSObjectPathName object, libraryName: " + libraryName + " objectName: " + objectName + " memberName: " + memberName + " objectType: " + objectType);
        }
        QSYSObjectPathName.checkLibraryName(libraryName);
        QSYSObjectPathName.checkObjectName(objectName);
        QSYSObjectPathName.checkMemberName(memberName);
        QSYSObjectPathName.checkObjectTypeIsMember(objectType);
        this.libraryName_ = QSYSObjectPathName.toQSYSName(libraryName);
        this.objectName_ = QSYSObjectPathName.toQSYSName(objectName);
        this.memberName_ = QSYSObjectPathName.toQSYSName(memberName);
        this.objectType_ = "MBR";
        this.path_ = QSYSObjectPathName.buildPathName(this.libraryName_, this.objectName_, this.memberName_, this.objectType_);
    }

    public QSYSObjectPathName(String aspName, String libraryName, String objectName, String memberName, String objectType) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing QSYSObjectPathName object, libraryName: " + libraryName + " objectName: " + objectName + " memberName: " + memberName + " objectType: " + objectType);
        }
        QSYSObjectPathName.checkAspName(aspName);
        QSYSObjectPathName.checkLibraryName(libraryName);
        QSYSObjectPathName.checkObjectName(objectName);
        QSYSObjectPathName.checkMemberName(memberName);
        QSYSObjectPathName.checkObjectTypeIsMember(objectType);
        this.libraryName_ = QSYSObjectPathName.toQSYSName(libraryName);
        this.objectName_ = QSYSObjectPathName.toQSYSName(objectName);
        this.memberName_ = QSYSObjectPathName.toQSYSName(memberName);
        this.objectType_ = "MBR";
        this.aspName_ = aspName;
        this.path_ = QSYSObjectPathName.buildPathName(this.aspName_, this.libraryName_, this.objectName_, this.memberName_, this.objectType_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        QSYSObjectPathName.checkListener(listener);
        QSYSObjectPathName qSYSObjectPathName = this;
        synchronized (qSYSObjectPathName) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        QSYSObjectPathName.checkListener(listener);
        QSYSObjectPathName qSYSObjectPathName = this;
        synchronized (qSYSObjectPathName) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(listener);
        }
    }

    private static String buildPathName(String aspName, String libraryName, String objectName, String memberName, String objectType) {
        if (Trace.traceOn_) {
            Trace.log(1, "QSYSObjectPathName buildPathName(asp): aspName: " + aspName + " libraryName: " + libraryName + " objectName: " + objectName + " memberName: " + memberName + " objectType: " + objectType);
        }
        String result1 = QSYSObjectPathName.buildPathName(libraryName, objectName, memberName, objectType);
        StringBuilder result2 = new StringBuilder(75);
        if (!result1.equals("")) {
            if (!aspName.equals("")) {
                result2.append("/");
                result2.append(aspName);
            }
            result2.append(result1);
            if (Trace.traceOn_) {
                Trace.log(1, "QSYSObjectPathName buildPathName(asp): result: " + result2.toString());
            }
            return result2.toString();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "QSYSObjectPathName buildPathName(asp): result: EMPTY STRING");
        }
        return "";
    }

    private static String buildPathName(String libraryName, String objectName, String memberName, String objectType) {
        if (Trace.traceOn_) {
            Trace.log(1, "QSYSObjectPathName buildPathName(): libraryName: " + libraryName + " objectName: " + objectName + " memberName: " + memberName + " objectType: " + objectType);
        }
        if (!(libraryName.equals("") || objectType.equals("") || memberName.equals("") && objectType.equals("MBR"))) {
            StringBuilder result = new StringBuilder(64);
            result.append("/QSYS.LIB");
            if (!libraryName.equals("QSYS")) {
                result.append("/");
                result.append(QSYSObjectPathName.convertLibraryName(libraryName));
                result.append(".LIB");
            }
            if (!objectName.equals("")) {
                result.append("/");
                result.append(QSYSObjectPathName.convertObjectName(objectName));
                if (!memberName.equals("")) {
                    result.append(".FILE/");
                    result.append(QSYSObjectPathName.convertMemberName(memberName));
                    result.append(".MBR");
                } else {
                    result.append(".");
                    result.append(objectType);
                }
            }
            if (Trace.traceOn_) {
                Trace.log(1, "QSYSObjectPathName buildPathName(): result: " + result.toString());
            }
            return result.toString();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "QSYSObjectPathName buildPathName(): result: EMPTY STRING");
        }
        return "";
    }

    static void checkObjectTypeIsMember(String objectType) {
        if (objectType == null) {
            Trace.log(2, "Parameter 'objectType' is null.");
            throw new NullPointerException("objectType");
        }
        if (!objectType.toUpperCase().equals("MBR")) {
            Trace.log(2, "Value of parameter 'objectType' is not valid: " + objectType);
            throw new ExtendedIllegalArgumentException("objectType (" + objectType + ")", 2);
        }
    }

    static void checkMemberName(String memberName) {
        if (memberName == null) {
            Trace.log(2, "Parameter 'memberName' is null.");
            throw new NullPointerException("memberName");
        }
        if (memberName.length() < 1 || memberName.length() > 10) {
            Trace.log(2, "Length of parameter 'memberName' is not valid: '" + memberName + "'");
            throw new ExtendedIllegalArgumentException("memberName (" + memberName + ")", 1);
        }
    }

    static void checkListener(EventListener listener) {
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
    }

    static void checkAspName(String aspName) {
        if (aspName == null) {
            Trace.log(2, "Parameter 'aspName' is null.");
            throw new NullPointerException("aspName");
        }
        if (aspName.length() < 1 || aspName.length() > 10) {
            Trace.log(2, "Length of parameter 'aspName' is not valid: '" + aspName + "'");
            throw new ExtendedIllegalArgumentException("aspName (" + aspName + ")", 1);
        }
    }

    static void checkLibraryName(String libraryName) {
        if (libraryName == null) {
            Trace.log(2, "Parameter 'libraryName' is null.");
            throw new NullPointerException("libraryName");
        }
        if (libraryName.length() < 1 || libraryName.length() > 10) {
            Trace.log(2, "Length of parameter 'libraryName' is not valid: '" + libraryName + "'");
            throw new ExtendedIllegalArgumentException("libraryName (" + libraryName + ")", 1);
        }
    }

    static void checkObjectName(String objectName) {
        if (objectName == null) {
            Trace.log(2, "Parameter 'objectName' is null.");
            throw new NullPointerException("objectName");
        }
        if (objectName.length() < 1 || objectName.length() > 10) {
            Trace.log(2, "Length of parameter 'objectName' is not valid: '" + objectName + "'");
            throw new ExtendedIllegalArgumentException("objectName (" + objectName + ")", 1);
        }
    }

    static void checkObjectType(String objectType) {
        if (objectType == null) {
            Trace.log(2, "Parameter 'objectType' is null.");
            throw new NullPointerException("objectType");
        }
        if (objectType.length() < 1 || objectType.length() > 6) {
            Trace.log(2, "Length of parameter 'objectType' is not valid: '" + objectType + "'");
            throw new ExtendedIllegalArgumentException("objectType (" + objectType + ")", 1);
        }
    }

    private static String convertLibraryName(String libraryName) {
        if (libraryName.equals("*LIBL")) {
            return "%LIBL%";
        }
        if (libraryName.equals("*CURLIB")) {
            return "%CURLIB%";
        }
        if (libraryName.equals("*USRLIBL")) {
            return "%USRLIBL%";
        }
        if (libraryName.equals("*ALL")) {
            return "%ALL%";
        }
        if (libraryName.equals("*ALLUSR")) {
            return "%ALLUSR%";
        }
        return libraryName;
    }

    private static String convertMemberName(String memberName) {
        if (memberName.equals("*FIRST")) {
            return "%FIRST%";
        }
        if (memberName.equals("*LAST")) {
            return "%LAST%";
        }
        if (memberName.equals("*FILE")) {
            return "%FILE%";
        }
        if (memberName.equals("*ALL")) {
            return "%ALL%";
        }
        if (memberName.equals("*NONE")) {
            return "%NONE%";
        }
        return memberName;
    }

    private static String convertObjectName(String objectName) {
        if (objectName.equals("*ALL")) {
            return "%ALL%";
        }
        return objectName;
    }

    public String getAspName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting ASP name: " + this.aspName_);
        }
        return this.aspName_;
    }

    public String getLibraryName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting library name: " + this.libraryName_);
        }
        return this.libraryName_;
    }

    public String getMemberName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting member name: " + this.memberName_);
        }
        return this.memberName_;
    }

    public String getObjectName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting object name: " + this.objectName_);
        }
        return this.objectName_;
    }

    public String getObjectType() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting object type: " + this.objectType_);
        }
        return this.objectType_;
    }

    public String getPath() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting path: " + this.path_);
        }
        return this.path_;
    }

    private void parse(String path) {
        int nextOffset;
        String upperCasePath = QSYSObjectPathName.toQSYSName(path);
        int indexOfQsysLib = upperCasePath.indexOf("/QSYS.LIB");
        if (indexOfQsysLib == -1) {
            Trace.log(2, "Specified path does not include '/QSYS.LIB':", path);
            throw new IllegalPathNameException(path, 6);
        }
        if (indexOfQsysLib > 0) {
            this.aspName_ = upperCasePath.substring(1, indexOfQsysLib);
        }
        if (upperCasePath.substring(indexOfQsysLib).equals("/QSYS.LIB") || upperCasePath.substring(indexOfQsysLib).equals("/QSYS.LIB/")) {
            this.libraryName_ = "QSYS";
            this.objectType_ = "LIB";
            this.path_ = QSYSObjectPathName.buildPathName(this.aspName_, this.libraryName_, this.objectName_, this.memberName_, this.objectType_);
            return;
        }
        int currentOffset = 10;
        if (!this.aspName_.equals("")) {
            currentOffset = currentOffset + 1 + this.aspName_.length();
        }
        if ((nextOffset = upperCasePath.indexOf(".LIB/", currentOffset)) > currentOffset) {
            this.libraryName_ = QSYSObjectPathName.toQSYSName(path.substring(currentOffset, nextOffset));
            if (this.libraryName_.equals("QSYS")) {
                Trace.log(2, "Object in library QSYS specified incorrectly, path: '" + path + "'");
                throw new IllegalPathNameException(path, 7);
            }
            if (this.libraryName_.charAt(0) == '%') {
                if (this.libraryName_.equals("%LIBL%")) {
                    this.libraryName_ = "*LIBL";
                } else if (this.libraryName_.equals("%CURLIB%")) {
                    this.libraryName_ = "*CURLIB";
                } else if (this.libraryName_.equals("%USRLIBL%")) {
                    this.libraryName_ = "*USRLIBL";
                } else if (this.libraryName_.equals("%ALL%")) {
                    this.libraryName_ = "*ALL";
                } else if (this.libraryName_.equals("%ALLUSR%")) {
                    this.libraryName_ = "*ALLUSR";
                }
            }
            currentOffset = nextOffset + 5;
        } else if (nextOffset == -1) {
            this.libraryName_ = "QSYS";
        } else {
            Trace.log(2, "Length of the library name is not valid, path: '" + path + "'");
            throw new IllegalPathNameException(path, 2);
        }
        if (this.libraryName_.length() > 10) {
            Trace.log(2, "Length of the library name is not valid, path: '" + path + "'");
            throw new IllegalPathNameException(path, 2);
        }
        nextOffset = upperCasePath.lastIndexOf(46);
        if (nextOffset < currentOffset || upperCasePath.length() - nextOffset - 1 > 6) {
            Trace.log(2, "Length of the object type is not valid, path: '" + path + "'");
            throw new IllegalPathNameException(path, 5);
        }
        this.objectType_ = upperCasePath.substring(nextOffset + 1);
        if (this.objectType_.equals("MBR")) {
            int memberOffset = upperCasePath.lastIndexOf(".FILE/", nextOffset);
            if (memberOffset == -1 || memberOffset < currentOffset) {
                Trace.log(2, "Member is not contained in a file, path: '" + path + "'");
                throw new IllegalPathNameException(path, 8);
            }
            if (nextOffset < (memberOffset += 6) || nextOffset - memberOffset > 10) {
                Trace.log(2, "Length of the member name is not valid, path: '" + path + "'");
                throw new IllegalPathNameException(path, 4);
            }
            this.memberName_ = QSYSObjectPathName.toQSYSName(path.substring(memberOffset, nextOffset));
            if (this.memberName_.charAt(0) == '%') {
                if (this.memberName_.equals("%FIRST%")) {
                    this.memberName_ = "*FIRST";
                } else if (this.memberName_.equals("%LAST%")) {
                    this.memberName_ = "*LAST";
                } else if (this.memberName_.equals("%FILE%")) {
                    this.memberName_ = "*FILE";
                } else if (this.memberName_.equals("%ALL%")) {
                    this.memberName_ = "*ALL";
                } else if (this.memberName_.equals("%NONE%")) {
                    this.memberName_ = "*NONE";
                }
            }
            nextOffset = memberOffset - 6;
        }
        if (this.libraryName_.equals("QSYS") && upperCasePath.substring(currentOffset, nextOffset).indexOf(47) != -1 && upperCasePath.charAt(currentOffset) != '\"') {
            Trace.log(2, "Library not specified correctly, path: '" + path + "'");
            throw new IllegalPathNameException(path, 9);
        }
        if (nextOffset < currentOffset || nextOffset - currentOffset > 10) {
            Trace.log(2, "Length of the object name is not valid, path: '" + path + "'");
            throw new IllegalPathNameException(path, 3);
        }
        this.objectName_ = QSYSObjectPathName.toQSYSName(path.substring(currentOffset, nextOffset));
        if (this.objectName_.equals("%ALL%")) {
            this.objectName_ = "*ALL";
        }
        this.path_ = QSYSObjectPathName.buildPathName(this.aspName_, this.libraryName_, this.objectName_, this.memberName_, this.objectType_);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        QSYSObjectPathName.checkListener(listener);
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        QSYSObjectPathName.checkListener(listener);
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(listener);
        }
    }

    public void setAspName(String aspName) throws PropertyVetoException {
        QSYSObjectPathName.checkAspName(aspName);
        String newAspName = QSYSObjectPathName.toQSYSName(aspName);
        String newPath = QSYSObjectPathName.buildPathName(newAspName, this.libraryName_, this.objectName_, this.memberName_, this.objectType_);
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.aspName_ = newAspName;
            this.path_ = newPath;
        } else {
            String oldAspName = this.aspName_;
            String oldPath = this.path_;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("aspName", oldAspName, newAspName);
                this.vetoableChangeListeners_.fireVetoableChange("path", oldPath, newPath);
            }
            this.aspName_ = newAspName;
            this.path_ = newPath;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("aspName", oldAspName, newAspName);
                this.propertyChangeListeners_.firePropertyChange("path", oldPath, newPath);
            }
        }
    }

    public void setLibraryName(String libraryName) throws PropertyVetoException {
        QSYSObjectPathName.checkLibraryName(libraryName);
        String newLibraryName = QSYSObjectPathName.toQSYSName(libraryName);
        String newPath = QSYSObjectPathName.buildPathName(this.aspName_, newLibraryName, this.objectName_, this.memberName_, this.objectType_);
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.libraryName_ = newLibraryName;
            this.path_ = newPath;
        } else {
            String oldLibraryName = this.libraryName_;
            String oldPath = this.path_;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("libraryName", oldLibraryName, newLibraryName);
                this.vetoableChangeListeners_.fireVetoableChange("path", oldPath, newPath);
            }
            this.libraryName_ = newLibraryName;
            this.path_ = newPath;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("libraryName", oldLibraryName, newLibraryName);
                this.propertyChangeListeners_.firePropertyChange("path", oldPath, newPath);
            }
        }
    }

    public void setMemberName(String memberName) throws PropertyVetoException {
        if (memberName == null) {
            Trace.log(2, "Parameter 'memberName' is null.");
            throw new NullPointerException("memberName");
        }
        if (memberName.length() > 10) {
            Trace.log(2, "Length of parameter 'memberName' is not valid: '" + memberName + "'");
            throw new ExtendedIllegalArgumentException("memberName (" + memberName + ")", 1);
        }
        String newMemberName = QSYSObjectPathName.toQSYSName(memberName);
        String newObjectType = memberName.length() != 0 ? "MBR" : this.objectType_;
        String newPath = QSYSObjectPathName.buildPathName(this.aspName_, this.libraryName_, this.objectName_, newMemberName, newObjectType);
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.memberName_ = newMemberName;
            this.objectType_ = newObjectType;
            this.path_ = newPath;
        } else {
            String oldMemberName = this.memberName_;
            String oldObjectType = this.objectType_;
            String oldPath = this.path_;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("memberName", oldMemberName, newMemberName);
                this.vetoableChangeListeners_.fireVetoableChange("objectType", oldObjectType, newObjectType);
                this.vetoableChangeListeners_.fireVetoableChange("path", oldPath, newPath);
            }
            this.memberName_ = newMemberName;
            this.objectType_ = newObjectType;
            this.path_ = newPath;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("memberName", oldMemberName, newMemberName);
                this.propertyChangeListeners_.firePropertyChange("objectType", oldObjectType, newObjectType);
                this.propertyChangeListeners_.firePropertyChange("path", oldPath, newPath);
            }
        }
    }

    public void setObjectName(String objectName) throws PropertyVetoException {
        QSYSObjectPathName.checkObjectName(objectName);
        String newObjectName = QSYSObjectPathName.toQSYSName(objectName);
        String newPath = QSYSObjectPathName.buildPathName(this.aspName_, this.libraryName_, newObjectName, this.memberName_, this.objectType_);
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.objectName_ = newObjectName;
            this.path_ = newPath;
        } else {
            String oldObjectName = this.objectName_;
            String oldPath = this.path_;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("objectName", oldObjectName, newObjectName);
                this.vetoableChangeListeners_.fireVetoableChange("path", oldPath, newPath);
            }
            this.objectName_ = newObjectName;
            this.path_ = newPath;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("objectName", oldObjectName, newObjectName);
                this.propertyChangeListeners_.firePropertyChange("path", oldPath, newPath);
            }
        }
    }

    public void setObjectType(String objectType) throws PropertyVetoException {
        QSYSObjectPathName.checkObjectType(objectType);
        String newObjectType = objectType.toUpperCase();
        String newMemberName = newObjectType.equals("MBR") ? this.memberName_ : "";
        String newPath = QSYSObjectPathName.buildPathName(this.aspName_, this.libraryName_, this.objectName_, newMemberName, newObjectType);
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.memberName_ = newMemberName;
            this.objectType_ = newObjectType;
            this.path_ = newPath;
        } else {
            String oldMemberName = this.memberName_;
            String oldObjectType = this.objectType_;
            String oldPath = this.path_;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("memberName", oldMemberName, newMemberName);
                this.vetoableChangeListeners_.fireVetoableChange("objectType", oldObjectType, newObjectType);
                this.vetoableChangeListeners_.fireVetoableChange("path", oldPath, newPath);
            }
            this.objectType_ = newObjectType;
            this.memberName_ = newMemberName;
            this.path_ = newPath;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("memberName", oldMemberName, newMemberName);
                this.propertyChangeListeners_.firePropertyChange("objectType", oldObjectType, newObjectType);
                this.propertyChangeListeners_.firePropertyChange("path", oldPath, newPath);
            }
        }
    }

    public void setPath(String path) throws PropertyVetoException {
        QSYSObjectPathName ifs = new QSYSObjectPathName(path);
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.path_ = ifs.path_;
            this.libraryName_ = ifs.libraryName_;
            this.objectName_ = ifs.objectName_;
            this.memberName_ = ifs.memberName_;
            this.objectType_ = ifs.objectType_;
        } else {
            String newPath = ifs.path_;
            String newLibraryName = ifs.libraryName_;
            String newObjectName = ifs.objectName_;
            String newMemberName = ifs.memberName_;
            String newObjectType = ifs.objectType_;
            String oldPath = this.path_;
            String oldLibraryName = this.libraryName_;
            String oldObjectName = this.objectName_;
            String oldMemberName = this.memberName_;
            String oldObjectType = this.objectType_;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("path", oldPath, newPath);
                this.vetoableChangeListeners_.fireVetoableChange("libraryName", oldLibraryName, newLibraryName);
                this.vetoableChangeListeners_.fireVetoableChange("objectName", oldObjectName, newObjectName);
                this.vetoableChangeListeners_.fireVetoableChange("memberName", oldMemberName, newMemberName);
                this.vetoableChangeListeners_.fireVetoableChange("objectType", oldObjectType, newObjectType);
            }
            this.path_ = newPath;
            this.libraryName_ = newLibraryName;
            this.objectName_ = newObjectName;
            this.memberName_ = newMemberName;
            this.objectType_ = newObjectType;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("path", oldPath, newPath);
                this.propertyChangeListeners_.firePropertyChange("libraryName", oldLibraryName, newLibraryName);
                this.propertyChangeListeners_.firePropertyChange("objectName", oldObjectName, newObjectName);
                this.propertyChangeListeners_.firePropertyChange("memberName", oldMemberName, newMemberName);
                this.propertyChangeListeners_.firePropertyChange("objectType", oldObjectType, newObjectType);
            }
        }
    }

    public static String toPath(String libraryName, String objectName, String objectType) {
        QSYSObjectPathName.checkLibraryName(libraryName);
        QSYSObjectPathName.checkObjectName(objectName);
        QSYSObjectPathName.checkObjectType(objectType);
        libraryName = QSYSObjectPathName.toQSYSName(libraryName);
        objectName = QSYSObjectPathName.toQSYSName(objectName);
        objectType = objectType.toUpperCase();
        return QSYSObjectPathName.buildPathName(libraryName, objectName, "", objectType);
    }

    public static String toPath(String libraryName, String objectName, String memberName, String objectType) {
        QSYSObjectPathName.checkLibraryName(libraryName);
        QSYSObjectPathName.checkObjectName(objectName);
        QSYSObjectPathName.checkMemberName(memberName);
        QSYSObjectPathName.checkObjectTypeIsMember(objectType);
        libraryName = QSYSObjectPathName.toQSYSName(libraryName);
        objectName = QSYSObjectPathName.toQSYSName(objectName);
        memberName = QSYSObjectPathName.toQSYSName(memberName);
        objectType = objectType.toUpperCase();
        return QSYSObjectPathName.buildPathName(libraryName, objectName, memberName, objectType);
    }

    public static String toPath(String aspName, String libraryName, String objectName, String memberName, String objectType) {
        QSYSObjectPathName.checkAspName(aspName);
        QSYSObjectPathName.checkLibraryName(libraryName);
        QSYSObjectPathName.checkObjectName(objectName);
        QSYSObjectPathName.checkMemberName(memberName);
        QSYSObjectPathName.checkObjectTypeIsMember(objectType);
        libraryName = QSYSObjectPathName.toQSYSName(libraryName);
        objectName = QSYSObjectPathName.toQSYSName(objectName);
        memberName = QSYSObjectPathName.toQSYSName(memberName);
        objectType = objectType.toUpperCase();
        aspName = aspName.toUpperCase();
        return QSYSObjectPathName.buildPathName(aspName, libraryName, objectName, memberName, objectType);
    }

    public static final String toQSYSName(String name) {
        if (name.indexOf(224) == -1 && name.indexOf(34) == -1) {
            return name.toUpperCase();
        }
        StringBuilder result = new StringBuilder();
        int length = name.length();
        boolean inQuotes = false;
        for (int i = 0; i < length; ++i) {
            char character = name.charAt(i);
            if (character == '\"') {
                boolean bl = inQuotes = !inQuotes;
            }
            if (!inQuotes && character != '\u00e0') {
                result.append(Character.toUpperCase(character));
                continue;
            }
            result.append(name.charAt(i));
        }
        return result.toString();
    }

    public String toQualifiedObjectName() {
        StringBuilder buffer = new StringBuilder("                    ");
        if (this.objectName_.length() > 10) {
            if (Trace.traceOn_) {
                Trace.log(4, "Truncating object name to 10 characters:", this.objectName_);
            }
            buffer.replace(0, 10, this.objectName_.substring(0, 10));
        } else {
            buffer.replace(0, this.objectName_.length(), this.objectName_);
        }
        if (this.libraryName_.length() > 10) {
            if (Trace.traceOn_) {
                Trace.log(4, "Truncating library name to 10 characters:", this.libraryName_);
            }
            buffer.replace(10, 20, this.libraryName_.substring(0, 10));
        } else {
            buffer.replace(10, this.libraryName_.length() + 10, this.libraryName_);
        }
        return buffer.toString();
    }

    static final void validatePath(String path, String objectType) {
        verified_ = new QSYSObjectPathName(path, objectType);
    }
}

