/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.NetServer;
import com.ibm.as400.access.NetServerFileShare;
import com.ibm.as400.access.NetServerSession;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.ArrayResourceList;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.ProgramAttributeGetter;
import com.ibm.as400.resource.ProgramMap;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.resource.ResourceMetaDataTable;
import java.beans.PropertyVetoException;
import java.util.Vector;

public class NetServerConnection
extends Resource {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static PresentationLoader presentationLoader_ = new PresentationLoader("com.ibm.as400.access.MRI2");
    private static final String ICON_BASE_NAME_ = "NetServerConnection";
    private static final String PRESENTATION_KEY_ = "NETSERVER";
    private static ResourceMetaDataTable attributes_ = new ResourceMetaDataTable(presentationLoader_, "NETSERVER");
    private static ProgramMap getterMap_ = new ProgramMap();
    private static ProgramMap openListAttributeMap_ = new ProgramMap();
    static final int SHARE = 0;
    static final int SESSION = 1;
    private static final String OLST0600_ = "qzlsolst_zlsl0600";
    private static final String OLST0700_ = "qzlsolst_zlsl0700";
    private static final int[] INDICES_ = new int[]{0};
    public static final String CONNECT_TIME = "CONNECT_TIME";
    public static final String FILES_OPEN_COUNT = "FILES_OPEN_COUNT";
    public static final String NAME = "NAME";
    public static final String TYPE = "TYPE";
    public static final Integer TYPE_DISK_DRIVE;
    public static final Integer TYPE_SPOOLED_OUTPUT_QUEUE;
    public static final String USER = "USER";
    static final String USER_COUNT = "USER_COUNT";
    private static final String DOCUMENT_NAME_ = "com.ibm.as400.access.NetServer";
    private static ProgramCallDocument staticDocument_;
    private ProgramCallDocument document_;
    private int id_;
    private boolean idWasSet_ = false;
    private ProgramAttributeGetter attributeGetter_;

    NetServerConnection() {
        super(presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_), null, attributes_);
    }

    NetServerConnection(AS400 system, int id) {
        this();
        try {
            this.setSystem(system);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.setID(id);
    }

    static Object computeResourceKey(AS400 system, int id) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(NetServerConnection.class);
        buffer.append(':');
        buffer.append(system.getSystemName());
        buffer.append(':');
        buffer.append(id);
        return buffer.toString();
    }

    @Override
    protected void establishConnection() throws ResourceException {
        if (!this.idWasSet_) {
            throw new ExtendedIllegalStateException("id", 4);
        }
        super.establishConnection();
        AS400 system = this.getSystem();
        this.document_ = (ProgramCallDocument)staticDocument_.clone();
        try {
            this.document_.setSystem(system);
            String connectionName = (String)this.getAttributeValue(NAME);
            this.document_.setValue("qzlsolst_zlsl0600.informationQualifier", connectionName);
            this.document_.setValue("qzlsolst_zlsl0700.informationQualifier", connectionName);
            this.attributeGetter_ = new ProgramAttributeGetter(system, this.document_, getterMap_);
        }
        catch (PcmlException e) {
            Trace.log(2, "PcmlException when establishing connection.", (Throwable)e);
            throw new ResourceException(e);
        }
    }

    @Override
    protected void freezeProperties() throws ResourceException {
        if (!this.idWasSet_) {
            throw new ExtendedIllegalStateException("id", 4);
        }
        Presentation presentation = this.getPresentation();
        presentation.setName(Integer.toString(this.id_));
        presentation.setFullName(Integer.toString(this.id_));
        if (this.getResourceKey() == null) {
            this.setResourceKey(NetServerConnection.computeResourceKey(this.getSystem(), this.id_));
        }
        super.freezeProperties();
    }

    static ResourceMetaData[] getAttributeMetaDataStatic() {
        return attributes_.getMetaData();
    }

    @Override
    public Object getAttributeValue(Object attributeID) throws ResourceException {
        Object value;
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        if ((value = super.getAttributeValue(attributeID)) == null) {
            value = this.attributeGetter_.getValue(attributeID);
        }
        return value;
    }

    public int getID() {
        return this.id_;
    }

    static ResourceList list(AS400 sys, int type) throws ResourceException {
        if (type != 0 && type != 1) {
            Trace.log(2, "Invalid type of connection: " + type);
            throw new InternalErrorException(10);
        }
        ResourceList resources = type == 0 ? NetServerFileShare.list(sys) : NetServerSession.list(sys);
        resources.waitForComplete();
        Vector<Resource> connList = new Vector<Resource>();
        int i = 0;
        while ((long)i < resources.getListLength()) {
            ResourceList conns = type == 0 ? ((NetServerFileShare)resources.resourceAt(i)).listConnections() : ((NetServerSession)resources.resourceAt(i)).listConnections();
            conns.waitForComplete();
            int ii = 0;
            while ((long)ii < conns.getListLength()) {
                connList.addElement(conns.resourceAt(ii));
                ++ii;
            }
            ++i;
        }
        Object[] array = new NetServerConnection[connList.size()];
        connList.copyInto(array);
        Presentation presentation = presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_);
        return new ArrayResourceList((Resource[])array, presentation, NetServerConnection.getAttributeMetaDataStatic());
    }

    private static ResourceList list(AS400 system, int connectionType, String qualifier) throws ResourceException {
        try {
            ProgramCallDocument document = (ProgramCallDocument)staticDocument_.clone();
            document.setSystem(system);
            String programName = connectionType == 1 ? OLST0600_ : OLST0700_;
            document.setValue(programName + ".informationQualifier", qualifier);
            int expectedInfoLength = 640;
            document.setIntValue(programName + ".lengthOfReceiverVariable", expectedInfoLength);
            NetServer.callListProgram(document, programName, true);
            int recCount = document.getIntValue(programName + ".listInformation.recordsReturned");
            int recSize = document.getIntValue(programName + ".listInformation.recordLength");
            Vector<NetServerConnection> connections = new Vector<NetServerConnection>();
            String prefix = programName + ".receiverVariable.";
            int[] indices = new int[1];
            Object[] attributeIDs = openListAttributeMap_.getIDs();
            for (int i = 0; i < recCount; ++i) {
                indices[0] = i;
                int id = document.getIntValue(prefix + "connectionId", indices);
                NetServerConnection connection = new NetServerConnection(system, id);
                Object[] values = openListAttributeMap_.getValues(attributeIDs, system, document, programName, indices);
                for (int ii = 0; ii < values.length; ++ii) {
                    connection.initializeAttributeValue(attributeIDs[ii], values[ii]);
                }
                connection.freezeProperties();
                connections.addElement(connection);
            }
            Object[] array = new NetServerConnection[connections.size()];
            connections.copyInto(array);
            Presentation presentation = presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_);
            return new ArrayResourceList((Resource[])array, presentation, NetServerConnection.getAttributeMetaDataStatic());
        }
        catch (PcmlException e) {
            Trace.log(2, "PcmlException when listing connections.", (Throwable)e);
            throw new ResourceException(e);
        }
    }

    static ResourceList listConnectionsForSession(AS400 sys, String sessionName) throws ResourceException {
        return NetServerConnection.list(sys, 1, sessionName);
    }

    static ResourceList listConnectionsForShare(AS400 sys, String shareName) throws ResourceException {
        return NetServerConnection.list(sys, 0, shareName);
    }

    @Override
    public void refreshAttributeValues() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        this.attributeGetter_.clearBuffer();
        super.refreshAttributeValues();
    }

    void setID(int id) {
        this.id_ = id;
        this.idWasSet_ = true;
    }

    static {
        attributes_.add((Object)CONNECT_TIME, Integer.class, true);
        getterMap_.add((Object)CONNECT_TIME, OLST0600_, "receiverVariable.connectionTime", INDICES_);
        getterMap_.add((Object)CONNECT_TIME, OLST0700_, "receiverVariable.connectionTime", INDICES_);
        openListAttributeMap_.add(CONNECT_TIME, null, "receiverVariable.connectionTime");
        attributes_.add((Object)FILES_OPEN_COUNT, Integer.class, true);
        getterMap_.add((Object)FILES_OPEN_COUNT, OLST0600_, "receiverVariable.numberOfFilesOpen", INDICES_);
        getterMap_.add((Object)FILES_OPEN_COUNT, OLST0700_, "receiverVariable.numberOfFilesOpen", INDICES_);
        openListAttributeMap_.add(FILES_OPEN_COUNT, null, "receiverVariable.numberOfFilesOpen");
        attributes_.add((Object)NAME, String.class, true);
        getterMap_.add((Object)NAME, OLST0600_, "receiverVariable.resourceName", INDICES_);
        getterMap_.add((Object)NAME, OLST0700_, "receiverVariable.resourceName", INDICES_);
        openListAttributeMap_.add(NAME, null, "receiverVariable.resourceName");
        TYPE_DISK_DRIVE = 0;
        TYPE_SPOOLED_OUTPUT_QUEUE = 1;
        attributes_.add(TYPE, Integer.class, true, new Object[]{TYPE_DISK_DRIVE, TYPE_SPOOLED_OUTPUT_QUEUE}, null, true);
        getterMap_.add((Object)TYPE, OLST0600_, "receiverVariable.connectionType", INDICES_);
        getterMap_.add((Object)TYPE, OLST0700_, "receiverVariable.connectionType", INDICES_);
        openListAttributeMap_.add(TYPE, null, "receiverVariable.connectionType");
        attributes_.add((Object)USER, String.class, true);
        getterMap_.add((Object)USER, OLST0600_, "receiverVariable.userName", INDICES_);
        getterMap_.add((Object)USER, OLST0700_, "receiverVariable.userName", INDICES_);
        openListAttributeMap_.add(USER, null, "receiverVariable.userName");
        attributes_.add((Object)USER_COUNT, Integer.class, true);
        getterMap_.add((Object)USER_COUNT, OLST0600_, "receiverVariable.numberOfConnectionUsers", INDICES_);
        getterMap_.add((Object)USER_COUNT, OLST0700_, "receiverVariable.numberOfConnectionUsers", INDICES_);
        openListAttributeMap_.add(USER_COUNT, null, "receiverVariable.numberOfConnectionUsers");
        staticDocument_ = null;
        try {
            staticDocument_ = new ProgramCallDocument();
            staticDocument_.setDocument(DOCUMENT_NAME_);
        }
        catch (PcmlException e) {
            Trace.log(2, "PcmlException when instantiating ProgramCallDocument.", (Throwable)e);
        }
    }
}

