/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.MessageFile;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class AS400Message
implements Serializable {
    static final long serialVersionUID = 4L;
    static final int EXTENSION_VERSION = 5;
    static final int EXTENSION_VERSION_FIRST = 5;
    static final byte[] EXTENSION = new byte[]{74, 84, 79, 80, 69, 78, 69, 88, 84};
    public static final int COMPLETION = 1;
    public static final int DIAGNOSTIC = 2;
    public static final int INFORMATIONAL = 4;
    public static final int INQUIRY = 5;
    public static final int SENDERS_COPY = 6;
    public static final int REQUEST = 8;
    public static final int REQUEST_WITH_PROMPTING = 10;
    public static final int NOTIFY = 14;
    public static final int ESCAPE = 15;
    public static final int NOTIFY_NOT_HANDLED = 16;
    public static final int ESCAPE_NOT_HANDLED = 17;
    public static final int REPLY_NOT_VALIDITY_CHECKED = 21;
    public static final int REPLY_VALIDITY_CHECKED = 22;
    public static final int REPLY_MESSAGE_DEFAULT_USED = 23;
    public static final int REPLY_SYSTEM_DEFAULT_USED = 24;
    public static final int REPLY_FROM_SYSTEM_REPLY_LIST = 25;
    public static final int MESSAGE_OPTION_UP_TO_10 = 0;
    public static final int MESSAGE_OPTION_NONE = 1;
    public static final int MESSAGE_OPTION_ALL = 2;
    private Calendar date_;
    private String dateSent_;
    private String timeSent_;
    private String fileName_;
    private String id_;
    private String libraryName_;
    private String defaultReply_;
    private int severity_ = -1;
    private byte[] substitutionData_;
    private String text_;
    private int type_ = -1;
    private String help_;
    private int textCcsid_ = -1;
    private int substitutionDataCcsid_ = -1;
    private transient AS400 system_;
    private transient boolean messageLoaded_ = false;
    private Date createDate_ = null;
    private Date modificationDate_ = null;
    private transient byte[] key_ = null;
    private transient String messageFileLibrarySpecified_ = null;
    private transient String sendingProgramName_ = null;
    private transient String sendingProgramInstructionNumber_ = null;
    private transient String receivingProgramName_ = null;
    private transient String receivingProgramInstructionNumber_ = null;
    private transient String sendingType_ = null;
    private transient String receivingType_ = null;
    private transient int textCcsidConversionStatusIndicator_ = 0;
    private transient int dataCcsidConversionStatusIndicator_ = 0;
    private transient String alertOption_ = null;

    AS400Message() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400Message object.");
        }
    }

    AS400Message(String id, String text) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400Message object, ID: " + id + " text: " + text);
        }
        this.id_ = id;
        this.text_ = text;
    }

    AS400Message(String id, String text, String fileName, String libraryName, int severity, int type, byte[] substitutionData, String help) {
        this.id_ = id;
        this.text_ = text;
        this.fileName_ = fileName;
        this.libraryName_ = libraryName;
        this.severity_ = severity;
        this.type_ = type;
        this.substitutionData_ = substitutionData;
        this.help_ = help;
    }

    AS400Message(String id, String text, String fileName, String libraryName, int severity, int type, byte[] substitutionData, String help, String date, String time, String defaultReply) {
        this.id_ = id;
        this.text_ = text;
        this.fileName_ = fileName;
        this.libraryName_ = libraryName;
        this.severity_ = severity;
        this.type_ = type;
        this.substitutionData_ = substitutionData;
        this.help_ = help;
        this.setDate(date, time);
        this.defaultReply_ = defaultReply;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        boolean nullIndicator = false;
        byte[] oldSubstitutionData = this.substitutionData_;
        if (this.key_ != null || this.messageFileLibrarySpecified_ != null || this.sendingProgramName_ != null || this.sendingProgramInstructionNumber_ != null || this.receivingProgramName_ != null || this.receivingProgramInstructionNumber_ != null || this.sendingType_ != null || this.receivingType_ != null || this.textCcsidConversionStatusIndicator_ != 0 || this.dataCcsidConversionStatusIndicator_ != 0 || this.alertOption_ != null) {
            if (oldSubstitutionData == null) {
                nullIndicator = true;
                oldSubstitutionData = new byte[]{};
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeInt(5);
            oos.writeBoolean(nullIndicator);
            oos.writeObject(this.key_);
            oos.writeObject(this.messageFileLibrarySpecified_);
            oos.writeObject(this.sendingProgramName_);
            oos.writeObject(this.sendingProgramInstructionNumber_);
            oos.writeObject(this.receivingProgramName_);
            oos.writeObject(this.receivingProgramInstructionNumber_);
            oos.writeObject(this.sendingType_);
            oos.writeObject(this.receivingType_);
            oos.writeInt(this.textCcsidConversionStatusIndicator_);
            oos.writeInt(this.dataCcsidConversionStatusIndicator_);
            oos.writeObject(this.alertOption_);
            oos.flush();
            byte[] newStuff = baos.toByteArray();
            this.substitutionData_ = new byte[oldSubstitutionData.length + EXTENSION.length + newStuff.length + 4 + EXTENSION.length];
            int offset = 0;
            System.arraycopy(oldSubstitutionData, 0, this.substitutionData_, offset, oldSubstitutionData.length);
            System.arraycopy(EXTENSION, 0, this.substitutionData_, offset += oldSubstitutionData.length, EXTENSION.length);
            System.arraycopy(newStuff, 0, this.substitutionData_, offset += EXTENSION.length, newStuff.length);
            this.substitutionData_[offset += newStuff.length] = (byte)(oldSubstitutionData.length >> 24 & 0xFF);
            this.substitutionData_[++offset] = (byte)(oldSubstitutionData.length >> 16 & 0xFF);
            this.substitutionData_[++offset] = (byte)(oldSubstitutionData.length >> 8 & 0xFF);
            this.substitutionData_[++offset] = (byte)(oldSubstitutionData.length & 0xFF);
            System.arraycopy(EXTENSION, 0, this.substitutionData_, ++offset, EXTENSION.length);
        }
        out.defaultWriteObject();
        this.substitutionData_ = (byte[])(nullIndicator ? null : oldSubstitutionData);
    }

    private static boolean arrayEndsWith(byte[] byteArray, byte[] pattern) {
        if (byteArray.length < pattern.length) {
            return false;
        }
        int searchOffset = byteArray.length - pattern.length;
        for (int i = 0; i < pattern.length; ++i) {
            if (byteArray[searchOffset + i] == pattern[i]) continue;
            return false;
        }
        return true;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.substitutionData_ != null && this.substitutionData_.length > 2 * EXTENSION.length && AS400Message.arrayEndsWith(this.substitutionData_, EXTENSION)) {
            int lengthOffset = this.substitutionData_.length - EXTENSION.length - 4;
            int realSubstitutionLength = 0;
            realSubstitutionLength += (0xFF & this.substitutionData_[lengthOffset]) << 24;
            realSubstitutionLength += (0xFF & this.substitutionData_[++lengthOffset]) << 16;
            realSubstitutionLength += (0xFF & this.substitutionData_[++lengthOffset]) << 8;
            byte[] realSubstitution = new byte[realSubstitutionLength += 0xFF & this.substitutionData_[++lengthOffset]];
            System.arraycopy(this.substitutionData_, 0, realSubstitution, 0, realSubstitutionLength);
            ByteArrayInputStream bais = new ByteArrayInputStream(this.substitutionData_, realSubstitutionLength + EXTENSION.length, this.substitutionData_.length - realSubstitutionLength - EXTENSION.length);
            ObjectInputStream ois = new ObjectInputStream(bais);
            int extensionVersion = ois.readInt();
            boolean nullIndicator = false;
            if (extensionVersion >= 5) {
                nullIndicator = ois.readBoolean();
                this.key_ = (byte[])ois.readObject();
                this.messageFileLibrarySpecified_ = (String)ois.readObject();
                this.sendingProgramName_ = (String)ois.readObject();
                this.sendingProgramInstructionNumber_ = (String)ois.readObject();
                this.receivingProgramName_ = (String)ois.readObject();
                this.receivingProgramInstructionNumber_ = (String)ois.readObject();
                this.sendingType_ = (String)ois.readObject();
                this.receivingType_ = (String)ois.readObject();
                this.textCcsidConversionStatusIndicator_ = ois.readInt();
                this.dataCcsidConversionStatusIndicator_ = ois.readInt();
                this.alertOption_ = (String)ois.readObject();
            }
            this.substitutionData_ = (byte[])(nullIndicator ? null : realSubstitution);
        }
    }

    public Calendar getDate() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting date: " + this.date_);
        }
        if (this.date_ == null && (this.dateSent_ != null || this.timeSent_ != null)) {
            this.setDate();
        }
        return this.date_;
    }

    public String getDefaultReply() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting default reply: " + this.defaultReply_);
        }
        return this.defaultReply_;
    }

    public String getFileName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message file name: " + this.fileName_);
        }
        return this.fileName_;
    }

    public String getHelp() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message help: " + this.help_);
        }
        return this.help_;
    }

    public String getID() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message ID: " + this.id_);
        }
        return this.id_;
    }

    public String getLibraryName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message file library: " + this.libraryName_);
        }
        return this.libraryName_;
    }

    public String getPath() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message file path, file name: " + this.fileName_ + " library: " + this.libraryName_);
        }
        if (this.fileName_ == null || this.libraryName_ == null || this.fileName_.length() == 0 || this.libraryName_.length() == 0) {
            return null;
        }
        return QSYSObjectPathName.toPath(this.libraryName_, this.fileName_, "MSGF");
    }

    public int getSeverity() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message severity:", this.severity_);
        }
        return this.severity_;
    }

    public byte[] getSubstitutionData() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message substitution data:", this.substitutionData_);
        }
        return this.substitutionData_;
    }

    public String getText() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message text: " + this.text_);
        }
        if (!(this.messageLoaded_ || this.substitutionData_ == null || this.substitutionData_.length == 0 || this.text_ != null && this.text_.trim().length() != 0)) {
            try {
                int ccsid;
                Trace.log(1, "The 'text' field of the message is blank. Copying substitution data to message text.");
                if (this.substitutionDataCcsid_ == -1) {
                    Trace.log(1, "Assuming CCSID of substitution data is 37.");
                    ccsid = 37;
                } else {
                    ccsid = this.substitutionDataCcsid_;
                }
                this.text_ = CharConverter.byteArrayToString(ccsid, this.substitutionData_);
            }
            catch (Exception e) {
                Trace.log(2, e);
            }
        }
        return this.text_;
    }

    public int getType() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message type:", this.type_);
        }
        return this.type_;
    }

    public void load() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        this.load(0);
    }

    public void load(int helpTextFormatting) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Loading additional message information.");
        }
        if (this.messageLoaded_) {
            if (Trace.traceOn_) {
                Trace.log(1, "Repeat message load not necessary.");
            }
            return;
        }
        if (this.libraryName_ == null || this.fileName_ == null || this.libraryName_.trim().length() == 0 || this.fileName_.trim().length() == 0) {
            if (Trace.traceOn_) {
                Trace.log(1, "No message file associated with this message: " + this.toString());
            }
            return;
        }
        if (this.system_ == null) {
            if (Trace.traceOn_) {
                Trace.log(1, "Unable to load message file, because system was not specified when AS400Message was created.");
            }
            return;
        }
        MessageFile file = new MessageFile(this.system_, QSYSObjectPathName.toPath(this.libraryName_, this.fileName_, "MSGF"));
        try {
            file.setHelpTextFormatting(helpTextFormatting);
            AS400Message retrievedMessage = file.getMessage(this.id_, this.substitutionData_);
            if (this.defaultReply_ == null) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Setting default reply: " + retrievedMessage.defaultReply_);
                }
                this.defaultReply_ = retrievedMessage.defaultReply_;
            }
            if (this.severity_ == -1) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Setting message severity:", retrievedMessage.severity_);
                }
                this.severity_ = retrievedMessage.severity_;
            }
            if (this.text_ == null) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Setting message text: " + retrievedMessage.text_);
                }
                this.text_ = retrievedMessage.text_;
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Setting message help: " + retrievedMessage.help_);
            }
            this.help_ = retrievedMessage.help_;
            this.messageLoaded_ = true;
        }
        catch (PropertyVetoException e) {
            Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)e);
            throw new InternalErrorException(10);
        }
    }

    private void setDate() {
        if (this.dateSent_ == null && this.timeSent_ == null) {
            return;
        }
        if (this.dateSent_ != null && this.dateSent_.trim().length() == 0 && this.timeSent_ != null && this.timeSent_.trim().length() == 0) {
            this.dateSent_ = null;
            this.timeSent_ = null;
            return;
        }
        this.date_ = AS400Calendar.getGregorianInstance();
        this.date_.clear();
        if (this.dateSent_ != null && this.dateSent_.trim().length() > 0) {
            this.date_.set(1, Integer.parseInt(this.dateSent_.substring(0, 3)) + 1900);
            this.date_.set(2, Integer.parseInt(this.dateSent_.substring(3, 5)) - 1);
            this.date_.set(5, Integer.parseInt(this.dateSent_.substring(5, 7)));
        }
        if (this.timeSent_ != null && this.timeSent_.trim().length() > 0) {
            this.date_.set(10, Integer.parseInt(this.timeSent_.substring(0, 2)));
            this.date_.set(12, Integer.parseInt(this.timeSent_.substring(2, 4)));
            this.date_.set(13, Integer.parseInt(this.timeSent_.substring(4, 6)));
        }
        this.dateSent_ = null;
        this.timeSent_ = null;
        if (Trace.traceOn_) {
            Trace.log(1, "Date: " + this.date_);
        }
    }

    void setDate(String dateSent, String timeSent) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting date, date: " + dateSent + " time: " + timeSent);
        }
        this.dateSent_ = dateSent;
        this.timeSent_ = timeSent;
    }

    void setDefaultReply(String defaultReply) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting default reply: " + defaultReply);
        }
        this.defaultReply_ = defaultReply;
    }

    void setFileName(String fileName) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message file name: " + fileName);
        }
        this.fileName_ = fileName;
    }

    void setHelp(String help) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message help: " + help);
        }
        this.help_ = help;
    }

    void setID(String id) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message ID: " + id);
        }
        this.id_ = id;
    }

    void setLibraryName(String libraryName) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message file library: " + libraryName);
        }
        this.libraryName_ = libraryName;
    }

    void setSeverity(int severity) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message severity:", severity);
        }
        this.severity_ = severity;
    }

    void setSubstitutionData(byte[] substitutionData) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message substitution data:", substitutionData);
        }
        this.substitutionData_ = substitutionData;
    }

    void setSystem(AS400 system) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message file system: " + system);
        }
        this.system_ = system;
    }

    void setText(String text) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message text: " + text);
        }
        this.text_ = text;
    }

    void setTextCcsid(int ccsid) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message text CCSID: " + ccsid);
        }
        this.textCcsid_ = ccsid;
    }

    void setSubstitutionDataCcsid(int ccsid) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message substitution data CCSID: " + ccsid);
        }
        this.substitutionDataCcsid_ = ccsid;
    }

    void setType(int type) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message type:", type);
        }
        this.type_ = type;
    }

    public String toString() {
        return "AS400Message (ID: " + this.id_ + " text: " + this.text_ + "):" + super.toString();
    }

    String toStringM2() {
        StringBuilder buffer = new StringBuilder();
        String id = this.getID();
        String text = this.getText();
        if (id != null) {
            buffer.append(id);
            buffer.append(" ");
        }
        if (text != null) {
            buffer.append(text);
        }
        return buffer.toString().trim();
    }

    public Date getCreateDate() {
        return this.createDate_;
    }

    public void setCreateDate(Date createDate_) {
        this.createDate_ = createDate_;
    }

    public Date getModificationDate() {
        return this.modificationDate_;
    }

    public void setModificationDate(Date modificationDate_) {
        this.modificationDate_ = modificationDate_;
    }

    public void setKey(byte[] key) {
        this.key_ = key;
    }

    public byte[] getKey() {
        return this.key_;
    }

    public void setMessageFileLibrarySpecified(String library) {
        this.messageFileLibrarySpecified_ = library;
    }

    public String getMessageFileLibrarySpecified() {
        return this.messageFileLibrarySpecified_;
    }

    public void setSendingProgramName(String programName) {
        this.sendingProgramName_ = programName;
    }

    public String getSendingProgramName() {
        return this.sendingProgramName_;
    }

    public void setSendingProgramInstructionNumber(String instructionNumber) {
        this.sendingProgramInstructionNumber_ = instructionNumber;
    }

    public String getSendingProgramInstructionNumber() {
        return this.sendingProgramInstructionNumber_;
    }

    public void setReceivingProgramName(String programName) {
        this.receivingProgramName_ = programName;
    }

    public String getReceivingProgramName() {
        return this.receivingProgramName_;
    }

    public void setReceivingProgramInstructionNumber(String instructionNumber) {
        this.receivingProgramInstructionNumber_ = instructionNumber;
    }

    public String getReceivingProgramInstructionNumber() {
        return this.receivingProgramInstructionNumber_;
    }

    public void setSendingType(String sendingType) {
        this.sendingType_ = sendingType;
    }

    public String getSendingType() {
        return this.sendingType_;
    }

    public void setReceivingType(String receivingType) {
        this.receivingType_ = receivingType;
    }

    public String getReceivingType() {
        return this.receivingType_;
    }

    public void setTextCcsidConversionStatusIndicator(int conversionStatusIndicator) {
        this.textCcsidConversionStatusIndicator_ = conversionStatusIndicator;
    }

    public int getTextCcsidConversionStatusIndicator() {
        return this.textCcsidConversionStatusIndicator_;
    }

    public void setDataCcsidConversionStatusIndicator(int conversionStatusIndicator) {
        this.dataCcsidConversionStatusIndicator_ = conversionStatusIndicator;
    }

    public int getDataCcsidConversionStatusIndicator() {
        return this.dataCcsidConversionStatusIndicator_;
    }

    public void setAlertOption(String alertOption) {
        this.alertOption_ = alertOption;
    }

    public String getAlertOption() {
        return this.alertOption_;
    }

    private boolean checkObject(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public boolean equals(Object o) {
        if (o instanceof AS400Message) {
            AS400Message m = (AS400Message)o;
            if (!this.checkObject(this.date_, m.date_)) {
                return false;
            }
            if (!this.checkObject(this.dateSent_, m.dateSent_)) {
                return false;
            }
            if (!this.checkObject(this.timeSent_, m.timeSent_)) {
                return false;
            }
            if (!this.checkObject(this.fileName_, m.fileName_)) {
                return false;
            }
            if (!this.checkObject(this.id_, m.id_)) {
                return false;
            }
            if (!this.checkObject(this.libraryName_, m.libraryName_)) {
                return false;
            }
            if (!this.checkObject(this.defaultReply_, m.defaultReply_)) {
                return false;
            }
            if (this.severity_ != m.severity_) {
                return false;
            }
            if (!this.checkByteArray(this.substitutionData_, m.substitutionData_)) {
                return false;
            }
            if (!this.checkObject(this.text_, m.text_)) {
                return false;
            }
            if (this.type_ != m.type_) {
                return false;
            }
            if (!this.checkObject(this.help_, m.help_)) {
                return false;
            }
            if (this.textCcsid_ != m.textCcsid_) {
                return false;
            }
            if (this.substitutionDataCcsid_ != m.substitutionDataCcsid_) {
                return false;
            }
            if (!this.checkObject(this.createDate_, m.createDate_)) {
                return false;
            }
            if (!this.checkObject(this.modificationDate_, m.modificationDate_)) {
                return false;
            }
            if (!this.checkByteArray(this.key_, m.key_)) {
                return false;
            }
            if (!this.checkObject(this.messageFileLibrarySpecified_, m.messageFileLibrarySpecified_)) {
                return false;
            }
            if (!this.checkObject(this.sendingProgramName_, m.sendingProgramName_)) {
                return false;
            }
            if (!this.checkObject(this.sendingProgramInstructionNumber_, m.sendingProgramInstructionNumber_)) {
                return false;
            }
            if (!this.checkObject(this.receivingProgramName_, m.receivingProgramName_)) {
                return false;
            }
            if (!this.checkObject(this.receivingProgramInstructionNumber_, m.receivingProgramInstructionNumber_)) {
                return false;
            }
            if (!this.checkObject(this.sendingType_, m.sendingType_)) {
                return false;
            }
            if (!this.checkObject(this.receivingType_, m.receivingType_)) {
                return false;
            }
            if (this.textCcsidConversionStatusIndicator_ != m.textCcsidConversionStatusIndicator_) {
                return false;
            }
            if (this.dataCcsidConversionStatusIndicator_ != m.dataCcsidConversionStatusIndicator_) {
                return false;
            }
            return this.checkObject(this.alertOption_, m.alertOption_);
        }
        return false;
    }

    private boolean checkByteArray(byte[] ba1, byte[] ba2) {
        if (ba1 == null) {
            return ba2 == null;
        }
        if (ba2 == null) {
            return false;
        }
        if (ba1.length != ba2.length) {
            return false;
        }
        for (int i = 0; i < ba1.length; ++i) {
            if (ba1[i] == ba2[i]) continue;
            return false;
        }
        return true;
    }
}

