/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCArrayResultSet;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLBoolean;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLDataFactory;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;

public class AS400JDBCArray
implements java.sql.Array,
Serializable {
    private Object[] data_;
    private String typeName_;
    int typeCode_;
    private int vrm_;
    private transient AS400JDBCConnection con_;
    private transient SQLData contentTemplate_;
    private boolean isSQLData_ = false;

    AS400JDBCArray() {
    }

    AS400JDBCArray(String typeName, Object[] data, int vrm, AS400JDBCConnection con) throws SQLException {
        this.typeCode_ = JDUtilities.getTypeCode(typeName);
        this.typeName_ = JDUtilities.getTypeName(this.typeCode_);
        this.vrm_ = vrm;
        if (data instanceof SQLData[]) {
            this.isSQLData_ = true;
            this.data_ = data;
        } else {
            this.isSQLData_ = false;
            this.setArray(data);
        }
        this.con_ = con;
        this.contentTemplate_ = null;
        for (int i = 0; this.isSQLData_ && this.contentTemplate_ == null && i < this.data_.length; ++i) {
            if (this.data_[i] == null) continue;
            this.contentTemplate_ = (SQLData)this.data_[i];
        }
        if (this.contentTemplate_ == null) {
            this.contentTemplate_ = SQLDataFactory.newData(typeName, 1, 1, 1, 37, null, this.vrm_, con == null ? null : con.getProperties());
        }
    }

    @Override
    public synchronized void free() throws SQLException {
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.typeName_;
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.contentTemplate_.getType();
    }

    @Override
    public synchronized Object getArray() throws SQLException {
        return this.getArrayX(1L, this.data_.length);
    }

    @Override
    public synchronized Object getArray(long index, int count) throws SQLException {
        if (index <= 0L) {
            JDError.throwSQLException("HY090", "" + index);
        }
        if (count < 0) {
            JDError.throwSQLException("HY090", "" + count);
        }
        if (index > (long)this.data_.length) {
            JDError.throwSQLException("HY090", "" + index);
        }
        if (index + (long)count > (long)(this.data_.length + 1)) {
            JDError.throwSQLException("HY090", index + "+" + count);
        }
        return this.getArrayX(index, count);
    }

    @Override
    public synchronized ResultSet getResultSet() throws SQLException {
        AS400JDBCArrayResultSet rs = new AS400JDBCArrayResultSet(this.data_, this.contentTemplate_, this.isSQLData_, this.getBaseType(), this.vrm_);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getResultSet");
        }
        return rs;
    }

    @Override
    public synchronized ResultSet getResultSet(long index, int count) throws SQLException {
        int intIndex = (int)index - 1;
        Object[] retArry = new Object[count];
        if (this.data_.length > 0) {
            for (int x = 0; x < count; ++x) {
                retArry[x] = this.data_[x + intIndex];
            }
        } else {
            retArry = this.data_;
        }
        AS400JDBCArrayResultSet rs = new AS400JDBCArrayResultSet(retArry, this.contentTemplate_, this.isSQLData_, this.getBaseType(), this.vrm_);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getResultSet");
        }
        return rs;
    }

    public synchronized Object getArray(Map map) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001", "getArray(java.util.Map)");
        return null;
    }

    public synchronized Object getArray(long index, int count, Map map) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001", "getArray(long,int,Java.util.Map)");
        return null;
    }

    public synchronized ResultSet getResultSet(Map map) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001", "getResultSet(java.util.Map)");
        return null;
    }

    public synchronized ResultSet getResultSet(long index, int count, Map map) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001", "getResultSet(long,int,java.util.Map)");
        return null;
    }

    private Object getArrayX(long index, int count) throws SQLException {
        int intIndex = (int)index - 1;
        if (this.isSQLData_) {
            Class<?> dummySQLXType = null;
            try {
                String className = this.contentTemplate_.getJavaClassName();
                if (className.equals("com.ibm.as400.access.AS400JDBCBlob")) {
                    className = "java.sql.Blob";
                }
                dummySQLXType = Class.forName(className);
            }
            catch (Exception e) {
                try {
                    dummySQLXType = Class.forName("java.lang.Object");
                }
                catch (Exception ee) {
                    dummySQLXType = null;
                }
            }
            Object retArry = Array.newInstance(dummySQLXType, count);
            for (int x = 0; x < count; ++x) {
                Object o;
                ((Object[])retArry)[x] = this.data_[x + intIndex] != null ? (o = ((SQLData)this.data_[x + intIndex]).getObject()) : null;
            }
            return retArry;
        }
        if (this.data_.length > 0 && !this.isSQLData_) {
            Object retArry = Array.newInstance(this.data_.getClass().getComponentType(), count);
            for (int x = 0; x < count; ++x) {
                ((Object[])retArry)[x] = this.data_[x + intIndex];
            }
            return retArry;
        }
        return this.data_;
    }

    private void setArray(Object inArray) throws SQLException {
        if (inArray == null) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "DB2Array.validate array is null 07006");
            }
            JDError.throwSQLException("07006", "null");
            return;
        }
        Class<?> arrayComponentClass = inArray.getClass().getComponentType();
        String arrayType = arrayComponentClass.getName();
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setArray typeCode is " + this.typeCode_ + " arrayType is " + arrayType);
        }
        switch (this.typeCode_) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                if ("java.lang.String".equals(arrayType)) {
                    String[] inStringArray = (String[])inArray;
                    String[] stringArray = new String[inStringArray.length];
                    System.arraycopy(inStringArray, 0, stringArray, 0, inStringArray.length);
                    this.data_ = stringArray;
                    break;
                }
                if ("java.math.BigDecimal".equals(arrayType) || "java.lang.Boolean".equals(arrayType) || "java.lang.Byte".equals(arrayType) || "java.lang.Short".equals(arrayType) || "java.lang.Integer".equals(arrayType) || "java.lang.Long".equals(arrayType) || "java.lang.Float".equals(arrayType) || "java.lang.Double".equals(arrayType) || "java.sql.Date".equals(arrayType) || "java.sql.Time".equals(arrayType) || "java.sql.Timestamp".equals(arrayType) || JDUtilities.classIsInstanceOf(arrayComponentClass, "java.math.BigDecimal") || JDUtilities.classIsInstanceOf(arrayComponentClass, "java.sql.Date") || JDUtilities.classIsInstanceOf(arrayComponentClass, "java.sql.Time") || JDUtilities.classIsInstanceOf(arrayComponentClass, "java.sql.Timestamp")) {
                    Object[] inObjectArray = (Object[])inArray;
                    String[] stringArray = new String[inObjectArray.length];
                    for (int i = 0; i < inObjectArray.length; ++i) {
                        stringArray[i] = inObjectArray[i] == null ? null : inObjectArray[i].toString();
                    }
                    this.data_ = stringArray;
                    break;
                }
                if (JDUtilities.classIsInstanceOf(arrayComponentClass, "java.sql.Clob")) {
                    Clob[] inObjectArray = (Clob[])inArray;
                    String[] stringArray = new String[inObjectArray.length];
                    for (int i = 0; i < inObjectArray.length; ++i) {
                        if (inObjectArray[i] == null) {
                            stringArray[i] = null;
                            continue;
                        }
                        int length = (int)inObjectArray[i].length();
                        stringArray[i] = inObjectArray[i].getSubString(1L, length);
                    }
                    this.data_ = stringArray;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is CHAR/VARCHAR but array type is " + arrayType);
                }
                JDError.throwSQLException("07006", arrayType);
                break;
            }
            case 5: {
                if ("java.lang.Short".equals(arrayType)) {
                    Short[] inShortArray = (Short[])inArray;
                    Integer[] shortArray = new Integer[inShortArray.length];
                    for (int i = 0; i < inShortArray.length; ++i) {
                        shortArray[i] = inShortArray[i] == null ? null : Integer.valueOf(inShortArray[i].shortValue());
                    }
                    this.data_ = shortArray;
                    break;
                }
                if ("short".equals(arrayType)) {
                    short[] inShortArray = (short[])inArray;
                    Integer[] shortArray = new Integer[inShortArray.length];
                    for (int i = 0; i < inShortArray.length; ++i) {
                        shortArray[i] = inShortArray[i];
                    }
                    this.data_ = shortArray;
                    break;
                }
                if ("java.lang.Integer".equals(arrayType)) {
                    Integer[] inIntegerArray = (Integer[])inArray;
                    Integer[] shortArray = new Integer[inIntegerArray.length];
                    System.arraycopy(inIntegerArray, 0, shortArray, 0, inIntegerArray.length);
                    this.data_ = shortArray;
                    break;
                }
                if ("int".equals(arrayType)) {
                    int[] inIntArray = (int[])inArray;
                    Integer[] shortArray = new Integer[inIntArray.length];
                    for (int i = 0; i < inIntArray.length; ++i) {
                        shortArray[i] = inIntArray[i];
                    }
                    this.data_ = shortArray;
                    break;
                }
                if ("java.lang.Long".equals(arrayType)) {
                    Long[] inLongArray = (Long[])inArray;
                    Integer[] shortArray = new Integer[inLongArray.length];
                    for (int i = 0; i < inLongArray.length; ++i) {
                        if (inLongArray[i] == null) {
                            shortArray[i] = null;
                            continue;
                        }
                        long lv = inLongArray[i];
                        if (lv >= -32768L && lv <= 32767L) {
                            shortArray[i] = (int)lv;
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is SMALLINT but value at index " + i + " is " + lv);
                        }
                        JDError.throwSQLException("07006", "SMALLINT(" + lv + ")");
                    }
                    this.data_ = shortArray;
                    break;
                }
                if ("java.lang.Float".equals(arrayType)) {
                    Float[] inFloatArray = (Float[])inArray;
                    Integer[] shortArray = new Integer[inFloatArray.length];
                    for (int i = 0; i < inFloatArray.length; ++i) {
                        if (inFloatArray[i] == null) {
                            shortArray[i] = null;
                            continue;
                        }
                        float lv = inFloatArray[i].floatValue();
                        if (lv >= -32768.0f && lv <= 32767.0f) {
                            shortArray[i] = (int)lv;
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is SMALLINT but value at index " + i + " is " + lv);
                        }
                        JDError.throwSQLException("07006", "SMALLINT(" + lv + ")");
                        return;
                    }
                    this.data_ = shortArray;
                    break;
                }
                if ("java.lang.Double".equals(arrayType)) {
                    Double[] inDoubleArray = (Double[])inArray;
                    Integer[] shortArray = new Integer[inDoubleArray.length];
                    for (int i = 0; i < inDoubleArray.length; ++i) {
                        if (inDoubleArray[i] == null) {
                            shortArray[i] = null;
                            continue;
                        }
                        double lv = inDoubleArray[i];
                        if (lv >= -32768.0 && lv <= 32767.0) {
                            shortArray[i] = (int)lv;
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is SMALLINT but value at index " + i + " is " + lv);
                        }
                        JDError.throwSQLException("07006", "SMALLINT(" + lv + ")");
                        return;
                    }
                    this.data_ = shortArray;
                    break;
                }
                if ("java.math.BigDecimal".equals(arrayType)) {
                    BigDecimal[] inBigDecimalArray = (BigDecimal[])inArray;
                    Integer[] shortArray = new Integer[inBigDecimalArray.length];
                    for (int i = 0; i < inBigDecimalArray.length; ++i) {
                        if (inBigDecimalArray[i] == null) {
                            shortArray[i] = null;
                            continue;
                        }
                        BigInteger bi = inBigDecimalArray[i].toBigInteger();
                        long lv = bi.longValue();
                        if (lv >= -32768L && lv <= 32767L) {
                            shortArray[i] = (int)lv;
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is SMALLINT but value at index " + i + " is " + lv);
                        }
                        JDError.throwSQLException("07006", "SMALLINT(" + lv + ")");
                        return;
                    }
                    this.data_ = shortArray;
                    break;
                }
                if ("java.lang.Boolean".equals(arrayType)) {
                    Boolean[] inBooleanArray = (Boolean[])inArray;
                    Integer[] shortArray = new Integer[inBooleanArray.length];
                    for (int i = 0; i < inBooleanArray.length; ++i) {
                        boolean b;
                        shortArray[i] = inBooleanArray[i] == null ? null : ((b = inBooleanArray[i].booleanValue()) ? Integer.valueOf(1) : Integer.valueOf(0));
                    }
                    this.data_ = shortArray;
                    break;
                }
                if ("java.lang.Byte".equals(arrayType)) {
                    Byte[] inByteArray = (Byte[])inArray;
                    Integer[] shortArray = new Integer[inByteArray.length];
                    for (int i = 0; i < inByteArray.length; ++i) {
                        if (inByteArray[i] == null) {
                            shortArray[i] = null;
                            continue;
                        }
                        byte b = inByteArray[i];
                        shortArray[i] = b;
                    }
                    this.data_ = shortArray;
                    break;
                }
                if ("java.lang.String".equals(arrayType)) {
                    String[] inStringArray = (String[])inArray;
                    Integer[] shortArray = new Integer[inStringArray.length];
                    for (int i = 0; i < inStringArray.length; ++i) {
                        if (inStringArray[i] == null) {
                            shortArray[i] = null;
                            continue;
                        }
                        try {
                            shortArray[i] = Short.parseShort(inStringArray[i]);
                            continue;
                        }
                        catch (NumberFormatException nfe) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "DB2Array.validate 07006 type is SMALLINT but NumberFormatException thrown for string " + inStringArray[i]);
                            }
                            JDError.throwSQLException("07006", "SMALLINT(" + inStringArray[i] + ")");
                            return;
                        }
                    }
                    this.data_ = shortArray;
                    break;
                }
                try {
                    Object[] inObjectArray = (Object[])inArray;
                    Integer[] shortArray = new Integer[inObjectArray.length];
                    for (int i = 0; i < inObjectArray.length; ++i) {
                        if (inObjectArray[i] == null) {
                            shortArray[i] = null;
                            continue;
                        }
                        try {
                            shortArray[i] = Short.parseShort(inObjectArray[i].toString());
                            continue;
                        }
                        catch (NumberFormatException nfe) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "DB2Array.validate 07006 type is SMALLINT but NumberFormatException thrown for string " + inObjectArray[i]);
                            }
                            JDError.throwSQLException("07006", "SMALLINT(" + inObjectArray[i] + ")");
                            return;
                        }
                    }
                    this.data_ = shortArray;
                }
                catch (Exception e) {
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "DB2Array.validate 07006 type is SMALLINT but array types is " + arrayType);
                    }
                    JDError.throwSQLException("07006", "SMALLINT<>" + arrayType);
                }
                break;
            }
            case 4: {
                if ("java.lang.Integer".equals(arrayType)) {
                    Integer[] inIntegerArray = (Integer[])inArray;
                    Integer[] integerArray = new Integer[inIntegerArray.length];
                    System.arraycopy(inIntegerArray, 0, integerArray, 0, inIntegerArray.length);
                    this.data_ = integerArray;
                    break;
                }
                if ("int".equals(arrayType)) {
                    int[] inIntegerArray = (int[])inArray;
                    Integer[] integerArray = new Integer[inIntegerArray.length];
                    for (int i = 0; i < inIntegerArray.length; ++i) {
                        integerArray[i] = inIntegerArray[i];
                    }
                    this.data_ = integerArray;
                    break;
                }
                if ("java.math.BigDecimal".equals(arrayType)) {
                    BigDecimal[] inBigDecimalArray = (BigDecimal[])inArray;
                    Integer[] integerArray = new Integer[inBigDecimalArray.length];
                    for (int i = 0; i < inBigDecimalArray.length; ++i) {
                        if (inBigDecimalArray[i] == null) {
                            integerArray[i] = null;
                            continue;
                        }
                        BigInteger bi = inBigDecimalArray[i].toBigInteger();
                        long lv = bi.longValue();
                        if (lv >= Integer.MIN_VALUE && lv <= Integer.MAX_VALUE) {
                            integerArray[i] = (int)lv;
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is INTEGER but value at index " + i + " is " + lv);
                        }
                        JDError.throwSQLException("07006", "INTEGER(" + lv + ")");
                        return;
                    }
                    this.data_ = integerArray;
                    break;
                }
                if ("java.lang.Long".equals(arrayType)) {
                    Long[] inLongArray = (Long[])inArray;
                    Integer[] integerArray = new Integer[inLongArray.length];
                    for (int i = 0; i < inLongArray.length; ++i) {
                        if (inLongArray[i] == null) {
                            integerArray[i] = null;
                            continue;
                        }
                        long lv = inLongArray[i];
                        if (lv >= Integer.MIN_VALUE && lv <= Integer.MAX_VALUE) {
                            integerArray[i] = (int)lv;
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is SMALLINT but value at index " + i + " is " + lv);
                        }
                        JDError.throwSQLException("07006", "SMALLINT(" + lv + ")");
                        return;
                    }
                    this.data_ = integerArray;
                    break;
                }
                if ("java.lang.Float".equals(arrayType)) {
                    Float[] inFloatArray = (Float[])inArray;
                    Integer[] integerArray = new Integer[inFloatArray.length];
                    for (int i = 0; i < inFloatArray.length; ++i) {
                        if (inFloatArray[i] == null) {
                            integerArray[i] = null;
                            continue;
                        }
                        float lv = inFloatArray[i].floatValue();
                        if (lv >= -2.1474836E9f && lv <= 2.1474836E9f) {
                            integerArray[i] = (int)lv;
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is INTEGER but value at index " + i + " is " + lv);
                        }
                        JDError.throwSQLException("07006", "INTEGER(" + lv + ")");
                        return;
                    }
                    this.data_ = integerArray;
                    break;
                }
                if ("java.lang.Double".equals(arrayType)) {
                    Double[] inDoubleArray = (Double[])inArray;
                    Integer[] integerArray = new Integer[inDoubleArray.length];
                    for (int i = 0; i < inDoubleArray.length; ++i) {
                        if (inDoubleArray[i] == null) {
                            integerArray[i] = null;
                            continue;
                        }
                        double lv = inDoubleArray[i];
                        if (lv >= -2.147483648E9 && lv <= 2.147483647E9) {
                            integerArray[i] = (int)lv;
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is INTEGER but value at index " + i + " is " + lv);
                        }
                        JDError.throwSQLException("07006", "INTEGER(" + lv + ")");
                        return;
                    }
                    this.data_ = integerArray;
                    break;
                }
                if ("java.lang.Boolean".equals(arrayType)) {
                    Boolean[] inBooleanArray = (Boolean[])inArray;
                    Integer[] integerArray = new Integer[inBooleanArray.length];
                    for (int i = 0; i < inBooleanArray.length; ++i) {
                        boolean b;
                        integerArray[i] = inBooleanArray[i] == null ? null : ((b = inBooleanArray[i].booleanValue()) ? Integer.valueOf(1) : Integer.valueOf(0));
                    }
                    this.data_ = integerArray;
                    break;
                }
                if ("java.lang.Byte".equals(arrayType)) {
                    Byte[] inByteArray = (Byte[])inArray;
                    Integer[] integerArray = new Integer[inByteArray.length];
                    for (int i = 0; i < inByteArray.length; ++i) {
                        if (inByteArray[i] == null) {
                            integerArray[i] = null;
                            continue;
                        }
                        byte b = inByteArray[i];
                        integerArray[i] = b;
                    }
                    this.data_ = integerArray;
                    break;
                }
                if ("java.lang.Short".equals(arrayType)) {
                    Short[] inShortArray = (Short[])inArray;
                    Integer[] integerArray = new Integer[inShortArray.length];
                    for (int i = 0; i < inShortArray.length; ++i) {
                        if (inShortArray[i] == null) {
                            integerArray[i] = null;
                            continue;
                        }
                        short b = inShortArray[i];
                        integerArray[i] = b;
                    }
                    this.data_ = integerArray;
                    break;
                }
                if ("java.lang.String".equals(arrayType)) {
                    String[] inStringArray = (String[])inArray;
                    Integer[] intArray = new Integer[inStringArray.length];
                    for (int i = 0; i < inStringArray.length; ++i) {
                        if (inStringArray[i] == null) {
                            intArray[i] = null;
                            continue;
                        }
                        try {
                            intArray[i] = Integer.valueOf(inStringArray[i]);
                            continue;
                        }
                        catch (NumberFormatException nfe) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "DB2Array.validate 07006 type is INTEGER but NumberFormatException thrown for string " + inStringArray[i]);
                            }
                            JDError.throwSQLException("07006", "INTEGER(" + inStringArray[i] + ")");
                            return;
                        }
                    }
                    this.data_ = intArray;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is INTEGER but array types is " + arrayType);
                }
                JDError.throwSQLException("07006", "INTEGER<>" + arrayType);
                break;
            }
            case -5: {
                if ("java.lang.Long".equals(arrayType)) {
                    Long[] inLongArray = (Long[])inArray;
                    Long[] longArray = new Long[inLongArray.length];
                    System.arraycopy(inLongArray, 0, longArray, 0, inLongArray.length);
                    this.data_ = longArray;
                    break;
                }
                if ("long".equals(arrayType)) {
                    long[] inLongArray = (long[])inArray;
                    Long[] longArray = new Long[inLongArray.length];
                    for (int i = 0; i < inLongArray.length; ++i) {
                        longArray[i] = inLongArray[i];
                    }
                    this.data_ = longArray;
                    break;
                }
                if ("java.math.BigDecimal".equals(arrayType)) {
                    BigDecimal[] inBigDecimalArray = (BigDecimal[])inArray;
                    Long[] longArray = new Long[inBigDecimalArray.length];
                    for (int i = 0; i < inBigDecimalArray.length; ++i) {
                        if (inBigDecimalArray[i] == null) {
                            longArray[i] = null;
                            continue;
                        }
                        BigInteger bi = inBigDecimalArray[i].toBigInteger();
                        long lv = bi.longValue();
                        if (lv >= Long.MIN_VALUE && lv <= Long.MAX_VALUE) {
                            longArray[i] = (int)lv;
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is BIGINT but value at index " + i + " is " + lv);
                        }
                        JDError.throwSQLException("07006", "BIGINT(" + lv + ")");
                        return;
                    }
                    this.data_ = longArray;
                    break;
                }
                if ("java.lang.Boolean".equals(arrayType)) {
                    Boolean[] inBooleanArray = (Boolean[])inArray;
                    Long[] longArray = new Long[inBooleanArray.length];
                    for (int i = 0; i < inBooleanArray.length; ++i) {
                        boolean b;
                        longArray[i] = inBooleanArray[i] == null ? null : ((b = inBooleanArray[i].booleanValue()) ? Long.valueOf(1L) : Long.valueOf(0L));
                    }
                    this.data_ = longArray;
                    break;
                }
                if ("java.lang.Float".equals(arrayType)) {
                    Float[] inFloatArray = (Float[])inArray;
                    Long[] longArray = new Long[inFloatArray.length];
                    for (int i = 0; i < inFloatArray.length; ++i) {
                        if (inFloatArray[i] == null) {
                            longArray[i] = null;
                            continue;
                        }
                        float lv = inFloatArray[i].floatValue();
                        if (lv >= -9.223372E18f && lv <= 9.223372E18f) {
                            longArray[i] = (int)lv;
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is LONG but value at index " + i + " is " + lv);
                        }
                        JDError.throwSQLException("07006", "BIGINT(" + lv + ")");
                        return;
                    }
                    this.data_ = longArray;
                    break;
                }
                if ("java.lang.Double".equals(arrayType)) {
                    Double[] inDoubleArray = (Double[])inArray;
                    Long[] longArray = new Long[inDoubleArray.length];
                    for (int i = 0; i < inDoubleArray.length; ++i) {
                        if (inDoubleArray[i] == null) {
                            longArray[i] = null;
                            continue;
                        }
                        double lv = inDoubleArray[i];
                        if (lv >= -9.223372036854776E18 && lv <= 9.223372036854776E18) {
                            longArray[i] = (int)lv;
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is BIGINT but value at index " + i + " is " + lv);
                        }
                        JDError.throwSQLException("07006", "BIGINT(" + lv + ")");
                        return;
                    }
                    this.data_ = longArray;
                    break;
                }
                if ("java.lang.Byte".equals(arrayType)) {
                    Byte[] inByteArray = (Byte[])inArray;
                    Long[] longArray = new Long[inByteArray.length];
                    for (int i = 0; i < inByteArray.length; ++i) {
                        if (inByteArray[i] == null) {
                            longArray[i] = null;
                            continue;
                        }
                        byte b = inByteArray[i];
                        longArray[i] = b;
                    }
                    this.data_ = longArray;
                    break;
                }
                if ("java.lang.Short".equals(arrayType)) {
                    Short[] inShortArray = (Short[])inArray;
                    Long[] longArray = new Long[inShortArray.length];
                    for (int i = 0; i < inShortArray.length; ++i) {
                        if (inShortArray[i] == null) {
                            longArray[i] = null;
                            continue;
                        }
                        short b = inShortArray[i];
                        longArray[i] = b;
                    }
                    this.data_ = longArray;
                    break;
                }
                if ("java.lang.Integer".equals(arrayType)) {
                    Integer[] inIntegerArray = (Integer[])inArray;
                    Long[] longArray = new Long[inIntegerArray.length];
                    for (int i = 0; i < inIntegerArray.length; ++i) {
                        if (inIntegerArray[i] == null) {
                            longArray[i] = null;
                            continue;
                        }
                        int b = inIntegerArray[i];
                        longArray[i] = b;
                    }
                    this.data_ = longArray;
                    break;
                }
                if ("java.lang.String".equals(arrayType)) {
                    String[] inStringArray = (String[])inArray;
                    Long[] longArray = new Long[inStringArray.length];
                    for (int i = 0; i < inStringArray.length; ++i) {
                        if (inStringArray[i] == null) {
                            longArray[i] = null;
                            continue;
                        }
                        try {
                            longArray[i] = Long.valueOf(inStringArray[i]);
                            continue;
                        }
                        catch (NumberFormatException nfe) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "DB2Array.validate 07006 type is BIGINT but NumberFormatException thrown for string " + inStringArray[i]);
                            }
                            JDError.throwSQLException("07006", "BIGINT(" + inStringArray[i] + ")");
                            return;
                        }
                    }
                    this.data_ = longArray;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is BIGINT but array types is " + arrayType);
                }
                JDError.throwSQLException("07006", "BIGINT<>" + arrayType);
                return;
            }
            case 7: {
                if ("java.lang.Float".equals(arrayType)) {
                    Float[] inFloatArray = (Float[])inArray;
                    Float[] floatArray = new Float[inFloatArray.length];
                    System.arraycopy(inFloatArray, 0, floatArray, 0, inFloatArray.length);
                    this.data_ = floatArray;
                    break;
                }
                if ("float".equals(arrayType)) {
                    float[] inFloatArray = (float[])inArray;
                    Float[] floatArray = new Float[inFloatArray.length];
                    for (int i = 0; i < inFloatArray.length; ++i) {
                        floatArray[i] = Float.valueOf(inFloatArray[i]);
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("java.lang.Short".equals(arrayType)) {
                    Short[] inShortArray = (Short[])inArray;
                    Float[] floatArray = new Float[inShortArray.length];
                    for (int i = 0; i < inShortArray.length; ++i) {
                        floatArray[i] = inShortArray[i] == null ? null : Float.valueOf(inShortArray[i].shortValue());
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("short".equals(arrayType)) {
                    short[] inShortArray = (short[])inArray;
                    Float[] floatArray = new Float[inShortArray.length];
                    for (int i = 0; i < inShortArray.length; ++i) {
                        floatArray[i] = Float.valueOf(inShortArray[i]);
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("java.lang.Integer".equals(arrayType)) {
                    Integer[] inIntegerArray = (Integer[])inArray;
                    Float[] floatArray = new Float[inIntegerArray.length];
                    for (int i = 0; i < inIntegerArray.length; ++i) {
                        floatArray[i] = inIntegerArray[i] == null ? null : Float.valueOf(inIntegerArray[i].floatValue());
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("int".equals(arrayType)) {
                    int[] inIntArray = (int[])inArray;
                    Float[] floatArray = new Float[inIntArray.length];
                    for (int i = 0; i < inIntArray.length; ++i) {
                        floatArray[i] = Float.valueOf(inIntArray[i]);
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("java.lang.Long".equals(arrayType)) {
                    Long[] inLongArray = (Long[])inArray;
                    Float[] floatArray = new Float[inLongArray.length];
                    for (int i = 0; i < inLongArray.length; ++i) {
                        if (inLongArray[i] == null) {
                            floatArray[i] = null;
                            continue;
                        }
                        long lv = inLongArray[i];
                        if ((float)lv >= -3.4028235E38f && (float)lv <= Float.MAX_VALUE) {
                            floatArray[i] = Float.valueOf(lv);
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is REAL but value at index " + i + " is " + lv);
                        }
                        JDError.throwSQLException("07006", "REAL(" + lv + ")");
                        return;
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("java.lang.Float".equals(arrayType)) {
                    Float[] inFloatArray = (Float[])inArray;
                    Float[] floatArray = new Float[inFloatArray.length];
                    for (int i = 0; i < inFloatArray.length; ++i) {
                        if (inFloatArray[i] == null) {
                            floatArray[i] = null;
                            continue;
                        }
                        float lv = inFloatArray[i].floatValue();
                        if (lv >= -3.4028235E38f && lv <= Float.MAX_VALUE) {
                            floatArray[i] = Float.valueOf(lv);
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is REAL but value at index " + i + " is " + lv);
                        }
                        JDError.throwSQLException("07006", "REAL(" + lv + ")");
                        return;
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("java.lang.Double".equals(arrayType)) {
                    Double[] inDoubleArray = (Double[])inArray;
                    Float[] floatArray = new Float[inDoubleArray.length];
                    for (int i = 0; i < inDoubleArray.length; ++i) {
                        if (inDoubleArray[i] == null) {
                            floatArray[i] = null;
                            continue;
                        }
                        double lv = inDoubleArray[i];
                        if (lv >= -3.4028234663852886E38 && lv <= 3.4028234663852886E38) {
                            floatArray[i] = Float.valueOf((float)lv);
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is REAL but value at index " + i + " is " + lv);
                        }
                        JDError.throwSQLException("07006", "REAL(" + lv + ")");
                        return;
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("java.math.BigDecimal".equals(arrayType)) {
                    BigDecimal[] inBigDecimalArray = (BigDecimal[])inArray;
                    Float[] floatArray = new Float[inBigDecimalArray.length];
                    for (int i = 0; i < inBigDecimalArray.length; ++i) {
                        if (inBigDecimalArray[i] == null) {
                            floatArray[i] = null;
                            continue;
                        }
                        float f = inBigDecimalArray[i].floatValue();
                        if (f == Float.NEGATIVE_INFINITY || f == Float.POSITIVE_INFINITY) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "DB2Array.setArray 07006 type is REAL but value at index " + i + " is " + f);
                            }
                            JDError.throwSQLException("07006", "REAL(" + f + ")");
                            return;
                        }
                        floatArray[i] = Float.valueOf(f);
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("java.lang.Boolean".equals(arrayType)) {
                    Boolean[] inBooleanArray = (Boolean[])inArray;
                    Float[] floatArray = new Float[inBooleanArray.length];
                    for (int i = 0; i < inBooleanArray.length; ++i) {
                        boolean b;
                        floatArray[i] = inBooleanArray[i] == null ? null : ((b = inBooleanArray[i].booleanValue()) ? Float.valueOf(1.0f) : Float.valueOf(0.0f));
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("java.lang.Byte".equals(arrayType)) {
                    Byte[] inByteArray = (Byte[])inArray;
                    Float[] floatArray = new Float[inByteArray.length];
                    for (int i = 0; i < inByteArray.length; ++i) {
                        if (inByteArray[i] == null) {
                            floatArray[i] = null;
                            continue;
                        }
                        byte b = inByteArray[i];
                        floatArray[i] = Float.valueOf(b);
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("java.lang.String".equals(arrayType)) {
                    String[] inStringArray = (String[])inArray;
                    Float[] floatArray = new Float[inStringArray.length];
                    for (int i = 0; i < inStringArray.length; ++i) {
                        if (inStringArray[i] == null) {
                            floatArray[i] = null;
                            continue;
                        }
                        try {
                            floatArray[i] = Float.valueOf(inStringArray[i]);
                            continue;
                        }
                        catch (NumberFormatException nfe) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "DB2Array.validate 07006 type is REAL but NumberFormatException thrown for string " + inStringArray[i]);
                            }
                            JDError.throwSQLException("07006", "REAL(" + inStringArray[i] + ")");
                            return;
                        }
                    }
                    this.data_ = floatArray;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is REAL but array types is " + arrayType);
                }
                JDError.throwSQLException("07006", "REAL<>" + arrayType);
                break;
            }
            case 6: {
                if ("java.lang.Double".equals(arrayType)) {
                    Double[] inDoubleArray = (Double[])inArray;
                    Double[] doubleArray = new Double[inDoubleArray.length];
                    System.arraycopy(inDoubleArray, 0, doubleArray, 0, inDoubleArray.length);
                    this.data_ = doubleArray;
                    break;
                }
                if ("double".equals(arrayType)) {
                    double[] inDoubleArray = (double[])inArray;
                    Double[] doubleArray = new Double[inDoubleArray.length];
                    for (int i = 0; i < inDoubleArray.length; ++i) {
                        doubleArray[i] = inDoubleArray[i];
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.lang.Float".equals(arrayType)) {
                    Float[] inFloatArray = (Float[])inArray;
                    Double[] floatArray = new Double[inFloatArray.length];
                    for (int i = 0; i < inFloatArray.length; ++i) {
                        floatArray[i] = inFloatArray[i] == null ? null : Double.valueOf(inFloatArray[i].doubleValue());
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("float".equals(arrayType)) {
                    float[] inFloatArray = (float[])inArray;
                    Double[] floatArray = new Double[inFloatArray.length];
                    for (int i = 0; i < inFloatArray.length; ++i) {
                        floatArray[i] = inFloatArray[i];
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("java.lang.Short".equals(arrayType)) {
                    Short[] inShortArray = (Short[])inArray;
                    Double[] doubleArray = new Double[inShortArray.length];
                    for (int i = 0; i < inShortArray.length; ++i) {
                        doubleArray[i] = inShortArray[i] == null ? null : Double.valueOf(inShortArray[i].shortValue());
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("short".equals(arrayType)) {
                    short[] inShortArray = (short[])inArray;
                    Double[] doubleArray = new Double[inShortArray.length];
                    for (int i = 0; i < inShortArray.length; ++i) {
                        doubleArray[i] = inShortArray[i];
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.lang.Integer".equals(arrayType)) {
                    Integer[] inIntegerArray = (Integer[])inArray;
                    Double[] doubleArray = new Double[inIntegerArray.length];
                    for (int i = 0; i < inIntegerArray.length; ++i) {
                        doubleArray[i] = inIntegerArray[i] == null ? null : Double.valueOf(inIntegerArray[i].doubleValue());
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("int".equals(arrayType)) {
                    int[] inIntArray = (int[])inArray;
                    Double[] doubleArray = new Double[inIntArray.length];
                    for (int i = 0; i < inIntArray.length; ++i) {
                        doubleArray[i] = inIntArray[i];
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.lang.Long".equals(arrayType)) {
                    Long[] inLongArray = (Long[])inArray;
                    Double[] doubleArray = new Double[inLongArray.length];
                    for (int i = 0; i < inLongArray.length; ++i) {
                        if (inLongArray[i] == null) {
                            doubleArray[i] = null;
                            continue;
                        }
                        long lv = inLongArray[i];
                        doubleArray[i] = lv;
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.math.BigDecimal".equals(arrayType)) {
                    BigDecimal[] inBigDecimalArray = (BigDecimal[])inArray;
                    Double[] doubleArray = new Double[inBigDecimalArray.length];
                    for (int i = 0; i < inBigDecimalArray.length; ++i) {
                        if (inBigDecimalArray[i] == null) {
                            doubleArray[i] = null;
                            continue;
                        }
                        double f = inBigDecimalArray[i].doubleValue();
                        if (f == Double.NEGATIVE_INFINITY || f == Double.POSITIVE_INFINITY) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "DB2Array.setArray 07006 type is Double but value at index " + i + " is " + f);
                            }
                            JDError.throwSQLException("07006", "DOUBLE(" + f + ")");
                            return;
                        }
                        doubleArray[i] = f;
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.lang.Boolean".equals(arrayType)) {
                    Boolean[] inBooleanArray = (Boolean[])inArray;
                    Double[] doubleArray = new Double[inBooleanArray.length];
                    for (int i = 0; i < inBooleanArray.length; ++i) {
                        boolean b;
                        doubleArray[i] = inBooleanArray[i] == null ? null : ((b = inBooleanArray[i].booleanValue()) ? Double.valueOf(1.0) : Double.valueOf(0.0));
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.lang.Byte".equals(arrayType)) {
                    Byte[] inByteArray = (Byte[])inArray;
                    Double[] doubleArray = new Double[inByteArray.length];
                    for (int i = 0; i < inByteArray.length; ++i) {
                        if (inByteArray[i] == null) {
                            doubleArray[i] = null;
                            continue;
                        }
                        byte b = inByteArray[i];
                        doubleArray[i] = b;
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.lang.String".equals(arrayType)) {
                    String[] inStringArray = (String[])inArray;
                    Double[] doubleArray = new Double[inStringArray.length];
                    for (int i = 0; i < inStringArray.length; ++i) {
                        if (inStringArray[i] == null) {
                            doubleArray[i] = null;
                            continue;
                        }
                        try {
                            doubleArray[i] = Double.valueOf(inStringArray[i]);
                            continue;
                        }
                        catch (NumberFormatException nfe) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "DB2Array.validate 07006 type is Double but NumberFormatException thrown for string " + inStringArray[i]);
                            }
                            JDError.throwSQLException("07006", "DOUBLE(" + inStringArray[i] + ")");
                            return;
                        }
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is DOUBLE but array types is " + arrayType);
                }
                JDError.throwSQLException("07006", "DOUBLE<>" + arrayType);
                break;
            }
            case 8: {
                if ("java.lang.Double".equals(arrayType)) {
                    Double[] inDoubleArray = (Double[])inArray;
                    Double[] doubleArray = new Double[inDoubleArray.length];
                    System.arraycopy(inDoubleArray, 0, doubleArray, 0, inDoubleArray.length);
                    this.data_ = doubleArray;
                    break;
                }
                if ("double".equals(arrayType)) {
                    double[] inDoubleArray = (double[])inArray;
                    Double[] doubleArray = new Double[inDoubleArray.length];
                    for (int i = 0; i < inDoubleArray.length; ++i) {
                        doubleArray[i] = inDoubleArray[i];
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.lang.Float".equals(arrayType)) {
                    Float[] inFloatArray = (Float[])inArray;
                    Double[] floatArray = new Double[inFloatArray.length];
                    for (int i = 0; i < inFloatArray.length; ++i) {
                        floatArray[i] = inFloatArray[i] == null ? null : Double.valueOf(inFloatArray[i].doubleValue());
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("float".equals(arrayType)) {
                    float[] inFloatArray = (float[])inArray;
                    Double[] floatArray = new Double[inFloatArray.length];
                    for (int i = 0; i < inFloatArray.length; ++i) {
                        floatArray[i] = inFloatArray[i];
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("java.lang.Short".equals(arrayType)) {
                    Short[] inShortArray = (Short[])inArray;
                    Double[] doubleArray = new Double[inShortArray.length];
                    for (int i = 0; i < inShortArray.length; ++i) {
                        doubleArray[i] = inShortArray[i] == null ? null : Double.valueOf(inShortArray[i].shortValue());
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("short".equals(arrayType)) {
                    short[] inShortArray = (short[])inArray;
                    Double[] doubleArray = new Double[inShortArray.length];
                    for (int i = 0; i < inShortArray.length; ++i) {
                        doubleArray[i] = inShortArray[i];
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.lang.Integer".equals(arrayType)) {
                    Integer[] inIntegerArray = (Integer[])inArray;
                    Double[] doubleArray = new Double[inIntegerArray.length];
                    for (int i = 0; i < inIntegerArray.length; ++i) {
                        doubleArray[i] = inIntegerArray[i] == null ? null : Double.valueOf(inIntegerArray[i].doubleValue());
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("int".equals(arrayType)) {
                    int[] inIntArray = (int[])inArray;
                    Double[] doubleArray = new Double[inIntArray.length];
                    for (int i = 0; i < inIntArray.length; ++i) {
                        doubleArray[i] = inIntArray[i];
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.lang.Long".equals(arrayType)) {
                    Long[] inLongArray = (Long[])inArray;
                    Double[] doubleArray = new Double[inLongArray.length];
                    for (int i = 0; i < inLongArray.length; ++i) {
                        if (inLongArray[i] == null) {
                            doubleArray[i] = null;
                            continue;
                        }
                        long lv = inLongArray[i];
                        doubleArray[i] = lv;
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.math.BigDecimal".equals(arrayType)) {
                    BigDecimal[] inBigDecimalArray = (BigDecimal[])inArray;
                    Double[] doubleArray = new Double[inBigDecimalArray.length];
                    for (int i = 0; i < inBigDecimalArray.length; ++i) {
                        if (inBigDecimalArray[i] == null) {
                            doubleArray[i] = null;
                            continue;
                        }
                        double f = inBigDecimalArray[i].doubleValue();
                        if (f == Double.NEGATIVE_INFINITY || f == Double.POSITIVE_INFINITY) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "DB2Array.setArray 07006 type is Double but value at index " + i + " is " + f);
                            }
                            JDError.throwSQLException("07006", "DOUBLE(" + f + ")");
                            return;
                        }
                        doubleArray[i] = f;
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.lang.Boolean".equals(arrayType)) {
                    Boolean[] inBooleanArray = (Boolean[])inArray;
                    Double[] doubleArray = new Double[inBooleanArray.length];
                    for (int i = 0; i < inBooleanArray.length; ++i) {
                        boolean b;
                        doubleArray[i] = inBooleanArray[i] == null ? null : ((b = inBooleanArray[i].booleanValue()) ? Double.valueOf(1.0) : Double.valueOf(0.0));
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.lang.Byte".equals(arrayType)) {
                    Byte[] inByteArray = (Byte[])inArray;
                    Double[] doubleArray = new Double[inByteArray.length];
                    for (int i = 0; i < inByteArray.length; ++i) {
                        if (inByteArray[i] == null) {
                            doubleArray[i] = null;
                            continue;
                        }
                        byte b = inByteArray[i];
                        doubleArray[i] = b;
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.lang.String".equals(arrayType)) {
                    String[] inStringArray = (String[])inArray;
                    Double[] doubleArray = new Double[inStringArray.length];
                    for (int i = 0; i < inStringArray.length; ++i) {
                        if (inStringArray[i] == null) {
                            doubleArray[i] = null;
                            continue;
                        }
                        try {
                            doubleArray[i] = Double.valueOf(inStringArray[i]);
                            continue;
                        }
                        catch (NumberFormatException nfe) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "DB2Array.validate 07006 type is Double but NumberFormatException thrown for string " + inStringArray[i]);
                            }
                            JDError.throwSQLException("07006", "DOUBLE(" + inStringArray[i] + ")");
                            return;
                        }
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is DOUBLE/FLOAT but array types is " + arrayType);
                }
                JDError.throwSQLException("07006", "DOUBLE<>" + arrayType);
                break;
            }
            case -360: 
            case 2: 
            case 3: {
                if (JDUtilities.classIsInstanceOf(arrayComponentClass, "java.math.BigDecimal")) {
                    BigDecimal[] inBdArray = (BigDecimal[])inArray;
                    BigDecimal[] bdArray = new BigDecimal[inBdArray.length];
                    System.arraycopy(inBdArray, 0, bdArray, 0, inBdArray.length);
                    this.data_ = bdArray;
                    break;
                }
                if ("java.lang.Double".equals(arrayType)) {
                    Double[] inDoubleArray = (Double[])inArray;
                    BigDecimal[] bigDecimalArray = new BigDecimal[inDoubleArray.length];
                    for (int i = 0; i < inDoubleArray.length; ++i) {
                        bigDecimalArray[i] = inDoubleArray[i] == null ? null : new BigDecimal(inDoubleArray[i]);
                    }
                    this.data_ = bigDecimalArray;
                    break;
                }
                if ("double".equals(arrayType)) {
                    double[] inDoubleArray = (double[])inArray;
                    BigDecimal[] bigDecimalArray = new BigDecimal[inDoubleArray.length];
                    for (int i = 0; i < inDoubleArray.length; ++i) {
                        bigDecimalArray[i] = new BigDecimal(inDoubleArray[i]);
                    }
                    this.data_ = bigDecimalArray;
                    break;
                }
                if ("java.lang.Float".equals(arrayType)) {
                    Float[] inFloatArray = (Float[])inArray;
                    BigDecimal[] floatArray = new BigDecimal[inFloatArray.length];
                    for (int i = 0; i < inFloatArray.length; ++i) {
                        floatArray[i] = inFloatArray[i] == null ? null : new BigDecimal(inFloatArray[i].doubleValue());
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("float".equals(arrayType)) {
                    float[] inFloatArray = (float[])inArray;
                    BigDecimal[] floatArray = new BigDecimal[inFloatArray.length];
                    for (int i = 0; i < inFloatArray.length; ++i) {
                        floatArray[i] = new BigDecimal(inFloatArray[i]);
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("java.lang.Short".equals(arrayType)) {
                    Short[] inShortArray = (Short[])inArray;
                    BigDecimal[] bigDecimalArray = new BigDecimal[inShortArray.length];
                    for (int i = 0; i < inShortArray.length; ++i) {
                        bigDecimalArray[i] = inShortArray[i] == null ? null : new BigDecimal(inShortArray[i].doubleValue());
                    }
                    this.data_ = bigDecimalArray;
                    break;
                }
                if ("short".equals(arrayType)) {
                    short[] inShortArray = (short[])inArray;
                    BigDecimal[] bigDecimalArray = new BigDecimal[inShortArray.length];
                    for (int i = 0; i < inShortArray.length; ++i) {
                        bigDecimalArray[i] = new BigDecimal((double)inShortArray[i]);
                    }
                    this.data_ = bigDecimalArray;
                    break;
                }
                if ("java.lang.Integer".equals(arrayType)) {
                    Integer[] inIntegerArray = (Integer[])inArray;
                    BigDecimal[] bigDecimalArray = new BigDecimal[inIntegerArray.length];
                    for (int i = 0; i < inIntegerArray.length; ++i) {
                        bigDecimalArray[i] = inIntegerArray[i] == null ? null : new BigDecimal(inIntegerArray[i].doubleValue());
                    }
                    this.data_ = bigDecimalArray;
                    break;
                }
                if ("int".equals(arrayType)) {
                    int[] inIntArray = (int[])inArray;
                    BigDecimal[] bigDecimalArray = new BigDecimal[inIntArray.length];
                    for (int i = 0; i < inIntArray.length; ++i) {
                        bigDecimalArray[i] = new BigDecimal((double)inIntArray[i]);
                    }
                    this.data_ = bigDecimalArray;
                    break;
                }
                if ("java.lang.Long".equals(arrayType)) {
                    Long[] inLongArray = (Long[])inArray;
                    BigDecimal[] bigDecimalArray = new BigDecimal[inLongArray.length];
                    for (int i = 0; i < inLongArray.length; ++i) {
                        if (inLongArray[i] == null) {
                            bigDecimalArray[i] = null;
                            continue;
                        }
                        long lv = inLongArray[i];
                        bigDecimalArray[i] = new BigDecimal((double)lv);
                    }
                    this.data_ = bigDecimalArray;
                    break;
                }
                if ("java.lang.Boolean".equals(arrayType)) {
                    Boolean[] inBooleanArray = (Boolean[])inArray;
                    BigDecimal[] bigDecimalArray = new BigDecimal[inBooleanArray.length];
                    for (int i = 0; i < inBooleanArray.length; ++i) {
                        boolean b;
                        bigDecimalArray[i] = inBooleanArray[i] == null ? null : ((b = inBooleanArray[i].booleanValue()) ? new BigDecimal(1.0) : new BigDecimal(0.0));
                    }
                    this.data_ = bigDecimalArray;
                    break;
                }
                if ("java.lang.Byte".equals(arrayType)) {
                    Byte[] inByteArray = (Byte[])inArray;
                    BigDecimal[] bigDecimalArray = new BigDecimal[inByteArray.length];
                    for (int i = 0; i < inByteArray.length; ++i) {
                        if (inByteArray[i] == null) {
                            bigDecimalArray[i] = null;
                            continue;
                        }
                        byte b = inByteArray[i];
                        bigDecimalArray[i] = new BigDecimal((double)b);
                    }
                    this.data_ = bigDecimalArray;
                    break;
                }
                if ("java.lang.String".equals(arrayType)) {
                    String[] inStringArray = (String[])inArray;
                    BigDecimal[] bigDecimalArray = new BigDecimal[inStringArray.length];
                    for (int i = 0; i < inStringArray.length; ++i) {
                        if (inStringArray[i] == null) {
                            bigDecimalArray[i] = null;
                            continue;
                        }
                        try {
                            bigDecimalArray[i] = new BigDecimal(inStringArray[i]);
                            continue;
                        }
                        catch (NumberFormatException nfe) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "DB2Array.validate 07006 type is DECIMAL/NUMERIC/DECFLOAT but NumberFormatException thrown for string " + inStringArray[i]);
                            }
                            JDError.throwSQLException("07006", "DECIMAL[" + i + "](" + inStringArray[i] + ")");
                            return;
                        }
                    }
                    this.data_ = bigDecimalArray;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is DECIMAL/NUMERIC/DECFLOAT but array types is " + arrayType);
                }
                JDError.throwSQLException("07006", "DECIMAL<>" + arrayType);
                return;
            }
            case -3: 
            case -2: {
                if ("[B".equals(arrayType)) {
                    byte[][] inByteArray = (byte[][])inArray;
                    byte[][] byteArray = new byte[inByteArray.length][];
                    System.arraycopy(inByteArray, 0, byteArray, 0, inByteArray.length);
                    this.data_ = (Object[])byteArray;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is BINARY/VARBINARY but array types is " + arrayType);
                }
                JDError.throwSQLException("07006", "BINARY<>" + arrayType);
                break;
            }
            case 2004: {
                if (JDUtilities.classIsInstanceOf(arrayComponentClass, "java.sql.Blob")) {
                    Blob[] inBlobArray = (Blob[])inArray;
                    Blob[] blobArray = new Blob[inBlobArray.length];
                    System.arraycopy(inBlobArray, 0, blobArray, 0, inBlobArray.length);
                    this.data_ = blobArray;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is BLOB but array types is " + arrayType);
                }
                JDError.throwSQLException("07006", "BLOB<>" + arrayType);
                break;
            }
            case 2005: 
            case 2011: {
                if (JDUtilities.classIsInstanceOf(arrayComponentClass, "java.sql.Clob")) {
                    Clob[] inClobArray = (Clob[])inArray;
                    Clob[] clobArray = new Clob[inClobArray.length];
                    System.arraycopy(inClobArray, 0, clobArray, 0, inClobArray.length);
                    this.data_ = clobArray;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is CLOB but array types is " + arrayType);
                }
                JDError.throwSQLException("07006", "CLOB<>" + arrayType);
                break;
            }
            case 91: {
                if (JDUtilities.classIsInstanceOf(arrayComponentClass, "java.sql.Date")) {
                    Date[] inDateArray = (Date[])inArray;
                    Date[] dateArray = new Date[inDateArray.length];
                    System.arraycopy(inDateArray, 0, dateArray, 0, inDateArray.length);
                    this.data_ = dateArray;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is DATE but array types is " + arrayType);
                }
                JDError.throwSQLException("07006", "DATE<>" + arrayType);
                break;
            }
            case 2009: {
                boolean allValid = true;
                String subArrayType = "";
                Object[] inSQLXMLArray = (Object[])inArray;
                SQLXML[] SQLXMLArray = new SQLXML[inSQLXMLArray.length];
                for (int i = 0; allValid && i < inSQLXMLArray.length; ++i) {
                    if (inSQLXMLArray[i] == null) {
                        SQLXMLArray[i] = null;
                        continue;
                    }
                    if (inSQLXMLArray[i] instanceof SQLXML) {
                        SQLXMLArray[i] = (SQLXML)inSQLXMLArray[i];
                        continue;
                    }
                    subArrayType = inSQLXMLArray[i].getClass().getName();
                    allValid = false;
                }
                if (allValid) {
                    this.data_ = SQLXMLArray;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is SQLXML but array types is " + arrayType + " subArrayType = " + subArrayType);
                }
                JDError.throwSQLException("07006");
                break;
            }
            case 92: {
                if (JDUtilities.classIsInstanceOf(arrayComponentClass, "java.sql.Time")) {
                    Time[] inTimeArray = (Time[])inArray;
                    Time[] timeArray = new Time[inTimeArray.length];
                    System.arraycopy(inTimeArray, 0, timeArray, 0, inTimeArray.length);
                    this.data_ = timeArray;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is TIME but array types is " + arrayType);
                }
                JDError.throwSQLException("07006", "TIME<>" + arrayType);
                break;
            }
            case 93: {
                if (JDUtilities.classIsInstanceOf(arrayComponentClass, "java.sql.Timestamp")) {
                    Timestamp[] inTimestampArray = (Timestamp[])inArray;
                    Timestamp[] timestampArray = new Timestamp[inTimestampArray.length];
                    System.arraycopy(inTimestampArray, 0, timestampArray, 0, inTimestampArray.length);
                    this.data_ = timestampArray;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is TIMESTAMP but array types is " + arrayType);
                }
                JDError.throwSQLException("07006", "TIMESTAMP<>" + arrayType);
                break;
            }
            case 16: {
                if ("java.lang.Boolean".equals(arrayType)) {
                    Boolean[] inBooleanArray = (Boolean[])inArray;
                    Boolean[] booleanArray = new Boolean[inBooleanArray.length];
                    System.arraycopy(inBooleanArray, 0, booleanArray, 0, inBooleanArray.length);
                    this.data_ = booleanArray;
                    break;
                }
                if ("boolean".equals(arrayType)) {
                    boolean[] inBooleanArray = (boolean[])inArray;
                    Boolean[] booleanArray = new Boolean[inBooleanArray.length];
                    for (int i = 0; i < inBooleanArray.length; ++i) {
                        booleanArray[i] = inBooleanArray[i];
                    }
                    this.data_ = booleanArray;
                    break;
                }
                if ("java.lang.Integer".equals(arrayType)) {
                    Integer[] inIntegerArray = (Integer[])inArray;
                    Boolean[] booleanArray = new Boolean[inIntegerArray.length];
                    for (int i = 0; i < inIntegerArray.length; ++i) {
                        booleanArray[i] = SQLBoolean.getBooleanObject((Object)this, inIntegerArray[i]);
                    }
                    this.data_ = booleanArray;
                    break;
                }
                if ("int".equals(arrayType)) {
                    int[] inIntegerArray = (int[])inArray;
                    Boolean[] booleanArray = new Boolean[inIntegerArray.length];
                    for (int i = 0; i < inIntegerArray.length; ++i) {
                        booleanArray[i] = SQLBoolean.getBoolean((Object)this, inIntegerArray[i]);
                    }
                    this.data_ = booleanArray;
                    break;
                }
                if ("java.math.BigDecimal".equals(arrayType)) {
                    BigDecimal[] inBigDecimalArray = (BigDecimal[])inArray;
                    Boolean[] booleanArray = new Boolean[inBigDecimalArray.length];
                    for (int i = 0; i < inBigDecimalArray.length; ++i) {
                        booleanArray[i] = SQLBoolean.getBooleanObject((Object)this, inBigDecimalArray[i]);
                    }
                    this.data_ = booleanArray;
                    break;
                }
                if ("java.lang.Long".equals(arrayType)) {
                    Long[] inLongArray = (Long[])inArray;
                    Boolean[] booleanArray = new Boolean[inLongArray.length];
                    for (int i = 0; i < inLongArray.length; ++i) {
                        booleanArray[i] = SQLBoolean.getBooleanObject((Object)this, inLongArray[i]);
                    }
                    this.data_ = booleanArray;
                    break;
                }
                if ("java.lang.Float".equals(arrayType)) {
                    Float[] inFloatArray = (Float[])inArray;
                    Boolean[] booleanArray = new Boolean[inFloatArray.length];
                    for (int i = 0; i < inFloatArray.length; ++i) {
                        booleanArray[i] = SQLBoolean.getBooleanObject((Object)this, inFloatArray[i]);
                    }
                    this.data_ = booleanArray;
                    break;
                }
                if ("java.lang.Double".equals(arrayType)) {
                    Double[] inDoubleArray = (Double[])inArray;
                    Boolean[] booleanArray = new Boolean[inDoubleArray.length];
                    for (int i = 0; i < inDoubleArray.length; ++i) {
                        booleanArray[i] = SQLBoolean.getBooleanObject((Object)this, inDoubleArray[i]);
                    }
                    this.data_ = booleanArray;
                    break;
                }
                if ("java.lang.Byte".equals(arrayType)) {
                    Byte[] inByteArray = (Byte[])inArray;
                    Boolean[] booleanArray = new Boolean[inByteArray.length];
                    for (int i = 0; i < inByteArray.length; ++i) {
                        booleanArray[i] = SQLBoolean.getBooleanObject((Object)this, inByteArray[i]);
                    }
                    this.data_ = booleanArray;
                    break;
                }
                if ("java.lang.Short".equals(arrayType)) {
                    Short[] inShortArray = (Short[])inArray;
                    Boolean[] booleanArray = new Boolean[inShortArray.length];
                    for (int i = 0; i < inShortArray.length; ++i) {
                        booleanArray[i] = SQLBoolean.getBooleanObject((Object)this, inShortArray[i]);
                    }
                    this.data_ = booleanArray;
                    break;
                }
                if ("java.lang.String".equals(arrayType)) {
                    String[] inStringArray = (String[])inArray;
                    Boolean[] booleanArray = new Boolean[inStringArray.length];
                    for (int i = 0; i < inStringArray.length; ++i) {
                        booleanArray[i] = SQLBoolean.getBooleanObject((Object)this, inStringArray[i]);
                    }
                    this.data_ = booleanArray;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is INTEGER but array types is " + arrayType);
                }
                JDError.throwSQLException("07006", "INTEGER<>" + arrayType);
                break;
            }
            default: {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 invalid type " + this.typeCode_ + " array type is " + arrayType);
                }
                JDError.throwSQLException("07006", this.typeCode_ + "<>" + arrayType);
            }
        }
    }
}

