/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.dbproc;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.ActionTransformType;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dbproc.DBProc;
import org.apache.hop.pipeline.transforms.dbproc.DBProcData;

@Transform(id="DBProc", image="dbproc.svg", name="i18n::CallDBProcedure.Name", description="i18n::CallDBProcedure.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Utility", keywords={"i18n::DBProcMeta.keyword"}, documentationUrl="/pipeline/transforms/calldbproc.html", actionTransformTypes={ActionTransformType.RDBMS})
public class DBProcMeta
extends BaseTransformMeta<DBProc, DBProcData> {
    private static final Class<?> PKG = DBProcMeta.class;
    @HopMetadataProperty(key="connection", hopMetadataPropertyType=HopMetadataPropertyType.RDBMS_CONNECTION)
    private String connection;
    @HopMetadataProperty
    private String procedure;
    @HopMetadataProperty(groupKey="lookup", key="arg")
    List<ProcArgument> arguments = new ArrayList<ProcArgument>();
    @HopMetadataProperty
    private ProcResult result = new ProcResult();
    @HopMetadataProperty(key="auto_commit")
    private boolean autoCommit;

    public DBProcMeta() {
    }

    public DBProcMeta(DBProcMeta m) {
        this();
        this.connection = m.connection;
        this.procedure = m.procedure;
        for (ProcArgument argument : m.arguments) {
            this.arguments.add(new ProcArgument(argument));
        }
        this.result = new ProcResult(m.result);
        this.autoCommit = m.autoCommit;
    }

    public DBProcMeta clone() {
        return new DBProcMeta(this);
    }

    public void setDefault() {
        this.connection = null;
        this.result.name = "result";
        this.result.type = "Number";
        this.autoCommit = true;
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (!Utils.isEmpty((CharSequence)this.result.getName())) {
            try {
                IValueMeta v = ValueMetaFactory.createValueMeta((String)this.result.getName(), (int)this.result.getHopType());
                v.setOrigin(name);
                r.addValueMeta(v);
            }
            catch (HopPluginException e) {
                throw new HopTransformException((Throwable)e);
            }
        }
        for (ProcArgument argument : this.arguments) {
            if (!argument.getDirection().equalsIgnoreCase("OUT")) continue;
            try {
                IValueMeta v = ValueMetaFactory.createValueMeta((String)argument.getName(), (int)argument.getHopType());
                v.setOrigin(name);
                r.addValueMeta(v);
            }
            catch (HopPluginException e) {
                throw new HopTransformException((Throwable)e);
            }
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        Object errorMessage = "";
        DatabaseMeta databaseMeta = null;
        try {
            databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
        }
        catch (HopException e) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"DBProcMeta.CheckResult.DatabaseMetaError", (String[])new String[]{variables.resolve(this.connection)}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (databaseMeta != null) {
            try (Database db = new Database(loggingObject, variables, databaseMeta);){
                db.connect();
                if (prev != null && !prev.isEmpty()) {
                    boolean first = true;
                    errorMessage = "";
                    boolean errorFound = false;
                    for (ProcArgument argument : this.arguments) {
                        IValueMeta v = prev.searchValueMeta(argument.getName());
                        if (v == null) {
                            if (first) {
                                first = false;
                                errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"DBProcMeta.CheckResult.MissingArguments", (String[])new String[0]) + Const.CR;
                            }
                            errorFound = true;
                            errorMessage = (String)errorMessage + "\t\t" + argument.getName() + Const.CR;
                            continue;
                        }
                        int hopType = argument.getHopType();
                        if (v.getType() == hopType || v.isNumeric() && ValueMetaBase.isNumeric((int)hopType)) continue;
                        errorFound = true;
                        errorMessage = (String)errorMessage + "\t\t" + argument.getName() + BaseMessages.getString(PKG, (String)"DBProcMeta.CheckResult.WrongTypeArguments", (String[])new String[]{v.getTypeDesc(), ValueMetaFactory.getValueMetaName((int)hopType)}) + Const.CR;
                    }
                    cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DBProcMeta.CheckResult.AllArgumentsOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                } else {
                    errorMessage = BaseMessages.getString(PKG, (String)"DBProcMeta.CheckResult.CouldNotReadFields", (String[])new String[0]) + Const.CR;
                    cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
            }
            catch (HopException e) {
                errorMessage = BaseMessages.getString(PKG, (String)"DBProcMeta.CheckResult.ErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"DBProcMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DBProcMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"DBProcMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public String[] argumentNames() {
        String[] names = new String[this.arguments.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.arguments.get(i).getName();
        }
        return names;
    }

    public String[] argumentDirections() {
        String[] directions = new String[this.arguments.size()];
        for (int i = 0; i < directions.length; ++i) {
            directions[i] = this.arguments.get(i).getDirection();
        }
        return directions;
    }

    public int[] argumentTypes() {
        int[] types = new int[this.arguments.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.arguments.get(i).getHopType();
        }
        return types;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public String getProcedure() {
        return this.procedure;
    }

    public void setProcedure(String procedure) {
        this.procedure = procedure;
    }

    public List<ProcArgument> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<ProcArgument> arguments) {
        this.arguments = arguments;
    }

    public ProcResult getResult() {
        return this.result;
    }

    public void setResult(ProcResult result) {
        this.result = result;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public static class ProcResult {
        @HopMetadataProperty
        private String name;
        @HopMetadataProperty
        private String type;

        public ProcResult() {
        }

        public ProcResult(ProcResult r) {
            this.name = r.name;
            this.type = r.type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public int getHopType() {
            return ValueMetaFactory.getIdForValueMeta((String)this.type);
        }
    }

    public static class ProcArgument {
        @HopMetadataProperty
        private String name;
        @HopMetadataProperty
        private String direction;
        @HopMetadataProperty
        private String type;

        public ProcArgument() {
        }

        public ProcArgument(ProcArgument a) {
            this.name = a.name;
            this.direction = a.direction;
            this.type = a.type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDirection() {
            return this.direction;
        }

        public void setDirection(String direction) {
            this.direction = direction;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public int getHopType() {
            return ValueMetaFactory.getIdForValueMeta((String)this.type);
        }
    }
}

