/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.testing.TestStream;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.construction.PTransformTranslation;
import org.apache.beam.sdk.util.construction.RehydratedComponents;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.util.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class TestStreamTranslation {
    public static <T> @UnknownKeyFor @NonNull @Initialized TestStream<T> testStreamFromProtoPayload(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.TestStreamPayload testStreamPayload, @UnknownKeyFor @NonNull @Initialized RehydratedComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Coder<?> coder = components.getCoder(testStreamPayload.getCoderId());
        return TestStreamTranslation.testStreamFromProtoPayload(testStreamPayload, coder);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized TestStream<T> testStreamFromProtoPayload(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.TestStreamPayload testStreamPayload, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList events = new ArrayList();
        for (RunnerApi.TestStreamPayload.Event event : testStreamPayload.getEventsList()) {
            events.add(TestStreamTranslation.eventFromProto(event, coder));
        }
        return TestStream.fromRawEvents(coder, events);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized TestStream<T> getTestStream(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>>> application) throws @UnknownKeyFor @NonNull @Initialized IOException {
        SdkComponents sdkComponents = SdkComponents.create(application.getPipeline().getOptions());
        RunnerApi.PTransform transformProto = PTransformTranslation.toProto(application, sdkComponents);
        Preconditions.checkArgument((boolean)"beam:transform:teststream:v1".equals(transformProto.getSpec().getUrn()), (String)"Attempt to get %s from a transform with wrong URN %s", (Object)TestStream.class.getSimpleName(), (Object)transformProto.getSpec().getUrn());
        RunnerApi.TestStreamPayload testStreamPayload = RunnerApi.TestStreamPayload.parseFrom((ByteString)transformProto.getSpec().getPayload());
        return TestStreamTranslation.testStreamFromProtoPayload(testStreamPayload, RehydratedComponents.forComponents(sdkComponents.toComponents()));
    }

    static <T> // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.TestStreamPayload.Event eventToProto(@UnknownKeyFor @NonNull @Initialized TestStream.Event<T> event, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) throws @UnknownKeyFor @NonNull @Initialized IOException {
        switch (event.getType()) {
            case WATERMARK: {
                return RunnerApi.TestStreamPayload.Event.newBuilder().setWatermarkEvent(RunnerApi.TestStreamPayload.Event.AdvanceWatermark.newBuilder().setNewWatermark(((TestStream.WatermarkEvent)event).getWatermark().getMillis())).build();
            }
            case PROCESSING_TIME: {
                return RunnerApi.TestStreamPayload.Event.newBuilder().setProcessingTimeEvent(RunnerApi.TestStreamPayload.Event.AdvanceProcessingTime.newBuilder().setAdvanceDuration(((TestStream.ProcessingTimeEvent)event).getProcessingTimeAdvance().getMillis())).build();
            }
            case ELEMENT: {
                RunnerApi.TestStreamPayload.Event.AddElements.Builder builder = RunnerApi.TestStreamPayload.Event.AddElements.newBuilder();
                for (TimestampedValue element : ((TestStream.ElementEvent)event).getElements()) {
                    builder.addElements(RunnerApi.TestStreamPayload.TimestampedElement.newBuilder().setTimestamp(element.getTimestamp().getMillis()).setEncodedElement(ByteString.copyFrom((byte[])CoderUtils.encodeToByteArray(coder, element.getValue()))));
                }
                return RunnerApi.TestStreamPayload.Event.newBuilder().setElementEvent(builder).build();
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported type of %s: %s", new Object[]{TestStream.Event.class.getCanonicalName(), event.getType()}));
    }

    static <T> @UnknownKeyFor @NonNull @Initialized TestStream.Event<T> eventFromProto(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.TestStreamPayload.Event protoEvent, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) throws @UnknownKeyFor @NonNull @Initialized IOException {
        switch (protoEvent.getEventCase()) {
            case WATERMARK_EVENT: {
                return TestStream.WatermarkEvent.advanceTo(new Instant(protoEvent.getWatermarkEvent().getNewWatermark()));
            }
            case PROCESSING_TIME_EVENT: {
                return TestStream.ProcessingTimeEvent.advanceBy(Duration.millis((long)protoEvent.getProcessingTimeEvent().getAdvanceDuration()));
            }
            case ELEMENT_EVENT: {
                ArrayList decodedElements = new ArrayList();
                for (RunnerApi.TestStreamPayload.TimestampedElement element : protoEvent.getElementEvent().getElementsList()) {
                    decodedElements.add(TimestampedValue.of(CoderUtils.decodeFromByteArray(coder, element.getEncodedElement().toByteArray()), new Instant(element.getTimestamp())));
                }
                return TestStream.ElementEvent.add(decodedElements);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported type of %s: %s", RunnerApi.TestStreamPayload.Event.class.getCanonicalName(), protoEvent.getEventCase()));
    }

    static <T> // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.TestStreamPayload payloadForTestStream(@UnknownKeyFor @NonNull @Initialized TestStream<T> transform, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList<RunnerApi.TestStreamPayload.Event> protoEvents = new ArrayList<RunnerApi.TestStreamPayload.Event>();
        try {
            for (TestStream.Event<T> event : transform.getEvents()) {
                protoEvents.add(TestStreamTranslation.eventToProto(event, transform.getValueCoder()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return RunnerApi.TestStreamPayload.newBuilder().setCoderId(components.registerCoder(transform.getValueCoder())).addAllEvents(protoEvents).build();
    }

    static class TestStreamTranslator
    implements PTransformTranslation.TransformPayloadTranslator<TestStream<?>> {
        TestStreamTranslator() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getUrn() {
            return "beam:transform:teststream:v1";
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec translate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized TestStream<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> transform, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return this.translateTyped(transform.getTransform(), components);
        }

        private <T> // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec translateTyped(@UnknownKeyFor @NonNull @Initialized TestStream<T> testStream, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return RunnerApi.FunctionSpec.newBuilder().setUrn("beam:transform:teststream:v1").setPayload(TestStreamTranslation.payloadForTestStream(testStream, components).toByteString()).build();
        }

        @AutoService(value={TransformPayloadTranslatorRegistrar.class})
        public static class Registrar
        implements TransformPayloadTranslatorRegistrar {
            @Override
            public @UnknownKeyFor @NonNull @Initialized Map<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransform>, @KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
                return Collections.singletonMap(TestStream.class, new TestStreamTranslator());
            }
        }
    }
}

