/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import com.google.cloud.secretmanager.v1.AccessSecretVersionResponse;
import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1.SecretVersionName;
import java.io.IOException;
import org.apache.beam.sdk.util.Secret;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class GcpSecret
implements Secret {
    private final @UnknownKeyFor @NonNull @Initialized String versionName;

    public GcpSecret(@UnknownKeyFor @NonNull @Initialized String versionName) {
        this.versionName = versionName;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getSecretBytes() {
        byte[] byArray;
        block8: {
            SecretManagerServiceClient client = SecretManagerServiceClient.create();
            try {
                SecretVersionName secretVersionName = SecretVersionName.parse((String)this.versionName);
                AccessSecretVersionResponse response = client.accessSecretVersion(secretVersionName);
                byArray = response.getPayload().getData().toByteArray();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to retrieve secret bytes", e);
                }
            }
            client.close();
        }
        return byArray;
    }

    public @UnknownKeyFor @NonNull @Initialized String getVersionName() {
        return this.versionName;
    }
}

