/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.beam.model.pipeline.v1.ExternalTransforms;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.model.pipeline.v1.SchemaApi;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.schemas.SchemaTranslation;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.util.construction.BeamUrns;
import org.apache.beam.sdk.util.construction.PTransformTranslation;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ProtocolMessageEnum;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SchemaTransformTranslation {

    public static abstract class SchemaTransformPayloadTranslator<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized SchemaTransform>
    implements PTransformTranslation.TransformPayloadTranslator<T> {
        public abstract @UnknownKeyFor @NonNull @Initialized SchemaTransformProvider provider();

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getUrn() {
            return BeamUrns.getUrn((ProtocolMessageEnum)ExternalTransforms.ExpansionMethods.Enum.SCHEMA_TRANSFORM);
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable @UnknownKeyFor @Initialized RunnerApi.FunctionSpec translate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, T> application, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
            SchemaApi.Schema expansionSchema = SchemaTranslation.schemaToProto(this.provider().configurationSchema(), true);
            Row configRow = this.toConfigRow((SchemaTransform)application.getTransform());
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            RowCoder.of(this.provider().configurationSchema()).encode(configRow, os);
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn()).setPayload(ExternalTransforms.SchemaTransformPayload.newBuilder().setIdentifier(this.provider().identifier()).setConfigurationSchema(expansionSchema).setConfigurationRow(ByteString.copyFrom((byte[])os.toByteArray())).build().toByteString()).build();
        }

        @Override
        public T fromConfigRow(@UnknownKeyFor @NonNull @Initialized Row configRow, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return (T)this.provider().from(configRow);
        }
    }
}

