/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.environment;

import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.runners.fnexecution.control.InstructionRequestHandler;
import org.apache.beam.runners.fnexecution.environment.DockerCommand;
import org.apache.beam.runners.fnexecution.environment.RemoteEnvironment;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class DockerContainerEnvironment
implements RemoteEnvironment {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DockerContainerEnvironment.class);
    private final @UnknownKeyFor @NonNull @Initialized Object lock = new Object();
    private final @UnknownKeyFor @NonNull @Initialized DockerCommand docker;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment environment;
    private final @UnknownKeyFor @NonNull @Initialized String containerId;
    private final @UnknownKeyFor @NonNull @Initialized InstructionRequestHandler instructionHandler;
    private final @UnknownKeyFor @NonNull @Initialized boolean retainDockerContainer;
    private @UnknownKeyFor @NonNull @Initialized boolean isClosed = false;

    static @UnknownKeyFor @NonNull @Initialized DockerContainerEnvironment create(@UnknownKeyFor @NonNull @Initialized DockerCommand docker, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment environment, @UnknownKeyFor @NonNull @Initialized String containerId, @UnknownKeyFor @NonNull @Initialized InstructionRequestHandler instructionHandler, @UnknownKeyFor @NonNull @Initialized boolean retainDockerContainer) {
        return new DockerContainerEnvironment(docker, environment, containerId, instructionHandler, retainDockerContainer);
    }

    private DockerContainerEnvironment(@UnknownKeyFor @NonNull @Initialized DockerCommand docker, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment environment, @UnknownKeyFor @NonNull @Initialized String containerId, @UnknownKeyFor @NonNull @Initialized InstructionRequestHandler instructionHandler, @UnknownKeyFor @NonNull @Initialized boolean retainDockerContainer) {
        this.docker = docker;
        this.environment = environment;
        this.containerId = containerId;
        this.instructionHandler = instructionHandler;
        this.retainDockerContainer = retainDockerContainer;
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized InstructionRequestHandler getInstructionRequestHandler() {
        return this.instructionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isClosed) {
                this.isClosed = true;
                this.instructionHandler.close();
                String containerLogs = this.docker.getContainerLogs(this.containerId);
                LOG.info("Closing Docker container {}. Logs:\n{}", (Object)this.containerId, (Object)containerLogs);
                this.docker.killContainer(this.containerId);
                if (!this.retainDockerContainer) {
                    this.docker.removeContainer(this.containerId);
                }
            }
        }
    }
}

