/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.runners.core.metrics.ExecutionStateTracker;
import org.apache.beam.runners.core.metrics.MonitoringInfoEncodings;
import org.apache.beam.runners.core.metrics.ShortIdMap;
import org.apache.beam.runners.core.metrics.SimpleMonitoringInfoBuilder;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleExecutionState
extends ExecutionStateTracker.ExecutionState {
    private @UnknownKeyFor @NonNull @Initialized long totalMillis = 0L;
    private @UnknownKeyFor @NonNull @Initialized HashMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> labelsMetadata;
    private @UnknownKeyFor @NonNull @Initialized String urn;
    private @UnknownKeyFor @NonNull @Initialized String shortId;
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SimpleExecutionState.class);
    private static final @UnknownKeyFor @NonNull @Initialized PeriodFormatter DURATION_FORMATTER = new PeriodFormatterBuilder().appendDays().appendSuffix("d").minimumPrintedDigits(2).appendHours().appendSuffix("h").printZeroAlways().appendMinutes().appendSuffix("m").appendSeconds().appendSuffix("s").toFormatter();

    public SimpleExecutionState(@UnknownKeyFor @NonNull @Initialized String stateName, @UnknownKeyFor @NonNull @Initialized String urn, @UnknownKeyFor @NonNull @Initialized HashMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> labelsMetadata) {
        super(stateName);
        this.urn = urn;
        this.labelsMetadata = labelsMetadata;
        if (this.labelsMetadata == null) {
            this.labelsMetadata = new HashMap();
        }
    }

    public void reset() {
        this.totalMillis = 0L;
    }

    public @UnknownKeyFor @NonNull @Initialized String getUrn() {
        return this.urn;
    }

    public @UnknownKeyFor @NonNull @Initialized String getTotalMillisShortId(@UnknownKeyFor @NonNull @Initialized ShortIdMap shortIds) {
        if (this.shortId == null) {
            this.shortId = shortIds.getOrCreateShortId(this.getTotalMillisMonitoringMetadata());
        }
        return this.shortId;
    }

    public @UnknownKeyFor @NonNull @Initialized ByteString getTotalMillisPayload() {
        return MonitoringInfoEncodings.encodeInt64Counter(this.getTotalMillis());
    }

    public @UnknownKeyFor @NonNull @Initialized ByteString mergeTotalMillisPayload(@UnknownKeyFor @NonNull @Initialized ByteString other) {
        return MonitoringInfoEncodings.encodeInt64Counter(this.getTotalMillis() + MonitoringInfoEncodings.decodeInt64Counter(other));
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MetricsApi.MonitoringInfo getTotalMillisMonitoringMetadata() {
        SimpleMonitoringInfoBuilder builder = new SimpleMonitoringInfoBuilder();
        builder.setUrn(this.getUrn());
        for (Map.Entry<String, String> entry : this.getLabels().entrySet()) {
            builder.setLabel(entry.getKey(), entry.getValue());
        }
        builder.setType("beam:metrics:sum_int64:v1");
        return builder.build();
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getLabels() {
        return Collections.unmodifiableMap(this.labelsMetadata);
    }

    @Override
    public void takeSample(@UnknownKeyFor @NonNull @Initialized long millisSinceLastSample) {
        this.totalMillis += millisSinceLastSample;
    }

    public @UnknownKeyFor @NonNull @Initialized long getTotalMillis() {
        return this.totalMillis;
    }

    @VisibleForTesting
    public @UnknownKeyFor @NonNull @Initialized String getLullMessage(@UnknownKeyFor @NonNull @Initialized Thread trackedThread, @UnknownKeyFor @NonNull @Initialized Duration millis) {
        StackTraceElement[] fullTrace;
        String userStepName = this.labelsMetadata.getOrDefault("PTRANSFORM", null);
        StringBuilder message = new StringBuilder();
        message.append("Operation ongoing");
        if (userStepName != null) {
            message.append(" in step ").append(userStepName);
        }
        message.append(" for at least ").append(SimpleExecutionState.formatDuration(millis)).append(" without outputting or completing in state ").append(this.getStateName());
        message.append("\n");
        for (StackTraceElement e : fullTrace = trackedThread.getStackTrace()) {
            message.append("  at ").append(e).append("\n");
        }
        return message.toString();
    }

    @Override
    public void reportLull(@UnknownKeyFor @NonNull @Initialized Thread trackedThread, @UnknownKeyFor @NonNull @Initialized long millis) {
        LOG.warn(this.getLullMessage(trackedThread, Duration.millis((long)millis)));
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized String formatDuration(@UnknownKeyFor @NonNull @Initialized Duration duration) {
        return DURATION_FORMATTER.print((ReadablePeriod)duration.toPeriod());
    }
}

