/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.core.SplittableProcessElementInvoker;
import org.apache.beam.sdk.fn.splittabledofn.RestrictionTrackers;
import org.apache.beam.sdk.fn.splittabledofn.WatermarkEstimators;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnOutputReceivers;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.sdk.transforms.splittabledofn.TimestampObservingWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimator;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.OutputBuilderSuppliers;
import org.apache.beam.sdk.util.WindowedValueMultiReceiver;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowedValues;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.Futures;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class OutputAndTimeBoundedSplittableProcessElementInvoker<@UnknownKeyFor InputT, @UnknownKeyFor OutputT, @UnknownKeyFor RestrictionT, @UnknownKeyFor PositionT, @UnknownKeyFor WatermarkEstimatorStateT>
extends SplittableProcessElementInvoker<InputT, OutputT, RestrictionT, PositionT, WatermarkEstimatorStateT> {
    private final @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> fn;
    private final @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions;
    private final @UnknownKeyFor @NonNull @Initialized WindowedValueMultiReceiver outputReceiver;
    private final @UnknownKeyFor @NonNull @Initialized SideInputReader sideInputReader;
    private final @UnknownKeyFor @NonNull @Initialized ScheduledExecutorService executor;
    private final @UnknownKeyFor @NonNull @Initialized int maxNumOutputs;
    private final @UnknownKeyFor @NonNull @Initialized Duration maxDuration;
    private final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized DoFn.BundleFinalizer> bundleFinalizer;
    private final @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainOutputTag;

    public OutputAndTimeBoundedSplittableProcessElementInvoker(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> fn, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, @UnknownKeyFor @NonNull @Initialized WindowedValueMultiReceiver outputReceiver, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainOutputTag, @UnknownKeyFor @NonNull @Initialized SideInputReader sideInputReader, @UnknownKeyFor @NonNull @Initialized ScheduledExecutorService executor, @UnknownKeyFor @NonNull @Initialized int maxNumOutputs, @UnknownKeyFor @NonNull @Initialized Duration maxDuration, @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized DoFn.BundleFinalizer> bundleFinalizer) {
        this.fn = fn;
        this.pipelineOptions = pipelineOptions;
        this.outputReceiver = outputReceiver;
        this.mainOutputTag = mainOutputTag;
        this.sideInputReader = sideInputReader;
        this.executor = executor;
        this.maxNumOutputs = maxNumOutputs;
        this.maxDuration = maxDuration;
        this.bundleFinalizer = bundleFinalizer;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SplittableProcessElementInvoker. @UnknownKeyFor @NonNull @Initialized Result invokeProcessElement(@UnknownKeyFor @NonNull @Initialized DoFnInvoker<InputT, OutputT> invoker, final @UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> element, final @UnknownKeyFor @NonNull @Initialized RestrictionTracker<RestrictionT, PositionT> tracker, @UnknownKeyFor @NonNull @Initialized WatermarkEstimator<WatermarkEstimatorStateT> watermarkEstimator, final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping) {
        final ProcessContext processContext = new ProcessContext(element, tracker, watermarkEstimator);
        DoFn.ProcessContinuation cont = invoker.invokeProcessElement(new DoFnInvoker.BaseArgumentProvider<InputT, OutputT>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized String getErrorContext() {
                return OutputAndTimeBoundedSplittableProcessElementInvoker.class.getSimpleName();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext processContext(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                return processContext;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Object sideInput(@UnknownKeyFor @NonNull @Initialized String tagId) {
                PCollectionView view = (PCollectionView)sideInputMapping.get(tagId);
                if (view == null) {
                    throw new IllegalArgumentException("calling getSideInput() with unknown view");
                }
                return processContext.sideInput(view);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Object restriction() {
                return tracker.currentRestriction();
            }

            @Override
            public InputT element(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                return processContext.element();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Instant timestamp(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                return processContext.timestamp();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String timerId(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                throw new UnsupportedOperationException("Cannot access timerId as parameter outside of @OnTimer method.");
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                throw new UnsupportedOperationException("Access to time domain not supported in ProcessElement");
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<OutputT> outputReceiver(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                return DoFnOutputReceivers.windowedReceiver(processContext, OutputBuilderSuppliers.supplierForElement(element), null);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> outputRowReceiver(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                throw new UnsupportedOperationException("Not supported in SplittableDoFn");
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver taggedOutputReceiver(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                return DoFnOutputReceivers.windowedMultiReceiver(processContext, OutputBuilderSuppliers.supplierForElement(element));
            }

            @Override
            public /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> restrictionTracker() {
                return processContext.tracker;
            }

            @Override
            public /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized WatermarkEstimator<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> watermarkEstimator() {
                return processContext.watermarkEstimator;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions() {
                return OutputAndTimeBoundedSplittableProcessElementInvoker.this.pipelineOptions;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized DoFn.BundleFinalizer bundleFinalizer() {
                return (DoFn.BundleFinalizer)OutputAndTimeBoundedSplittableProcessElementInvoker.this.bundleFinalizer.get();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized StartBundleContext startBundleContext(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                throw new IllegalStateException("Should not access startBundleContext() from @" + DoFn.ProcessElement.class.getSimpleName());
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext finishBundleContext(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                throw new IllegalStateException("Should not access finishBundleContext() from @" + DoFn.ProcessElement.class.getSimpleName());
            }
        });
        processContext.cancelScheduledCheckpoint();
        @Nullable KV<RestrictionT, KV<Instant, WatermarkEstimatorStateT>> residual = processContext.getTakenCheckpoint();
        if (cont.shouldResume()) {
            Preconditions.checkState((!processContext.hasClaimFailed ? 1 : 0) != 0, (Object)"After tryClaim() returned false, @ProcessElement must return stop(), but returned resume()");
            if (residual == null) {
                residual = processContext.takeCheckpointNow();
                processContext.tracker.checkDone();
            } else {
                processContext.tracker.checkDone();
            }
        } else {
            processContext.tracker.checkDone();
        }
        if (residual == null) {
            return new SplittableProcessElementInvoker.Result(null, cont, null, null);
        }
        return new SplittableProcessElementInvoker.Result(residual.getKey(), cont, residual.getValue().getKey(), residual.getValue().getValue());
    }

    private class ProcessContext
    extends DoFn.ProcessContext
    implements RestrictionTrackers.ClaimObserver<PositionT> {
        private final @UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> element;
        private final @UnknownKeyFor @NonNull @Initialized RestrictionTracker<RestrictionT, PositionT> tracker;
        private final @UnknownKeyFor @NonNull @Initialized WatermarkEstimators.WatermarkAndStateObserver<WatermarkEstimatorStateT> watermarkEstimator;
        private @UnknownKeyFor @NonNull @Initialized int numClaimedBlocks;
        private @UnknownKeyFor @NonNull @Initialized boolean hasClaimFailed;
        private @UnknownKeyFor @NonNull @Initialized int numOutputs;
        private @Nullable RestrictionT checkpoint;
        private @Nullable @UnknownKeyFor @Initialized KV<@UnknownKeyFor @NonNull @Initialized Instant, WatermarkEstimatorStateT> residualWatermarkAndState;
        private /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized Future<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> scheduledCheckpoint;

        public ProcessContext(@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> element, @UnknownKeyFor @NonNull @Initialized RestrictionTracker<RestrictionT, PositionT> tracker, WatermarkEstimator<WatermarkEstimatorStateT> watermarkEstimator) {
            super(OutputAndTimeBoundedSplittableProcessElementInvoker.this.fn);
            this.element = element;
            this.tracker = RestrictionTrackers.observe(tracker, this);
            this.watermarkEstimator = WatermarkEstimators.threadSafe(watermarkEstimator);
        }

        @Override
        public void onClaimed(PositionT position) {
            Preconditions.checkState((!this.hasClaimFailed ? 1 : 0) != 0, (Object)"Must not call tryClaim() after it has previously returned false");
            if (this.numClaimedBlocks == 0) {
                this.scheduledCheckpoint = OutputAndTimeBoundedSplittableProcessElementInvoker.this.executor.schedule(this::takeCheckpointNow, OutputAndTimeBoundedSplittableProcessElementInvoker.this.maxDuration.getMillis(), TimeUnit.MILLISECONDS);
            }
            ++this.numClaimedBlocks;
        }

        @Override
        public void onClaimFailed(PositionT position) {
            Preconditions.checkState((!this.hasClaimFailed ? 1 : 0) != 0, (Object)"Must not call tryClaim() after it has previously returned false");
            this.hasClaimFailed = true;
        }

        void cancelScheduledCheckpoint() {
            if (this.scheduledCheckpoint == null) {
                return;
            }
            this.scheduledCheckpoint.cancel(true);
            try {
                Futures.getUnchecked(this.scheduledCheckpoint);
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
        }

        synchronized @UnknownKeyFor @NonNull @Initialized KV<RestrictionT, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Instant, WatermarkEstimatorStateT>> takeCheckpointNow() {
            if (this.checkpoint == null) {
                this.residualWatermarkAndState = this.watermarkEstimator.getWatermarkAndState();
                SplitResult split = this.tracker.trySplit(0.0);
                if (split != null) {
                    this.checkpoint = Preconditions.checkNotNull(split.getResidual());
                }
            }
            return this.getTakenCheckpoint();
        }

        synchronized @Nullable @UnknownKeyFor @Initialized KV<RestrictionT, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Instant, WatermarkEstimatorStateT>> getTakenCheckpoint() {
            return this.checkpoint == null ? null : KV.of(this.checkpoint, this.residualWatermarkAndState);
        }

        @Override
        @Pure
        public InputT element() {
            return this.element.getValue();
        }

        @Override
        @Pure
        public <T> T sideInput(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view) {
            return OutputAndTimeBoundedSplittableProcessElementInvoker.this.sideInputReader.get(view, (BoundedWindow)view.getWindowMappingFn().getSideInputWindow((BoundedWindow)Iterables.getOnlyElement(this.element.getWindows())));
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized Instant timestamp() {
            return this.element.getTimestamp();
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized PaneInfo pane() {
            return this.element.getPaneInfo();
        }

        @Override
        @Pure
        public @Nullable @UnknownKeyFor @Initialized String currentRecordId() {
            return this.element.getRecordId();
        }

        @Override
        @Pure
        public @Nullable @UnknownKeyFor @Initialized Long currentRecordOffset() {
            return this.element.getRecordOffset();
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized PipelineOptions getPipelineOptions() {
            return OutputAndTimeBoundedSplittableProcessElementInvoker.this.pipelineOptions;
        }

        @Override
        public void output(OutputT output) {
            this.outputWithTimestamp(output, this.element.getTimestamp());
        }

        @Override
        public void outputWithTimestamp(OutputT value, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
            this.outputWindowedValue(value, timestamp, this.element.getWindows(), this.element.getPaneInfo());
        }

        @Override
        public void outputWindowedValue(OutputT value, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo) {
            this.noteOutput();
            if (this.watermarkEstimator instanceof TimestampObservingWatermarkEstimator) {
                ((TimestampObservingWatermarkEstimator)((Object)this.watermarkEstimator)).observeTimestamp(timestamp);
            }
            OutputAndTimeBoundedSplittableProcessElementInvoker.this.outputReceiver.output(OutputAndTimeBoundedSplittableProcessElementInvoker.this.mainOutputTag, WindowedValues.of(value, timestamp, windows, paneInfo));
        }

        @Override
        public <T> void output(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag, T value) {
            this.outputWithTimestamp(tag, value, this.element.getTimestamp());
        }

        @Override
        public <T> void outputWithTimestamp(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag, T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
            OutputAndTimeBoundedSplittableProcessElementInvoker.this.outputReceiver.output(tag, WindowedValues.of(value, timestamp, this.element.getWindows(), this.element.getPaneInfo()));
        }

        @Override
        public <T> void outputWindowedValue(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag, T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo) {
            this.noteOutput();
            if (this.watermarkEstimator instanceof TimestampObservingWatermarkEstimator) {
                ((TimestampObservingWatermarkEstimator)((Object)this.watermarkEstimator)).observeTimestamp(timestamp);
            }
            OutputAndTimeBoundedSplittableProcessElementInvoker.this.outputReceiver.output(tag, WindowedValues.of(value, timestamp, windows, paneInfo));
        }

        private void noteOutput() {
            Preconditions.checkState((!this.hasClaimFailed ? 1 : 0) != 0, (Object)"Output is not allowed after a failed tryClaim()");
            Preconditions.checkState((this.numClaimedBlocks > 0 ? 1 : 0) != 0, (Object)"Output is not allowed before tryClaim()");
            ++this.numOutputs;
            if (this.numOutputs >= OutputAndTimeBoundedSplittableProcessElementInvoker.this.maxNumOutputs) {
                this.takeCheckpointNow();
            }
        }
    }
}

