/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.parquet.transforms.input;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.parquet.transforms.input.ParquetField;
import org.apache.hop.parquet.transforms.input.ParquetInput;
import org.apache.hop.parquet.transforms.input.ParquetInputData;
import org.apache.hop.parquet.transforms.input.ParquetReadSupport;
import org.apache.hop.parquet.transforms.input.ParquetReaderBuilder;
import org.apache.hop.parquet.transforms.input.ParquetStream;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;

@Transform(id="ParquetFileInput", image="parquet_input.svg", name="i18n::ParquetInput.Name", description="i18n::ParquetInput.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", documentationUrl="/pipeline/transforms/parquet-file-input.html", keywords={"i18n::ParquetInputMeta.keyword"})
public class ParquetInputMeta
extends BaseTransformMeta<ParquetInput, ParquetInputData> {
    @HopMetadataProperty(key="filename_field")
    private String filenameField;
    @HopMetadataProperty(key="metadata_filename")
    private String metadataFilename;
    @HopMetadataProperty(groupKey="fields", key="field")
    private List<ParquetField> fields = new ArrayList<ParquetField>();

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (this.fields.isEmpty() && StringUtils.isNotEmpty((String)this.metadataFilename)) {
            String filename = variables.resolve(this.metadataFilename);
            try {
                inputRowMeta.addRowMeta(ParquetInputMeta.extractRowMeta(variables, filename));
                return;
            }
            catch (Exception e) {
                throw new HopTransformException((Throwable)e);
            }
        }
        for (ParquetField field : this.fields) {
            try {
                IValueMeta valueMeta = field.createValueMeta();
                valueMeta.setOrigin(name);
                inputRowMeta.addValueMeta(valueMeta);
            }
            catch (HopException e) {
                throw new HopTransformException("Unable to create value metadata of type '" + field.getTargetType() + "'", (Throwable)e);
            }
        }
    }

    public static IRowMeta extractRowMeta(IVariables variables, String filename) throws HopException {
        try {
            FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(filename), (IVariables)variables);
            long size = fileObject.getContent().getSize();
            InputStream inputStream = HopVfs.getInputStream((FileObject)fileObject);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream((int)size);
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            ParquetStream inputFile = new ParquetStream(outputStream.toByteArray(), filename);
            ParquetReadSupport readSupport = new ParquetReadSupport(new ArrayList<ParquetField>());
            ParquetReader reader = new ParquetReaderBuilder<RowMetaAndData>(readSupport, inputFile).build();
            reader.read();
            MessageType schema = readSupport.getMessageType();
            RowMeta rowMeta = new RowMeta();
            List columns = schema.getColumns();
            for (ColumnDescriptor column : columns) {
                Object sourceField = "";
                String[] path = column.getPath();
                if (path.length == 1) {
                    sourceField = path[0];
                } else {
                    for (int i = 0; i < path.length; ++i) {
                        if (i > 0) {
                            sourceField = (String)sourceField + ".";
                        }
                        sourceField = (String)sourceField + path[i];
                    }
                }
                PrimitiveType primitiveType = column.getPrimitiveType();
                int hopType = 2;
                LogicalTypeAnnotation logicalType = primitiveType.getLogicalTypeAnnotation();
                if (logicalType != null) {
                    if (logicalType instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation || logicalType instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation) {
                        hopType = 9;
                    } else if (logicalType instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) {
                        hopType = 3;
                    } else if (logicalType instanceof LogicalTypeAnnotation.JsonLogicalTypeAnnotation) {
                        hopType = 11;
                    } else if (logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                        hopType = 6;
                    } else if (logicalType instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
                        hopType = 5;
                    }
                } else {
                    hopType = switch (primitiveType.getPrimitiveTypeName()) {
                        case PrimitiveType.PrimitiveTypeName.INT32, PrimitiveType.PrimitiveTypeName.INT64 -> 5;
                        case PrimitiveType.PrimitiveTypeName.INT96 -> 8;
                        case PrimitiveType.PrimitiveTypeName.FLOAT, PrimitiveType.PrimitiveTypeName.DOUBLE -> 1;
                        case PrimitiveType.PrimitiveTypeName.BOOLEAN -> 4;
                        case PrimitiveType.PrimitiveTypeName.BINARY -> 8;
                        default -> hopType;
                    };
                }
                IValueMeta valueMeta = ValueMetaFactory.createValueMeta((String)sourceField, (int)hopType, (int)-1, (int)-1);
                rowMeta.addValueMeta(valueMeta);
            }
            return rowMeta;
        }
        catch (Exception e) {
            throw new HopException("Unable to extract row metadata from parquet file '" + filename + "'", (Throwable)e);
        }
    }

    @Generated
    public String getFilenameField() {
        return this.filenameField;
    }

    @Generated
    public String getMetadataFilename() {
        return this.metadataFilename;
    }

    @Generated
    public List<ParquetField> getFields() {
        return this.fields;
    }

    @Generated
    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    @Generated
    public void setMetadataFilename(String metadataFilename) {
        this.metadataFilename = metadataFilename;
    }

    @Generated
    public void setFields(List<ParquetField> fields) {
        this.fields = fields;
    }
}

