/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.avro.coders;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.AvroEncode;
import org.apache.avro.reflect.AvroName;
import org.apache.avro.reflect.AvroSchema;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.Union;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.util.ClassUtils;
import org.apache.avro.util.Utf8;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderProvider;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.extensions.avro.coders.AvroGenericCoder;
import org.apache.beam.sdk.extensions.avro.io.AvroDatumFactory;
import org.apache.beam.sdk.util.EmptyOnDeserializationThreadLocal;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.Cache;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.CacheBuilder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class AvroCoder<@UnknownKeyFor T>
extends CustomCoder<T> {
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @NonNull @Initialized AvroCoderCacheKey, @UnknownKeyFor @NonNull @Initialized AvroCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> AVRO_CODER_CACHE = CacheBuilder.newBuilder().weakValues().build();
    private final @UnknownKeyFor @NonNull @Initialized AvroDatumFactory<T> datumFactory;
    private final @UnknownKeyFor @NonNull @Initialized SerializableSchemaSupplier schemaSupplier;
    private final @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> nonDeterministicReasons;
    private static final @UnknownKeyFor @NonNull @Initialized EncoderFactory ENCODER_FACTORY = EncoderFactory.get();
    private static final @UnknownKeyFor @NonNull @Initialized DecoderFactory DECODER_FACTORY = DecoderFactory.get();
    private final @UnknownKeyFor @NonNull @Initialized EmptyOnDeserializationThreadLocal<@UnknownKeyFor @NonNull @Initialized BinaryDecoder> decoder;
    private final @UnknownKeyFor @NonNull @Initialized EmptyOnDeserializationThreadLocal<@UnknownKeyFor @NonNull @Initialized BinaryEncoder> encoder;
    private final @UnknownKeyFor @NonNull @Initialized EmptyOnDeserializationThreadLocal<@UnknownKeyFor @NonNull @Initialized DatumWriter<T>> writer = null;
    private final @UnknownKeyFor @NonNull @Initialized EmptyOnDeserializationThreadLocal<@UnknownKeyFor @NonNull @Initialized DatumReader<T>> reader = null;
    private transient @UnknownKeyFor @NonNull @Initialized DatumWriter<T> datumWriter;
    private transient @UnknownKeyFor @NonNull @Initialized DatumReader<T> datumReader;

    public static @UnknownKeyFor @NonNull @Initialized AvroCoder<@UnknownKeyFor @NonNull @Initialized GenericRecord> generic(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return AvroGenericCoder.of(schema);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized AvroCoder<T> specific(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> type) {
        return AvroCoder.specific(type.getRawType());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized AvroCoder<T> specific(@UnknownKeyFor @NonNull @Initialized Class<T> type) {
        return AvroCoder.specific(type, new SpecificData(type.getClassLoader()).getSchema(type));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized AvroCoder<T> specific(@UnknownKeyFor @NonNull @Initialized Class<T> type, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        return AvroCoder.fromCacheOrCreate(type, schema, AvroCoderType.SPECIFIC, () -> new AvroCoder(AvroDatumFactory.specific(type), schema));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized AvroCoder<T> reflect(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> type) {
        return AvroCoder.reflect(type.getRawType());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized AvroCoder<T> reflect(@UnknownKeyFor @NonNull @Initialized Class<T> type) {
        return AvroCoder.reflect(type, new ReflectData(type.getClassLoader()).getSchema(type));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized AvroCoder<T> reflect(@UnknownKeyFor @NonNull @Initialized Class<T> type, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        return AvroCoder.fromCacheOrCreate(type, schema, AvroCoderType.REFLECT, () -> new AvroCoder(AvroDatumFactory.reflect(type), schema));
    }

    public static @UnknownKeyFor @NonNull @Initialized AvroGenericCoder of(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return AvroGenericCoder.of(schema);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized AvroCoder<T> of(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> type) {
        return AvroCoder.of(type, true);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized AvroCoder<T> of(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> type, @UnknownKeyFor @NonNull @Initialized boolean useReflectApi) {
        Class clazz = type.getRawType();
        return AvroCoder.of(clazz, useReflectApi);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized AvroCoder<T> of(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        return AvroCoder.of(clazz, true);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized AvroCoder<T> of(@UnknownKeyFor @NonNull @Initialized Class<T> type, @UnknownKeyFor @NonNull @Initialized boolean useReflectApi) {
        if (GenericRecord.class.equals(type)) {
            throw new IllegalArgumentException("AvroCoder for GenericRecord requires a schema");
        }
        if (SpecificRecord.class.isAssignableFrom(type) && !useReflectApi) {
            return AvroCoder.specific(type);
        }
        return AvroCoder.reflect(type);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized AvroCoder<T> of(@UnknownKeyFor @NonNull @Initialized Class<T> type, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        return AvroCoder.of(type, schema, true);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized AvroCoder<T> of(@UnknownKeyFor @NonNull @Initialized AvroDatumFactory<T> datumFactory, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        Optional<AvroCoderType> avroCoderTypeOptional = AvroCoderType.fromDatumFactory(datumFactory);
        if (!avroCoderTypeOptional.isPresent()) {
            return new AvroCoder<T>(datumFactory, schema);
        }
        Class<T> type = datumFactory.getType();
        return AvroCoder.fromCacheOrCreate(type, schema, avroCoderTypeOptional.get(), () -> new AvroCoder(datumFactory, schema));
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized AvroCoder<T> fromCacheOrCreate(@UnknownKeyFor @NonNull @Initialized Class<T> type, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized AvroCoderType avroCoderType, @UnknownKeyFor @NonNull @Initialized Callable<@UnknownKeyFor @NonNull @Initialized AvroCoder<T>> avroCoderCreator) {
        try {
            return (AvroCoder)((Object)AVRO_CODER_CACHE.get((Object)new AvroCoderCacheKey(type, schema, avroCoderType), avroCoderCreator));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized AvroCoder<T> of(@UnknownKeyFor @NonNull @Initialized Class<T> type, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized boolean useReflectApi) {
        if (GenericRecord.class.equals(type)) {
            return AvroCoder.generic(schema);
        }
        if (SpecificRecord.class.isAssignableFrom(type) && !useReflectApi) {
            return AvroCoder.specific(type, schema);
        }
        return AvroCoder.reflect(type, schema);
    }

    public static @UnknownKeyFor @NonNull @Initialized CoderProvider getCoderProvider() {
        return new AvroCoderProvider();
    }

    protected AvroCoder(@UnknownKeyFor @NonNull @Initialized Class<T> type, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        this(type, schema, false);
    }

    protected AvroCoder(@UnknownKeyFor @NonNull @Initialized Class<T> type, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized boolean useReflectApi) {
        this(AvroDatumFactory.of(type, useReflectApi), schema);
    }

    protected AvroCoder(@UnknownKeyFor @NonNull @Initialized AvroDatumFactory<T> datumFactory, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        this.datumFactory = datumFactory;
        this.schemaSupplier = new SerializableSchemaSupplier(schema);
        this.typeDescriptor = TypeDescriptor.of(datumFactory.getType());
        this.nonDeterministicReasons = new AvroDeterminismChecker().check(this.typeDescriptor, schema);
        this.decoder = new EmptyOnDeserializationThreadLocal();
        this.encoder = new EmptyOnDeserializationThreadLocal();
        this.initializeAvroDatumReaderAndWriter();
    }

    public @UnknownKeyFor @NonNull @Initialized Class<T> getType() {
        return this.datumFactory.getType();
    }

    public @UnknownKeyFor @NonNull @Initialized AvroDatumFactory<T> getDatumFactory() {
        return this.datumFactory;
    }

    public @UnknownKeyFor @NonNull @Initialized DatumWriter<T> getDatumWriter() {
        return this.datumWriter;
    }

    public @UnknownKeyFor @NonNull @Initialized DatumReader<T> getDatumReader() {
        return this.datumReader;
    }

    @Deprecated
    public @UnknownKeyFor @NonNull @Initialized boolean useReflectApi() {
        return this.datumFactory instanceof AvroDatumFactory.ReflectDatumFactory;
    }

    public void encode(T value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        BinaryEncoder encoderInstance = ENCODER_FACTORY.directBinaryEncoder(outStream, (BinaryEncoder)this.encoder.get());
        this.encoder.set((Object)encoderInstance);
        this.datumWriter.write(value, (Encoder)encoderInstance);
    }

    public T decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        BinaryDecoder decoderInstance = DECODER_FACTORY.directBinaryDecoder(inStream, (BinaryDecoder)this.decoder.get());
        this.decoder.set((Object)decoderInstance);
        return (T)this.datumReader.read(null, (Decoder)decoderInstance);
    }

    public void verifyDeterministic() throws // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        if (!this.nonDeterministicReasons.isEmpty()) {
            throw new Coder.NonDeterministicException((Coder)this, this.nonDeterministicReasons);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Schema getSchema() {
        return this.schemaSupplier.get();
    }

    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> getEncodedTypeDescriptor() {
        return this.typeDescriptor;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        AvroCoder that = (AvroCoder)((Object)other);
        return Objects.equals(this.typeDescriptor, that.typeDescriptor) && Objects.equals(this.datumFactory, that.datumFactory) && Objects.equals(this.schemaSupplier.get(), that.schemaSupplier.get());
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(((Object)((Object)this)).getClass(), this.typeDescriptor, this.datumFactory, this.schemaSupplier.get());
    }

    private void readObject(@UnknownKeyFor @NonNull @Initialized ObjectInputStream in) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
        in.defaultReadObject();
        Optional<AvroCoder> cachedCoder = AvroCoderType.fromDatumFactory(this.datumFactory).map(avroCoderType -> new AvroCoderCacheKey(this.typeDescriptor.getRawType(), this.schemaSupplier.get(), (AvroCoderType)((Object)avroCoderType))).map(avroCoderCacheKey -> (AvroCoder)((Object)((Object)AVRO_CODER_CACHE.getIfPresent(avroCoderCacheKey))));
        if (cachedCoder.isPresent()) {
            this.datumReader = cachedCoder.get().datumReader;
            this.datumWriter = cachedCoder.get().datumWriter;
        } else {
            this.initializeAvroDatumReaderAndWriter();
        }
    }

    private void initializeAvroDatumReaderAndWriter() {
        this.datumReader = this.datumFactory.apply(this.schemaSupplier.get(), this.schemaSupplier.get());
        this.datumWriter = this.datumFactory.apply(this.schemaSupplier.get());
    }

    static class AvroCoderCacheKey
    implements Serializable {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type;
        private final @UnknownKeyFor @NonNull @Initialized Schema schema;
        private final @UnknownKeyFor @NonNull @Initialized AvroCoderType avroCoderType;

        AvroCoderCacheKey(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized AvroCoderType avroCoderType) {
            this.type = type;
            this.schema = schema;
            this.avroCoderType = avroCoderType;
        }

        public static @UnknownKeyFor @NonNull @Initialized AvroCoderCacheKey specific(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type, @UnknownKeyFor @NonNull @Initialized Schema schema) {
            return new AvroCoderCacheKey(type, schema, AvroCoderType.SPECIFIC);
        }

        public static @UnknownKeyFor @NonNull @Initialized AvroCoderCacheKey reflect(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type, @UnknownKeyFor @NonNull @Initialized Schema schema) {
            return new AvroCoderCacheKey(type, schema, AvroCoderType.REFLECT);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AvroCoderCacheKey that = (AvroCoderCacheKey)o;
            return Objects.equals(this.type, that.type) && Objects.equals(this.schema, that.schema) && Objects.equals((Object)this.avroCoderType, (Object)that.avroCoderType);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(new Object[]{this.type, this.schema, this.avroCoderType});
        }
    }

    static enum AvroCoderType {
        SPECIFIC,
        REFLECT;


        public static @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized AvroCoderType> fromDatumFactory(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AvroDatumFactory<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> datumFactory) {
            if (AvroDatumFactory.ReflectDatumFactory.class.equals(datumFactory.getClass())) {
                return Optional.of(REFLECT);
            }
            if (AvroDatumFactory.SpecificDatumFactory.class.equals(datumFactory.getClass())) {
                return Optional.of(SPECIFIC);
            }
            return Optional.empty();
        }
    }

    private static class AvroDeterminismChecker {
        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> reasons = new ArrayList<String>();
        private /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> activeTypes = new HashSet();
        private @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Schema> activeSchemas = new HashSet<Schema>();
        private static final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> DETERMINISTIC_STRINGABLE_CLASSES = new HashSet();
        private static final @UnknownKeyFor @NonNull @Initialized Schema AVRO_NULL_SCHEMA;

        @FormatMethod
        private void reportError(@UnknownKeyFor @NonNull @Initialized String context, @FormatString @UnknownKeyFor @NonNull @Initialized String fmt, Object ... args) {
            String message = String.format(fmt, args);
            this.reasons.add(context + ": " + message);
        }

        private static @UnknownKeyFor @NonNull @Initialized boolean isSubtypeOf(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type, Class<?> ... parents) {
            for (Class<?> parent : parents) {
                if (!type.isSubtypeOf(TypeDescriptor.of(parent))) continue;
                return true;
            }
            return false;
        }

        protected AvroDeterminismChecker() {
        }

        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> check(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type, @UnknownKeyFor @NonNull @Initialized Schema schema) {
            this.recurse(type.getRawType().getName(), type, schema);
            return this.reasons;
        }

        private void recurse(@UnknownKeyFor @NonNull @Initialized String context, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type, @UnknownKeyFor @NonNull @Initialized Schema schema) {
            if (type.getRawType().isAnnotationPresent(AvroSchema.class)) {
                this.reportError(context, "Custom schemas are not supported -- remove @AvroSchema.", new Object[0]);
                return;
            }
            if (!this.activeTypes.add(type)) {
                this.reportError(context, "%s appears recursively", type);
                return;
            }
            if (AvroDeterminismChecker.isSubtypeOf(type, IndexedRecord.class)) {
                this.checkIndexedRecord(context, schema, null);
            } else {
                this.doCheck(context, type, schema);
            }
            this.activeTypes.remove(type);
        }

        private void doCheck(@UnknownKeyFor @NonNull @Initialized String context, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type, @UnknownKeyFor @NonNull @Initialized Schema schema) {
            switch (schema.getType()) {
                case ARRAY: {
                    this.checkArray(context, type, schema);
                    break;
                }
                case ENUM: {
                    break;
                }
                case FIXED: {
                    this.reportError(context, "FIXED encodings are not guaranteed to be deterministic", new Object[0]);
                    break;
                }
                case MAP: {
                    this.checkMap(context, type, schema);
                    break;
                }
                case RECORD: {
                    if (!(type.getType() instanceof Class)) {
                        this.reportError(context, "Cannot determine type from generic %s due to erasure", type);
                        return;
                    }
                    this.checkRecord(type, schema);
                    break;
                }
                case UNION: {
                    this.checkUnion(context, type, schema);
                    break;
                }
                case STRING: {
                    this.checkString(context, type);
                    break;
                }
                case BOOLEAN: 
                case BYTES: 
                case DOUBLE: 
                case INT: 
                case FLOAT: 
                case LONG: 
                case NULL: {
                    break;
                }
                default: {
                    this.reportError(context, "Unknown schema type %s may be non-deterministic", schema.getType());
                }
            }
        }

        private void checkString(@UnknownKeyFor @NonNull @Initialized String context, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type) {
            if (!DETERMINISTIC_STRINGABLE_CLASSES.contains(type.getRawType())) {
                this.reportError(context, "%s may not have deterministic #toString()", type);
            }
        }

        private void checkUnion(@UnknownKeyFor @NonNull @Initialized String context, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type, @UnknownKeyFor @NonNull @Initialized Schema schema) {
            List unionTypes = schema.getTypes();
            if (!type.getRawType().isAnnotationPresent(Union.class)) {
                if (unionTypes.size() == 2 && unionTypes.contains(AVRO_NULL_SCHEMA)) {
                    Schema nullableFieldSchema = ((Schema)unionTypes.get(0)).equals((Object)AVRO_NULL_SCHEMA) ? (Schema)unionTypes.get(1) : (Schema)unionTypes.get(0);
                    this.doCheck(context, type, nullableFieldSchema);
                    return;
                }
                this.reportError(context, "Expected type %s to have @Union annotation", type);
                return;
            }
            String baseClassContext = type.getRawType().getName();
            for (Schema concrete : unionTypes) {
                TypeDescriptor unionType = TypeDescriptor.of((Class)ReflectData.get().getClass(concrete));
                this.recurse(baseClassContext, unionType, concrete);
            }
        }

        private void checkRecord(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type, @UnknownKeyFor @NonNull @Initialized Schema schema) {
            Class clazz = type.getRawType();
            for (Schema.Field fieldSchema : schema.getFields()) {
                Field field = AvroDeterminismChecker.getField(clazz, fieldSchema.name());
                String fieldContext = field.getDeclaringClass().getName() + "#" + field.getName();
                if (field.isAnnotationPresent(AvroEncode.class)) {
                    this.reportError(fieldContext, "Custom encoders may be non-deterministic -- remove @AvroEncode", new Object[0]);
                    continue;
                }
                if (!IndexedRecord.class.isAssignableFrom(field.getType()) && field.isAnnotationPresent(AvroSchema.class)) {
                    this.reportError(fieldContext, "Custom schemas are only supported for subtypes of IndexedRecord.", new Object[0]);
                    continue;
                }
                TypeDescriptor fieldType = type.resolveType(field.getGenericType());
                this.recurse(fieldContext, fieldType, fieldSchema.schema());
            }
        }

        private void checkIndexedRecord(@UnknownKeyFor @NonNull @Initialized String context, @UnknownKeyFor @NonNull @Initialized Schema schema, @Nullable @UnknownKeyFor @Initialized String specificClassStr) {
            if (!this.activeSchemas.add(schema)) {
                this.reportError(context, "%s appears recursively", schema.getName());
                return;
            }
            switch (schema.getType()) {
                case ARRAY: {
                    this.checkIndexedRecord(context, schema.getElementType(), null);
                    break;
                }
                case ENUM: {
                    break;
                }
                case FIXED: {
                    break;
                }
                case MAP: {
                    this.reportError(context, "GenericRecord and SpecificRecords use a HashMap to represent MAPs, so it is non-deterministic", new Object[0]);
                    break;
                }
                case RECORD: {
                    for (Schema.Field field : schema.getFields()) {
                        this.checkIndexedRecord(schema.getName() + "." + field.name(), field.schema(), field.getProp("java-class"));
                    }
                    break;
                }
                case STRING: {
                    if (specificClassStr == null) break;
                    try {
                        Class specificClass = ClassUtils.forName((String)specificClassStr);
                        if (DETERMINISTIC_STRINGABLE_CLASSES.contains(specificClass)) break;
                        this.reportError(context, "Specific class %s is not known to be deterministic", specificClassStr);
                    }
                    catch (ClassNotFoundException e) {
                        this.reportError(context, "Specific class %s is not known to be deterministic", specificClassStr);
                    }
                    break;
                }
                case UNION: {
                    for (Schema subschema : schema.getTypes()) {
                        this.checkIndexedRecord(subschema.getName(), subschema, null);
                    }
                    break;
                }
                case BOOLEAN: 
                case BYTES: 
                case DOUBLE: 
                case INT: 
                case FLOAT: 
                case LONG: 
                case NULL: {
                    break;
                }
                default: {
                    this.reportError(context, "Unknown schema type %s may be non-deterministic", schema.getType());
                }
            }
            this.activeSchemas.remove(schema);
        }

        private void checkMap(@UnknownKeyFor @NonNull @Initialized String context, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type, @UnknownKeyFor @NonNull @Initialized Schema schema) {
            Class keyType;
            if (!AvroDeterminismChecker.isSubtypeOf(type, SortedMap.class)) {
                this.reportError(context, "%s may not be deterministically ordered", type);
            }
            if (!String.class.equals((Object)(keyType = type.resolveType(Map.class.getTypeParameters()[0]).getRawType()))) {
                this.reportError(context, "map keys should be Strings, but was %s", keyType);
            }
            this.recurse(context, type.resolveType(Map.class.getTypeParameters()[1]), schema.getValueType());
        }

        /*
         * Enabled aggressive block sorting
         */
        private void checkArray(@UnknownKeyFor @NonNull @Initialized String context, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type, @UnknownKeyFor @NonNull @Initialized Schema schema) {
            TypeDescriptor elementType = null;
            if (type.isArray()) {
                elementType = type.getComponentType();
            } else {
                if (!AvroDeterminismChecker.isSubtypeOf(type, Collection.class)) {
                    this.reportError(context, "encoding %s as an ARRAY was unexpected", type);
                    return;
                }
                if (!AvroDeterminismChecker.isSubtypeOf(type, List.class, SortedSet.class)) {
                    this.reportError(context, "%s may not be deterministically ordered", type);
                    return;
                }
                elementType = type.resolveType(Collection.class.getTypeParameters()[0]);
            }
            this.recurse(context, elementType, schema.getElementType());
        }

        private static @UnknownKeyFor @NonNull @Initialized Field getField(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> originalClazz, @UnknownKeyFor @NonNull @Initialized String name) {
            for (Class<?> clazz = originalClazz; clazz != null; clazz = clazz.getSuperclass()) {
                for (Field field : clazz.getDeclaredFields()) {
                    AvroName avroName = field.getAnnotation(AvroName.class);
                    if (avroName != null && name.equals(avroName.value())) {
                        return field;
                    }
                    if (avroName != null || !name.equals(field.getName())) continue;
                    return field;
                }
            }
            throw new IllegalArgumentException("Unable to get field " + name + " from " + originalClazz);
        }

        static {
            DETERMINISTIC_STRINGABLE_CLASSES.add(String.class);
            DETERMINISTIC_STRINGABLE_CLASSES.add(Utf8.class);
            DETERMINISTIC_STRINGABLE_CLASSES.add(BigDecimal.class);
            DETERMINISTIC_STRINGABLE_CLASSES.add(BigInteger.class);
            DETERMINISTIC_STRINGABLE_CLASSES.add(URI.class);
            DETERMINISTIC_STRINGABLE_CLASSES.add(URL.class);
            AVRO_NULL_SCHEMA = Schema.create((Schema.Type)Schema.Type.NULL);
        }
    }

    static class SerializableSchemaSupplier
    implements Serializable,
    Supplier<Schema> {
        @SuppressFBWarnings(value={"SE_BAD_FIELD"})
        private final @UnknownKeyFor @NonNull @Initialized Schema schema;

        private SerializableSchemaSupplier(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            this.schema = schema;
        }

        private @UnknownKeyFor @NonNull @Initialized Object writeReplace() {
            return new SerializableSchemaString(this.schema.toString());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Schema get() {
            return this.schema;
        }
    }

    private static class SerializableSchemaString
    implements Serializable {
        private final @UnknownKeyFor @NonNull @Initialized String schema;

        private SerializableSchemaString(@UnknownKeyFor @NonNull @Initialized String schema) {
            this.schema = schema;
        }

        private @UnknownKeyFor @NonNull @Initialized Object readResolve() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
            return new SerializableSchemaSupplier(new Schema.Parser().parse(this.schema));
        }
    }

    static class AvroCoderProvider
    extends CoderProvider {
        AvroCoderProvider() {
        }

        public <T> @UnknownKeyFor @NonNull @Initialized Coder<T> coderFor(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> componentCoders) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
            try {
                return AvroCoder.of(typeDescriptor);
            }
            catch (AvroRuntimeException e) {
                throw new CannotProvideCoderException(String.format("%s is not compatible with Avro", typeDescriptor), (Throwable)e);
            }
        }
    }
}

