/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mergerows;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopRowException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transform.stream.Stream;
import org.apache.hop.pipeline.transform.stream.StreamIcon;
import org.apache.hop.pipeline.transforms.mergerows.MergeRows;
import org.apache.hop.pipeline.transforms.mergerows.MergeRowsData;

@Transform(id="MergeRows", image="mergerows.svg", name="i18n::MergeRows.Name", description="i18n::MergeRows.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Joins", keywords={"i18n::MergeRowsMeta.keyword"}, documentationUrl="/pipeline/transforms/mergerows.html")
public class MergeRowsMeta
extends BaseTransformMeta<MergeRows, MergeRowsData> {
    private static final Class<?> PKG = MergeRowsMeta.class;
    @HopMetadataProperty(key="flag_field", injectionKey="FLAG_FIELD", injectionKeyDescription="MergeRows.Injection.FLAG_FIELD")
    private String flagField;
    @HopMetadataProperty(key="key", groupKey="keys", injectionKey="KEY_FIELDS", injectionKeyDescription="MergeRows.Injection.KEY_FIELD", injectionGroupDescription="MergeRows.Injection.KEY_FIELDS")
    private List<String> keyFields;
    @HopMetadataProperty(key="value", groupKey="values", injectionKey="VALUE_FIELDS", injectionKeyDescription="MergeRows.Injection.VALUE_FIELD", injectionGroupDescription="MergeRows.Injection.VALUE_FIELDS")
    private List<String> valueFields;
    @HopMetadataProperty(key="reference", injectionKey="REFERENCE_TRANSFORM", injectionKeyDescription="MergeRowsMeta.InfoStream.FirstStream.Description")
    private String referenceTransform;
    @HopMetadataProperty(key="compare", injectionKey="COMPARE_TRANSFORM", injectionKeyDescription="MergeRowsMeta.InfoStream.SecondStream.Description")
    private String compareTransform;
    @HopMetadataProperty(key="diff-field", injectionKey="DIFF_FIELD", injectionKeyDescription="MergeRows.Injection.DIFF_FIELD")
    private String diffJsonField;

    public MergeRowsMeta() {
        this.keyFields = new ArrayList<String>();
        this.valueFields = new ArrayList<String>();
    }

    public MergeRowsMeta(MergeRowsMeta m) {
        this.flagField = m.flagField;
        this.keyFields = new ArrayList<String>(m.keyFields);
        this.valueFields = new ArrayList<String>(m.valueFields);
        this.referenceTransform = m.referenceTransform;
        this.compareTransform = m.compareTransform;
    }

    public MergeRowsMeta clone() {
        return new MergeRowsMeta(this);
    }

    public void setDefault() {
        this.flagField = "flagfield";
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        List infoStreams = this.getTransformIOMeta().getInfoStreams();
        for (IStream stream : infoStreams) {
            stream.setTransformMeta(TransformMeta.findTransform(transforms, (String)stream.getSubject()));
        }
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (info != null) {
            boolean found = false;
            for (int i = 0; i < info.length && !found; ++i) {
                if (info[i] == null) continue;
                r.mergeRowMeta(info[i], name);
                found = true;
            }
        }
        if (Utils.isEmpty((CharSequence)this.flagField)) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"MergeRowsMeta.Exception.FlagFieldNotSpecified", (String[])new String[0]));
        }
        if (StringUtils.isNotEmpty((String)variables.resolve(this.diffJsonField))) {
            ValueMetaString diffField = new ValueMetaString(variables.resolve(this.diffJsonField));
            diffField.setOrigin(name);
            r.addValueMeta((IValueMeta)diffField);
        }
        ValueMetaString flagFieldValue = new ValueMetaString(this.flagField);
        flagFieldValue.setOrigin(name);
        r.addValueMeta((IValueMeta)flagFieldValue);
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        List infoStreams = this.getTransformIOMeta().getInfoStreams();
        IStream referenceStream = (IStream)infoStreams.get(0);
        IStream compareStream = (IStream)infoStreams.get(1);
        if (referenceStream.getTransformName() != null && compareStream.getTransformName() != null) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MergeRowsMeta.CheckResult.SourceTransformsOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else if (referenceStream.getTransformName() == null && compareStream.getTransformName() == null) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MergeRowsMeta.CheckResult.SourceTransformsMissing", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MergeRowsMeta.CheckResult.OneSourceTransformMissing", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        IRowMeta referenceRowMeta = null;
        IRowMeta compareRowMeta = null;
        try {
            referenceRowMeta = pipelineMeta.getPrevTransformFields(variables, referenceStream.getTransformName());
            compareRowMeta = pipelineMeta.getPrevTransformFields(variables, compareStream.getTransformName());
        }
        catch (HopTransformException kse) {
            new CheckResult(4, BaseMessages.getString(PKG, (String)"MergeRowsMeta.CheckResult.ErrorGettingPrevTransformFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
        }
        if (referenceRowMeta != null && compareRowMeta != null) {
            boolean rowsMatch = false;
            try {
                MergeRows.checkInputLayoutValid(referenceRowMeta, compareRowMeta);
                rowsMatch = true;
            }
            catch (HopRowException hopRowException) {
                // empty catch block
            }
            if (rowsMatch) {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MergeRowsMeta.CheckResult.RowDefinitionMatch", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MergeRowsMeta.CheckResult.RowDefinitionNotMatch", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
    }

    public ITransformIOMeta getTransformIOMeta() {
        ITransformIOMeta ioMeta = super.getTransformIOMeta(false);
        if (ioMeta == null) {
            ioMeta = new TransformIOMeta(true, true, false, false, false, false);
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"MergeRowsMeta.InfoStream.FirstStream.Description", (String[])new String[0]), StreamIcon.INFO, this.referenceTransform));
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"MergeRowsMeta.InfoStream.SecondStream.Description", (String[])new String[0]), StreamIcon.INFO, this.compareTransform));
            this.setTransformIOMeta(ioMeta);
        }
        return ioMeta;
    }

    public PipelineMeta.PipelineType[] getSupportedPipelineTypes() {
        return new PipelineMeta.PipelineType[]{PipelineMeta.PipelineType.Normal};
    }

    @Generated
    public String getFlagField() {
        return this.flagField;
    }

    @Generated
    public List<String> getKeyFields() {
        return this.keyFields;
    }

    @Generated
    public List<String> getValueFields() {
        return this.valueFields;
    }

    @Generated
    public String getReferenceTransform() {
        return this.referenceTransform;
    }

    @Generated
    public String getCompareTransform() {
        return this.compareTransform;
    }

    @Generated
    public String getDiffJsonField() {
        return this.diffJsonField;
    }

    @Generated
    public void setFlagField(String flagField) {
        this.flagField = flagField;
    }

    @Generated
    public void setKeyFields(List<String> keyFields) {
        this.keyFields = keyFields;
    }

    @Generated
    public void setValueFields(List<String> valueFields) {
        this.valueFields = valueFields;
    }

    @Generated
    public void setReferenceTransform(String referenceTransform) {
        this.referenceTransform = referenceTransform;
    }

    @Generated
    public void setCompareTransform(String compareTransform) {
        this.compareTransform = compareTransform;
    }

    @Generated
    public void setDiffJsonField(String diffJsonField) {
        this.diffJsonField = diffJsonField;
    }
}

