/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing.xp;

import java.util.Map;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.testing.PipelineUnitTest;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;

@ExtensionPoint(extensionPointId="HopGuiPipelineMetaExecutionStart", id="HopGuiFlagUnitTestExtensionPoint", description="Change the pipeline variables prior to execution but only in HopGui")
public class HopGuiFlagUnitTestExtensionPoint
implements IExtensionPoint<PipelineMeta> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, PipelineMeta pipelineMeta) throws HopException {
        HopGuiPipelineGraph activePipelineGraph = HopGui.getActivePipelineGraph();
        if (activePipelineGraph == null) {
            return;
        }
        PipelineUnitTest unitTest = null;
        Map stateMap = activePipelineGraph.getStateMap();
        if (stateMap != null) {
            unitTest = (PipelineUnitTest)stateMap.get("ActiveUnitTest");
        }
        if (unitTest == null) {
            return;
        }
        String unitTestName = unitTest.getName();
        if (!StringUtil.isEmpty((String)unitTestName)) {
            variables.setVariable("__UnitTest_Run__", "Y");
            variables.setVariable("__UnitTest_Name__", unitTestName);
        }
    }
}

