/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.util;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.beam.runners.core.InMemoryMultimapSideInputView;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.spark.util.SideInputBroadcast;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class SparkSideInputReader
implements SideInputReader {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized SideInputBroadcast<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> sideInputs;

    public SparkSideInputReader(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized SideInputBroadcast<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> sideInputs) {
        this.sideInputs = sideInputs;
    }

    @Pure
    public <T> @Nullable T get(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
        Preconditions.checkNotNull(view, (Object)"The PCollectionView passed to sideInput cannot be null ");
        KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>> windowedBroadcastHelper = this.sideInputs.get(view.getTagInternal());
        Preconditions.checkNotNull(windowedBroadcastHelper, (String)"SideInput for view %s is not available.", view);
        BoundedWindow sideInputWindow = view.getWindowMappingFn().getSideInputWindow(window);
        SideInputBroadcast sideInputBroadcast = (SideInputBroadcast)windowedBroadcastHelper.getValue();
        Iterable availableSideInputs = (Iterable)sideInputBroadcast.getValue();
        Stream<WindowedValue<?>> stream = StreamSupport.stream(availableSideInputs.spliterator(), false).filter(sideInputCandidate -> {
            if (sideInputCandidate == null) {
                return false;
            }
            return Iterables.contains((Iterable)sideInputCandidate.getWindows(), (Object)sideInputWindow);
        });
        List<?> sideInputForWindow = this.getSideInputForWindow(sideInputBroadcast.getSparkPCollectionViewType(), stream);
        switch (view.getViewFn().getMaterialization().getUrn()) {
            case "beam:side_input:iterable:v1": {
                ViewFn viewFn = view.getViewFn();
                return (T)viewFn.apply(() -> sideInputForWindow);
            }
            case "beam:side_input:multimap:v1": {
                ViewFn viewFn = view.getViewFn();
                Coder keyCoder = ((KvCoder)view.getCoderInternal()).getKeyCoder();
                return (T)viewFn.apply((Object)InMemoryMultimapSideInputView.fromIterable((Coder)keyCoder, sideInputForWindow));
            }
        }
        throw new IllegalStateException(String.format("Unknown side input materialization format requested '%s'", view.getViewFn().getMaterialization().getUrn()));
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> getSideInputForWindow( @UnknownKeyFor @NonNull @Initialized SparkPCollectionView.Type sparkPCollectionViewType, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Stream<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> stream) {
        switch (sparkPCollectionViewType) {
            case STATIC: {
                return stream.map(WindowedValue::getValue).collect(Collectors.toList());
            }
            case STREAMING: {
                return stream.flatMap(windowedValue -> {
                    Object value = windowedValue.getValue();
                    if (value instanceof List) {
                        List list = (List)value;
                        return list.stream();
                    }
                    return Stream.of(value);
                }).collect(Collectors.toList());
            }
        }
        throw new IllegalStateException(String.format("Unknown pcollection view type %s", new Object[]{sparkPCollectionViewType}));
    }

    @Pure
    public <T> @UnknownKeyFor @NonNull @Initialized boolean contains(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view) {
        return this.sideInputs.containsKey(view.getTagInternal());
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
        return this.sideInputs != null && this.sideInputs.isEmpty();
    }
}

