/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.coders;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.apache.beam.runners.spark.util.ByteArray;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Function;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.spark.api.java.function.PairFunction;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import scala.Tuple2;

public final class CoderHelpers {
    private CoderHelpers() {
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray(T value, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            coder.encode(value, (OutputStream)baos);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error encoding value: " + value, e);
        }
        return baos.toByteArray();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArrayWithTs(T value, @UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            coder.encode(value, (OutputStream)baos);
            ByteBuffer buf = ByteBuffer.allocate(8);
            buf.asLongBuffer().put(timestamp.getMillis());
            baos.write(buf.array());
        }
        catch (IOException e) {
            throw new IllegalStateException("Error encoding value: " + value, e);
        }
        return baos.toByteArray();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> toByteArrays(@UnknownKeyFor @NonNull @Initialized Iterable<T> values, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        ArrayList<byte[]> res = new ArrayList<byte[]>();
        for (T value : values) {
            res.add(CoderHelpers.toByteArray(value, coder));
        }
        return res;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> toByteArrays(@UnknownKeyFor @NonNull @Initialized Iterator<T> values, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        ArrayList<byte[]> res = new ArrayList<byte[]>();
        while (values.hasNext()) {
            T value = values.next();
            res.add(CoderHelpers.toByteArray(value, coder));
        }
        return res;
    }

    public static <T> T fromByteArray(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] serialized, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        ByteArrayInputStream bais = new ByteArrayInputStream(serialized);
        try {
            return (T)coder.decode((InputStream)bais);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error decoding bytes for coder: " + coder, e);
        }
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Iterable<T> fromByteArrays(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> serialized, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        return serialized.stream().map(bytes -> CoderHelpers.fromByteArray((byte[])Preconditions.checkNotNull((Object)bytes, (Object)"Cannot decode null values."), coder)).collect(Collectors.toList());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized org.apache.spark.api.java.function.Function<T, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> toByteFunction(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        return (org.apache.spark.api.java.function.Function & Serializable)t -> CoderHelpers.toByteArray(t, coder);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized org.apache.spark.api.java.function.Function<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], T> fromByteFunction(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        return (org.apache.spark.api.java.function.Function & Serializable)bytes -> CoderHelpers.fromByteArray(bytes, coder);
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized PairFunction<@UnknownKeyFor @NonNull @Initialized Tuple2<K, V>, @UnknownKeyFor @NonNull @Initialized ByteArray, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> toByteFunction(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
        return (PairFunction & Serializable)kv -> new Tuple2((Object)new ByteArray(CoderHelpers.toByteArray(kv._1(), keyCoder)), (Object)CoderHelpers.toByteArray(kv._2(), valueCoder));
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized PairFunction<@UnknownKeyFor @NonNull @Initialized Tuple2<K, V>, @UnknownKeyFor @NonNull @Initialized ByteArray, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> toByteFunctionWithTs(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder, @UnknownKeyFor @NonNull @Initialized org.apache.spark.api.java.function.Function<@UnknownKeyFor @NonNull @Initialized Tuple2<K, V>, @UnknownKeyFor @NonNull @Initialized Instant> timestamp) {
        return (PairFunction & Serializable)kv -> new Tuple2((Object)new ByteArray(CoderHelpers.toByteArrayWithTs(kv._1(), keyCoder, (Instant)timestamp.call(kv))), (Object)CoderHelpers.toByteArray(kv._2(), valueCoder));
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized PairFunction<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized ByteArray, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>>, K, @UnknownKeyFor @NonNull @Initialized Iterable<V>> fromByteFunctionIterable(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
        return (PairFunction & Serializable)tuple -> new Tuple2(CoderHelpers.fromByteArray(((ByteArray)tuple._1()).getValue(), keyCoder), (Object)StreamSupport.stream(((Iterable)tuple._2()).spliterator(), false).map(bytes -> CoderHelpers.fromByteArray(bytes, valueCoder)).collect(Collectors.toList()));
    }

    public static class FromByteFunction<@UnknownKeyFor K, @UnknownKeyFor V>
    implements PairFunction<Tuple2<ByteArray, byte[]>, K, V>,
    Function<Tuple2<ByteArray, byte[]>, Tuple2<K, V>> {
        private final @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
        private final @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder;

        public FromByteFunction(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
            this.keyCoder = keyCoder;
            this.valueCoder = valueCoder;
        }

        public @UnknownKeyFor @NonNull @Initialized Tuple2<K, V> call(@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized ByteArray, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> tuple) {
            return new Tuple2(CoderHelpers.fromByteArray(((ByteArray)tuple._1()).getValue(), this.keyCoder), CoderHelpers.fromByteArray((byte[])tuple._2(), this.valueCoder));
        }

        @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="https://github.com/google/guava/issues/920")
        public @UnknownKeyFor @NonNull @Initialized Tuple2<K, V> apply(@Nonnull @UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized ByteArray, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> tuple) {
            return this.call(tuple);
        }
    }
}

