/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.vault.response;

import com.bettercloud.vault.json.Json;
import com.bettercloud.vault.json.JsonArray;
import com.bettercloud.vault.json.JsonObject;
import com.bettercloud.vault.json.JsonValue;
import com.bettercloud.vault.json.ParseException;
import com.bettercloud.vault.response.VaultResponse;
import com.bettercloud.vault.rest.RestResponse;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class AuthResponse
extends VaultResponse {
    private Boolean renewable;
    private String authClientToken;
    private List<String> authPolicies;
    private long authLeaseDuration;
    private boolean authRenewable;
    private String appId;
    private String userId;
    private String username;

    public AuthResponse(RestResponse restResponse, int retries) {
        super(restResponse, retries);
        try {
            String responseJson = new String(restResponse.getBody(), "UTF-8");
            JsonObject jsonObject = Json.parse(responseJson).asObject();
            JsonObject authJsonObject = jsonObject.get("auth").asObject();
            this.renewable = jsonObject.get("renewable").asBoolean();
            this.authLeaseDuration = authJsonObject.getInt("lease_duration", 0);
            this.authRenewable = authJsonObject.getBoolean("renewable", false);
            if (authJsonObject.get("metadata") != null && !authJsonObject.get("metadata").toString().equalsIgnoreCase("null")) {
                JsonObject metadata = authJsonObject.get("metadata").asObject();
                this.appId = metadata.getString("app-id", "");
                this.userId = metadata.getString("user-id", "");
                this.username = metadata.getString("username", "");
            }
            this.authClientToken = authJsonObject.getString("client_token", "");
            JsonArray authPoliciesJsonArray = authJsonObject.get("policies").asArray();
            this.authPolicies = new ArrayList<String>();
            for (JsonValue authPolicy : authPoliciesJsonArray) {
                this.authPolicies.add(authPolicy.asString());
            }
        }
        catch (ParseException | UnsupportedEncodingException exception) {
            // empty catch block
        }
    }

    public String getUsername() {
        return this.username;
    }

    public Boolean getRenewable() {
        return this.renewable;
    }

    public String getAuthClientToken() {
        return this.authClientToken;
    }

    public List<String> getAuthPolicies() {
        return this.authPolicies;
    }

    public long getAuthLeaseDuration() {
        return this.authLeaseDuration;
    }

    public boolean isAuthRenewable() {
        return this.authRenewable;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getUserId() {
        return this.userId;
    }
}

