/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsendnsca;

import com.googlecode.jsendnsca.Level;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class MessagePayload
implements Serializable {
    private static final long serialVersionUID = 6014395299584333124L;
    private static final String DEFAULT_SERVICENAME = "UNDEFINED";
    private String hostname;
    private Level level = Level.UNKNOWN;
    private String serviceName = "UNDEFINED";
    private String message = "";

    public MessagePayload() {
        this.useLocalHostname();
    }

    public MessagePayload(String hostname, Level level, String serviceName, String message) {
        Validate.notEmpty((String)hostname, (String)"hostname cannot be null or an empty String");
        Validate.notEmpty((String)serviceName, (String)"serviceName cannot be null or an empty String");
        this.hostname = hostname;
        this.level = level;
        this.serviceName = serviceName;
        this.message = message;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void useLocalHostname() {
        this.setHostname(false);
    }

    public void setHostname(boolean useCanonical) {
        InetAddress ipAddress;
        try {
            ipAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new UnknownHostRuntimeException(e);
        }
        this.hostname = useCanonical ? ipAddress.getCanonicalHostName() : ipAddress.getHostName();
    }

    public void setHostname(String hostname) {
        Validate.notEmpty((String)hostname, (String)"hostname cannot be null or an empty String");
        this.hostname = hostname;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = Level.tolevel(level);
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        Validate.notEmpty((String)serviceName, (String)"serviceName cannot be null or an empty String");
        this.serviceName = serviceName;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int hashCode() {
        return new HashCodeBuilder(21, 57).append((Object)this.hostname).append((Object)this.level).append((Object)this.serviceName).append((Object)this.message).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MessagePayload)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        MessagePayload other = (MessagePayload)obj;
        return new EqualsBuilder().append((Object)this.hostname, (Object)other.hostname).append((Object)this.level, (Object)other.level).append((Object)this.serviceName, (Object)other.serviceName).append((Object)this.message, (Object)other.message).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("level", (Object)this.level).append("hostname", (Object)this.hostname).append("serviceName", (Object)this.serviceName).append("message", (Object)this.message).toString();
    }

    public static class UnknownHostRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = 6164363358198216472L;

        public UnknownHostRuntimeException(UnknownHostException e) {
            super(e);
        }
    }
}

