/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.edi2xml;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.edi2xml.Edi2XmlData;
import org.apache.hop.pipeline.transforms.edi2xml.Edi2XmlMeta;
import org.apache.hop.pipeline.transforms.edi2xml.grammar.FastSimpleGenericEdifactDirectXMLLexer;
import org.apache.hop.pipeline.transforms.edi2xml.grammar.FastSimpleGenericEdifactDirectXMLParser;

public class Edi2Xml
extends BaseTransform<Edi2XmlMeta, Edi2XmlData> {
    private static final Class<?> PKG = Edi2XmlMeta.class;
    private static final String CONST_UNKNOWN = "<UNKNOWN>";
    private static final String CONST_PROBLEM_LINE = "Problem line: ";
    private FastSimpleGenericEdifactDirectXMLLexer lexer;
    private CommonTokenStream tokens;
    private FastSimpleGenericEdifactDirectXMLParser parser;

    public Edi2Xml(TransformMeta transformMeta, Edi2XmlMeta meta, Edi2XmlData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        StringBuilder errorMessage;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        String inputValue = "";
        if (this.first) {
            this.first = false;
            ((Edi2XmlData)this.data).inputRowMeta = this.getInputRowMeta().clone();
            ((Edi2XmlData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((Edi2XmlMeta)this.meta).getFields(((Edi2XmlData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            String realInputField = this.resolve(((Edi2XmlMeta)this.meta).getInputField());
            String realOutputField = this.resolve(((Edi2XmlMeta)this.meta).getOutputField());
            ((Edi2XmlData)this.data).inputFieldIndex = this.getInputRowMeta().indexOfValue(realInputField);
            if (((Edi2XmlData)this.data).inputFieldIndex < 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)"Edi2Xml.Log.CouldNotFindInputField", (String[])new String[]{realInputField}));
            }
            if (!((Edi2XmlData)this.data).inputRowMeta.getValueMeta(((Edi2XmlData)this.data).inputFieldIndex).isString()) {
                throw new HopException(BaseMessages.getString(PKG, (String)"Edi2Xml.Log.InputFieldIsNotAString", (String[])new String[]{realInputField}));
            }
            ((Edi2XmlData)this.data).inputMeta = ((Edi2XmlData)this.data).inputRowMeta.getValueMeta(((Edi2XmlData)this.data).inputFieldIndex);
            if (Utils.isEmpty((CharSequence)((Edi2XmlMeta)this.meta).getOutputField())) {
                ((Edi2XmlData)this.data).outputMeta = ((Edi2XmlData)this.data).outputRowMeta.getValueMeta(((Edi2XmlData)this.data).inputFieldIndex);
                ((Edi2XmlData)this.data).outputFieldIndex = ((Edi2XmlData)this.data).inputFieldIndex;
            } else {
                ((Edi2XmlData)this.data).outputMeta = ((Edi2XmlData)this.data).outputRowMeta.searchValueMeta(realOutputField);
                ((Edi2XmlData)this.data).outputFieldIndex = ((Edi2XmlData)this.data).outputRowMeta.size() - 1;
            }
            inputValue = Const.NVL((String)((Edi2XmlData)this.data).inputMeta.getString(r[((Edi2XmlData)this.data).inputFieldIndex]), (String)"");
            this.lexer = new FastSimpleGenericEdifactDirectXMLLexer((CharStream)new ANTLRStringStream(inputValue));
            this.tokens = new CommonTokenStream((TokenSource)this.lexer);
            this.parser = new FastSimpleGenericEdifactDirectXMLParser((TokenStream)this.tokens);
        } else {
            inputValue = Const.NVL((String)((Edi2XmlData)this.data).inputMeta.getString(r[((Edi2XmlData)this.data).inputFieldIndex]), (String)"");
            this.lexer.setCharStream((CharStream)new ANTLRStringStream(inputValue));
            this.tokens.setTokenSource((TokenSource)this.lexer);
            this.parser.setTokenStream((TokenStream)this.tokens);
        }
        try {
            this.parser.edifact();
            r = RowDataUtil.resizeArray((Object[])r, (int)((Edi2XmlData)this.data).outputRowMeta.size());
            r[((Edi2XmlData)this.data).outputFieldIndex] = this.parser.buf.toString();
            this.putRow(((Edi2XmlData)this.data).outputRowMeta, r);
        }
        catch (MismatchedTokenException e) {
            errorMessage = new StringBuilder(180);
            errorMessage.append("error parsing edi on line " + e.line + " position " + e.charPositionInLine);
            errorMessage.append(": expecting " + (e.expecting > -1 ? this.parser.getTokenNames()[e.expecting] : CONST_UNKNOWN) + " but found ");
            errorMessage.append(e.token.getType() >= 0 ? this.parser.getTokenNames()[e.token.getType()] : "<EOF>");
            if (this.getTransformMeta().isDoingErrorHandling()) {
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage.toString(), this.resolve(((Edi2XmlMeta)this.meta).getInputField()), "MALFORMED_EDI");
            }
            this.logError(errorMessage.toString());
            String errorline = CONST_UNKNOWN;
            try {
                errorline = inputValue.split("\\r?\\n")[e.line - 1];
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logError(CONST_PROBLEM_LINE + errorline);
            this.logError(StringUtils.leftPad((String)"^", (int)(e.charPositionInLine + CONST_PROBLEM_LINE.length() + 1)));
            throw new HopException((Throwable)e);
        }
        catch (RecognitionException e) {
            errorMessage = new StringBuilder(180);
            errorMessage.append("error parsing edi on line ").append(e.line).append(" position ").append(e.charPositionInLine).append(". ").append(e.toString());
            if (this.getTransformMeta().isDoingErrorHandling()) {
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage.toString(), this.resolve(((Edi2XmlMeta)this.meta).getInputField()), "MALFORMED_EDI");
            }
            this.logError(errorMessage.toString());
            String errorline = CONST_UNKNOWN;
            try {
                errorline = inputValue.split("\\r?\\n")[e.line - 1];
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logError(CONST_PROBLEM_LINE + errorline);
            this.logError(StringUtils.leftPad((String)"^", (int)(e.charPositionInLine + CONST_PROBLEM_LINE.length() + 1)));
            throw new HopException((Throwable)e);
        }
        if (this.checkFeedback(this.getLinesRead()) && this.isBasic()) {
            this.logBasic("Line nr " + this.getLinesRead());
        }
        return true;
    }

    public void dispose() {
        ((Edi2XmlData)this.data).inputMeta = null;
        ((Edi2XmlData)this.data).inputRowMeta = null;
        ((Edi2XmlData)this.data).outputMeta = null;
        ((Edi2XmlData)this.data).outputRowMeta = null;
        super.dispose();
    }
}

