/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.snowflake;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.metadata.api.HopMetadataProperty;

@DatabaseMetaPlugin(type="SNOWFLAKE", typeDescription="Snowflake", image="snowflake.svg", documentationUrl="/database/databases/snowflake.html", classLoaderGroup="snowflake")
@GuiPlugin(id="GUI-SnowflakeDatabaseMeta")
public class SnowflakeDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    public static final String CONST_ALTER_TABLE = "ALTER TABLE ";
    @HopMetadataProperty
    @GuiWidgetElement(id="warehouse", order="02B", label="i18n:org.apache.hop.ui.core.database:DatabaseDialog.label.Warehouse", type=GuiElementType.TEXT, variables=true, parentId="DatabaseMeta-PluginSpecific-Options")
    private String warehouse;

    public String getWarehouse() {
        return this.warehouse;
    }

    public void setWarehouse(String warehouse) {
        this.warehouse = warehouse;
    }

    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 443;
        }
        return -1;
    }

    public Map<String, String> getDefaultOptions() {
        HashMap<String, String> defaultOptions = new HashMap<String, String>();
        defaultOptions.put(this.getPluginId() + ".ssl", "on");
        return defaultOptions;
    }

    public boolean isFetchSizeSupported() {
        return false;
    }

    public String getDriverClass() {
        return "net.snowflake.client.jdbc.SnowflakeDriver";
    }

    public String getURL(String hostName, String port, String databaseName) {
        Validate.notEmpty((String)hostName, (String)"Host name is empty");
        String url = "jdbc:snowflake://" + hostName.toLowerCase();
        if (!url.endsWith(".snowflakecomputing.com")) {
            url = url + ".snowflakecomputing.com";
        }
        if (!Utils.isEmpty((CharSequence)port)) {
            url = url + ":" + port;
        }
        boolean isFirstQueryParam = true;
        if (!Utils.isEmpty((CharSequence)this.warehouse)) {
            url = url + "/?warehouse=" + this.warehouse;
            isFirstQueryParam = false;
        }
        if (!Utils.isEmpty((CharSequence)databaseName)) {
            url = isFirstQueryParam ? url + "/?db=" + databaseName : url + "&db=" + databaseName;
        }
        return url;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return CONST_ALTER_TABLE + tableName + " ADD COLUMN " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getDropColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return CONST_ALTER_TABLE + tableName + " DROP COLUMN " + v.getName() + Const.CR;
    }

    public String getSqlListOfSchemas() {
        return "SELECT SCHEMA_NAME AS \"name\" FROM " + this.getDatabaseName() + ".INFORMATION_SCHEMA.SCHEMATA";
    }

    public String getSqlListOfProcedures() {
        return "SELECT PROCEDURE_NAME AS \"name\" FROM " + this.getDatabaseName() + ".INFORMATION_SCHEMA.PROCEDURES";
    }

    public String getSqlListOfSequences() {
        return "SELECT SEQUENCE_NAME AS \"name\" FROM " + this.getDatabaseName() + ".INFORMATION_SCHEMA.SEQUENCES";
    }

    public String getSqlNextSequenceValue(String sequenceName) {
        return "SELECT " + sequenceName + ".NEXTVAL FROM DUAL";
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return CONST_ALTER_TABLE + tableName + " MODIFY COLUMN " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getFieldDefinition(IValueMeta v, String surrogateKey, String primaryKey, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        boolean isKeyField;
        Object fieldDefinitionDdl = "";
        String newline = addCr ? Const.CR : "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        int type = v.getType();
        boolean bl = isKeyField = fieldname.equalsIgnoreCase(surrogateKey) || fieldname.equalsIgnoreCase(primaryKey);
        if (addFieldName) {
            fieldDefinitionDdl = (String)fieldDefinitionDdl + fieldname + " ";
        }
        if (isKeyField) {
            Validate.isTrue((type == 1 || type == 5 || type == 6 ? 1 : 0) != 0);
            return this.ddlForPrimaryKey(useAutoinc) + newline;
        }
        switch (type) {
            case 3: 
            case 9: {
                fieldDefinitionDdl = (String)fieldDefinitionDdl + "TIMESTAMP_LTZ";
                break;
            }
            case 4: {
                fieldDefinitionDdl = (String)fieldDefinitionDdl + this.ddlForBooleanValue();
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (precision == 0) {
                    fieldDefinitionDdl = (String)fieldDefinitionDdl + this.ddlForIntegerValue(length);
                    break;
                }
                fieldDefinitionDdl = (String)fieldDefinitionDdl + this.ddlForFloatValue(length, precision);
                break;
            }
            case 2: {
                if (length <= 0) {
                    fieldDefinitionDdl = (String)fieldDefinitionDdl + "VARCHAR";
                    break;
                }
                fieldDefinitionDdl = (String)fieldDefinitionDdl + "VARCHAR(" + length + ")";
                break;
            }
            case 8: {
                fieldDefinitionDdl = (String)fieldDefinitionDdl + "VARIANT";
                break;
            }
            default: {
                fieldDefinitionDdl = (String)fieldDefinitionDdl + " UNKNOWN";
            }
        }
        return (String)fieldDefinitionDdl + newline;
    }

    private String ddlForBooleanValue() {
        if (this.isSupportsBooleanDataType()) {
            return "BOOLEAN";
        }
        return "CHAR(1)";
    }

    private String ddlForIntegerValue(int length) {
        if (length > 9) {
            if (length < 19) {
                return "BIGINT";
            }
            return "NUMBER(" + length + ", 0 )";
        }
        return "INT";
    }

    private String ddlForFloatValue(int length, int precision) {
        if (length > 15) {
            return "NUMBER(" + length + ", " + precision + ")";
        }
        return "FLOAT";
    }

    private String ddlForPrimaryKey(boolean useAutoinc) {
        if (useAutoinc) {
            return "BIGINT AUTOINCREMENT NOT NULL PRIMARY KEY";
        }
        return "BIGINT NOT NULL PRIMARY KEY";
    }

    public String getLimitClause(int nrRows) {
        return " LIMIT " + nrRows;
    }

    public String getSqlQueryFields(String tableName) {
        return "SELECT * FROM " + tableName + " LIMIT 0";
    }

    public String getSqlTableExists(String tableName) {
        return this.getSqlQueryFields(tableName);
    }

    public String getSqlColumnExists(String columnname, String tableName) {
        return this.getSqlQueryColumnFields(columnname, tableName);
    }

    public String getSqlQueryColumnFields(String columnname, String tableName) {
        return "SELECT " + columnname + " FROM " + tableName + " LIMIT 0";
    }

    public int getNotFoundTK(boolean useAutoinc) {
        if (this.isSupportsAutoInc() && useAutoinc) {
            return 1;
        }
        return super.getNotFoundTK(useAutoinc);
    }

    public String getExtraOptionSeparator() {
        return "&";
    }

    public String getExtraOptionIndicator() {
        return "&";
    }

    public boolean isSupportsTransactions() {
        return false;
    }

    public boolean isSupportsTimeStampToDateConversion() {
        return false;
    }

    public boolean isSupportsBitmapIndex() {
        return false;
    }

    public boolean isSupportsViews() {
        return true;
    }

    public boolean isSupportsSequences() {
        return true;
    }

    public boolean isSupportsSynonyms() {
        return false;
    }

    public boolean IsSupportsErrorHandlingOnBatchUpdates() {
        return true;
    }

    public String[] getReservedWords() {
        return new String[]{"ALL", "ALTER", "AND", "ANY", "AS", "ASC", "BETWEEN", "BY", "CASE", "CAST", "CHECK", "CLUSTER", "COLUMN", "CONNECT", "CREATE", "CROSS", "CURRENT", "DELETE", "DESC", "DISTINCT", "DROP", "ELSE", "EXCLUSIVE", "EXISTS", "FALSE", "FOR", "FROM", "FULL", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IMMEDIATE", "IN", "INCREMENT", "INNER", "INSERT", "INTERSECT", "INTO", "IS", "JOIN", "LATERAL", "LEFT", "LIKE", "LOCK", "LONG", "MAXEXTENTS", "MINUS", "MODIFY", "NATURAL", "NOT", "NULL", "OF", "ON", "OPTION", "OR", "ORDER", "REGEXP", "RENAME", "REVOKE", "RIGHT", "RLIKE", "ROW", "ROWS", "SELECT", "SET", "SOME", "START", "TABLE", "THEN", "TO", "TRIGGER", "TRUE", "UNION", "UNIQUE", "UPDATE", "USING", "VALUES", "WHEN", "WHENEVER", "WHERE", "WITH"};
    }

    public String getExtraOptionsHelpText() {
        return "https://docs.snowflake.net/manuals/user-guide/jdbc-configure.html";
    }

    public String getSqlInsertAutoIncUnknownDimensionRow(String schemaTable, String keyField, String versionField) {
        return "insert into " + schemaTable + "(" + keyField + ", " + versionField + ") values (1, 1)";
    }

    public String quoteSqlString(String string) {
        string = string.replace("'", "\\\\'");
        string = string.replace("\\n", "\\\\n");
        string = string.replace("\\r", "\\\\r");
        return "'" + string + "'";
    }

    public boolean isReleaseSavepoint() {
        return false;
    }

    public boolean isRequiringTransactionsOnQueries() {
        return false;
    }

    public void addDefaultOptions() {
        this.setSupportsBooleanDataType(true);
    }
}

