/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.row;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopEofException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.xml.XmlHandler;
import org.w3c.dom.Node;

public class RowMeta
implements IRowMeta {
    public static final String XML_META_TAG = "row-meta";
    public static final String XML_DATA_TAG = "row-data";
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final RowMetaCache cache;
    List<IValueMeta> valueMetaList;
    List<Integer> needRealClone;

    public RowMeta() {
        this(new ArrayList<IValueMeta>(), new RowMetaCache());
    }

    private RowMeta(RowMeta rowMeta, Integer targetType) throws HopPluginException {
        this(new ArrayList<IValueMeta>(rowMeta.valueMetaList.size()), new RowMetaCache(rowMeta.cache));
        for (IValueMeta iValueMeta : rowMeta.valueMetaList) {
            this.valueMetaList.add(ValueMetaFactory.cloneValueMeta(iValueMeta, targetType == null ? iValueMeta.getType() : targetType.intValue()));
        }
        this.needRealClone = rowMeta.needRealClone;
    }

    private RowMeta(List<IValueMeta> valueMetaList, RowMetaCache rowMetaCache) {
        this.cache = rowMetaCache;
        this.valueMetaList = valueMetaList;
        this.needRealClone = new ArrayList<Integer>();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowMeta rowMeta = (RowMeta)o;
        for (int i = 0; i < this.valueMetaList.size(); ++i) {
            IValueMeta thatValue;
            IValueMeta thisValue = this.valueMetaList.get(i);
            if (thisValue.equals(thatValue = rowMeta.getValueMeta(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.valueMetaList);
    }

    @Override
    public RowMeta clone() {
        this.lock.readLock().lock();
        try {
            RowMeta rowMeta = new RowMeta(this, null);
            return rowMeta;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public IRowMeta cloneToType(int targetType) throws HopValueException {
        this.lock.readLock().lock();
        try {
            RowMeta rowMeta = new RowMeta(this, targetType);
            return rowMeta;
        }
        catch (HopPluginException e) {
            throw new HopValueException(e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.lock.readLock().lock();
        try {
            boolean notFirst = false;
            for (IValueMeta valueMeta : this.valueMetaList) {
                if (notFirst) {
                    buffer.append(", ");
                } else {
                    notFirst = true;
                }
                buffer.append("[").append(valueMeta.toString()).append("]");
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public List<IValueMeta> getValueMetaList() {
        ArrayList<IValueMeta> copy;
        this.lock.readLock().lock();
        try {
            copy = new ArrayList<IValueMeta>(this.valueMetaList);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return Collections.unmodifiableList(copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueMetaList(List<IValueMeta> valueMetaList) {
        this.lock.writeLock().lock();
        try {
            this.valueMetaList = valueMetaList;
            this.cache.invalidate();
            int len = valueMetaList.size();
            for (int i = 0; i < len; ++i) {
                IValueMeta valueMeta = valueMetaList.get(i);
                this.cache.storeMapping(valueMeta.getName(), i);
            }
            this.needRealClone = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.valueMetaList.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    @JsonIgnore
    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.valueMetaList.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean exists(IValueMeta meta) {
        return meta != null && this.searchValueMeta(meta.getName()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addValueMeta(IValueMeta meta) {
        if (meta != null) {
            this.lock.writeLock().lock();
            try {
                Integer existsIdx = this.cache.findAndCompare(meta.getName(), this.valueMetaList);
                IValueMeta newMeta = existsIdx == null ? meta : this.renameValueMetaIfInRow(meta, null);
                int sz = this.valueMetaList.size();
                this.valueMetaList.add(newMeta);
                this.cache.storeMapping(newMeta.getName(), sz);
                this.needRealClone = null;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addValueMeta(int index, IValueMeta meta) {
        if (meta != null) {
            this.lock.writeLock().lock();
            try {
                Integer existsIdx = this.cache.findAndCompare(meta.getName(), this.valueMetaList);
                IValueMeta newMeta = existsIdx == null ? meta : this.renameValueMetaIfInRow(meta, null);
                this.valueMetaList.add(index, newMeta);
                this.cache.insertAtMapping(newMeta.getName(), index);
                this.needRealClone = null;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    @Override
    public IValueMeta getValueMeta(int index) {
        this.lock.readLock().lock();
        try {
            if (index >= 0 && index < this.valueMetaList.size()) {
                IValueMeta iValueMeta = this.valueMetaList.get(index);
                return iValueMeta;
            }
            IValueMeta iValueMeta = null;
            return iValueMeta;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueMeta(int index, IValueMeta valueMeta) {
        if (valueMeta != null) {
            this.lock.writeLock().lock();
            try {
                IValueMeta old = this.valueMetaList.get(index);
                IValueMeta newMeta = valueMeta;
                int existsIndex = this.indexOfValue(valueMeta.getName());
                if (existsIndex >= 0 && existsIndex != index) {
                    newMeta = this.renameValueMetaIfInRow(valueMeta, null);
                }
                this.valueMetaList.set(index, newMeta);
                this.cache.replaceMapping(old.getName(), newMeta.getName(), index);
                this.needRealClone = null;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    @Override
    public String getString(Object[] dataRow, int index) throws HopValueException {
        if (dataRow == null) {
            return null;
        }
        IValueMeta meta = this.getValueMeta(index);
        return meta.getString(dataRow[index]);
    }

    @Override
    public Long getInteger(Object[] dataRow, int index) throws HopValueException {
        if (dataRow == null) {
            return null;
        }
        IValueMeta meta = this.getValueMeta(index);
        return meta.getInteger(dataRow[index]);
    }

    @Override
    public Double getNumber(Object[] dataRow, int index) throws HopValueException {
        if (dataRow == null) {
            return null;
        }
        IValueMeta meta = this.getValueMeta(index);
        return meta.getNumber(dataRow[index]);
    }

    @Override
    public Date getDate(Object[] dataRow, int index) throws HopValueException {
        if (dataRow == null) {
            return null;
        }
        IValueMeta meta = this.getValueMeta(index);
        return meta.getDate(dataRow[index]);
    }

    @Override
    public BigDecimal getBigNumber(Object[] dataRow, int index) throws HopValueException {
        if (dataRow == null) {
            return null;
        }
        IValueMeta meta = this.getValueMeta(index);
        return meta.getBigNumber(dataRow[index]);
    }

    @Override
    @Nullable
    public Boolean getBoolean(Object[] dataRow, int index) throws HopValueException {
        if (dataRow == null) {
            return null;
        }
        IValueMeta meta = this.getValueMeta(index);
        return meta.getBoolean(dataRow[index]);
    }

    @Override
    public byte[] getBinary(Object[] dataRow, int index) throws HopValueException {
        if (dataRow == null) {
            return null;
        }
        IValueMeta meta = this.getValueMeta(index);
        return meta.getBinary(dataRow[index]);
    }

    @Override
    public boolean isNull(Object[] dataRow, int index) throws HopValueException {
        if (dataRow == null) {
            return true;
        }
        return this.getValueMeta(index).isNull(dataRow[index]);
    }

    @Override
    public Object[] cloneRow(Object[] objects) throws HopValueException {
        return this.cloneRow(objects, (Object[])objects.clone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] cloneRow(Object[] objects, Object[] newObjects) throws HopValueException {
        List<Integer> list = this.getOrCreateValuesThatNeedRealClone(this.valueMetaList);
        this.lock.readLock().lock();
        try {
            for (Integer i : list) {
                IValueMeta valueMeta = this.valueMetaList.get(i);
                newObjects[i.intValue()] = valueMeta.cloneValueData(objects[i]);
            }
            Object[] objectArray = newObjects;
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    List<Integer> getOrCreateValuesThatNeedRealClone(List<IValueMeta> values) {
        this.lock.writeLock().lock();
        try {
            if (this.needRealClone == null) {
                int len = values.size();
                this.needRealClone = new ArrayList<Integer>(len);
                for (int i = 0; i < len; ++i) {
                    IValueMeta valueMeta = values.get(i);
                    if (!valueMeta.requiresRealClone()) continue;
                    this.needRealClone.add(i);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return this.needRealClone;
    }

    @Override
    public String getString(Object[] dataRow, String valueName, String defaultValue) throws HopValueException {
        int index = this.indexOfValue(valueName);
        if (index < 0) {
            return defaultValue;
        }
        return this.getString(dataRow, index);
    }

    @Override
    public Long getInteger(Object[] dataRow, String valueName, Long defaultValue) throws HopValueException {
        int index = this.indexOfValue(valueName);
        if (index < 0) {
            return defaultValue;
        }
        return this.getInteger(dataRow, index);
    }

    @Override
    public Date getDate(Object[] dataRow, String valueName, Date defaultValue) throws HopValueException {
        int index = this.indexOfValue(valueName);
        if (index < 0) {
            return defaultValue;
        }
        return this.getDate(dataRow, index);
    }

    @Override
    public Boolean getBoolean(Object[] dataRow, String valueName, Boolean defaultValue) throws HopValueException {
        int index = this.indexOfValue(valueName);
        if (index < 0) {
            return defaultValue;
        }
        return this.getBoolean(dataRow, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOfValue(String valueName) {
        if (valueName == null) {
            return -1;
        }
        this.lock.readLock().lock();
        try {
            int n;
            Integer index = this.cache.findAndCompare(valueName, this.valueMetaList);
            for (int i = 0; index == null && i < this.valueMetaList.size(); ++i) {
                if (!valueName.equalsIgnoreCase(this.valueMetaList.get(i).getName())) continue;
                index = i;
                this.cache.storeMapping(valueName, index);
                this.needRealClone = null;
            }
            if (index == null) {
                n = -1;
                return n;
            }
            n = index;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IValueMeta searchValueMeta(String valueName) {
        this.lock.readLock().lock();
        try {
            Integer index = this.indexOfValue(valueName);
            if (index < 0) {
                IValueMeta iValueMeta = null;
                return iValueMeta;
            }
            IValueMeta iValueMeta = this.valueMetaList.get(index);
            return iValueMeta;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void addRowMeta(IRowMeta rowMeta) {
        for (int i = 0; i < rowMeta.size(); ++i) {
            this.addValueMeta(rowMeta.getValueMeta(i));
        }
    }

    @Override
    public void mergeRowMeta(IRowMeta r) {
        this.mergeRowMeta(r, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeRowMeta(IRowMeta r, String originTransformName) {
        this.lock.writeLock().lock();
        try {
            for (int x = 0; x < r.size(); ++x) {
                IValueMeta field = r.getValueMeta(x);
                if (this.searchValueMeta(field.getName()) == null) {
                    this.addValueMeta(field);
                    continue;
                }
                this.addValueMeta(this.renameValueMetaIfInRow(field, originTransformName));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private IValueMeta renameValueMetaIfInRow(IValueMeta valueMeta, String originTransform) {
        int index = 1;
        String name = valueMeta.getName() + "_" + index;
        while (this.searchValueMeta(name) != null) {
            name = valueMeta.getName() + "_" + ++index;
        }
        IValueMeta copy = valueMeta.clone();
        copy.setName(name);
        if (originTransform != null) {
            copy.setOrigin(originTransform);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JsonIgnore
    public String[] getFieldNames() {
        this.lock.readLock().lock();
        try {
            String[] retval = new String[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                String valueName = this.getValueMeta(i).getName();
                retval[i] = valueName == null ? "" : valueName;
            }
            String[] stringArray = retval;
            return stringArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeData(DataOutputStream outputStream, Object[] data) throws HopFileException {
        block6: {
            this.lock.readLock().lock();
            try {
                for (int i = 0; i < this.size(); ++i) {
                    this.getValueMeta(i).writeData(outputStream, data[i]);
                }
                if (this.size() != 0) break block6;
                try {
                    outputStream.writeBoolean(true);
                }
                catch (IOException e) {
                    throw new HopFileException("Error writing marker flag", e);
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    @Override
    public void writeMeta(DataOutputStream outputStream) throws HopFileException {
        this.lock.readLock().lock();
        try {
            try {
                outputStream.writeInt(this.size());
            }
            catch (IOException e) {
                throw new HopFileException("Unable to write nr of metadata values", e);
            }
            for (int i = 0; i < this.size(); ++i) {
                this.getValueMeta(i).writeMeta(outputStream);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public RowMeta(DataInputStream inputStream) throws HopFileException, SocketTimeoutException {
        this();
        int nr;
        try {
            nr = inputStream.readInt();
        }
        catch (SocketTimeoutException e) {
            throw e;
        }
        catch (EOFException e) {
            throw new HopEofException("End of file while reading the number of metadata values in the row metadata", e);
        }
        catch (IOException e) {
            throw new HopFileException("Unable to read nr of metadata values: " + String.valueOf(e), e);
        }
        for (int i = 0; i < nr; ++i) {
            try {
                int type = inputStream.readInt();
                IValueMeta valueMeta = ValueMetaFactory.createValueMeta(type);
                valueMeta.readMetaData(inputStream);
                this.addValueMeta(valueMeta);
                continue;
            }
            catch (EOFException e) {
                throw new HopEofException(e);
            }
            catch (Exception e) {
                throw new HopFileException(String.valueOf(this) + " : Unable to read row metadata from input stream", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] readData(DataInputStream inputStream) throws HopFileException, SocketTimeoutException {
        this.lock.readLock().lock();
        try {
            Object[] data = new Object[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                data[i] = this.getValueMeta(i).readData(inputStream);
            }
            if (this.size() == 0) {
                try {
                    inputStream.readBoolean();
                }
                catch (EOFException e) {
                    throw new HopEofException(e);
                }
                catch (SocketTimeoutException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw new HopFileException(String.valueOf(this) + " : Unable to read the marker flag data from input stream", e);
                }
            }
            Object[] objectArray = data;
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.valueMetaList.clear();
            this.cache.invalidate();
            this.needRealClone = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void removeValueMeta(String valueName) throws HopValueException {
        this.lock.writeLock().lock();
        try {
            int index = this.indexOfValue(valueName);
            if (index < 0) {
                throw new HopValueException("Unable to find value metadata with name '" + valueName + "', so I can't delete it.");
            }
            this.removeValueMeta(index);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void removeValueMeta(int index) {
        this.lock.writeLock().lock();
        try {
            this.valueMetaList.remove(index);
            this.cache.invalidate();
            this.needRealClone = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toStringMeta() {
        StringBuilder buffer = new StringBuilder();
        this.lock.readLock().lock();
        try {
            boolean notFirst = false;
            for (IValueMeta valueMeta : this.valueMetaList) {
                if (notFirst) {
                    buffer.append(", ");
                } else {
                    notFirst = true;
                }
                buffer.append("[").append(valueMeta.toStringMeta()).append("]");
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(Object[] row) throws HopValueException {
        this.lock.readLock().lock();
        try {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < this.size(); ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append("[");
                buffer.append(this.getString(row, i));
                buffer.append("]");
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getFieldNamesAndTypes(int maxlen) {
        this.lock.readLock().lock();
        try {
            int size = this.size();
            String[] retval = new String[size];
            for (int i = 0; i < size; ++i) {
                IValueMeta v = this.getValueMeta(i);
                retval[i] = Const.rightPad(v.getName(), maxlen) + "   (" + v.getTypeDesc() + ")";
            }
            String[] stringArray = retval;
            return stringArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compare(Object[] rowData1, Object[] rowData2, int[] fieldnrs) throws HopValueException {
        this.lock.readLock().lock();
        try {
            for (int fieldnr : fieldnrs) {
                IValueMeta valueMeta = this.getValueMeta(fieldnr);
                int cmp = valueMeta.compare(rowData1[fieldnr], rowData2[fieldnr]);
                if (cmp == 0) continue;
                int n = cmp;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object[] rowData1, Object[] rowData2, int[] fieldnrs) throws HopValueException {
        this.lock.readLock().lock();
        try {
            for (int fieldnr : fieldnrs) {
                IValueMeta valueMeta = this.getValueMeta(fieldnr);
                int cmp = valueMeta.compare(rowData1[fieldnr], rowData2[fieldnr]);
                if (cmp == 0) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compare(Object[] rowData1, Object[] rowData2, int[] fieldnrs1, int[] fieldnrs2) throws HopValueException {
        int len = Math.min(fieldnrs1.length, fieldnrs2.length);
        this.lock.readLock().lock();
        try {
            for (int i = 0; i < len; ++i) {
                IValueMeta valueMeta = this.getValueMeta(fieldnrs1[i]);
                int cmp = valueMeta.compare(rowData1[fieldnrs1[i]], rowData2[fieldnrs2[i]]);
                if (cmp == 0) continue;
                int n = cmp;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compare(Object[] rowData1, IRowMeta rowMeta2, Object[] rowData2, int[] fieldnrs1, int[] fieldnrs2) throws HopValueException {
        int len = Math.min(fieldnrs1.length, fieldnrs2.length);
        this.lock.readLock().lock();
        try {
            for (int i = 0; i < len; ++i) {
                IValueMeta valueMeta2;
                IValueMeta valueMeta1 = this.getValueMeta(fieldnrs1[i]);
                int cmp = valueMeta1.compare(rowData1[fieldnrs1[i]], valueMeta2 = rowMeta2.getValueMeta(fieldnrs2[i]), rowData2[fieldnrs2[i]]);
                if (cmp == 0) continue;
                int n = cmp;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compare(Object[] rowData1, Object[] rowData2) throws HopValueException {
        this.lock.readLock().lock();
        try {
            for (int i = 0; i < this.size(); ++i) {
                IValueMeta valueMeta = this.getValueMeta(i);
                int cmp = valueMeta.compare(rowData1[i], rowData2[i]);
                if (cmp == 0) continue;
                int n = cmp;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int hashCode(Object[] rowData) throws HopValueException {
        return Arrays.deepHashCode(rowData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int convertedValuesHashCode(Object[] rowData) throws HopValueException {
        if (rowData == null) {
            return 0;
        }
        int result = 1;
        this.lock.readLock().lock();
        try {
            for (int i = 0; i < rowData.length; ++i) {
                result = 31 * result + this.getValueMeta(i).hashCode();
            }
            int n = result;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public static byte[] extractData(IRowMeta metadata, Object[] row) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            metadata.writeData(dataOutputStream, row);
            dataOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("Error serializing row to byte array", e);
        }
    }

    public static Object[] getRow(IRowMeta metadata, byte[] data) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            return metadata.readData(dataInputStream);
        }
        catch (Exception e) {
            throw new RuntimeException("Error de-serializing row of data from byte array", e);
        }
    }

    @Override
    @JsonIgnore
    public String getMetaXml() throws IOException {
        StringBuilder xml = new StringBuilder();
        xml.append("<").append(XML_META_TAG).append(">");
        this.lock.readLock().lock();
        try {
            for (int i = 0; i < this.size(); ++i) {
                xml.append(this.getValueMeta(i).getMetaXml());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        xml.append("</").append(XML_META_TAG).append(">");
        return xml.toString();
    }

    public RowMeta(Node node) throws HopException {
        this();
        int nrValues = XmlHandler.countNodes(node, "value-meta");
        for (int i = 0; i < nrValues; ++i) {
            ValueMetaBase valueMetaSource = new ValueMetaBase(XmlHandler.getSubNodeByNr(node, "value-meta", i));
            IValueMeta valueMeta = ValueMetaFactory.createValueMeta(valueMetaSource.getName(), valueMetaSource.getType(), valueMetaSource.getLength(), valueMetaSource.getPrecision());
            ValueMetaFactory.cloneInfo(valueMetaSource, valueMeta);
            this.addValueMeta(valueMeta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDataXml(Object[] rowData) throws IOException {
        StringBuilder xml = new StringBuilder();
        xml.append("<").append(XML_DATA_TAG).append(">");
        this.lock.readLock().lock();
        try {
            for (int i = 0; i < this.size(); ++i) {
                xml.append(this.getValueMeta(i).getDataXml(rowData[i]));
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        xml.append("</").append(XML_DATA_TAG).append(">");
        return xml.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getRow(Node node) throws HopException {
        this.lock.readLock().lock();
        try {
            Object[] rowData = RowDataUtil.allocateRowData(this.size());
            for (int i = 0; i < this.size(); ++i) {
                Node valueDataNode = XmlHandler.getSubNodeByNr(node, "value-data", i);
                rowData[i] = this.getValueMeta(i).getValue(valueDataNode);
            }
            Object[] objectArray = rowData;
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @VisibleForTesting
    static class RowMetaCache {
        @VisibleForTesting
        final Map<String, Integer> mapping;

        RowMetaCache() {
            this(new ConcurrentHashMap<String, Integer>());
        }

        RowMetaCache(RowMetaCache rowMetaCache) {
            this(new ConcurrentHashMap<String, Integer>(rowMetaCache.mapping));
        }

        RowMetaCache(Map<String, Integer> mapping) {
            this.mapping = mapping;
        }

        void invalidate() {
            this.mapping.clear();
        }

        void storeMapping(String name, int index) {
            if (Utils.isEmpty(name)) {
                return;
            }
            this.mapping.put(name.toLowerCase(), index);
        }

        void replaceMapping(String old, String current, int index) {
            if (!Utils.isEmpty(old)) {
                this.mapping.remove(old.toLowerCase());
            }
            this.storeMapping(current, index);
        }

        void insertAtMapping(String name, int index) {
            if (Utils.isEmpty(name) || index < 0) {
                return;
            }
            String key = name.toLowerCase();
            this.mapping.replaceAll((k, v) -> v >= index ? v + 1 : v);
            this.mapping.put(key, index);
        }

        Integer findAndCompare(String name, List<? extends IValueMeta> metas) {
            IValueMeta value;
            if (Utils.isEmpty(name)) {
                return null;
            }
            Integer index = this.mapping.get(name = name.toLowerCase());
            if (index != null && !name.equalsIgnoreCase((value = metas.get(index)).getName())) {
                this.mapping.remove(name);
                index = null;
            }
            return index;
        }
    }
}

