/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.parameters;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.parameters.DuplicateParamException;
import org.apache.hop.core.parameters.INamedParameterDefinitions;
import org.apache.hop.core.parameters.INamedParameters;
import org.apache.hop.core.parameters.NamedParameter;
import org.apache.hop.core.parameters.UnknownParamException;
import org.apache.hop.core.variables.IVariables;

public class NamedParameters
implements INamedParameters {
    protected Map<String, NamedParameter> params = new HashMap<String, NamedParameter>();

    @Override
    public void addParameterDefinition(String key, String defValue, String description) throws DuplicateParamException {
        if (this.params.get(key) != null) {
            throw new DuplicateParamException("Duplicate parameter '" + key + "' detected.");
        }
        NamedParameter oneParam = new NamedParameter();
        oneParam.key = key;
        oneParam.defaultValue = defValue;
        oneParam.description = description;
        oneParam.value = "";
        this.params.put(key, oneParam);
    }

    @Override
    public String getParameterDescription(String key) throws UnknownParamException {
        String description = null;
        NamedParameter theParam = this.params.get(key);
        if (theParam != null) {
            description = theParam.description;
        }
        return description;
    }

    @Override
    public String getParameterValue(String key) throws UnknownParamException {
        String value = null;
        NamedParameter theParam = this.params.get(key);
        if (theParam != null) {
            value = theParam.value;
        }
        return value;
    }

    @Override
    public String getParameterDefault(String key) throws UnknownParamException {
        String value = null;
        NamedParameter theParam = this.params.get(key);
        if (theParam != null) {
            value = theParam.defaultValue;
        }
        return value;
    }

    @Override
    public String[] listParameters() {
        Set<String> keySet = this.params.keySet();
        Object[] paramArray = keySet.toArray(new String[0]);
        Arrays.sort(paramArray);
        return paramArray;
    }

    @Override
    public void setParameterValue(String key, String value) {
        NamedParameter theParam = this.params.get(key);
        if (theParam != null) {
            theParam.value = value;
        }
    }

    @Override
    public void removeAllParameters() {
        this.params.clear();
    }

    @Override
    public void clearParameterValues() {
        String[] keys;
        for (String key : keys = this.listParameters()) {
            NamedParameter theParam = this.params.get(key);
            if (theParam == null) continue;
            theParam.value = "";
        }
    }

    @Override
    public void activateParameters(IVariables variables) {
        for (NamedParameter param : this.params.values()) {
            if (!StringUtils.isNotEmpty((String)param.key)) continue;
            variables.setVariable(param.key, Const.NVL(param.value, Const.NVL(param.defaultValue, "")));
        }
    }

    @Override
    public void copyParametersFromDefinitions(INamedParameterDefinitions definitions) {
        for (String name : definitions.listParameters()) {
            try {
                String defaultValue = definitions.getParameterDefault(name);
                String description = definitions.getParameterDescription(name);
                this.addParameterDefinition(name, defaultValue, description);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

