/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.logging;

import java.util.Date;
import java.util.Map;
import java.util.Queue;
import lombok.Generated;
import org.apache.hop.core.Const;
import org.apache.hop.core.logging.DefaultLogLevel;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.HopLoggingEvent;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILogMessage;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.IMetrics;
import org.apache.hop.core.logging.LogChannelFileWriterBuffer;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LogMessage;
import org.apache.hop.core.logging.LoggingRegistry;
import org.apache.hop.core.logging.MetricsRegistry;
import org.apache.hop.core.metrics.IMetricsSnapshot;
import org.apache.hop.core.metrics.MetricsSnapshot;
import org.apache.hop.core.metrics.MetricsSnapshotType;
import org.apache.hop.core.util.Utils;

public class LogChannel
implements ILogChannel {
    public static ILogChannel GENERAL = new LogChannel("General");
    public static ILogChannel UI = new LogChannel("GUI");
    private final String logChannelId;
    private LogLevel logLevel;
    private String containerObjectId;
    private boolean gatheringMetrics;
    private boolean forcingSeparateLogging;
    private static final MetricsRegistry metricsRegistry = MetricsRegistry.getInstance();
    private String filter;
    private LogChannelFileWriterBuffer fileWriter;
    private boolean simplified;

    public LogChannel(Object subject) {
        this.logLevel = DefaultLogLevel.getLogLevel();
        this.logChannelId = LoggingRegistry.getInstance().registerLoggingSource(subject);
    }

    public LogChannel(Object subject, boolean gatheringMetrics) {
        this(subject);
        this.gatheringMetrics = gatheringMetrics;
    }

    public LogChannel(Object subject, ILoggingObject parentObject) {
        this(subject, parentObject, false, false);
    }

    public LogChannel(Object subject, ILoggingObject parentObject, boolean gatheringMetrics) {
        this(subject, parentObject, gatheringMetrics, false);
    }

    public LogChannel(Object subject, ILoggingObject parentObject, boolean gatheringMetrics, boolean forceNewLoggingEntry) {
        if (parentObject != null) {
            this.logLevel = parentObject.getLogLevel();
            this.containerObjectId = parentObject.getContainerId();
        } else {
            this.logLevel = DefaultLogLevel.getLogLevel();
            this.containerObjectId = null;
        }
        this.gatheringMetrics = gatheringMetrics;
        this.logChannelId = LoggingRegistry.getInstance().registerLoggingSource(subject, forceNewLoggingEntry);
    }

    public String toString() {
        return this.logChannelId;
    }

    @Override
    public String getLogChannelId() {
        return this.logChannelId;
    }

    public void println(ILogMessage logMessage, LogLevel channelLogLevel) {
        String subject = null;
        LogLevel logLevel = logMessage.getLevel();
        if (!logLevel.isVisible(channelLogLevel)) {
            return;
        }
        if (subject == null) {
            subject = "Hop";
        }
        if (!logLevel.isError() && !Utils.isEmpty(this.filter) && subject.indexOf(this.filter) < 0 && logMessage.toString().indexOf(this.filter) < 0) {
            return;
        }
        if (channelLogLevel.getLevel() >= logLevel.getLevel()) {
            HopLoggingEvent loggingEvent = new HopLoggingEvent(logMessage, System.currentTimeMillis(), logLevel);
            HopLogStore.getAppender().addLogggingEvent(loggingEvent);
            if (this.fileWriter == null) {
                this.fileWriter = LoggingRegistry.getInstance().getLogChannelFileWriterBuffer(this.logChannelId);
            }
            if (this.fileWriter != null) {
                this.fileWriter.addEvent(loggingEvent);
            }
        }
    }

    public void println(ILogMessage message, Throwable e, LogLevel channelLogLevel) {
        this.println(message, channelLogLevel);
        String stackTrace = Const.getStackTracker(e);
        LogMessage traceMessage = new LogMessage(stackTrace, message.getLogChannelId(), LogLevel.ERROR, this.simplified);
        this.println(traceMessage, channelLogLevel);
    }

    public void logWithLevel(String s, LogLevel logMessageLevel) {
        if (logMessageLevel.isVisible(this.logLevel)) {
            this.println(new LogMessage(s, this.logChannelId, logMessageLevel, this.simplified), this.logLevel);
        }
    }

    public void logWithLevel(String s, Throwable e, LogLevel logMessageLevel) {
        if (logMessageLevel.isVisible(this.logLevel)) {
            this.println(new LogMessage(s, this.logChannelId, logMessageLevel, this.simplified), e, this.logLevel);
        }
    }

    public void logWithLevel(String s, LogLevel logMessageLevel, Object ... arguments) {
        if (logMessageLevel.isVisible(this.logLevel)) {
            this.println(new LogMessage(s, this.logChannelId, arguments, logMessageLevel, this.simplified), this.logLevel);
        }
    }

    @Override
    public void logMinimal(String s) {
        this.logWithLevel(s, LogLevel.MINIMAL);
    }

    @Override
    public void logBasic(String s) {
        this.logWithLevel(s, LogLevel.BASIC);
    }

    @Override
    public void logError(String s) {
        this.logWithLevel(s, LogLevel.ERROR);
    }

    @Override
    public void logError(String s, Throwable e) {
        this.logWithLevel(s, e, LogLevel.ERROR);
    }

    @Override
    public void logBasic(String s, Object ... arguments) {
        this.logWithLevel(s, LogLevel.BASIC, arguments);
    }

    @Override
    public void logDetailed(String s, Object ... arguments) {
        this.logWithLevel(s, LogLevel.DETAILED, arguments);
    }

    @Override
    public void logError(String s, Object ... arguments) {
        this.logWithLevel(s, LogLevel.ERROR, arguments);
    }

    @Override
    public void logDetailed(String s) {
        this.logWithLevel(s, LogLevel.DETAILED);
    }

    @Override
    public void logDebug(String s) {
        this.logWithLevel(s, LogLevel.DEBUG);
    }

    @Override
    public void logDebug(String message, Object ... arguments) {
        this.logWithLevel(message, LogLevel.DEBUG, arguments);
    }

    @Override
    public void logRowlevel(String s) {
        this.logWithLevel(s, LogLevel.ROWLEVEL);
    }

    @Override
    public void logMinimal(String message, Object ... arguments) {
        this.logWithLevel(message, LogLevel.MINIMAL, arguments);
    }

    @Override
    public void logRowlevel(String message, Object ... arguments) {
        this.logWithLevel(message, LogLevel.ROWLEVEL, arguments);
    }

    @Override
    public boolean isBasic() {
        return this.logLevel.isBasic();
    }

    @Override
    public boolean isDebug() {
        return this.logLevel.isDebug();
    }

    @Override
    public boolean isDetailed() {
        try {
            return this.logLevel.isDetailed();
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    @Override
    public boolean isRowLevel() {
        return this.logLevel.isRowlevel();
    }

    @Override
    public boolean isError() {
        return this.logLevel.isError();
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public String getContainerObjectId() {
        return this.containerObjectId;
    }

    @Override
    public void setContainerObjectId(String containerObjectId) {
        this.containerObjectId = containerObjectId;
    }

    @Override
    public boolean isGatheringMetrics() {
        return this.gatheringMetrics;
    }

    @Override
    public void setGatheringMetrics(boolean gatheringMetrics) {
        this.gatheringMetrics = gatheringMetrics;
    }

    @Override
    public boolean isForcingSeparateLogging() {
        return this.forcingSeparateLogging;
    }

    @Override
    public void setForcingSeparateLogging(boolean forcingSeparateLogging) {
        this.forcingSeparateLogging = forcingSeparateLogging;
    }

    @Override
    public void snap(IMetrics metric, long ... value) {
        this.snap(metric, null, value);
    }

    @Override
    public void snap(IMetrics metric, String subject, long ... value) {
        if (!this.isGatheringMetrics()) {
            return;
        }
        String key = MetricsSnapshot.getKey(metric, subject);
        Map<String, IMetricsSnapshot> metricsMap = null;
        IMetricsSnapshot snapshot = null;
        Queue<IMetricsSnapshot> metricsList = null;
        switch (metric.getType()) {
            case MAX: {
                if (value.length != 1) break;
                metricsMap = metricsRegistry.getSnapshotMap(this.logChannelId);
                snapshot = metricsMap.get(key);
                if (snapshot != null) {
                    if (value[0] <= snapshot.getValue()) break;
                    snapshot.setValue(value[0]);
                    snapshot.setDate(new Date());
                    break;
                }
                snapshot = new MetricsSnapshot(MetricsSnapshotType.MAX, metric, subject, value[0], this.logChannelId);
                metricsMap.put(key, snapshot);
                break;
            }
            case MIN: {
                if (value.length != 1) break;
                metricsMap = metricsRegistry.getSnapshotMap(this.logChannelId);
                snapshot = metricsMap.get(key);
                if (snapshot != null) {
                    if (value[0] >= snapshot.getValue()) break;
                    snapshot.setValue(value[0]);
                    snapshot.setDate(new Date());
                    break;
                }
                snapshot = new MetricsSnapshot(MetricsSnapshotType.MIN, metric, subject, value[0], this.logChannelId);
                metricsMap.put(key, snapshot);
                break;
            }
            case SUM: {
                metricsMap = metricsRegistry.getSnapshotMap(this.logChannelId);
                snapshot = metricsMap.get(key);
                if (snapshot != null) {
                    snapshot.setValue(snapshot.getValue() + value[0]);
                    break;
                }
                snapshot = new MetricsSnapshot(MetricsSnapshotType.SUM, metric, subject, value[0], this.logChannelId);
                metricsMap.put(key, snapshot);
                break;
            }
            case COUNT: {
                metricsMap = metricsRegistry.getSnapshotMap(this.logChannelId);
                snapshot = metricsMap.get(key);
                if (snapshot != null) {
                    snapshot.setValue(snapshot.getValue() + 1L);
                    break;
                }
                snapshot = new MetricsSnapshot(MetricsSnapshotType.COUNT, metric, subject, 1L, this.logChannelId);
                metricsMap.put(key, snapshot);
                break;
            }
            case START: {
                metricsList = metricsRegistry.getSnapshotList(this.logChannelId);
                snapshot = new MetricsSnapshot(MetricsSnapshotType.START, metric, subject, 1L, this.logChannelId);
                metricsList.add(snapshot);
                break;
            }
            case STOP: {
                metricsList = metricsRegistry.getSnapshotList(this.logChannelId);
                snapshot = new MetricsSnapshot(MetricsSnapshotType.STOP, metric, subject, 1L, this.logChannelId);
                metricsList.add(snapshot);
                break;
            }
        }
    }

    @Override
    public String getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Generated
    public void setSimplified(boolean simplified) {
        this.simplified = simplified;
    }

    @Generated
    public boolean isSimplified() {
        return this.simplified;
    }
}

